/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsNoticeConsumerService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import javax.annotation.Resource;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
public class JmsAppLogConsumer {
    @Resource
    JmsNoticeConsumerService jmsNoticeConsumerService;
    private static final Logger logger = LoggerFactory.getLogger(JmsAppLogConsumer.class);

    @JmsListener(destination="appLogQueue", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(Object model) {
        this.handlerAppLog(model);
    }

    private void handlerAppLog(Object source) {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof TextMessage)) {
            return;
        }
        TextMessage textMsg = (TextMessage)source;
        try {
            String text = textMsg.getText();
            this.jmsNoticeConsumerService.addAppLogs(text);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }
}

