/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import javax.annotation.Resource;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="jms", name={"enable", "portal"}, havingValue="true")
public class JmsSysLogConsumer {
    @Resource
    JmsConsumerService jmsConsumerService;
    private static final Logger logger = LoggerFactory.getLogger(JmsSysLogConsumer.class);

    @JmsListener(destination="sysLogQueue", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(Object model) {
        this.handlerSysLog(model);
    }

    private void handlerSysLog(Object source) {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof TextMessage)) {
            return;
        }
        TextMessage textMsg = (TextMessage)source;
        try {
            String text = textMsg.getText();
            this.jmsConsumerService.handlerSysLog(text);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }
}

