/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.consumer;

import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.util.BeanUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
public class JmsSysTypeChangeConsumer {
    @Resource
    JmsConsumerService jmsConsumerService;

    @JmsListener(destination="sysTypeChangeTopic", containerFactory="jmsListenerContainerTopic")
    public void receiveQueue(Object model) throws JMSException {
        this.handlerSysTypeChange(model);
    }

    private void handlerSysTypeChange(Object source) throws JMSException {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage message = (ObjectMessage)source;
        Serializable object = message.getObject();
        this.jmsConsumerService.handlerSysTypeChange(BeanUtils.ObjectToString((Object)object));
    }
}

