/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.activemq.producer;

import com.hotent.activemq.model.JmsHolder;
import com.hotent.activemq.model.JmsMessage;
import com.hotent.base.context.BaseContext;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Topic;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Primary
@Service
@ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
public class DefaultJmsProducer
implements JmsProducer {
    private static final Log logger = LogFactory.getLog(DefaultJmsProducer.class);
    private static final ThreadLocal<List<JmsHolder>> threadMsgs = new ThreadLocal();
    @Resource
    private Queue queue;
    @Resource
    private Topic topic;
    @Resource
    JmsMessagingTemplate jmsMessagingTemplate;
    @Resource
    BaseContext baseContext;
    QueueSession session = null;

    public void sendToQueue(Object object) {
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
        }
        this.sendJmsMessage(new JmsHolder(this.queue, object));
        logger.debug((Object)"[JMS]: Send to queue.");
    }

    public void sendToTopic(Object object) {
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
        }
        this.sendJmsMessage(new JmsHolder(this.topic, object));
        logger.debug((Object)"[JMS]: send to topic.");
    }

    public void sendToQueue(Object object, String queueName) {
        Queue bnsQueue = this.getQueue(queueName);
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
        }
        this.sendJmsMessage(new JmsHolder(bnsQueue, object));
        logger.debug((Object)("[JMS]: Send to queue\uff1a" + queueName));
    }

    public void sendToTopic(Object object, String topicName) {
        Topic bnsTopic = this.getTopic(topicName);
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
        }
        this.sendJmsMessage(new JmsHolder(bnsTopic, object));
        logger.debug((Object)("[JMS]: send to topic\uff1a" + topicName));
    }

    private Queue getQueue(String queueName) {
        ActiveMQQueue bnsQueue = new ActiveMQQueue(queueName);
        return bnsQueue;
    }

    private Topic getTopic(String topicName) {
        ActiveMQTopic bnsTopic = new ActiveMQTopic(topicName);
        return bnsTopic;
    }

    private synchronized void sendJmsMessage(JmsHolder holder) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            if (threadMsgs.get() != null) {
                threadMsgs.get().add(holder);
            } else {
                ArrayList<JmsHolder> holders = new ArrayList<JmsHolder>();
                holders.add(holder);
                threadMsgs.set(holders);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new JmsTransactionSynchronization());
            }
        } else {
            this.sendJmsMessageImmediately(holder);
        }
    }

    private void sendJmsMessageImmediately(JmsHolder holder) {
        try {
            if (holder.getMessage() != null) {
                if (holder.getQueue() != null) {
                    logger.debug((Object)("[JMS]: Send message to queue\uff1a" + holder.getQueue().toString()));
                    this.jmsMessagingTemplate.convertAndSend((Object)holder.getQueue(), holder.getMessage());
                } else if (holder.getTopic() != null) {
                    logger.debug((Object)("[JMS]: Send message to topic\uff1a" + holder.getTopic().toString()));
                    this.jmsMessagingTemplate.convertAndSend((Object)holder.getTopic(), holder.getMessage());
                }
                logger.debug((Object)("[JMS]: Send message content\uff1a" + JsonUtil.toJson((Object)holder.getMessage())));
            }
        }
        catch (Exception e) {
            logger.error((Object)"[JMS]: Send message error.", (Throwable)e);
            e.printStackTrace();
        }
    }

    class JmsTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        JmsTransactionSynchronization() {
        }

        public void afterCommit() {
            List msgs = (List)threadMsgs.get();
            threadMsgs.remove();
            for (JmsHolder holder : msgs) {
                DefaultJmsProducer.this.sendJmsMessageImmediately(holder);
            }
        }

        public void afterCompletion(int status) {
            if (status != 0) {
                threadMsgs.remove();
            }
        }
    }
}

