/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.manager.BpmAgentSettingManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.BpmAgentSetting;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/agent/v1/"})
@Api(tags={"\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e"})
@ApiGroup(group={"group_bpm"})
public class AgentController
extends BaseController<BpmAgentSettingManager, BpmAgentSetting> {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmAgentSetting> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmAgentSetting> queryFilter, @ApiParam(name="isMgr", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestParam Optional<Boolean> isMgr) throws Exception {
        if (!isMgr.orElse(false).booleanValue()) {
            queryFilter.addFilter("auth_id_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "a");
        }
        return ((BpmAgentSettingManager)this.baseService).findAll(queryFilter);
    }

    @RequestMapping(value={"agentGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u59d4\u6258id\u83b7\u53d6\u59d4\u6258\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public Object get(@ApiParam(name="id", value="\uff0c\u6d41\u7a0b\u59d4\u6258id", required=true) @RequestParam String id) throws Exception {
        BpmAgentSetting bpmAgentSetting = null;
        if (StringUtil.isNotEmpty((String)id)) {
            bpmAgentSetting = ((BpmAgentSettingManager)this.baseService).getById(id);
        }
        return bpmAgentSetting;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u59d4\u6258\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u59d4\u6258\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="bpmAgentSet", value="\u59d4\u6258\u5bf9\u8c61", required=true) @RequestBody BpmAgentSetting bpmAgentSet) throws Exception {
        CommonResult res = ((BpmAgentSettingManager)this.baseService).saveBpmAgentSetting(bpmAgentSet);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7528\u6237\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7528\u6237\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u7528\u6237id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            ((BpmAgentSettingManager)this.baseService).removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u5931\u8d25", (Object)"");
        }
    }
}

