/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmMobileCategoryManager;
import com.hotent.bpm.persistence.model.BpmMobileCategory;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bpmMobileCategory/v1/"})
public class BpmMobileCategoryController
extends BaseController<BpmMobileCategoryManager, BpmMobileCategory> {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefAuthorizeManager authorizeManager;

    @RequestMapping(value={"getByTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u79fb\u52a8\u7aef\u6d41\u7a0b\u5206\u7c7b", httpMethod="post", notes="\u901a\u8fc7\u5206\u7c7bID\u83b7\u53d6\u79fb\u52a8\u7aef\u6d41\u7a0b\u5206\u7c7b")
    public PageList<DefaultBpmDefinition> getByTypeId(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter, @ApiParam(name="typeId", value="\u5206\u7c7bID") @RequestParam String typeId) throws Exception {
        queryFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
        return this.bpmDefinitionManager.getByMobileTypeId(typeId, queryFilter);
    }

    @RequestMapping(value={"getByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5206\u7c7bKey\u83b7\u53d6\u6d41\u7a0b", httpMethod="post", notes="\u901a\u8fc7\u5206\u7c7bKey\u83b7\u53d6\u6d41\u7a0b")
    public List<DefaultBpmDefinition> getByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(false)));
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "a");
        queryFilter.addFilter("status_", (Object)"deploy", QueryOP.EQUAL, FieldRelation.AND, "a");
        queryFilter.getParams().put("bpmDefAuthorizeRightType", "start");
        List rows = this.bpmDefinitionManager.queryList(queryFilter).getRows();
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        List defKey = rows.stream().map(DefaultBpmDefinition::getDefKey).collect(Collectors.toList());
        List result = this.bpmDefinitionManager.getByMobileTypeKey(typeKey, defKey);
        return result;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u79fb\u52a8\u7aef\u5206\u7c7b", httpMethod="post", notes="\u4fdd\u5b58\u79fb\u52a8\u7aef\u5206\u7c7b")
    public CommonResult save(@ApiParam(name="defKeys", value="\u6d41\u7a0b\u5206\u7c7bKey", required=true) @RequestBody List<String> defKeys, @ApiParam(name="typeId", value="\u5206\u7c7bID", required=true) @RequestParam String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u5206\u7c7b");
        }
        if (BeanUtils.isEmpty(defKeys)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u6d41\u7a0b");
        }
        ((BpmMobileCategoryManager)this.baseService).saveAll(typeId, defKeys, false);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"removeMobileFlowCategory"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u79fb\u52a8\u7aef\u5206\u7c7b", httpMethod="delete", notes="\u5220\u9664\u79fb\u52a8\u7aef\u5206\u7c7b")
    public CommonResult removeMobileFlowCategory(@ApiParam(name="typeId", value="\u5206\u7c7bID") @RequestParam(value="typeId") String typeId, @ApiParam(name="defKeys", value="\u6d41\u7a0b\u5b9a\u4e49key\u96c6\u5408") @RequestParam(value="defKeys") String defKeys) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return new CommonResult(false, "\u8bf7\u5148\u9009\u62e9\u5206\u7c7b");
        }
        if (StringUtil.isEmpty((String)defKeys)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6d41\u7a0b");
        }
        String[] split = defKeys.split(",");
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.eq((Object)"TYPE_ID_", (Object)typeId)).in((Object)"DEF_KEY_", Arrays.asList(split));
        ((BpmMobileCategoryManager)this.baseService).remove((Wrapper)qw);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"customAddCommonFlow"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u6dfb\u52a0\u79fb\u52a8\u7aef\u5e38\u7528\u6d41\u7a0b", httpMethod="post", notes="\u7528\u6237\u6dfb\u52a0\u79fb\u52a8\u7aef\u5e38\u7528\u6d41\u7a0b")
    public CommonResult customAddCommonFlow(@ApiParam(name="defKeys", value="\u6d41\u7a0b\u5b9a\u4e49key\u96c6\u5408") @RequestBody List<String> defKeys) throws Exception {
        if (BeanUtils.isEmpty(defKeys)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6d41\u7a0b");
        }
        String typeId = "15";
        ((BpmMobileCategoryManager)this.baseService).saveAll(typeId, defKeys, true);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getMyCommonFlow"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u8bbe\u7f6e\u7684\u5e38\u7528\u6d41\u7a0b", httpMethod="post", notes="\u83b7\u53d6\u4e2a\u4eba\u8bbe\u7f6e\u7684\u5e38\u7528\u6d41\u7a0b")
    public PageList<BpmMobileCategory> getMyCommonFlow(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmMobileCategory> queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addFilter("creator_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR, "creator");
        queryFilter.addFilter("creator_", (Object)"admin", QueryOP.LIKE, FieldRelation.OR, "creator");
        queryFilter.addFilter("type_key_", (Object)"default", QueryOP.EQUAL, FieldRelation.AND, "main");
        return ((BpmMobileCategoryManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"batchRemove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="delete", notes="\u6279\u91cf\u5220\u9664")
    public CommonResult batchRemove(@ApiParam(name="ids", value="id\u96c6\u5408") @RequestParam String ids) throws Exception {
        ((BpmMobileCategoryManager)this.baseService).removeByIds(ids.split(","));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

