/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.def.impl.handler.PluginsBpmDefXmlHandler;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.plugin.execution.procnotify.context.ProcNotifyPluginContext;
import com.hotent.bpm.plugin.task.reminders.context.RemindersPluginContext;
import com.hotent.bpm.plugin.task.startnewflow.context.StartNewFlowPluginContext;
import com.hotent.bpm.plugin.task.test.context.TestPluginContext;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.bpmModel.manager.BpmPluginsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmPluginsServiceImpl
implements BpmPluginsService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @Override
    public String procNotifyEdit(String defId) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ProcNotifyPluginContext procNotifyPluginContext = (ProcNotifyPluginContext)defExt.getBpmPluginContext(ProcNotifyPluginContext.class);
        String procNotifyJson = null;
        if (procNotifyPluginContext != null) {
            procNotifyJson = procNotifyPluginContext.getJson();
        }
        return procNotifyJson;
    }

    @Override
    public CommonResult<String> procNotifySave(String defId, String procNotifyJson) throws Exception {
        String resultMsg = null;
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        try {
            if (StringUtil.isNotEmpty((String)defId)) {
                ProcNotifyPluginContext context = new ProcNotifyPluginContext();
                context.parse(procNotifyJson);
                List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(defExt.getBpmPluginContexts(), (BpmPluginContext)context);
                PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
                bpmDefXmlHandler.saveNodeXml(defId, null, plugins);
                resultMsg = "\u529e\u7ed3\u6284\u9001\u6dfb\u52a0\u6210\u529f\uff01";
                BpmUtil.clearCacheByDefId((String)defId);
            }
            return new CommonResult(resultMsg);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u529e\u7ed3\u6284\u9001\u8bbe\u7f6e\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public Map<String, Object> remindersJson(String defId, String nodeId) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        RemindersPluginContext remindersPluginContext = (RemindersPluginContext)nodeDef.getPluginContext(RemindersPluginContext.class);
        HashMap<String, Object> json = new HashMap<String, Object>();
        Map handlerList = MessageUtil.getHandlerTypes();
        json.put("reminders", remindersPluginContext != null ? remindersPluginContext.getBpmPluginDef() : JsonUtil.toJsonNode((String)"{\"reminderList\":[]}"));
        json.put("warnSetting", "[{name:'\u84dd\u8272\u9884\u8b66',color:'blue',level:51},{name:'\u9ec4\u8272\u9884\u8b66',color:'yellow',level:52},{name:'\u7ea2\u8272\u9884\u8b66',color:'red',level:53}]");
        json.put("handlerList", handlerList);
        return json;
    }

    @Override
    public CommonResult<String> reminderSave(String defId, String nodeId, String remindersJson) {
        try {
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            RemindersPluginContext context = new RemindersPluginContext();
            context.parse(remindersJson);
            List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
            PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmDefXmlHandler.saveNodeXml(defId, nodeId, plugins);
            BpmUtil.clearCacheByDefId((String)defId);
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public String getTestPlugin(String defId, String nodeId) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        TestPluginContext remindersPluginContext = (TestPluginContext)nodeDef.getPluginContext(TestPluginContext.class);
        if (BeanUtils.isEmpty((Object)remindersPluginContext)) {
            return "";
        }
        return remindersPluginContext.getJson();
    }

    @Override
    public CommonResult<String> saveTestPlugin(String defId, String nodeId, String json) {
        try {
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            TestPluginContext context = new TestPluginContext();
            context.parse(json);
            List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
            PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmDefXmlHandler.saveNodeXml(defId, nodeId, plugins);
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResult<String> startNewFlowSave(String defId, String nodeId, String json) {
        try {
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            StartNewFlowPluginContext context = new StartNewFlowPluginContext();
            context.parse(json);
            List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
            PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmDefXmlHandler.saveNodeXml(defId, nodeId, plugins);
            BpmUtil.clearCacheByDefId((String)defId);
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<BpmPluginContext> changeOnePluginContextForSave(List<BpmPluginContext> contexts, BpmPluginContext pluginContext) {
        ArrayList<BpmPluginContext> bpmPluginContexts = new ArrayList<BpmPluginContext>();
        bpmPluginContexts.add(pluginContext);
        if (BeanUtils.isEmpty(contexts)) {
            return bpmPluginContexts;
        }
        for (BpmPluginContext context : contexts) {
            if (context.getClass().isAssignableFrom(pluginContext.getClass())) continue;
            bpmPluginContexts.add(context);
        }
        return bpmPluginContexts;
    }
}

