/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.def.impl.handler.VarDefBpmDefXmlHandler;
import com.hotent.bpm.model.var.DefaultBpmVariableDef;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpmModel.manager.BpmDefVarService;
import com.hotent.bpmModel.params.BpmVariableDefVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefVarServiceImpl
implements BpmDefVarService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    VarDefBpmDefXmlHandler varDefBpmDefXmlHandler;

    @Override
    public List<BpmVariableDef> listJson(String defId, String nodeId) throws Exception {
        List<Object> bpmVariableList = new ArrayList<BpmVariableDef>();
        if (StringUtil.isNotEmpty((String)nodeId) && StringUtil.isNotEmpty((String)defId)) {
            UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            bpmVariableList = taskNodeDef.getVariableList();
        } else if (StringUtil.isNotEmpty((String)defId)) {
            try {
                bpmVariableList = this.getAllBpmVariableDef(defId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bpmVariableList;
    }

    @Override
    public Map<String, Object> defVarEdit(String defId, String varKey) throws Exception {
        List nodeDefList = this.bpmDefinitionAccessor.getNodeDefs(defId);
        List<BpmVariableDef> list = this.getAllBpmVariableDef(defId);
        BpmVariableDef bpmVariableDef = null;
        ArrayList<ObjectNode> nodeList = new ArrayList<ObjectNode>();
        for (BpmNodeDef bpmNodeDef : nodeDefList) {
            if (bpmNodeDef.getType() != NodeType.USERTASK) continue;
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("nodeId", bpmNodeDef.getNodeId());
            node.put("name", bpmNodeDef.getName());
            nodeList.add(node);
        }
        for (BpmVariableDef varDef : list) {
            if (!varKey.equals(varDef.getVarKey())) continue;
            bpmVariableDef = varDef;
        }
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("bpmVariableDef", BeanUtils.isEmpty(bpmVariableDef) ? null : JsonUtil.toJsonNode((Object)bpmVariableDef));
        obj.put("nodeDefList", nodeList);
        return obj;
    }

    @Override
    public CommonResult<String> remove(String defId, String varKey) {
        try {
            List<BpmVariableDef> list = this.getAllBpmVariableDef(defId);
            ArrayList<BpmVariableDef> bpmVariableDefs = new ArrayList<BpmVariableDef>();
            for (BpmVariableDef varDef : list) {
                if (varKey.equals(varDef.getVarKey())) continue;
                bpmVariableDefs.add(varDef);
            }
            this.varDefBpmDefXmlHandler.saveNodeXml(defId, null, bpmVariableDefs);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public CommonResult<String> save(BpmVariableDefVo variableDefVo) {
        String defId = variableDefVo.getDefId();
        boolean isAdd = variableDefVo.getIsAdd();
        DefaultBpmVariableDef variableDef = variableDefVo.getVariableDef();
        String varKey = variableDef.getVarKey();
        try {
            List<BpmVariableDef> list = this.getAllBpmVariableDef(defId);
            ArrayList<Object> bpmVariableDefs = new ArrayList<Object>();
            for (BpmVariableDef varDef : list) {
                if (varKey.equals(varDef.getVarKey())) {
                    if (!isAdd) continue;
                    throw new Exception("\u53d8\u91cfKey\u5fc5\u987b\u552f\u4e00\uff01");
                }
                bpmVariableDefs.add(varDef);
            }
            bpmVariableDefs.add(variableDef);
            this.varDefBpmDefXmlHandler.saveNodeXml(defId, null, bpmVariableDefs);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    private List<BpmVariableDef> getAllBpmVariableDef(String defId) throws Exception {
        ArrayList<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getVariableList() != null) {
            bpmVariableList.addAll(defExt.getVariableList());
        }
        List bpmNodeDefList = this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.USERTASK);
        bpmNodeDefList.addAll(this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.SIGNTASK));
        for (BpmNodeDef bpmNodeDef : bpmNodeDefList) {
            UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)bpmNodeDef;
            List nodeVarList = taskNodeDef.getVariableList();
            if (nodeVarList == null) continue;
            bpmVariableList.addAll(nodeVarList);
        }
        return bpmVariableList;
    }
}

