/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.manager.BpmDefActManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeTypeManager;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.BpmDefAct;
import com.hotent.bpm.persistence.model.BpmDefAuthorize;
import com.hotent.bpm.persistence.model.BpmDefAuthorizeType;
import com.hotent.bpm.persistence.model.BpmDefUser;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/defAuthorize/v1/"})
@Api(tags={"\u6d41\u7a0b\u5206\u7ba1\u6388\u6743"})
@ApiGroup(group={"group_bpm"})
public class DefAuthorizeController
extends BaseController<BpmDefAuthorizeManager, BpmDefAuthorize> {
    @Resource
    private BpmDefinitionManager bpmDefinitionManager;
    @Autowired
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    UCFeignService ucFeignService;
    @Autowired
    BpmDefActManager bpmDefActManager;
    @Autowired
    BpmDefAuthorizeTypeManager bpmDefAuthorizeTypeManager;
    @Autowired
    BpmDefUserManager bpmDefUserManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u6d41\u7a0b\u5b9a\u4e49\u6743\u9650\u5217\u8868", httpMethod="POST", notes="\u53d6\u5f97\u6d41\u7a0b\u5b9a\u4e49\u6743\u9650\u5217\u8868")
    public PageList<BpmDefAuthorize> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmDefAuthorize> queryFilter) throws Exception {
        PageList pageList = ((BpmDefAuthorizeManager)this.baseService).getAuthorizeListByFilter(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u65b0\u589e\u6216\u4fee\u6539\u6388\u6743\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u65b0\u589e\u6216\u4fee\u6539\u6388\u6743\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="author", value="\u6388\u6743\u4fe1\u606f", required=true) @RequestBody BpmDefAuthorize author) throws Exception {
        CommonResult res = this.bpmDefAuthorizeManager.saveBpmDefAuthorize(author);
        return res;
    }

    @RequestMapping(value={"del"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u4fe1\u606f", httpMethod="DELETE", notes="\u5220\u9664\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u4fe1\u606f")
    public CommonResult<String> del(@ApiParam(name="ids", value="\u6388\u6743\u4fe1\u606fid\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            ((BpmDefAuthorizeManager)this.baseService).deleteAuthorizeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6388\u6743\u4fe1\u606f\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u5220\u9664\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01", (Object)"");
        }
    }

    @RequestMapping(value={"defAuthorizeGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u5f97\u6d41\u7a0b\u5206\u7ba1\u6388\u6743\u8be6\u60c5")
    public Object defAuthorizeGet(@ApiParam(name="id", value="\u5206\u7ba1\u6388\u6743id", required=true) @RequestParam String id) throws Exception {
        Object res = this.bpmDefAuthorizeManager.defAuthorizeGet(id);
        return res;
    }

    @RequestMapping(value={"getPermissionList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u9ed8\u8ba4\u6743\u9650\u7c7b\u578b", httpMethod="GET", notes="\u83b7\u5f97\u9ed8\u8ba4\u6743\u9650\u7c7b\u578b")
    public Object getPermissionList() throws Exception {
        return AppUtil.getBean((String)"defaultObjectRightType");
    }

    @RequestMapping(value={"startRight"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u548c\u6d41\u7a0bID\u5224\u65ad\u662f\u5426\u6709\u542f\u52a8\u6743\u9650", httpMethod="GET", notes="\u6839\u636e\u7528\u6237ID\u548c\u6d41\u7a0bID\u5224\u65ad\u662f\u5426\u6709\u6d41\u7a0b\u542f\u52a8\u6743\u9650")
    public CommonResult<Boolean> startRight(@ApiParam(required=true, name="userId", value="\u7528\u6237ID") String userId, @ApiParam(required=true, name="defId", value="\u6d41\u7a0b\u5b9a\u4e49ID") String defId, @ApiParam(required=true, name="leadId", value="\u9886\u5bfcid") String leadId, @ApiParam(required=true, name="instId", value="\u5b9e\u4f8bid") Optional<String> instId) throws Exception {
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return new CommonResult(true, "\u7ba1\u7406\u5458", (Object)true);
        }
        Boolean hasRight = ((BpmDefAuthorizeManager)this.baseService).getStartRightByUserIdAndDefId(userId, defId, leadId, (String)instId.orElse(null));
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)hasRight);
    }

    @RequestMapping(value={"getAuthDetailPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u5206\u7ba1\u6388\u6743\u660e\u7ec6\u5217\u8868")
    public PageList<HashMap<String, Object>> getUserOrgPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter) throws Exception {
        IPage p = ((BpmDefAuthorizeManager)this.baseService).getAuthDetailPage(filter);
        return new PageList(p);
    }

    @RequestMapping(value={"getManageBtnByFlowDefId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bid \u83b7\u53d6 \u6388\u6743\u529f\u80fd\u6309\u94ae\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bid \u83b7\u53d6 \u6388\u6743\u529f\u80fd\u6309\u94ae\u4fe1\u606f")
    public CommonResult<ObjectNode> getManageBtnByFlowDefId(@ApiParam(name="flowDefId", value="\u4e1a\u52a1\u6570\u636eid", required=true) @RequestParam String flowDefId, @ApiParam(name="userId", value="userId") @RequestParam String userId) throws Exception {
        flowDefId = flowDefId.indexOf(95) != -1 ? flowDefId.substring(flowDefId.indexOf(95) + 1) : flowDefId;
        Object userRightMap = new HashedMap();
        if (StringUtil.isNotEmpty((String)userId)) {
            Map rmap = this.ucFeignService.getUserRightMapByIds(userId);
            userRightMap = (Map)rmap.get(userId);
            if (userRightMap.get("position") != null) {
                userRightMap.put("pos", userRightMap.get("position"));
            }
            userRightMap.remove("position");
        }
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(flowDefId);
        String defKey = bpmDefinition.getDefKey();
        ObjectNode resultNode = JsonUtil.createObjectNode();
        HashedMap map = new HashedMap();
        map.put("defKey", defKey);
        map.put("type", "1");
        List actList = this.bpmDefActManager.getAll((Map)map);
        if (actList == null || actList.size() <= 0) {
            CommonResult result = new CommonResult(ResponseErrorEnums.SUCCESS_OPTION);
            result.setValue((Object)resultNode);
            return result;
        }
        BpmDefAct bpmDefAct = (BpmDefAct)actList.get(0);
        String authorizeId = bpmDefAct.getAuthorizeId();
        String rightContent = bpmDefAct.getRightContent();
        JsonNode rightJsonNode = JsonUtil.toJsonNode((String)rightContent);
        Iterator fields = rightJsonNode.fields();
        ArrayNode rightArrayNode = JsonUtil.createArrayNode();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            ObjectNode rightNode = JsonUtil.createObjectNode();
            String key = (String)entry.getKey();
            boolean val = ((JsonNode)entry.getValue()).asBoolean();
            String title = "";
            if ("m_edit".equals(key)) {
                title = "\u7f16\u8f91";
            } else if ("m_del".equals(key)) {
                title = "\u5220\u9664";
            } else if ("m_start".equals(key)) {
                title = "\u542f\u52a8";
            } else if ("m_clean".equals(key)) {
                title = "\u6e05\u9664\u6570\u636e";
            } else if ("i_del".equals(key)) {
                title = "\u5b9e\u4f8b\u5220\u9664";
            } else if ("i_org".equals(key)) {
                title = "\u5b9e\u4f8b\u672c\u90e8\u95e8";
            } else if ("m_set".equals(key) || "i_log".equals(key)) continue;
            rightNode.put("type", key);
            rightNode.put("title", title);
            rightNode.put("flag", val);
            rightArrayNode.add((JsonNode)rightNode);
        }
        resultNode.put("right", (JsonNode)rightArrayNode);
        HashedMap typeMap = new HashedMap();
        typeMap.put("authorizeId", authorizeId);
        List typeList = this.bpmDefAuthorizeTypeManager.getAll((Map)typeMap);
        ArrayNode typeArrayNode = JsonUtil.createArrayNode();
        for (int i = 0; i < typeList.size(); ++i) {
            BpmDefAuthorizeType type = (BpmDefAuthorizeType)typeList.get(i);
            ObjectNode typeNode = JsonUtil.createObjectNode();
            String authorizeType = type.getAuthorizeType();
            String title = "";
            if ("start".equals(authorizeType)) {
                title = "\u542f\u52a8";
            } else if ("management".equals(authorizeType)) {
                title = "\u7ba1\u7406";
            } else if ("task".equals(authorizeType)) {
                title = "\u4efb\u52a1";
            } else if ("instance".equals(authorizeType)) {
                title = "\u5b9e\u4f8b";
            }
            typeNode.put("type", authorizeType);
            typeNode.put("title", title);
            typeArrayNode.add((JsonNode)typeNode);
        }
        resultNode.put("authorize", (JsonNode)typeArrayNode);
        HashedMap userMap = new HashedMap();
        userMap.put("authorizeId", authorizeId);
        userMap.put("objType", "bpmDef");
        List userList = this.bpmDefUserManager.getAll((Map)userMap);
        HashedMap rightTypeMap = new HashedMap();
        for (int i = 0; i < userList.size(); ++i) {
            BpmDefUser user = (BpmDefUser)userList.get(i);
            String rightType = user.getRightType();
            String string = user.getOwnerId();
            String ownerName = user.getOwnerName();
            String[] tmp = (String[])rightTypeMap.get(rightType);
            if (tmp == null) {
                tmp = new String[]{string, ownerName};
            } else {
                tmp[0] = tmp[0] + "," + string;
                tmp[1] = tmp[1] + "," + ownerName;
            }
            rightTypeMap.put(rightType, tmp);
        }
        boolean showFlag = false;
        ArrayNode userArrayNode = JsonUtil.createArrayNode();
        for (Map.Entry entry : rightTypeMap.entrySet()) {
            ObjectNode rightNode = JsonUtil.createObjectNode();
            String rightType = (String)entry.getKey();
            String[] rightValue = (String[])entry.getValue();
            String ownerId = rightValue[0];
            String ownerName = rightValue[1];
            String rightTitle = "";
            if ("user".equals(rightType)) {
                rightTitle = "\u7528\u6237";
            } else if ("org".equals(rightType)) {
                rightTitle = "\u7ec4\u7ec7";
            } else if ("pos".equals(rightType)) {
                rightTitle = "\u5c97\u4f4d";
            } else if ("role".equals(rightType)) {
                rightTitle = "\u89d2\u8272";
            } else if ("everyone".equals(rightType)) {
                rightTitle = "\u5168\u90e8";
                showFlag = true;
            }
            ObjectNode rightUserNode = JsonUtil.createObjectNode();
            rightUserNode.put("type", rightType);
            rightUserNode.put("title", rightTitle);
            rightUserNode.put("id", ownerId);
            rightUserNode.put("name", ownerName);
            if ("user".equals(rightType) || "org".equals(rightType) || "pos".equals(rightType) || "role".equals(rightType)) {
                String tmp = (String)userRightMap.get(rightType);
                tmp = StringUtil.isEmpty((String)tmp) ? "" : tmp.replaceAll("'", "");
                showFlag = this.hasDuplicates(tmp, ownerId);
                Map<String, Object> rightMap = this.getRightsFullInfo(rightType, ownerId);
                List rightInfoList = (List)rightMap.get("info");
                ArrayNode RightInfoArrayNode = JsonUtil.listToArrayNode((List)rightInfoList);
                rightUserNode.put("info", (JsonNode)RightInfoArrayNode);
            }
            rightUserNode.put("showFlag", showFlag);
            userArrayNode.add((JsonNode)rightUserNode);
        }
        resultNode.put("user", (JsonNode)userArrayNode);
        CommonResult result = new CommonResult(ResponseErrorEnums.SUCCESS_OPTION);
        result.setValue((Object)resultNode);
        return result;
    }

    private boolean hasDuplicates(String str1, String str2) {
        List list1 = Arrays.stream(str1.split(",")).collect(Collectors.toList());
        List list2 = Arrays.stream(str2.split(",")).collect(Collectors.toList());
        ArrayList intersection = new ArrayList(list1);
        intersection.retainAll(list2);
        return !intersection.isEmpty();
    }

    private Map<String, Object> getRightsFullInfo(String type, String ids) {
        HashedMap map = new HashedMap();
        if ("role".equals(type)) {
            ArrayList<ObjectNode> roleList = new ArrayList<ObjectNode>();
            List<String> idList = Arrays.asList(ids.split(","));
            for (int j = 0; j < idList.size(); ++j) {
                String id = idList.get(j);
                CommonResult commonResult = this.ucFeignService.getRoleByIdOrCode(id);
                if (!BeanUtils.isNotEmpty((Object)commonResult)) continue;
                ObjectNode node = (ObjectNode)commonResult.getValue();
                roleList.add(node);
            }
            map.put("info", roleList);
        } else if ("org".equals(type)) {
            ArrayList<ObjectNode> orgList = new ArrayList<ObjectNode>();
            List<String> idList = Arrays.asList(ids.split(","));
            for (int j = 0; j < idList.size(); ++j) {
                String id = idList.get(j);
                ObjectNode node = this.ucFeignService.getOrgById(id);
                if (!BeanUtils.isNotEmpty((Object)node)) continue;
                orgList.add(node);
            }
            map.put("info", orgList);
        } else if ("pos".equals(type)) {
            ArrayList<ObjectNode> userList = new ArrayList<ObjectNode>();
            List<String> idList = Arrays.asList(ids.split(","));
            for (int j = 0; j < idList.size(); ++j) {
                String id = idList.get(j);
                CommonResult commonResult = this.ucFeignService.getPostByIdOrCode(id);
                if (!BeanUtils.isNotEmpty((Object)commonResult)) continue;
                ObjectNode node = (ObjectNode)commonResult.getValue();
                userList.add(node);
            }
            map.put("info", userList);
        } else if ("user".equals(type)) {
            ArrayList<JsonNode> userList = new ArrayList<JsonNode>();
            List<String> idList = Arrays.asList(ids.split(","));
            for (int j = 0; j < idList.size(); ++j) {
                String id = idList.get(j);
                CommonResult commonResult = this.ucFeignService.getUserById(id);
                if (!BeanUtils.isNotEmpty((Object)commonResult)) continue;
                JsonNode node = (JsonNode)commonResult.getValue();
                userList.add(node);
            }
            map.put("info", userList);
        } else if ("job".equals(type)) {
            ArrayList<ObjectNode> jobList = new ArrayList<ObjectNode>();
            List<String> idList = Arrays.asList(ids.split(","));
            for (int j = 0; j < idList.size(); ++j) {
                String id = idList.get(j);
                ObjectNode node = this.ucFeignService.getJobByIdOrCode(id);
                if (!BeanUtils.isNotEmpty((Object)node)) continue;
                jobList.add(node);
            }
            map.put("info", jobList);
        }
        return map;
    }
}

