/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.persistence.constants.CategoryConstants;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpmModel.dao.BpmApprovalItemDao;
import com.hotent.bpmModel.manager.BpmApprovalItemManager;
import com.hotent.bpmModel.model.BpmApprovalItem;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.client.ClientProtocolException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmApprovalItemManager")
public class BpmApprovalItemManagerImpl
extends BaseManagerImpl<BpmApprovalItemDao, BpmApprovalItem>
implements BpmApprovalItemManager {
    @Resource
    PortalFeignService PortalFeignService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @Override
    @Transactional
    public void addTaskApproval(BpmApprovalItem bpmApprovalItem) throws Exception {
        short type = bpmApprovalItem.getType();
        String curUserId = ContextUtil.getCurrentUserId();
        String[] expressions = new String[]{StringUtil.join((String[])bpmApprovalItem.getExpression().split("\n"), (String)"")};
        if (type == 1 || type == 4) {
            for (String expression : expressions) {
                if (!StringUtil.isNotEmpty((String)expression)) continue;
                if (this.getCount(expression, type, bpmApprovalItem.getId()).booleanValue()) {
                    bpmApprovalItem.setUpdateTime(LocalDateTime.now());
                    ((BpmApprovalItemDao)this.baseMapper).updateById((Object)bpmApprovalItem);
                    return;
                }
                BpmApprovalItem approvalItem = new BpmApprovalItem();
                approvalItem.setId(UniqueIdUtil.getSuid());
                approvalItem.setType(type);
                approvalItem.setExpression(expression);
                approvalItem.setUserId(curUserId);
                approvalItem.setUpdateTime(LocalDateTime.now());
                ((BpmApprovalItemDao)this.baseMapper).insert((Object)approvalItem);
            }
        } else if (type == 2) {
            String[] typeIds;
            if (StringUtil.isEmpty((String)bpmApprovalItem.getTypeId())) {
                return;
            }
            for (String typeId : typeIds = bpmApprovalItem.getTypeId().split(",")) {
                for (String expression : expressions) {
                    if (!StringUtil.isNotEmpty((String)expression)) continue;
                    BpmApprovalItem approvalItem = new BpmApprovalItem();
                    approvalItem.setId(UniqueIdUtil.getSuid());
                    approvalItem.setType(type);
                    approvalItem.setTypeId(typeId);
                    approvalItem.setExpression(expression);
                    approvalItem.setUserId(curUserId);
                    approvalItem.setDefName(this.PortalFeignService.getSysTypeById(typeId).get("name").asText());
                    approvalItem.setUpdateTime(LocalDateTime.now());
                    ((BpmApprovalItemDao)this.baseMapper).insert((Object)approvalItem);
                }
            }
        } else if (type == 3) {
            if (StringUtil.isEmpty((String)bpmApprovalItem.getDefKey())) {
                return;
            }
            String[] defKeys = bpmApprovalItem.getDefKey().split(",");
            String names = bpmApprovalItem.getDefName();
            String[] defNames = names.split(",");
            for (int i = 0; i < defKeys.length; ++i) {
                for (String expression : expressions) {
                    if (!StringUtil.isNotEmpty((String)expression)) continue;
                    BpmApprovalItem approvalItem = new BpmApprovalItem();
                    approvalItem.setId(UniqueIdUtil.getSuid());
                    approvalItem.setType(type);
                    approvalItem.setDefKey(defKeys[i]);
                    approvalItem.setExpression(expression);
                    approvalItem.setDefName(defNames[i]);
                    approvalItem.setUserId(curUserId);
                    approvalItem.setUpdateTime(LocalDateTime.now());
                    ((BpmApprovalItemDao)this.baseMapper).insert((Object)approvalItem);
                }
            }
        }
        if (StringUtil.isNotEmpty((String)bpmApprovalItem.getId())) {
            ((BpmApprovalItemDao)this.baseMapper).deleteById((Serializable)((Object)bpmApprovalItem.getId()));
        }
    }

    private Boolean getCount(String expression, int type, String id) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"expression_", (Object)expression);
        wrapper.eq((Object)"type_", (Object)type);
        if (type == 4) {
            wrapper.eq((Object)"user_id_", (Object)ContextUtil.getCurrentUserId());
        }
        Boolean falg = false;
        BpmApprovalItem bpmApprovalItem = (BpmApprovalItem)((Object)((BpmApprovalItemDao)this.baseMapper).selectOne((Wrapper)wrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)bpmApprovalItem)) && StringUtil.isEmpty((String)id)) {
            throw new RuntimeException("\u5e38\u7528\u8bed\u3010" + expression + "\u3011\u5df2\u5b58\u5728");
        }
        if (BeanUtils.isNotEmpty((Object)((Object)bpmApprovalItem)) && StringUtil.isNotEmpty((String)id) && !id.equals(bpmApprovalItem.getId())) {
            throw new RuntimeException("\u5e38\u7528\u8bed\u3010" + expression + "\u3011\u5df2\u5b58\u5728");
        }
        if (BeanUtils.isNotEmpty((Object)((Object)bpmApprovalItem)) && StringUtil.isNotEmpty((String)id) && id.equals(bpmApprovalItem.getId())) {
            falg = true;
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmApprovalItem)) && StringUtil.isNotEmpty((String)id)) {
            falg = true;
        }
        return falg;
    }

    @Override
    public List<String> getApprovalByDefKeyAndTypeId(String defKey, String typeId, String userId) throws ClientProtocolException, IOException {
        ArrayList<String> taskAppItemsList = new ArrayList<String>();
        String curUserId = StringUtil.isNotEmpty((String)userId) ? userId : ContextUtil.getCurrentUserId();
        List<BpmApprovalItem> taskAppItem1 = ((BpmApprovalItemDao)this.baseMapper).getByDefKeyAndUserAndSys(defKey, curUserId);
        List<BpmApprovalItem> taskAppItem2 = ((BpmApprovalItemDao)this.baseMapper).getItemByType(BpmApprovalItem.TYPE_GLOBAL);
        if (BeanUtils.isNotEmpty(taskAppItem1)) {
            for (BpmApprovalItem taskAppItem : taskAppItem1) {
                taskAppItemsList.add(taskAppItem.getExpression());
            }
        }
        if (BeanUtils.isNotEmpty(taskAppItem2)) {
            for (BpmApprovalItem taskAppItem : taskAppItem2) {
                Boolean falg = true;
                for (BpmApprovalItem entity : taskAppItem1) {
                    if (!entity.getExpression().equals(taskAppItem.getExpression())) continue;
                    falg = false;
                    break;
                }
                if (!falg.booleanValue()) continue;
                taskAppItemsList.add(taskAppItem.getExpression());
            }
        }
        return taskAppItemsList;
    }

    @Override
    public PageList<BpmApprovalItem> listJson(boolean isPersonal, QueryFilter<BpmApprovalItem> queryFilter) {
        PageList bpmApprovalItemts = null;
        if (!isPersonal) {
            queryFilter.addFilter("TYPE_", (Object)4, QueryOP.NOT_EQUAL, FieldRelation.AND, "a");
            bpmApprovalItemts = this.query(queryFilter);
        } else {
            String currUserId = ContextUtil.getCurrentUserId();
            queryFilter.addFilter("TYPE_", (Object)4, QueryOP.EQUAL, FieldRelation.AND, "a");
            queryFilter.addFilter("USER_ID_", (Object)currUserId, QueryOP.EQUAL, FieldRelation.AND, "a");
            bpmApprovalItemts = this.query(queryFilter);
        }
        QueryFilter queryFilter2 = QueryFilter.build();
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter2.addFilter("type_group_key_", (Object)CategoryConstants.CAT_FLOW.key(), QueryOP.EQUAL);
        ObjectNode result = this.PortalFeignService.getAllSysType(queryFilter2);
        List sysTypeList = null;
        try {
            sysTypeList = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)result.get("rows")), (TypeReference)new TypeReference<List<ObjectNode>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List bpmDefinitionlList = this.bpmDefinitionManager.getAll();
        for (BpmApprovalItem approvalItem : bpmApprovalItemts.getRows()) {
            if (approvalItem.getType().equals(BpmApprovalItem.TYPE_FLOW)) {
                for (DefaultBpmDefinition bpmDefinition : bpmDefinitionlList) {
                    if (!approvalItem.getDefKey().equals(bpmDefinition.getDefKey())) continue;
                    approvalItem.setDefKey(bpmDefinition.getName());
                }
                continue;
            }
            if (approvalItem.getType().equals(BpmApprovalItem.TYPE_FLOWTYPE)) {
                for (ObjectNode ISysType : sysTypeList) {
                    if (!approvalItem.getTypeId().equals(ISysType.get("id").asText())) continue;
                    approvalItem.setTypeId(ISysType.get("name").asText());
                }
                continue;
            }
            approvalItem.setDefKey("\u6240\u6709\u6d41\u7a0b");
        }
        return bpmApprovalItemts;
    }

    private void removeDuplicate(List<?> list) {
        HashSet h = new HashSet(list);
        list.clear();
        list.addAll(h);
    }
}

