/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.constant.DecideType;
import com.hotent.bpm.api.constant.FlowExtraVars;
import com.hotent.bpm.api.constant.FollowMode;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.PrivilegeMode;
import com.hotent.bpm.api.constant.ScriptType;
import com.hotent.bpm.api.constant.VoteType;
import com.hotent.bpm.api.def.BpmDefXmlHandler;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmBoDef;
import com.hotent.bpm.api.model.process.def.BpmDefLayout;
import com.hotent.bpm.api.model.process.def.BpmDefSetting;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.BpmSubTableRight;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.def.EventScript;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.def.Restful;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.AutoTaskDef;
import com.hotent.bpm.api.model.process.nodedef.ext.BaseBpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultJumpRule;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.PrivilegeItem;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.SignRule;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.hotent.bpm.api.plugin.core.context.AbstractBpmPluginContext;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.DiagramService;
import com.hotent.bpm.engine.def.impl.DefaultBpmDefConditionService;
import com.hotent.bpm.engine.def.impl.handler.BoBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.BpmDefSettingBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.ButtonsBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.EventScriptBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.PluginsBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.PrivilegeBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.SignRulesBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.SubRightBpmDefXmlHandler;
import com.hotent.bpm.engine.def.impl.handler.TransRulesBpmDefXmlHandler;
import com.hotent.bpm.model.form.BpmUrlForm;
import com.hotent.bpm.model.form.DefaultForm;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.persistence.manager.BpmDefDataManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProBoManager;
import com.hotent.bpm.persistence.model.BpmDefData;
import com.hotent.bpm.persistence.model.BpmProBo;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.plugin.core.util.UserAssignRuleParser;
import com.hotent.bpm.plugin.execution.globalRestful.context.GlobalRestFulsPluginContext;
import com.hotent.bpm.plugin.task.restful.context.RestFulsPluginContext;
import com.hotent.bpm.plugin.task.userassign.UserCopyToDefBpmDefXmlHandler;
import com.hotent.bpm.plugin.task.userassign.UserDefBpmDefXmlHandler;
import com.hotent.bpm.plugin.task.userassign.context.UserAssignPluginContext;
import com.hotent.bpm.plugin.task.userassign.context.UserCopyToPluginContext;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.HandlerUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.bpmModel.manager.BpmNodeService;
import com.hotent.bpmModel.params.DefConfSaveVo;
import com.hotent.bpmModel.params.NodeConfCopyVo;
import com.hotent.bpmModel.params.NodeConfSaveVo;
import com.hotent.bpmModel.params.VarTreeGetVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmNodeServiceImpl
implements BpmNodeService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Autowired
    FormFeignService formFeignService;
    @Resource
    private FormFeignService formRestfulService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    DiagramService diagramService;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    BoBpmDefXmlHandler boBpmDefXmlHandler;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    BpmDefDataManager bpmDefDataManager;

    @Override
    public CommonResult<String> saveSub(String nodeId, String defId, String parentDefKey, HttpServletRequest request) throws Exception {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            ArrayList<BpmSubTableRight> rights = new ArrayList<BpmSubTableRight>();
            String json = FileUtil.inputStream2String((InputStream)request.getInputStream());
            JsonNode jobj = JsonUtil.toJsonNode((String)json);
            for (JsonNode jsonNode : jobj) {
                BpmSubTableRight right = (BpmSubTableRight)JsonUtil.toBean((JsonNode)jsonNode, BpmSubTableRight.class);
                rights.add(right);
            }
            param.put("list", rights);
            param.put("parentDefKey", parentDefKey);
            BpmDefXmlHandler handler = (BpmDefXmlHandler)AppUtil.getBean(SubRightBpmDefXmlHandler.class);
            handler.saveNodeXml(defId, nodeId, param);
            return new CommonResult(true, "\u4fdd\u5b58\u5b50\u8868\u6743\u9650\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u5b50\u8868\u6743\u9650\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public Map<String, Object> ruleEdit(String definitionId, String nodeId) throws Exception {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        List nodeDefList = this.bpmDefinitionAccessor.getAllNodeDef(definitionId);
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (BpmNodeDef bpmNodeDef : nodeDefList) {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("nodeId", bpmNodeDef.getNodeId());
            node.put("name", bpmNodeDef.getName());
            node.set("nodeType", JsonUtil.toJsonNode((Object)bpmNodeDef.getType()));
            list.add(node);
        }
        BpmNodeDef bpmNodeDef = this.bpmDefinitionService.getBpmNodeDefByDefIdNodeId(definitionId, nodeId);
        if (bpmNodeDef instanceof BaseBpmNodeDef) {
            resMap.put("nodeDef", (BaseBpmNodeDef)bpmNodeDef);
        } else if (bpmNodeDef instanceof UserTaskNodeDef) {
            resMap.put("nodeDef", (UserTaskNodeDef)bpmNodeDef);
        } else {
            resMap.put("nodeDef", bpmNodeDef);
        }
        resMap.put("nodeDefList", list);
        return resMap;
    }

    @Override
    public Map<String, Object> branchConditionEdit(String nodeId, String defId) throws Exception {
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<ObjectNode> incomeNodes = new ArrayList<ObjectNode>();
        for (BpmNodeDef def : bpmNodeDef.getIncomeNodes()) {
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("nodeId", def.getNodeId());
            obj.put("name", def.getName());
            incomeNodes.add(obj);
        }
        ArrayList<ObjectNode> outcomeNodes = new ArrayList<ObjectNode>();
        for (BpmNodeDef def : bpmNodeDef.getOutcomeNodes()) {
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("nodeId", def.getNodeId());
            obj.put("name", def.getName());
            outcomeNodes.add(obj);
        }
        data.put("incomeNodes", incomeNodes);
        data.put("outcomeNodes", outcomeNodes);
        data.put("conditions", bpmNodeDef.getConditions());
        return data;
    }

    @Override
    public CommonResult<String> eventScriptSave(NodeConfSaveVo vo) {
        String defId = vo.getDefId();
        String nodeId = vo.getNodeId();
        String eventScriptArray = vo.getEventScriptArray();
        try {
            EventScriptBpmDefXmlHandler eventScriptHandler = (EventScriptBpmDefXmlHandler)AppUtil.getBean(EventScriptBpmDefXmlHandler.class);
            ArrayNode eventScript = (ArrayNode)JsonUtil.toJsonNode((String)eventScriptArray);
            for (int i = 0; i < eventScript.size(); ++i) {
                ObjectNode objct = (ObjectNode)eventScript.get(i);
                ScriptType scriptType = ScriptType.fromKey((String)objct.get("scriptType").asText());
                EventScript es = new EventScript(scriptType, objct.get("content").asText());
                eventScriptHandler.saveNodeXml(defId, nodeId, (Object)es);
            }
            BpmUtil.clearCacheByDefId((String)defId);
            return new CommonResult("\u811a\u672c\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u811a\u672c\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public Object signConfigSave(NodeConfSaveVo vo) {
        String defId = vo.getDefId();
        String nodeId = vo.getNodeId();
        String signRuleJson = vo.getSignRule();
        String privilegeListJson = vo.getPrivilegeList();
        String resultMsg = "";
        try {
            if (StringUtil.isNotEmpty((String)nodeId)) {
                List<PrivilegeItem> privilegeList = this.getPrivilegeList(privilegeListJson);
                SignRule signRule = this.getSignRule(signRuleJson);
                SignRulesBpmDefXmlHandler signRulesBpmDefXmlHandler = (SignRulesBpmDefXmlHandler)AppUtil.getBean(SignRulesBpmDefXmlHandler.class);
                signRulesBpmDefXmlHandler.saveNodeXml(defId, nodeId, (Object)signRule);
                resultMsg = "\u4f1a\u7b7e\u89c4\u5219\u66f4\u65b0\u6210\u529f\uff0c\u4f1a\u7b7e\u6743\u9650\u4eba\u5458\u914d\u7f6e\u66f4\u65b0\u5931\u8d25!";
                PrivilegeBpmDefXmlHandler privilegeBpmDefXmlHandler = (PrivilegeBpmDefXmlHandler)AppUtil.getBean(PrivilegeBpmDefXmlHandler.class);
                privilegeBpmDefXmlHandler.saveNodeXml(defId, nodeId, privilegeList);
                resultMsg = "\u4f1a\u7b7e\u8282\u70b9\u914d\u7f6e\u6210\u529f";
            }
            return new CommonResult(resultMsg);
        }
        catch (Exception e) {
            resultMsg = resultMsg == null ? "\u4f1a\u7b7e\u89c4\u5219\u914d\u7f6e\u5931\u8d25" : resultMsg;
            e.printStackTrace();
            return new CommonResult(false, resultMsg);
        }
    }

    @Override
    public Object varTree(VarTreeGetVo vo) throws Exception {
        boolean includeBpmConstants;
        BpmDefinition parentDefinition;
        String defId = vo.getDefId();
        boolean removeSub = vo.getRemoveSub();
        boolean removeMain = vo.getRemoveMain();
        String flowKey = vo.getFlowKey();
        String nodeId = vo.getNodeId();
        String parentFlowKey = vo.getParentFlowKey();
        if (StringUtil.isNotEmpty((String)parentFlowKey) && BeanUtils.isNotEmpty((Object)(parentDefinition = this.bpmDefinitionService.getBpmDefinitionByDefKey(parentFlowKey, true)))) {
            defId = parentDefinition.getDefId();
        }
        if (StringUtil.isEmpty((String)defId) && StringUtil.isNotEmpty((String)flowKey)) {
            BpmDefinition definition = this.bpmDefinitionService.getBpmDefinitionByDefKey(flowKey, false);
            defId = definition.getDefId();
        }
        ArrayNode treeJA = JsonUtil.getMapper().createArrayNode();
        if (StringUtil.isEmpty((String)defId)) {
            this.handleSetExtraVars(treeJA);
            return treeJA;
        }
        BpmProcessDef procDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List boDefs = procDef.getProcessDefExt().getBoDefList();
        ArrayNode boList = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)boDefs) && vo.isBpmForm()) {
            for (ProcBoDef boDef : boDefs) {
                ObjectNode def = this.formFeignService.getBodefByAlias(boDef.getKey());
                ObjectNode objec = this.formRestfulService.getBoJosn(def.get("id").asText());
                if (removeSub || removeMain) {
                    JsonNode children = objec.get("children");
                    ArrayNode temp = JsonUtil.getMapper().createArrayNode();
                    for (Object obj : children) {
                        JsonNode json = (JsonNode)obj;
                        if (json.get("children") == null && removeSub) {
                            temp.add(json);
                        }
                        if (json.get("children") == null || !removeMain) continue;
                        temp.add(json);
                    }
                    objec.set("children", (JsonNode)temp);
                }
                boList.add((JsonNode)objec);
            }
            JsonNode bos = JsonUtil.toJsonNode((String)"{\"id\":\"0\",\"parentId\":\"-1\",\"desc\":\"\u8868\u5355\u53d8\u91cf\",\"name\":\"\u8868\u5355\u53d8\u91cf\",\"con\":\"fa fa-bold dark\"}");
            ((ObjectNode)bos).set("children", (JsonNode)boList);
            treeJA.add(bos);
        }
        if (!(includeBpmConstants = vo.getIncludeBpmConstants())) {
            this.handleSetExtraVars(treeJA);
            return treeJA;
        }
        ObjectNode flowVarJson = this.getFlowVarJson((BpmProcessDef<BpmProcessDefExt>)procDef, nodeId, vo.isUrgent());
        if (flowVarJson != null) {
            treeJA.add((JsonNode)flowVarJson);
        }
        this.handleSetExtraVars(treeJA);
        return treeJA;
    }

    private void handleSetExtraVars(ArrayNode treeJa) {
        treeJa.add((JsonNode)FlowExtraVars.getExtraVarTreeNode());
    }

    @Override
    public Map<String, Object> nodeDefSetting(String defId, String topDefKey) throws Exception {
        DefaultBpmDefinition bpmDefinition = null;
        BpmDefLayout bpmDefLayout = null;
        if (StringUtil.isNotEmpty((String)defId)) {
            bpmDefinition = this.bpmDefinitionManager.getById(defId);
            bpmDefLayout = this.diagramService.getLayoutByDefId(defId);
        }
        Map messageTypelist = MessageUtil.getHandlerTypes();
        HashMap<String, Object> initData = new HashMap<String, Object>();
        initData.put("bpmDefinition", bpmDefinition);
        initData.put("bpmDefLayout", bpmDefLayout);
        initData.put("messageTypelist", messageTypelist);
        HashMap<String, Object> nodeSetData = new HashMap<String, Object>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        BpmDefSetting bpmDefSetting = new BpmDefSetting();
        bpmDefSetting.setParentDefKey(topDefKey);
        bpmDefSetting.setGlobalForm(StringUtil.isEmpty((String)topDefKey) ? defExt.getGlobalForm() : defExt.getGlobalFormByDefKey(topDefKey, false));
        bpmDefSetting.setGlobalMobileForm(StringUtil.isEmpty((String)topDefKey) ? defExt.getGlobalMobileForm() : defExt.getGlobalFormByDefKey(topDefKey, true));
        bpmDefSetting.setInstForm(StringUtil.isEmpty((String)topDefKey) ? defExt.getInstForm() : defExt.getInstFormByDefKey(topDefKey, false));
        bpmDefSetting.setInstMobileForm(StringUtil.isEmpty((String)topDefKey) ? defExt.getInstMobileForm() : defExt.getInstFormByDefKey(topDefKey, true));
        bpmDefSetting.setGlobalRestfuls(this.getGlobalRestFulList((BpmProcessDef<BpmProcessDefExt>)bpmProcessDefExt, defId, topDefKey));
        ArrayNode nodes = JsonUtil.getMapper().createArrayNode();
        ArrayList<Form> formList = new ArrayList<Form>();
        ArrayList<NodeProperties> properties = new ArrayList<NodeProperties>();
        HashMap<String, List<Button>> btnMap = new HashMap<String, List<Button>>();
        HashMap<String, ObjectNode> nodeScriptMap = new HashMap<String, ObjectNode>();
        this.handNodeDefSetting(topDefKey, bpmProcessDefExt.getBpmnNodeDefs(), properties, formList, nodes, btnMap, nodeScriptMap);
        bpmDefSetting.setNodeProperties(properties);
        bpmDefSetting.setNodeForms(formList);
        List nodeDefList = this.bpmDefinitionAccessor.getAllNodeDef(defId);
        String userJson = JsonUtil.toJson((Object)this.getNodesUserJson(nodeDefList, defId, topDefKey));
        String userReadJson = JsonUtil.toJson((Object)this.getNodesReadUserJson(nodeDefList, defId, topDefKey));
        String restfulJson = JsonUtil.toJson((Object)this.getNodesRestFulJson(nodeDefList, defId, topDefKey));
        nodeSetData.put("bpmDefSetting", JsonUtil.toJsonNode((Object)bpmDefSetting));
        nodeSetData.put("nodes", nodes);
        nodeSetData.put("nodeUserMap", JsonUtil.toJsonNode((String)userJson));
        nodeSetData.put("nodeReadUserMap", JsonUtil.toJsonNode((String)userReadJson));
        nodeSetData.put("nodeBtnMap", btnMap);
        nodeSetData.put("nodeScriptMap", nodeScriptMap);
        nodeSetData.put("nodeRestfulMap", JsonUtil.toJsonNode((String)restfulJson));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("initData", initData);
        resultMap.put("nodeSetData", nodeSetData);
        return resultMap;
    }

    @Override
    public CommonResult<String> saveDefConf(DefConfSaveVo vo) throws Exception {
        String defId = vo.getDefId();
        String topDefKey = vo.getTopDefKey();
        String defSettingJson = vo.getDefSettingJson();
        String userJson = vo.getUserJson();
        String userReadJson = vo.getUserReadJson();
        String restfulJson = vo.getRestfulJson();
        String pcUrlkey = "";
        String mobileUrlKey = "";
        BpmDefSettingBpmDefXmlHandler bpmDefSettingBpmDefXmlHandler = (BpmDefSettingBpmDefXmlHandler)AppUtil.getBean(BpmDefSettingBpmDefXmlHandler.class);
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        try {
            ArrayList<ProcBoDef> boDefs;
            BpmBoDef bpmBoDef;
            BpmDefSetting bpmDefSetting;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", defId);
            map.put("rev", vo.getRev());
            DefaultBpmDefinition defaultBpmDefinition1 = this.bpmDefinitionManager.getBpmDefinitionByRev(map);
            if (BeanUtils.isNotEmpty((Object)defaultBpmDefinition1)) {
                defSettingJson = this.dealRestFulHeader(defSettingJson);
                bpmDefSetting = (BpmDefSetting)JsonUtil.toBean((String)defSettingJson, BpmDefSetting.class);
                HashSet<String> formKeys = new HashSet<String>();
                if (BeanUtils.isNotEmpty((Object)bpmDefSetting)) {
                    if (BeanUtils.isNotEmpty((Object)this.getInnerFormKey(bpmDefSetting.getGlobalForm()))) {
                        formKeys.add(bpmDefSetting.getGlobalForm().getFormValue());
                    }
                    if (BeanUtils.isNotEmpty((Object)this.getInnerFormKey(bpmDefSetting.getGlobalMobileForm()))) {
                        formKeys.add(bpmDefSetting.getGlobalMobileForm().getFormValue());
                    }
                    if (BeanUtils.isNotEmpty((Object)this.getInnerFormKey(bpmDefSetting.getInstForm()))) {
                        formKeys.add(bpmDefSetting.getInstForm().getFormValue());
                    }
                    if (BeanUtils.isNotEmpty((Object)this.getInnerFormKey(bpmDefSetting.getInstMobileForm()))) {
                        formKeys.add(bpmDefSetting.getInstMobileForm().getFormValue());
                    }
                    if (StringUtil.isNotEmpty((String)vo.getNodeFormKeys())) {
                        formKeys.addAll(Arrays.asList(vo.getNodeFormKeys().split(",")));
                    }
                    if (BeanUtils.isNotEmpty((Object)this.getFrameFormKey(bpmDefSetting.getGlobalForm()))) {
                        pcUrlkey = bpmDefSetting.getGlobalForm().getFormValue();
                    }
                    if (BeanUtils.isNotEmpty((Object)this.getFrameFormKey(bpmDefSetting.getGlobalMobileForm()))) {
                        mobileUrlKey = bpmDefSetting.getGlobalMobileForm().getFormValue();
                    }
                }
                HashMap<String, ObjectNode> boMap = new HashMap<String, ObjectNode>();
                FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
                for (String formkey : formKeys) {
                    if (!StringUtil.isNotEmpty((String)formkey)) continue;
                    List list = formRestfulService.getFormBoLists(formkey);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ObjectNode objectNode = (ObjectNode)iterator.next();
                        boMap.put(objectNode.get("alias").asText(), objectNode);
                    }
                }
                if (StringUtil.isEmpty((String)topDefKey)) {
                    List bpmnNodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
                    BpmDefinitionManager bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
                    for (BpmNodeDef bpmNodeDef : bpmnNodeDefs) {
                        String subFlowKey;
                        DefaultBpmDefinition mainByDefKey;
                        if (!(bpmNodeDef instanceof CallActivityNodeDef) || BeanUtils.isEmpty((Object)(mainByDefKey = bpmDefinitionManager.getMainByDefKey(subFlowKey = ((CallActivityNodeDef)bpmNodeDef).getFlowKey(), false)))) continue;
                        BpmProcessDef subProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(mainByDefKey.getDefId());
                        List boDefList = subProcessDef.getProcessDefExt().getBoDefList();
                        for (ProcBoDef procBoDef : boDefList) {
                            if (boMap.containsKey(procBoDef.getKey()) || !procBoDef.getParentDefKey().equals(bpmProcessDefExt.getDefKey())) continue;
                            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
                            objectNode.put("alias", procBoDef.getKey());
                            boMap.put(procBoDef.getKey(), objectNode);
                        }
                    }
                }
                bpmBoDef = new BpmBoDef();
                Iterator it = boMap.entrySet().iterator();
                boDefs = new ArrayList<ProcBoDef>();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ObjectNode value = (ObjectNode)entry.getValue();
                    ProcBoDef procBoDef = new ProcBoDef();
                    procBoDef.setKey(value.get("alias").asText());
                    procBoDef.setName(value.get("alias").asText());
                    if (StringUtil.isNotEmpty((String)topDefKey)) {
                        procBoDef.setParentDefKey(topDefKey);
                    }
                    boDefs.add(procBoDef);
                }
            } else {
                return new CommonResult(false, "\u6b64\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
            bpmBoDef.setBoDefs(boDefs);
            bpmBoDef.setBoSaveMode("database");
            this.saveBpmProBoList("", defId, "", topDefKey, bpmBoDef);
            this.boBpmDefXmlHandler.saveNodeXml(defId, "", (Object)bpmBoDef);
            bpmDefSettingBpmDefXmlHandler.saveNodeXml(defId, null, (Object)bpmDefSetting);
            int supportMobile = this.isMobileSet(defId, bpmDefSetting) ? 1 : 0;
            DefaultBpmDefinition def = (DefaultBpmDefinition)this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
            def.setSupportMobile(supportMobile);
            def.setUpdateTime(LocalDateTime.now());
            def.setPcStartUrl(this.getFrameStartUrl(pcUrlkey));
            def.setMobileStartUrl(this.getFrameStartUrl(mobileUrlKey));
            this.bpmDefinitionManager.update((Model)def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u8868\u5355\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
        }
        try {
            ObjectNode settingJson = (ObjectNode)JsonUtil.toJsonNode((String)defSettingJson);
            String globalRestfulStr = settingJson.get("globalRestfuls").toString();
            if (StringUtil.isNotEmpty((String)globalRestfulStr) || settingJson.get("globalRestfuls").size() > 0) {
                GlobalRestFulsPluginContext globalContext = new GlobalRestFulsPluginContext();
                globalContext.parse(globalRestfulStr);
                DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
                List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(defExt.getPluginContextList(), (BpmPluginContext)globalContext);
                PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
                bpmDefXmlHandler.saveNodeXml(defId, null, plugins);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String theNode = "";
        ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)userJson);
        Iterator fields = objectNode.fields();
        HashMap userMap = new HashMap();
        while (fields.hasNext()) {
            Map.Entry ent = (Map.Entry)fields.next();
            theNode = (String)ent.getKey();
            userMap.put(ent.getKey(), JsonUtil.toJson((Object)objectNode.get((String)ent.getKey())));
        }
        UserDefBpmDefXmlHandler userDefBpmDefXmlHandler = (UserDefBpmDefXmlHandler)AppUtil.getBean(UserDefBpmDefXmlHandler.class);
        userDefBpmDefXmlHandler.saveNodeXml(defId, userMap, topDefKey);
        ObjectNode objectNodeRead = (ObjectNode)JsonUtil.toJsonNode((String)userReadJson);
        Iterator fieldsRead = objectNodeRead.fields();
        HashMap userReadMap = new HashMap();
        while (fieldsRead.hasNext()) {
            Map.Entry ent = (Map.Entry)fieldsRead.next();
            theNode = (String)ent.getKey();
            userReadMap.put(ent.getKey(), JsonUtil.toJson((Object)objectNodeRead.get((String)ent.getKey())));
        }
        UserCopyToDefBpmDefXmlHandler userCopyToDefBpmDefXmlHandler = (UserCopyToDefBpmDefXmlHandler)AppUtil.getBean(UserCopyToDefBpmDefXmlHandler.class);
        userCopyToDefBpmDefXmlHandler.saveNodeXml(defId, userReadMap, topDefKey);
        try {
            HashMap nodeRestMap = new HashMap();
            ObjectNode restObjectNode = (ObjectNode)JsonUtil.toJsonNode((String)restfulJson);
            fields = restObjectNode.fields();
            while (fields.hasNext()) {
                Map.Entry ent = (Map.Entry)fields.next();
                BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, (String)ent.getKey());
                RestFulsPluginContext context = new RestFulsPluginContext();
                context.parse(JsonUtil.toJson((Object)restObjectNode.get((String)ent.getKey())));
                List<BpmPluginContext> plugins = this.changeOnePluginContextForSave(nodeDef.getBpmPluginContexts(), (BpmPluginContext)context);
                nodeRestMap.put(ent.getKey(), plugins);
            }
            if (!nodeRestMap.isEmpty()) {
                PluginsBpmDefXmlHandler bpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
                bpmDefXmlHandler.saveNodeXml(defId, nodeRestMap);
            }
        }
        catch (Exception e) {
            return new CommonResult(false, theNode + "\u8282\u70b9Restful\u4e8b\u4ef6\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.batchHandleMatrixProcRelation(vo.getOldMatrixCodes(), vo.getNewMatrixCodes(), bpmProcessDefExt.getDefKey(), bpmProcessDefExt.getName());
        return new CommonResult("\u6d41\u7a0b\u914d\u7f6e\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public CommonResult<String> ruleSave(String nodeId, String defId, List<JsonNode> nodeList) throws IOException {
        ArrayList<Object> jumpRuleList = new ArrayList<Object>();
        for (JsonNode jsonNode : nodeList) {
            jumpRuleList.add(JsonUtil.toBean((JsonNode)jsonNode, DefaultJumpRule.class));
        }
        try {
            if (StringUtil.isNotEmpty((String)nodeId)) {
                BpmDefXmlHandler bpmDefXmlHandler = (BpmDefXmlHandler)AppUtil.getBean((String)"transRulesBpmDefXmlHandler");
                bpmDefXmlHandler.saveNodeXml(defId, nodeId, jumpRuleList);
            }
            return new CommonResult("\u66f4\u65b0\u8282\u70b9\u8df3\u8f6c\u89c4\u5219\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u66f4\u65b0\u8282\u70b9\u8df3\u8f6c\u89c4\u5219\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResult<Boolean> isSubFirstNode(String defId, String nodeId, String parentKey) throws Exception {
        if (StringUtil.isNotEmpty((String)nodeId)) {
            BpmProcessDef procDef;
            List bpmNodeDefList;
            BpmNodeDef startNode;
            BpmNodeDef bpmNodeDef = this.bpmDefinitionService.getBpmNodeDef(defId, nodeId);
            BpmNodeDef parentBpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
            if ((StringUtil.isNotEmpty((String)parentKey) || BeanUtils.isNotEmpty((Object)parentBpmNodeDef) && parentBpmNodeDef instanceof SubProcessNodeDef) && !(startNode = (BpmNodeDef)(bpmNodeDefList = (procDef = bpmNodeDef.getBpmProcessDef()).getStartNodes()).get(0)).getNodeId().equals(nodeId)) {
                return new CommonResult(true, "", (Object)true);
            }
        }
        return new CommonResult(true, "", (Object)false);
    }

    @Override
    public CommonResult<String> nodeUserConditionSave(NodeConfSaveVo vo) {
        String nodeId = vo.getNodeId();
        String defId = vo.getDefId();
        String nodeJson = vo.getNodeJson();
        String parentFlowKey = vo.getParentFlowKey();
        try {
            if (StringUtil.isNotEmpty((String)nodeId)) {
                UserDefBpmDefXmlHandler userDefBpmDefXmlHandler = (UserDefBpmDefXmlHandler)AppUtil.getBean(UserDefBpmDefXmlHandler.class);
                userDefBpmDefXmlHandler.saveNodeXml(defId, nodeId, nodeJson, parentFlowKey);
            }
            return new CommonResult("\u66f4\u65b0\u8282\u70b9\u4eba\u5458\u914d\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u66f4\u65b0\u8282\u70b9\u4eba\u5458\u914d\u7f6e\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public CommonResult<String> branchConditionSave(NodeConfSaveVo vo) {
        String defId = vo.getDefId();
        String nodeId = vo.getNodeId();
        String condition = vo.getCondition();
        try {
            DefaultBpmDefConditionService bpmDefHandler = (DefaultBpmDefConditionService)AppUtil.getBean(DefaultBpmDefConditionService.class);
            Map map = JsonUtil.toMap((String)condition);
            bpmDefHandler.saveCondition(defId, nodeId, map);
            return new CommonResult("\u5206\u652f\u7f51\u5173\u8bbe\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5206\u652f\u7f51\u5173\u8bbe\u7f6e\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    public Map<String, Object> autoTaskPluginGet(String defId, String nodeId, String pluginType) throws Exception {
        List<BpmVariableDef> bpmVariableList = this.getAllBpmVariableDef(defId, nodeId);
        AutoTaskDef autoTaskDef = (AutoTaskDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        AbstractBpmPluginContext bpmPluginContext = (AbstractBpmPluginContext)autoTaskDef.getAutoTaskBpmPluginContext();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (bpmPluginContext != null && bpmPluginContext.getType().equals(pluginType)) {
            BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
            data.put("bpmPluginDef", bpmPluginDef);
            String json = bpmPluginContext.getJson();
            json = Base64.getBase64((String)json);
            data.put("bpmPluginDefJson", json);
        }
        data.put("bpmPluginContext", bpmPluginContext);
        data.put("bpmVariableList", bpmVariableList);
        return data;
    }

    @Override
    public Object validHandler(String handler) {
        int rtn = HandlerUtil.isHandlerValid((String)handler);
        String template = "{\"result\":\"%s\",\"msg\":\"%s\"}";
        String msg = "";
        switch (rtn) {
            case 0: {
                msg = "\u8f93\u5165\u6709\u6548";
                break;
            }
            case -1: {
                msg = "\u8f93\u5165\u683c\u5f0f\u65e0\u6548";
                break;
            }
            case -2: {
                msg = "\u6ca1\u6709service\u7c7b";
                break;
            }
            case -3: {
                msg = "\u6ca1\u6709\u5bf9\u5e94\u7684\u65b9\u6cd5";
                break;
            }
            default: {
                msg = "\u5176\u4ed6\u9519\u8bef";
            }
        }
        String str = String.format(template, rtn, msg);
        return str;
    }

    @Override
    public Object getNodes(String defId) throws Exception {
        List nodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(defId);
        ArrayNode list = JsonUtil.getMapper().createArrayNode();
        for (BpmNodeDef node : nodeDefs) {
            ObjectNode jo = JsonUtil.getMapper().createObjectNode();
            jo.put("name", node.getName());
            jo.put("nodeId", node.getNodeId());
            jo.put("type", node.getType().toString());
            list.add((JsonNode)jo);
        }
        return list;
    }

    @Override
    public Map<String, Object> getNodeOutcomes(String defId, String nodeId) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (nodeDef == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayNode outComes = JsonUtil.getMapper().createArrayNode();
        for (BpmNodeDef n : nodeDef.getOutcomeNodes()) {
            ObjectNode nodeJson = JsonUtil.getMapper().createObjectNode();
            nodeJson.put("nodeName", n.getName());
            nodeJson.put("nodeId", n.getNodeId());
            outComes.add((JsonNode)nodeJson);
        }
        data.put("scriptMap", nodeDef.getConditions());
        data.put("outComes", outComes);
        return data;
    }

    @Override
    public Object getNodeAutoTask(String defId, String nodeId) throws Exception {
        AutoTaskDef autoTaskDef = (AutoTaskDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        AbstractBpmPluginContext bpmPluginContext = (AbstractBpmPluginContext)autoTaskDef.getAutoTaskBpmPluginContext();
        if (bpmPluginContext == null) {
            return null;
        }
        ObjectNode object = (ObjectNode)JsonUtil.toJsonNode((String)bpmPluginContext.getJson());
        object.put("title", bpmPluginContext.getTitle());
        return object;
    }

    @Override
    public ObjectNode getGlobalForm(String defId, String type) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (BeanUtils.isEmpty((Object)defExt)) {
            throw new BaseException("\u8bf7\u5148\u8bbe\u7f6e\u5168\u5c40\u8868\u5355");
        }
        FormExt globalForm = defExt.getGlobalForm();
        if (BeanUtils.isEmpty((Object)globalForm)) {
            throw new BaseException("\u8bf7\u5148\u8bbe\u7f6e\u5168\u5c40\u8868\u5355");
        }
        return this.formFeignService.getByFormKey(globalForm.getFormValue());
    }

    private List<PrivilegeItem> getPrivilegeList(String json) throws Exception {
        ArrayList<PrivilegeItem> privilegeList = new ArrayList<PrivilegeItem>();
        if (StringUtil.isEmpty((String)json)) {
            return privilegeList;
        }
        ObjectNode privilegeListJson = (ObjectNode)JsonUtil.toJsonNode((String)json);
        Iterator newSet = privilegeListJson.fields();
        while (newSet.hasNext()) {
            Map.Entry ent = (Map.Entry)newSet.next();
            PrivilegeItem privilege = new PrivilegeItem();
            PrivilegeMode privilegeMode = PrivilegeMode.fromKey((String)((String)ent.getKey()));
            privilege.setPrivilegeMode(privilegeMode);
            ArrayNode ruleArray = (ArrayNode)privilegeListJson.get((String)ent.getKey());
            if (ruleArray.size() == 0) continue;
            ArrayList<UserAssignRule> rules = new ArrayList<UserAssignRule>();
            for (int i = 0; i < ruleArray.size(); ++i) {
                ObjectNode ruleObjectNode = (ObjectNode)ruleArray.get(i);
                UserAssignRule rule = UserAssignRuleParser.getUserAssignRule((ObjectNode)ruleObjectNode);
                rules.add(rule);
            }
            privilege.setUserRuleList(rules);
            privilegeList.add(privilege);
        }
        return privilegeList;
    }

    private SignRule getSignRule(String json) throws IOException {
        ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        DecideType decideType = DecideType.fromKey((String)obj.get("decideType").asText());
        VoteType voteType = VoteType.fromKey((String)obj.get("voteType").asText());
        FollowMode followMode = FollowMode.fromKey((String)obj.get("followMode").asText());
        int voteAmount = obj.get("voteAmount").asInt();
        return new SignRule(decideType, voteType, followMode, voteAmount);
    }

    private ObjectNode getFlowVarJson(BpmProcessDef<BpmProcessDefExt> procDef, String nodeId, boolean isUrgent) throws Exception {
        ArrayList variables = new ArrayList();
        boolean isBmpnInstId = true;
        if (procDef.getProcessDefExt().getVariableList() != null) {
            variables.addAll(procDef.getProcessDefExt().getVariableList());
        }
        ObjectNode flowVariable = (ObjectNode)JsonUtil.toJsonNode((String)"{\"id\":\"-99\",\"desc\":\"\u6d41\u7a0b\u53d8\u91cf\",\"name\":\"\u6d41\u7a0b\u53d8\u91cf\",\"icon\":\"fa fa-bold dark\",\"nodeType\":\"root\"}");
        if (StringUtil.isNotEmpty((String)nodeId)) {
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(procDef.getProcessDefinitionId(), nodeId);
            if (bpmNodeDef != null && bpmNodeDef instanceof UserTaskNodeDef) {
                UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)bpmNodeDef;
                if (taskNodeDef.getVariableList() != null) {
                    variables.addAll(taskNodeDef.getVariableList());
                }
            } else if (bpmNodeDef.getType().equals((Object)NodeType.START)) {
                isBmpnInstId = false;
            }
        }
        ArrayNode varList = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty(variables)) {
            for (BpmVariableDef variable : variables) {
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((Object)variable);
                String name = variable.getName();
                String varKey = variable.getVarKey();
                obj.put("name", varKey);
                obj.put("nodeType", "var");
                obj.put("desc", name);
                varList.add((JsonNode)obj);
            }
        }
        ObjectNode businessKey = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"flowKey_\",\"desc\":\"\u6d41\u7a0b\u5b9a\u4e49Key\",\"nodeType\":\"var\"}");
        ObjectNode startUserId = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"startUser\",\"desc\":\"\u53d1\u8d77\u4ebaId\",\"nodeType\":\"var\"}");
        ObjectNode startUserAccount = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"startUserAccount\",\"desc\":\"\u53d1\u8d77\u4eba\u8d26\u53f7\",\"nodeType\":\"var\"}");
        ObjectNode startUser = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"startorName\",\"desc\":\"\u53d1\u8d77\u4eba\u59d3\u540d\",\"nodeType\":\"var\"}");
        if (isBmpnInstId) {
            ObjectNode bmpnInstId = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"instanceId_\",\"desc\":\"\u6d41\u7a0b\u5b9e\u4f8bID\",\"nodeType\":\"var\"}");
            varList.add((JsonNode)bmpnInstId);
        }
        varList.add((JsonNode)businessKey);
        varList.add((JsonNode)startUser);
        varList.add((JsonNode)startUserId);
        varList.add((JsonNode)startUserAccount);
        if (isUrgent) {
            ObjectNode promoter = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"promoter\",\"desc\":\"\u50ac\u529e\u4eba\",\"nodeType\":\"var\"}");
            varList.add((JsonNode)promoter);
            ObjectNode appointee = (ObjectNode)JsonUtil.toJsonNode((String)"{\"name\":\"appointee\",\"desc\":\"\u88ab\u50ac\u529e\u4eba\",\"nodeType\":\"var\"}");
            varList.add((JsonNode)appointee);
            List bpmnNodeDefs = procDef.getBpmnNodeDefs();
            if (BeanUtils.isNotEmpty((Object)bpmnNodeDefs)) {
                for (BpmNodeDef nodeDef : bpmnNodeDefs) {
                    if (!NodeType.USERTASK.equals((Object)nodeDef.getType()) || StringUtil.isNotEmpty((String)nodeId) && nodeDef.getNodeId().equals(nodeId)) continue;
                    ObjectNode nodeUserVar = JsonUtil.createObjectNode();
                    nodeUserVar.put("desc", nodeDef.getName() + "-\u5904\u7406\u4eba");
                    nodeUserVar.put("name", "nodeAuditor_" + nodeDef.getNodeId());
                    nodeUserVar.put("nodeType", "var");
                    varList.add((JsonNode)nodeUserVar);
                }
            }
        }
        if (varList.size() <= 0) {
            return null;
        }
        for (JsonNode jsonNode : varList) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.hasNonNull("id")) continue;
            objectNode.put("id", UniqueIdUtil.getSuid());
        }
        flowVariable.set("children", (JsonNode)varList);
        return flowVariable;
    }

    private List<Restful> getGlobalRestFulList(BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt, String defId, String parentFlowKey) throws Exception {
        ArrayList<Restful> globalRests = new ArrayList<Restful>();
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        List plugins = defExt.getPluginContextList();
        for (BpmPluginContext bpmPluginContext : plugins) {
            GlobalRestFulsPluginContext context;
            List restFuls;
            if (!(bpmPluginContext instanceof GlobalRestFulsPluginContext) || !BeanUtils.isNotEmpty((Object)(restFuls = (context = (GlobalRestFulsPluginContext)bpmPluginContext).getByParentFlowKey(parentFlowKey)))) continue;
            globalRests.addAll(restFuls);
        }
        return globalRests;
    }

    private void handNodeDefSetting(String parentDefKey, List<BpmNodeDef> nodeDefList, List<NodeProperties> properties, List<Form> formList, ArrayNode nodes, Map<String, List<Button>> btnMap, Map<String, ObjectNode> nodeScriptMap) throws IOException {
        for (BpmNodeDef nodeDef : nodeDefList) {
            Map scriptMap;
            String nodeId = nodeDef.getNodeId();
            NodeType type = nodeDef.getType();
            if (NodeType.START.equals((Object)type) || NodeType.CUSTOMSIGNTASK.equals((Object)type) || NodeType.USERTASK.equals((Object)type) || NodeType.SIGNTASK.equals((Object)type)) {
                ObjectNode node = JsonUtil.getMapper().createObjectNode();
                node.put("name", nodeDef.getName());
                node.put("nodeId", nodeId);
                node.put("type", nodeDef.getType().toString());
                nodes.add((JsonNode)node);
                Form form = null;
                Form mobileForm = null;
                NodeProperties propertie = null;
                if (StringUtil.isEmpty((String)parentDefKey) || "local_".equals(parentDefKey)) {
                    propertie = nodeDef.getLocalProperties();
                    form = nodeDef.getForm();
                    mobileForm = nodeDef.getMobileForm();
                } else {
                    propertie = nodeDef.getPropertiesByParentDefKey(parentDefKey);
                    form = nodeDef.getSubForm(parentDefKey, FormType.PC);
                    mobileForm = nodeDef.getSubForm(parentDefKey, FormType.MOBILE);
                }
                if (propertie != null) {
                    propertie.setNodeId(nodeId);
                    properties.add(propertie);
                }
                if (form == null) {
                    form = new DefaultForm();
                    form.setType(FormCategory.INNER);
                }
                if (mobileForm == null) {
                    mobileForm = new DefaultForm();
                    mobileForm.setFormType(FormType.MOBILE.value());
                }
                form.setNodeId(nodeId);
                mobileForm.setNodeId(nodeId);
                formList.add(mobileForm);
                formList.add(form);
                List buttons = nodeDef.getButtons();
                btnMap.put(nodeDef.getNodeId(), buttons);
            } else if (NodeType.SUBPROCESS.equals((Object)type)) {
                SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)nodeDef;
                BpmProcessDef processDef = subProcessNodeDef.getChildBpmProcessDef();
                List bpmNodeDefs = processDef.getBpmnNodeDefs();
                this.handNodeDefSetting(parentDefKey, bpmNodeDefs, properties, formList, nodes, btnMap, nodeScriptMap);
            }
            if ((scriptMap = nodeDef.getScripts()).isEmpty()) continue;
            nodeScriptMap.put(nodeId, (ObjectNode)JsonUtil.toJsonNode((Object)scriptMap));
        }
    }

    private Object getNodesUserJson(List<BpmNodeDef> nodeDefList, String defId, String parentFlowKey) throws Exception {
        ObjectNode jobject = JsonUtil.getMapper().createObjectNode();
        ArrayList<BpmNodeDef> userNodes = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef nodeDef : nodeDefList) {
            if (nodeDef.getType() != NodeType.USERTASK && nodeDef.getType() != NodeType.SIGNTASK && nodeDef.getType() != NodeType.CUSTOMSIGNTASK) continue;
            userNodes.add(nodeDef);
        }
        for (int i = 0; i < userNodes.size(); ++i) {
            BpmNodeDef node = (BpmNodeDef)userNodes.get(i);
            UserAssignPluginContext userPluginContext = (UserAssignPluginContext)node.getPluginContext(UserAssignPluginContext.class);
            if (userPluginContext == null) {
                jobject.set(node.getNodeId(), (JsonNode)JsonUtil.getMapper().createArrayNode());
                continue;
            }
            String nodeConditionJson = userPluginContext.getJsonByParentFlowKey(parentFlowKey);
            ArrayNode nodeConditionJsonAry = (ArrayNode)JsonUtil.toJsonNode((String)nodeConditionJson);
            jobject.set(node.getNodeId(), (JsonNode)nodeConditionJsonAry);
        }
        return jobject;
    }

    private Object getNodesReadUserJson(List<BpmNodeDef> nodeDefList, String defId, String parentFlowKey) throws Exception {
        ObjectNode jobject = JsonUtil.getMapper().createObjectNode();
        ArrayList<BpmNodeDef> userNodes = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef nodeDef : nodeDefList) {
            if (nodeDef.getType() != NodeType.USERTASK && nodeDef.getType() != NodeType.SIGNTASK) continue;
            userNodes.add(nodeDef);
        }
        for (int i = 0; i < userNodes.size(); ++i) {
            BpmNodeDef node = (BpmNodeDef)userNodes.get(i);
            UserCopyToPluginContext userPluginContext = (UserCopyToPluginContext)node.getPluginContext(UserCopyToPluginContext.class);
            if (userPluginContext == null) {
                jobject.set(node.getNodeId(), (JsonNode)JsonUtil.getMapper().createArrayNode());
                continue;
            }
            String nodeConditionJson = userPluginContext.getJsonByParentFlowKey(parentFlowKey);
            ArrayNode nodeConditionJsonAry = (ArrayNode)JsonUtil.toJsonNode((String)nodeConditionJson);
            jobject.set(node.getNodeId(), (JsonNode)nodeConditionJsonAry);
        }
        return jobject;
    }

    private Object getNodesRestFulJson(List<BpmNodeDef> nodeDefList, String defId, String parentFlowKey) throws Exception {
        ObjectNode jobject = JsonUtil.getMapper().createObjectNode();
        ArrayList<BpmNodeDef> restfulNodes = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef nodeDef : nodeDefList) {
            if (!NodeType.USERTASK.equals((Object)nodeDef.getType()) && !NodeType.SIGNTASK.equals((Object)nodeDef.getType()) && !NodeType.START.equals((Object)nodeDef.getType()) && !NodeType.END.equals((Object)nodeDef.getType())) continue;
            restfulNodes.add(nodeDef);
        }
        for (int i = 0; i < restfulNodes.size(); ++i) {
            BpmNodeDef node = (BpmNodeDef)restfulNodes.get(i);
            RestFulsPluginContext context = (RestFulsPluginContext)node.getPluginContext(RestFulsPluginContext.class);
            if (context == null) {
                jobject.set(node.getNodeId(), (JsonNode)JsonUtil.getMapper().createArrayNode());
                continue;
            }
            String nodeRestfulJson = context.getJsonByParentFlowKey(parentFlowKey);
            JsonNode nodeRestfulJsonAry = JsonUtil.toJsonNode((String)nodeRestfulJson);
            jobject.set(node.getNodeId(), nodeRestfulJsonAry);
        }
        return jobject;
    }

    private String dealRestFulHeader(String defSettingJson) throws IOException {
        JsonNode node = JsonUtil.toJsonNode((String)defSettingJson);
        ArrayNode globalRestArray = (ArrayNode)node.get("globalRestfuls");
        if (BeanUtils.isNotEmpty((Object)globalRestArray)) {
            for (JsonNode jsonNode : globalRestArray) {
                ObjectNode restJson = (ObjectNode)jsonNode;
                if (!BeanUtils.isNotEmpty((Object)restJson.get("header")) || !StringUtil.isEmpty((String)restJson.get("header").asText())) continue;
                restJson.put("header", restJson.get("header").toString());
            }
        }
        return node.toString();
    }

    private String getInnerFormKey(FormExt form) {
        String formkey = "";
        if (BeanUtils.isNotEmpty((Object)form) && BeanUtils.isNotEmpty((Object)form.getType()) && form.getType().value().equals(FormCategory.INNER.value()) && StringUtil.isNotEmpty((String)form.getFormValue())) {
            return form.getFormValue();
        }
        return formkey;
    }

    private String getFrameFormKey(FormExt form) {
        String formkey = "";
        if (BeanUtils.isNotEmpty((Object)form) && BeanUtils.isNotEmpty((Object)form.getType()) && form.getType().value().equals(FormCategory.FRAME.value()) && StringUtil.isNotEmpty((String)form.getFormValue())) {
            return form.getFormValue();
        }
        return formkey;
    }

    private String getFrameStartUrl(String formKey) throws Exception {
        ObjectNode objectNode;
        String sysId;
        BpmUrlForm bpmUrlForm;
        ObjectNode byFormKey;
        if (StringUtil.isNotEmpty((String)formKey) && BeanUtils.isNotEmpty((Object)(byFormKey = this.formFeignService.getUrlFormByKey(formKey))) && BpmUrlForm.NO.equals((bpmUrlForm = (BpmUrlForm)JsonUtil.toBean((JsonNode)byFormKey, BpmUrlForm.class)).getIsEmbed()) && StringUtil.isNotEmpty((String)(sysId = bpmUrlForm.getSysId())) && BeanUtils.isNotEmpty((Object)(objectNode = this.portalFeignService.getBizSystem(sysId)).get("rootAddress"))) {
            String baseUrl = objectNode.get("rootAddress").asText();
            bpmUrlForm.setBaseUrl(baseUrl);
            String url = baseUrl + bpmUrlForm.getStartUrl();
            if (StringUtil.isEmpty((String)url)) {
                url = baseUrl + bpmUrlForm.getTaskUrl();
            }
            if (BpmUrlForm.YES.equals(bpmUrlForm.getTokenAuth())) {
                url = url.indexOf("?") > -1 ? url + "&needToken=true" : url + "?needToken=true";
            }
            return url;
        }
        return null;
    }

    private void saveBpmProBoList(String userId, String flowId, String flowKey, String parentFlowKey, BpmBoDef bpmBoDef) throws Exception {
        ArrayList<BpmProBo> bpmProBoList = new ArrayList<BpmProBo>();
        List boDefs = bpmBoDef.getBoDefs();
        for (ProcBoDef procBoDef : boDefs) {
            BpmProBo bpmProBo = new BpmProBo();
            bpmProBo.setProcessId(flowId);
            bpmProBo.setProcessKey(flowKey);
            bpmProBo.setBoCode(procBoDef.getKey());
            bpmProBo.setBoName(procBoDef.getName());
            bpmProBo.setCreatorId(userId);
            bpmProBoList.add(bpmProBo);
        }
        this.bpmProBoManager.createByBpmProBoList(bpmProBoList, flowId, flowKey);
    }

    private boolean isMobileSet(String defId, BpmDefSetting bpmDefSetting) throws Exception {
        BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getStartEvent(defId);
        List startNodes = this.bpmDefinitionAccessor.getStartNodes(defId);
        Map nodeMap = bpmDefSetting.getFormMap(false);
        Form startForm = (Form)nodeMap.get(nodeDef.getNodeId());
        boolean isSet = this.isFormEmpty(startForm);
        if (isSet) {
            return true;
        }
        for (BpmNodeDef def : startNodes) {
            Form frm = (Form)nodeMap.get(def.getNodeId());
            isSet = this.isFormEmpty(frm);
            if (!isSet) continue;
            return true;
        }
        FormExt globalForm = defExt.getGlobalMobileForm();
        isSet = this.isFormEmpty((Form)globalForm);
        return isSet;
    }

    private boolean isFormEmpty(Form startForm) {
        return startForm != null && StringUtil.isNotEmpty((String)startForm.getFormValue());
    }

    private List<BpmPluginContext> changeOnePluginContextForSave(List<BpmPluginContext> contexts, BpmPluginContext pluginContext) {
        ArrayList<BpmPluginContext> bpmPluginContexts = new ArrayList<BpmPluginContext>();
        bpmPluginContexts.add(pluginContext);
        if (BeanUtils.isEmpty(contexts)) {
            return bpmPluginContexts;
        }
        for (BpmPluginContext context : contexts) {
            if (context.getClass().isAssignableFrom(pluginContext.getClass())) continue;
            bpmPluginContexts.add(context);
        }
        return bpmPluginContexts;
    }

    private void batchHandleMatrixProcRelation(Set<String> oldMatrixCodes, Set<String> newMatrixCodes, String procDefKey, String procDefName) throws Exception {
        if (oldMatrixCodes != null && newMatrixCodes != null && BeanUtils.isNotEmpty((Object)procDefKey)) {
            ArrayList oldRelations = new ArrayList();
            for (String string : oldMatrixCodes) {
                if (!BeanUtils.isNotEmpty((Object)string)) continue;
                HashMap<String, String> relation = new HashMap<String, String>();
                relation.put("matrixCode", string);
                relation.put("procDefKey", procDefKey);
                relation.put("procDefName", procDefName);
                oldRelations.add(relation);
            }
            ArrayList newRelations = new ArrayList();
            for (String matrixCode : newMatrixCodes) {
                if (!BeanUtils.isNotEmpty((Object)matrixCode)) continue;
                HashMap<String, String> relation = new HashMap<String, String>();
                relation.put("matrixCode", matrixCode);
                relation.put("procDefKey", procDefKey);
                relation.put("procDefName", procDefName);
                newRelations.add(relation);
            }
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            objectNode.set("oldMatrixProcRelations", JsonUtil.toJsonNode(oldRelations));
            objectNode.set("newMatrixProcRelations", JsonUtil.toJsonNode(newRelations));
            this.ucFeignService.batchHandleMatrixProcRelation(objectNode);
        }
    }

    private List<BpmVariableDef> getAllBpmVariableDef(String defId, String nodeId) throws Exception {
        ArrayList<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getVariableList() != null) {
            bpmVariableList.addAll(defExt.getVariableList());
        }
        List list = bpmProcessDefExt.getBpmnNodeDefs();
        for (BpmNodeDef node : list) {
            UserTaskNodeDef targetNodeDef;
            if (!node.getNodeId().equals(nodeId) || !node.getType().toString().equalsIgnoreCase("usertask") || (targetNodeDef = (UserTaskNodeDef)node).getVariableList() == null) continue;
            bpmVariableList.addAll(targetNodeDef.getVariableList());
        }
        return bpmVariableList;
    }

    @Override
    @Transactional
    public CommonResult<String> copyNodeConf(NodeConfCopyVo vo) throws Exception {
        String defId = vo.getDefId();
        String sourceNodeId = vo.getSourceNodeId();
        List<String> targetNodeIds = vo.getTargetNodeIds();
        List<String> scope = vo.getScope();
        String topDefKey = StringUtil.isEmpty((String)vo.getTopDefKey()) ? "local_" : vo.getTopDefKey();
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
        String bpmnXml = bpmDefData.getBpmnXml();
        Map permissionMap = new HashMap();
        FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        if ((scope.contains("nodeForm") || scope.contains("all")) && StringUtil.isNotEmpty((String)vo.getPcFormKey())) {
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("flowKey", vo.getDefKey());
            formRestParams.put("nodeId", sourceNodeId);
            formRestParams.put("formKey", vo.getPcFormKey());
            permissionMap = formRestfulService.getRightsPermission(formRestParams);
        }
        ArrayList<ObjectNode> addPermission = new ArrayList<ObjectNode>();
        for (String targetNodeId : targetNodeIds) {
            BpmDefSettingBpmDefXmlHandler bpmDefSettingBpmDefXmlHandler = (BpmDefSettingBpmDefXmlHandler)AppUtil.getBean(BpmDefSettingBpmDefXmlHandler.class);
            if (scope.contains("nodeForm") || scope.contains("all")) {
                bpmnXml = bpmDefSettingBpmDefXmlHandler.copyNodeForm(sourceNodeId, targetNodeId, bpmnXml, true, topDefKey);
                bpmnXml = bpmDefSettingBpmDefXmlHandler.copyNodeForm(sourceNodeId, targetNodeId, bpmnXml, false, topDefKey);
                if (permissionMap != null && permissionMap.size() > 0) {
                    ObjectNode node = JsonUtil.createObjectNode();
                    node.put("flowKey", vo.getDefKey());
                    node.put("formKey", vo.getPcFormKey());
                    node.put("nodeId", targetNodeId);
                    node.put("parentflowKey", "");
                    node.put("permission", JsonUtil.toJsonString(permissionMap.get("json")));
                    addPermission.add(node);
                }
            }
            if (scope.contains("nodeUser") || scope.contains("all")) {
                UserDefBpmDefXmlHandler userDefBpmDefXmlHandler = (UserDefBpmDefXmlHandler)AppUtil.getBean(UserDefBpmDefXmlHandler.class);
                bpmnXml = userDefBpmDefXmlHandler.copyNodeUser(sourceNodeId, targetNodeId, bpmnXml, topDefKey);
            }
            if (scope.contains("nodeReadUser") || scope.contains("all")) {
                UserCopyToDefBpmDefXmlHandler userCopyToDefBpmDefXmlHandler = (UserCopyToDefBpmDefXmlHandler)AppUtil.getBean(UserCopyToDefBpmDefXmlHandler.class);
                bpmnXml = userCopyToDefBpmDefXmlHandler.copyNodeUser(sourceNodeId, targetNodeId, bpmnXml);
            }
            if (scope.contains("nodeProperties") || scope.contains("all")) {
                bpmnXml = bpmDefSettingBpmDefXmlHandler.copyNodeProperties(sourceNodeId, targetNodeId, bpmnXml);
            }
            if (scope.contains("nodeBtn") || scope.contains("all")) {
                ButtonsBpmDefXmlHandler buttonsBpmDefXmlHandler = (ButtonsBpmDefXmlHandler)AppUtil.getBean(ButtonsBpmDefXmlHandler.class);
                bpmnXml = buttonsBpmDefXmlHandler.copyNodeButtons(sourceNodeId, targetNodeId, bpmnXml);
            }
            if (!scope.contains("all")) continue;
            PluginsBpmDefXmlHandler pluginsBpmDefXmlHandler = (PluginsBpmDefXmlHandler)AppUtil.getBean(PluginsBpmDefXmlHandler.class);
            bpmnXml = pluginsBpmDefXmlHandler.copyNodeRestFul(sourceNodeId, targetNodeId, bpmnXml);
            TransRulesBpmDefXmlHandler transRulesBpmDefXmlHandler = (TransRulesBpmDefXmlHandler)AppUtil.getBean(TransRulesBpmDefXmlHandler.class);
            bpmnXml = transRulesBpmDefXmlHandler.copyNodeTransRule(sourceNodeId, targetNodeId, bpmnXml);
            EventScriptBpmDefXmlHandler eventScriptBpmDefXmlHandler = (EventScriptBpmDefXmlHandler)AppUtil.getBean(EventScriptBpmDefXmlHandler.class);
            bpmnXml = eventScriptBpmDefXmlHandler.copyNodeEventScript(sourceNodeId, targetNodeId, bpmnXml);
            bpmnXml = pluginsBpmDefXmlHandler.copyNodeReminder(sourceNodeId, targetNodeId, bpmnXml);
            bpmnXml = pluginsBpmDefXmlHandler.copyNodeStartNewFlow(sourceNodeId, targetNodeId, bpmnXml);
        }
        if (addPermission.size() > 0) {
            formRestfulService.bathSave(addPermission);
        }
        bpmDefData.setBpmnXml(bpmnXml);
        this.bpmDefinitionManager.updBpmData(defId, bpmDefData);
        return new CommonResult("\u590d\u5236\u6210\u529f");
    }
}

