/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.constant.DesignerType;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.CurrentUserService;
import com.hotent.bpm.persistence.model.BpmDefData;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpmModel.dao.BpmOftenFlowDao;
import com.hotent.bpmModel.dao.BpmOftenFlowUserDao;
import com.hotent.bpmModel.manager.BpmOftenFlowManager;
import com.hotent.bpmModel.model.BpmOftenFlow;
import com.hotent.bpmModel.model.BpmOftenFlowUser;
import com.hotent.bpmModel.params.DefaultBpmDefinitionVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IUserGroupService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmCommonDefManager")
public class BpmOftenFlowManagerImpl
extends BaseManagerImpl<BpmOftenFlowDao, BpmOftenFlow>
implements BpmOftenFlowManager {
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    BpmOftenFlowUserDao bpmOftenFlowUserDao;
    @Resource(name="bpmCurrentUserService")
    private CurrentUserService currentUserService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    UCFeignService ucFeignService;

    @Override
    @Transactional
    public void removeByUserIdAndDefKeys(String userId, List<String> defkeys) {
        ((BpmOftenFlowDao)this.baseMapper).removeByUserIdAndDefKeys(userId, defkeys);
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrUpdateCommonFlow(Map<String, Object> map) throws Exception {
        List defkeysAry = (List)map.get("defkeys");
        String type = map.get("type").toString();
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((Object)map.get("calOwnerNameJson"));
        String msg = "\u6dfb\u52a0\u5e38\u7528\u6d41\u7a0b\u6210\u529f";
        if (BeanUtils.isNotEmpty((Object)defkeysAry)) {
            for (String defKey : defkeysAry) {
                BpmOftenFlow bpmOftenFlow = ((BpmOftenFlowDao)this.baseMapper).getBpmOftenFlow(defKey);
                if ("add".equals(type)) {
                    if (BeanUtils.isNotEmpty((Object)((Object)bpmOftenFlow))) {
                        return new CommonResult(false, "\u6d41\u7a0bkey\uff1a" + defKey + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    }
                    if (BeanUtils.isEmpty((Object)arrayNode)) {
                        return new CommonResult(false, "\u5e38\u7528\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
                    }
                    String id = UniqueIdUtil.getSuid();
                    BpmOftenFlow entity = new BpmOftenFlow();
                    entity.setId(id);
                    entity.setDefKey(defKey);
                    ((BpmOftenFlowDao)this.baseMapper).insert((Object)entity);
                    for (JsonNode jsonNode : arrayNode) {
                        this.saveBpmOftenFlowUser(jsonNode, id);
                    }
                    continue;
                }
                if (!"edit".equals(type)) continue;
                if (BeanUtils.isEmpty((Object)((Object)bpmOftenFlow))) {
                    return new CommonResult(false, "\u901a\u8fc7\u6d41\u7a0bkey\uff1a" + defKey + "\u67e5\u8be2\u4e0d\u5230\u5e38\u7528\u6d41\u7a0b");
                }
                if (BeanUtils.isEmpty((Object)arrayNode)) {
                    return new CommonResult(false, "\u5e38\u7528\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
                }
                this.bpmOftenFlowUserDao.removeByOftenFlowId(bpmOftenFlow.getId());
                for (JsonNode jsonNode : arrayNode) {
                    this.saveBpmOftenFlowUser(jsonNode, bpmOftenFlow.getId());
                }
            }
        }
        if ("edit".equals(type)) {
            msg = "\u4fee\u6539\u5e38\u7528\u6d41\u7a0b\u6210\u529f";
        }
        return new CommonResult(true, msg);
    }

    private void saveBpmOftenFlowUser(JsonNode jsonNode, String id) {
        String rightType = jsonNode.get("type").asText();
        if ("everyone".equals(rightType)) {
            BpmOftenFlowUser bpmOftenFlowUser = new BpmOftenFlowUser();
            bpmOftenFlowUser.setId(UniqueIdUtil.getSuid());
            bpmOftenFlowUser.setOftenFlowId(id);
            bpmOftenFlowUser.setRightType(rightType);
            this.bpmOftenFlowUserDao.insert((Object)bpmOftenFlowUser);
        } else {
            String[] ids = jsonNode.get("id").asText().split(",");
            String[] names = jsonNode.get("name").asText().split(",");
            for (int i = 0; i < ids.length; ++i) {
                BpmOftenFlowUser bpmOftenFlowUser = new BpmOftenFlowUser();
                bpmOftenFlowUser.setId(UniqueIdUtil.getSuid());
                bpmOftenFlowUser.setOftenFlowId(id);
                bpmOftenFlowUser.setOwnerId(ids[i]);
                bpmOftenFlowUser.setOwnerName(names[i]);
                bpmOftenFlowUser.setRightType(rightType);
                this.bpmOftenFlowUserDao.insert((Object)bpmOftenFlowUser);
            }
        }
    }

    @Override
    @Transactional
    public void saveMyFlow(String userId, String userName, ArrayNode list) {
        this.removeByUserIdAndDefKeys(userId, null);
        ArrayList bpmOftenFlows = new ArrayList();
        list.forEach(i -> bpmOftenFlows.add(new BpmOftenFlow(userId, userName, i.get("defKey").asText())));
        this.saveBatch(bpmOftenFlows);
    }

    @Override
    public PageList<BpmOftenFlow> customQuery(String userId) {
        QueryFilter queryFilter = QueryFilter.build();
        PageBean pageBean = new PageBean(Integer.valueOf(1), Integer.valueOf(20));
        queryFilter.setPageBean(pageBean);
        IPage<BpmOftenFlow> result = ((BpmOftenFlowDao)this.baseMapper).customQuery((IPage<BpmOftenFlow>)this.convert2IPage(pageBean), this.convertGroupList(userId), (Wrapper<BpmOftenFlow>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public Set<String> getMyOftenFlowKey() {
        QueryFilter queryFilter = QueryFilter.build();
        PageBean page = new PageBean(Integer.valueOf(1), Integer.valueOf(20));
        queryFilter.setPageBean(page);
        queryFilter.addFilter("USER_ID_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<BpmOftenFlow> query = this.query((QueryFilter<BpmOftenFlow>)queryFilter);
        if (query.getRows().size() == 0) {
            query = this.customQuery(ContextUtil.getCurrentUserId());
        }
        HashSet<String> defKeySet = new HashSet<String>();
        if (BeanUtils.isEmpty(query) || query.getRows().size() == 0) {
            return defKeySet;
        }
        for (BpmOftenFlow flow : query.getRows()) {
            defKeySet.add(flow.getDefKey());
        }
        return defKeySet;
    }

    @Override
    public Set<String> getMyOftenFlowKeyByNoAuth() {
        QueryFilter queryFilter = QueryFilter.build();
        PageBean page = new PageBean(Integer.valueOf(1), Integer.valueOf(20));
        queryFilter.setPageBean(page);
        JsonNode json = this.ucFeignService.getUser("admin", "");
        String userId = json.get("id").asText();
        queryFilter.addFilter("USER_ID_", (Object)userId, QueryOP.EQUAL);
        PageList<BpmOftenFlow> query = this.query((QueryFilter<BpmOftenFlow>)queryFilter);
        if (query.getRows().size() == 0) {
            query = this.customQuery(userId);
        }
        HashSet<String> defKeySet = new HashSet<String>();
        if (BeanUtils.isEmpty(query) || query.getRows().size() == 0) {
            return defKeySet;
        }
        for (BpmOftenFlow flow : query.getRows()) {
            defKeySet.add(flow.getDefKey());
        }
        return defKeySet;
    }

    @Override
    public CommonResult<String> webDefSave(DefaultBpmDefinitionVo bpmDefinitionVo) {
        int length;
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("oracle") && StringUtils.isNotEmpty((String)bpmDefinitionVo.getDefaultBpmDefinition().getName()) && (length = bpmDefinitionVo.getDefaultBpmDefinition().getName().length()) > 21) {
            return new CommonResult(false, "\u6d41\u7a0b\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc721\uff01", (Object)"");
        }
        Boolean isDeploy = bpmDefinitionVo.getIsdeploy();
        DefaultBpmDefinition bpmDefinition = null;
        try {
            bpmDefinition = this.getWebDesignFromRequest(bpmDefinitionVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String actionName = isDeploy != false ? "\u6d41\u7a0b\u53d1\u5e03" : "\u6d41\u7a0b\u4fdd\u5b58";
        String resultMsg = "";
        try {
            String oldTypeId;
            List oldDefs = this.bpmDefinitionManager.queryByDefKey(bpmDefinition.getDefKey());
            if (StringUtils.isEmpty((String)bpmDefinition.getDefId()) && BeanUtils.isNotEmpty((Object)oldDefs)) {
                resultMsg = "\u6d41\u7a0b\u5b9a\u4e49KEY\u201c" + bpmDefinition.getDefKey() + "\u201d \u5df2\u7ecf\u5b58\u5728\u4e8e\uff1a" + ((DefaultBpmDefinition)oldDefs.get(0)).getName();
                return new CommonResult(false, resultMsg, (Object)"");
            }
            if (isDeploy.booleanValue()) {
                resultMsg = "\u6d41\u7a0b\u53d1\u5e03\u6210\u529f";
                bpmDefinition.setUpdateTime(LocalDateTime.now());
                if (!this.bpmDefinitionService.deploy((BpmDefinition)bpmDefinition)) {
                    return new CommonResult(false, actionName + "\u5931\u8d25", (Object)"");
                }
            } else if (StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                this.bpmDefinitionService.updateBpmDefinition((BpmDefinition)bpmDefinition);
            } else {
                this.bpmDefinitionService.saveDraft((BpmDefinition)bpmDefinition);
            }
            if (BeanUtils.isNotEmpty((Object)oldDefs) && oldDefs.size() > 0 && !(oldTypeId = ((DefaultBpmDefinition)oldDefs.get(0)).getTypeId()).equals(bpmDefinition.getTypeId())) {
                this.bpmDefinitionManager.updateTypeIdByDefKey(bpmDefinition.getDefKey(), bpmDefinition.getTypeId());
            }
            return new CommonResult(true, actionName + "\u6210\u529f", (Object)bpmDefinition.getDefId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            return new CommonResult(false, "\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff1a" + rootCauseMessage, (Object)"");
        }
    }

    public PageList<BpmOftenFlow> query(QueryFilter<BpmOftenFlow> queryFilter) {
        return new PageList(((BpmOftenFlowDao)this.baseMapper).query((IPage<BpmOftenFlow>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BpmOftenFlow>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    private Map<String, String> convertGroupList(String userId) {
        List list = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", "'" + userId + "'");
        if (BeanUtils.isEmpty((Object)list)) {
            return map;
        }
        for (IGroup group : list) {
            String type = group.getGroupType();
            if (map.containsKey(type)) {
                String groupId = (String)map.get(type);
                groupId = groupId + ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
                continue;
            }
            map.put(type, "'" + group.getGroupId() + "'");
        }
        return map;
    }

    @Override
    public String getBpmOftenFlowUsers(String oftenFlowId) {
        return this.toOwnerNameJson(this.bpmOftenFlowUserDao.getBpmOftenFlowUsers(oftenFlowId));
    }

    private String toOwnerNameJson(List<BpmOftenFlowUser> bpmOftenFlowUsers) {
        if (BeanUtils.isEmpty(bpmOftenFlowUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (BpmOftenFlowUser user : bpmOftenFlowUsers) {
            List<BpmOftenFlowUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode ArrayNode2 = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<BpmOftenFlowUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            ArrayNode2.add((JsonNode)json);
        }
        return ArrayNode2.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<BpmOftenFlowUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<BpmOftenFlowUser> list = entry.getValue();
        String ids = "";
        String names = "";
        for (int i = 0; i < list.size(); ++i) {
            BpmOftenFlowUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
                continue;
            }
            ids = ids + "," + user.getOwnerId();
            names = names + "," + user.getOwnerName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        return jsonObj;
    }

    private DefaultBpmDefinition getWebDesignFromRequest(DefaultBpmDefinitionVo vo) throws Exception {
        DefaultBpmDefinition defaultBpmDef = vo.getDefaultBpmDefinition();
        String typeId = defaultBpmDef.getTypeId();
        String name = defaultBpmDef.getName();
        String defKey = defaultBpmDef.getDefKey();
        String descp = defaultBpmDef.getDesc();
        String defJson = defaultBpmDef.getDefJson();
        Boolean isDeploy = vo.getIsdeploy();
        String reason = defaultBpmDef.getReason();
        String defId = defaultBpmDef.getDefId();
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtils.isNotEmpty((String)defId) && (bpmDefinition = isDeploy != false ? (DefaultBpmDefinition)BeanUtils.cloneBean((Object)this.bpmDefinitionManager.getById(defId)) : (DefaultBpmDefinition)BeanUtils.cloneBean((Object)this.bpmDefinitionManager.getById(defId))) != null) {
            bpmDefinition.setBpmDefData((BpmDefData)BeanUtils.cloneBean((Object)bpmDefinition.getBpmDefData()));
        }
        if (bpmDefinition == null) {
            bpmDefinition = new DefaultBpmDefinition();
            if (StringUtils.isNotEmpty((String)defKey)) {
                bpmDefinition.setDefKey(defKey);
            }
        }
        if (StringUtils.isNotEmpty((String)typeId)) {
            bpmDefinition.setTypeId(typeId);
            bpmDefinition.setTypeName(defaultBpmDef.getTypeName());
        }
        if (StringUtils.isNotEmpty((String)name)) {
            bpmDefinition.setName(name);
        }
        if (descp != null) {
            bpmDefinition.setDesc(descp);
        }
        if (StringUtils.isNotEmpty((String)defJson)) {
            bpmDefinition.setDefJson(defJson);
        }
        bpmDefinition.setDesigner(StringUtil.isNotEmpty((String)defaultBpmDef.getDesigner()) ? defaultBpmDef.getDesigner() : DesignerType.WEB.name());
        bpmDefinition.setReason(reason);
        bpmDefinition.setCreateBy(ContextUtil.getCurrentUser().getUserId());
        bpmDefinition.setBpmnXml(defaultBpmDef.getBpmnXml());
        bpmDefinition.setCreateOrgId(ContextUtil.getCurrentGroupId());
        return bpmDefinition;
    }
}

