/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.BpmWordPrintDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.def.impl.handler.WordPrintDefBpmDefXmlHandler;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.model.wordPrint.DefaultBpmWordPrint;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.util.RuleCheckUtil;
import com.hotent.bpmModel.manager.BpmWordPrintService;
import com.hotent.bpmModel.params.BpmWordPrintDefVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmWordPrintServiceImpl
implements BpmWordPrintService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    WordPrintDefBpmDefXmlHandler wordPrintDefBpmDefXmlHandler;
    @Resource
    FormFeignService formFeignService;

    @Override
    public List<BpmWordPrintDef> listJson(String defId) throws Exception {
        ArrayList<BpmWordPrintDef> bpmVariableList = new ArrayList<BpmWordPrintDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getWordPrintList() != null) {
            bpmVariableList.addAll(defExt.getWordPrintList());
        }
        block0: for (BpmWordPrintDef bpmWordPrintDef : bpmVariableList) {
            for (BpmNodeDef bpmNodeDef : bpmProcessDefExt.getBpmnNodeDefs()) {
                if (!bpmWordPrintDef.getRange().equals(bpmNodeDef.getNodeId())) continue;
                bpmWordPrintDef.setRange(bpmNodeDef.getName());
                continue block0;
            }
        }
        return bpmVariableList;
    }

    @Override
    public BpmWordPrintDef wordPrintEdit(String defId, String alias) throws Exception {
        List<BpmWordPrintDef> list = this.getAllBpmWordPrintDef(defId);
        BpmWordPrintDef bpmWordPrintDef = null;
        for (BpmWordPrintDef wordPrint : list) {
            if (!alias.equals(wordPrint.getAlias())) continue;
            bpmWordPrintDef = wordPrint;
        }
        return bpmWordPrintDef;
    }

    @Override
    public CommonResult<String> remove(String defId, String alias) throws Exception {
        try {
            List<BpmWordPrintDef> list = this.getAllBpmWordPrintDef(defId);
            ArrayList<BpmWordPrintDef> bpmWordPrintDefs = new ArrayList<BpmWordPrintDef>();
            for (BpmWordPrintDef wordPrint : list) {
                if (alias.equals(wordPrint.getAlias())) continue;
                bpmWordPrintDefs.add(wordPrint);
            }
            this.wordPrintDefBpmDefXmlHandler.saveNodeXml(defId, null, bpmWordPrintDefs);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public CommonResult<String> save(BpmWordPrintDefVo wordPrintDefVo) {
        String defId = wordPrintDefVo.getDefId();
        boolean isAdd = wordPrintDefVo.getIsAdd();
        DefaultBpmWordPrint wordPrintDef = wordPrintDefVo.getWordPrintDef();
        String alias = wordPrintDef.getAlias();
        try {
            List<BpmWordPrintDef> list = this.getAllBpmWordPrintDef(defId);
            ArrayList<Object> bpmWordPrintDefs = new ArrayList<Object>();
            for (BpmWordPrintDef printDef : list) {
                if (alias.equals(printDef.getAlias())) {
                    if (!isAdd) continue;
                    return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25:\u8be5\u6a21\u677f\u5df2\u6dfb\u52a0\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0", (Object)"");
                }
                bpmWordPrintDefs.add(printDef);
            }
            bpmWordPrintDefs.add(wordPrintDef);
            this.wordPrintDefBpmDefXmlHandler.saveNodeXml(defId, null, bpmWordPrintDefs);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public List<ObjectNode> getAllFormPrintTemplateByDefId(String defId, String topDefKey) throws Exception {
        List<Object> printTemplates = new ArrayList<ObjectNode>();
        List<Form> forms = this.handNodeDefSetting(defId, topDefKey, null, null);
        if (BeanUtils.isNotEmpty(forms)) {
            HashSet<String> formKeys = new HashSet<String>();
            for (Form form : forms) {
                if (!FormCategory.INNER.equals((Object)form.getType())) continue;
                formKeys.add(form.getFormValue());
            }
            if (!formKeys.isEmpty()) {
                ArrayList keyList = new ArrayList(formKeys);
                printTemplates = this.formFeignService.getWordTemplatesByFormKey(String.join((CharSequence)",", keyList));
            }
        }
        return printTemplates;
    }

    @Override
    public List<ObjectNode> getFormPrintTemplates(String defId, String instId, String topDefKey, Optional<String> nodeId, Optional<String> formKey) throws Exception {
        List flowTemplates;
        List list;
        ArrayList<ObjectNode> printTemplates = new ArrayList<ObjectNode>();
        if (StringUtil.isNotEmpty((String)formKey.orElse("")) && BeanUtils.isNotEmpty((Object)(list = this.formFeignService.getPrintListByFormKey(formKey.get())))) {
            for (Map template : list) {
                template.put("isOld", true);
                template.put("download", true);
                printTemplates.add((ObjectNode)JsonUtil.toJsonNode((Object)template));
            }
        }
        HashMap<String, BpmWordPrintDef> printDefMap = new HashMap<String, BpmWordPrintDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ArrayList<String> aliasList = new ArrayList<String>();
        List printList = defExt.getWordPrintList();
        if (printList != null && printList.size() > 0) {
            String nodeIdStr = nodeId.orElse("");
            for (BpmWordPrintDef wordPrintDef : printList) {
                if (!StringUtil.isEmpty((String)nodeIdStr) && !"all".equals(wordPrintDef.getRange()) && !wordPrintDef.getRange().contains(nodeIdStr)) continue;
                printDefMap.put(wordPrintDef.getAlias(), wordPrintDef);
                aliasList.add(wordPrintDef.getAlias());
            }
        }
        if (BeanUtils.isNotEmpty(aliasList) && BeanUtils.isNotEmpty((Object)(flowTemplates = this.formFeignService.getPrintListByAlias(String.join((CharSequence)",", aliasList))))) {
            for (int i = 0; i < flowTemplates.size(); ++i) {
                Map templateNode = (Map)flowTemplates.get(i);
                ArrayNode fileJson = (ArrayNode)JsonUtil.toJsonNode((String)templateNode.get("fileJson").toString());
                String from = templateNode.get("dataSourceForm").toString();
                BpmWordPrintDef printDef = (BpmWordPrintDef)printDefMap.get(templateNode.get("alias").toString());
                String preview = printDef.getPreview();
                String download = printDef.getDownload();
                if (!"Y".equals(preview)) continue;
                for (JsonNode fileNode : fileJson) {
                    boolean isAuth;
                    ObjectNode filePrintNode = JsonUtil.getMapper().createObjectNode();
                    if (!"success".equals(fileNode.get("status").asText()) || BeanUtils.isNotEmpty((Object)fileNode.get("rule")) && !fileNode.get("rule").isEmpty() && !(isAuth = RuleCheckUtil.validateFileAuth((String)instId, (Map)templateNode, (String)from, (String)fileNode.get("rule").asText()))) continue;
                    filePrintNode.put("fileName", fileNode.get("name").asText());
                    filePrintNode.put("fileType", fileNode.get("type").asText());
                    ObjectNode response = (ObjectNode)fileNode.get("response");
                    filePrintNode.put("fileId", response.get("fileId").asText());
                    filePrintNode.put("id", templateNode.get("id").toString());
                    filePrintNode.put("type", from);
                    filePrintNode.put("download", "Y".equals(download));
                    printTemplates.add(filePrintNode);
                }
            }
        }
        return printTemplates;
    }

    @Override
    public List getGlobalPrintTemplate(String defId) throws Exception {
        BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmProcessDefExt processDefExt = bpmProcessDef.getProcessDefExt();
        List wordPrintList = processDefExt.getWordPrintList();
        if (BeanUtils.isEmpty((Object)wordPrintList)) {
            return new ArrayList();
        }
        HashMap mapping = new HashMap();
        CharSequence[] aliases = new String[wordPrintList.size()];
        for (int i = 0; i < wordPrintList.size(); ++i) {
            String alias = ((BpmWordPrintDef)wordPrintList.get(i)).getAlias();
            mapping.put(alias, wordPrintList.get(i));
            aliases[i] = alias;
        }
        ArrayList<Map> result = new ArrayList<Map>();
        List printListByAlias = this.formFeignService.getPrintListByAlias(String.join((CharSequence)",", aliases));
        for (Object listByAlias : printListByAlias) {
            Map map = (Map)listByAlias;
            String alias = map.get("alias").toString();
            BpmWordPrintDef bpmWordPrintDef = (BpmWordPrintDef)mapping.get(alias);
            map.put("allowDownload", "Y".equals(bpmWordPrintDef.getDownload()));
            map.put("allowPreview", "Y".equals(bpmWordPrintDef.getPreview()));
            result.add(map);
        }
        return result;
    }

    private List<BpmWordPrintDef> getAllBpmWordPrintDef(String defId) throws Exception {
        ArrayList<BpmWordPrintDef> bpmVariableList = new ArrayList<BpmWordPrintDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getWordPrintList() != null) {
            bpmVariableList.addAll(defExt.getWordPrintList());
        }
        return bpmVariableList;
    }

    private List<Form> handNodeDefSetting(String defId, String parentDefKey, List<BpmNodeDef> nodeDefList, List<Form> formList) throws Exception {
        if (StringUtil.isNotEmpty((String)defId)) {
            FormExt instMobileForm;
            formList = new ArrayList<Form>();
            BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
            nodeDefList = bpmProcessDefExt.getBpmnNodeDefs();
            DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
            FormExt globalForm = StringUtil.isEmpty((String)parentDefKey) ? defExt.getGlobalForm() : defExt.getGlobalFormByDefKey(parentDefKey, false);
            FormExt globalMobileForm = StringUtil.isEmpty((String)parentDefKey) ? defExt.getGlobalMobileForm() : defExt.getGlobalFormByDefKey(parentDefKey, true);
            FormExt instForm = StringUtil.isEmpty((String)parentDefKey) ? defExt.getInstForm() : defExt.getInstFormByDefKey(parentDefKey, false);
            FormExt formExt = instMobileForm = StringUtil.isEmpty((String)parentDefKey) ? defExt.getInstMobileForm() : defExt.getInstFormByDefKey(parentDefKey, true);
            if (BeanUtils.isNotEmpty((Object)globalForm)) {
                formList.add((Form)globalForm);
            }
            if (BeanUtils.isNotEmpty((Object)globalMobileForm)) {
                formList.add((Form)globalMobileForm);
            }
            if (BeanUtils.isNotEmpty((Object)instForm)) {
                formList.add((Form)instForm);
            }
            if (BeanUtils.isNotEmpty((Object)instMobileForm)) {
                formList.add((Form)instMobileForm);
            }
        }
        for (BpmNodeDef nodeDef : nodeDefList) {
            String nodeId = nodeDef.getNodeId();
            NodeType type = nodeDef.getType();
            if (NodeType.START.equals((Object)type) || NodeType.CUSTOMSIGNTASK.equals((Object)type) || NodeType.USERTASK.equals((Object)type) || NodeType.SIGNTASK.equals((Object)type)) {
                Form form = null;
                Form mobileForm = null;
                if (StringUtil.isEmpty((String)parentDefKey) || "local_".equals(parentDefKey)) {
                    form = nodeDef.getForm();
                    mobileForm = nodeDef.getMobileForm();
                } else {
                    form = nodeDef.getSubForm(parentDefKey, FormType.PC);
                    mobileForm = nodeDef.getSubForm(parentDefKey, FormType.MOBILE);
                }
                if (form != null) {
                    form.setNodeId(nodeId);
                    formList.add(form);
                }
                if (mobileForm == null) continue;
                mobileForm.setNodeId(nodeId);
                formList.add(mobileForm);
                continue;
            }
            if (!NodeType.SUBPROCESS.equals((Object)type)) continue;
            SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)nodeDef;
            BpmProcessDef processDef = subProcessNodeDef.getChildBpmProcessDef();
            List bpmNodeDefs = processDef.getBpmnNodeDefs();
            this.handNodeDefSetting(null, parentDefKey, bpmNodeDefs, formList);
        }
        if (BeanUtils.isNotEmpty(formList)) {
            BeanUtils.removeDuplicate(formList);
        }
        return formList;
    }
}

