/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmModel.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.defxml.DefXmlUtil;
import com.hotent.bpm.defxml.entity.ext.BoDef;
import com.hotent.bpm.defxml.entity.ext.ExtDefinitions;
import com.hotent.bpm.defxml.entity.ext.ExtProcess;
import com.hotent.bpm.model.def.BpmDefXml;
import com.hotent.bpm.model.def.BpmDefXmlList;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.natapi.def.NatProDefinitionService;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProBoManager;
import com.hotent.bpm.persistence.model.BpmProBo;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpmModel.manager.BpmDefTransform;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmDefTransform
implements BpmDefTransform {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    NatProDefinitionService natProDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public Map<String, String> exportDef(List<String> defList) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        BpmDefXmlList list = new BpmDefXmlList();
        HashSet<String> formKeys = new HashSet<String>();
        HashSet<String> bocodes = new HashSet<String>();
        HashSet<String> defKeys = new HashSet<String>();
        for (String defId : defList) {
            this.handelFormBo(defId, formKeys, bocodes, defKeys);
            BpmDefXml defXml = this.getByDefId(defId);
            list.addBpmDefXml(defXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)list, BpmDefXmlList.class);
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formKeys", StringUtil.join(new ArrayList<String>(formKeys), (String)","));
            obj.put("boCodes", StringUtil.join(new ArrayList<String>(bocodes), (String)","));
            obj.put("defKeys", StringUtil.join(new ArrayList<String>(defKeys), (String)","));
            Map formRightXml = this.formRestfulService.getFormAndBoExportXml(obj);
            map.put("bpmdefs.flow.xml", xml);
            if (BeanUtils.isNotEmpty((Object)formRightXml)) {
                map.putAll(formRightXml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    private void handelFormBo(String defId, Set<String> form, Set<String> bocode, Set<String> defKeys) throws Exception {
        FormExt globalMobileForm;
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        defKeys.add(bpmProcessDefExt.getDefKey());
        FormExt globalForm = defExt.getGlobalForm();
        if (globalForm != null && FormCategory.INNER == globalForm.getType() && StringUtil.isNotEmpty((String)globalForm.getFormValue())) {
            form.add(globalForm.getFormValue());
        }
        if ((globalMobileForm = defExt.getGlobalMobileForm()) != null && FormCategory.INNER == globalMobileForm.getType() && StringUtil.isNotEmpty((String)globalMobileForm.getFormValue())) {
            form.add(globalMobileForm.getFormValue());
        }
        List nodeList = this.bpmDefinitionAccessor.getSignUserNode(defId);
        for (BpmNodeDef bpmNodeDef : nodeList) {
            Form mobileNodeForm;
            Form nodeForm = bpmNodeDef.getForm();
            if (nodeForm != null && FormCategory.INNER == nodeForm.getType() && StringUtil.isNotEmpty((String)nodeForm.getFormValue())) {
                form.add(nodeForm.getFormValue());
            }
            if ((mobileNodeForm = bpmNodeDef.getMobileForm()) == null || FormCategory.INNER != mobileNodeForm.getType() || !StringUtil.isNotEmpty((String)mobileNodeForm.getFormValue())) continue;
            form.add(mobileNodeForm.getFormValue());
        }
        List boDefList = defExt.getBoDefList();
        for (ProcBoDef procBoDef : boDefList) {
            bocode.add(procBoDef.getKey());
        }
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId) {
        try {
            String appModelsPortalXml;
            String flowXml = objectNode.get("bpmdefsXml") == null ? null : objectNode.get("bpmdefsXml").asText();
            String formXmlStr = objectNode.get("formXmlStr") == null ? null : objectNode.get("formXmlStr").asText();
            String boXmlStr = objectNode.get("boXmlStr") == null ? null : objectNode.get("boXmlStr").asText();
            String formRightsXml = objectNode.get("formRightsXml") == null ? null : objectNode.get("formRightsXml").asText();
            String formDataTemplatesXml = objectNode.get("formDataTemplatesXml") == null ? null : objectNode.get("formDataTemplatesXml").asText();
            String sysAppsPortalXml = objectNode.get("sysAppsPortalXml") == null ? null : objectNode.get("sysAppsPortalXml").asText();
            String string = appModelsPortalXml = objectNode.get("appModelsPortalXml") == null ? null : objectNode.get("appModelsPortalXml").asText();
            if (StringUtil.isNotEmpty((String)flowXml)) {
                BpmDefXmlList defList = (BpmDefXmlList)JAXBUtil.unmarshall((String)flowXml, BpmDefXmlList.class);
                List list = defList.getBpmList();
                for (BpmDefXml defXml : list) {
                    String defTypeId = typeId;
                    if (StringUtil.isEmpty((String)typeId)) {
                        ObjectNode sysType = this.portalFeignService.getSysTypeByType("FLOW_TYPE", "default");
                        defTypeId = sysType.get("id").asText();
                    }
                    this.importDef(defXml, defTypeId);
                }
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            if (StringUtil.isNotEmpty((String)formXmlStr)) {
                obj.put("formXmlStr", formXmlStr);
            }
            if (StringUtil.isNotEmpty((String)boXmlStr)) {
                obj.put("boXmlStr", boXmlStr);
            }
            if (StringUtil.isNotEmpty((String)formRightsXml)) {
                obj.put("formRightsXml", formRightsXml);
            }
            if (StringUtil.isNotEmpty((String)formDataTemplatesXml)) {
                obj.put("formDataTemplatesXml", formDataTemplatesXml);
            }
            if (StringUtil.isNotEmpty((String)sysAppsPortalXml)) {
                obj.put("sysAppsPortalXml", sysAppsPortalXml);
            }
            if (StringUtil.isNotEmpty((String)appModelsPortalXml)) {
                obj.put("appModelsPortalXml", appModelsPortalXml);
            }
            return this.formRestfulService.importFormAndBo(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("XML\u8f6c\u6362\u4e3aPOJO\u7c7b\u578b\u9519\u8bef" + e.getMessage(), e);
        }
    }

    private BpmDefXml getByDefId(String defId) {
        DefaultBpmDefinition definition = this.bpmDefinitionManager.getById(defId);
        BpmDefXml defXml = new BpmDefXml();
        defXml.setBpmDefinition(definition);
        return defXml;
    }

    private void importDef(BpmDefXml defXml, String typeId) throws Exception {
        this.importDefinition(defXml, typeId);
    }

    private DefaultBpmDefinition importDefinition(BpmDefXml defXml, String typeId) throws Exception {
        String defId = UniqueIdUtil.getSuid();
        DefaultBpmDefinition def = defXml.getBpmDefinition();
        String defKey = def.getDefKey();
        def.setDefId(defId);
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        ObjectNode sysType = portalFeignService.getSysTypeById(typeId);
        String typeName = "";
        if (BeanUtils.isNotEmpty((Object)sysType)) {
            typeName = sysType.get("name").asText();
        }
        if (StringUtil.isNotEmpty((String)typeId)) {
            def.setTypeId(typeId);
            def.setTypeName(typeName);
        }
        String bpmnXml = def.getBpmnXml();
        String defJson = def.getDefJson();
        if (StringUtil.isNotEmpty((String)defJson)) {
            def.getBpmDefData().setDefJson(null);
        }
        IUser user = ContextUtil.getCurrentUser();
        String createBy = null;
        if (user != null) {
            createBy = user.getUserId();
        }
        def.setCreateBy(createBy);
        this.handleBpmProBo(bpmnXml, defId, defKey, createBy);
        String deployId = "";
        try {
            deployId = this.natProDefinitionService.deploy("", def.getName(), bpmnXml);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String bpmnDefId = this.natProDefinitionService.getProcessDefinitionIdByDeployId(deployId);
        def.setIsMain("Y");
        def.setBpmnDefId(bpmnDefId);
        def.setBpmnDeployId(deployId);
        Integer version = this.bpmDefinitionManager.getMaxVersion(defKey);
        def.setVersion(version);
        def.setCreateTime(LocalDateTime.now());
        this.bpmDefinitionManager.create((Model)def);
        this.bpmDefinitionManager.updMainVersion(defId);
        return def;
    }

    private void handleBpmProBo(String bpmnXml, String defId, String defKey, String createBy) throws Exception {
        ExtDefinitions definitions = DefXmlUtil.getDefinitionsByXml((String)bpmnXml);
        ExtProcess extProcess = definitions.getExtProcess();
        ExtProcess.BoList boList = extProcess.getBoList();
        if (BeanUtils.isEmpty((Object)boList)) {
            return;
        }
        List boDefs = boList.getBoDef();
        if (BeanUtils.isEmpty((Object)boDefs)) {
            return;
        }
        ArrayList<BpmProBo> bpmProBos = new ArrayList<BpmProBo>();
        for (BoDef boDef : boDefs) {
            BpmProBo bpmProBo = new BpmProBo();
            bpmProBo.setId(UniqueIdUtil.getSuid());
            bpmProBo.setProcessId(defId);
            bpmProBo.setBoCode(boDef.getKey());
            bpmProBo.setBoName(boDef.getName());
            bpmProBo.setCreatorId(createBy);
            bpmProBos.add(bpmProBo);
        }
        this.bpmProBoManager.createByBpmProBoList(bpmProBos, defId, defKey);
    }
}

