/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.groovy.IScript;
import com.hotent.base.groovy.IUserScript;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExtendClassLoader;
import com.hotent.base.util.FileUtil;
import com.hotent.runtime.manager.BpmExtendJarManager;
import com.hotent.runtime.model.BpmExtendClass;
import com.hotent.runtime.model.BpmExtendJar;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/bpmExtendJar/v1/"})
public class BpmExtendJarController
extends BaseController<BpmExtendJarManager, BpmExtendJar> {
    @RequestMapping(value={"resolutionJar"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89e3\u6790\u4e0a\u4f20\u7684jar\u5305", httpMethod="POST", notes="\u89e3\u6790\u4e0a\u4f20\u7684jar\u5305")
    public CommonResult<BpmExtendJar> resolutionJar(MultipartHttpServletRequest request) throws Exception {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        BpmExtendJar jarManage = new BpmExtendJar();
        while (it.hasNext()) {
            MultipartFile f = (MultipartFile)it.next();
            String oriFileName = f.getOriginalFilename();
            jarManage.setJarBytes(FileUtil.readByte((InputStream)f.getInputStream()));
            jarManage.setSize((int)Math.round((double)f.getSize() / 1024.0));
            jarManage.setName(oriFileName);
            this.setJarClassList(jarManage);
        }
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)jarManage);
    }

    private void setJarClassList(BpmExtendJar jarManage) throws IOException {
        Map resolutionJarClass = null;
        try {
            resolutionJarClass = ExtendClassLoader.resolutionJarClass((byte[])jarManage.getJarBytes());
        }
        catch (NullPointerException e) {
            throw new MessagePassingException("\u6587\u4ef6\u4e0d\u5408\u6cd5");
        }
        if (BeanUtils.isNotEmpty((Object)resolutionJarClass)) {
            HashSet<String> simpleNmaes = new HashSet<String>();
            ArrayList<BpmExtendClass> addClassList = new ArrayList<BpmExtendClass>();
            for (Map.Entry next : resolutionJarClass.entrySet()) {
                Class cls = (Class)next.getValue();
                BpmExtendClass extendClass = new BpmExtendClass();
                extendClass.setPath(cls.getName());
                extendClass.setSimpleName(ExtendClassLoader.getSimpleName((String)cls.getName()));
                simpleNmaes.add(extendClass.getSimpleName());
                extendClass.setMd5((String)next.getKey());
                if (IUserScript.class.isAssignableFrom(cls)) {
                    extendClass.setType("2");
                } else if (IScript.class.isAssignableFrom(cls)) {
                    extendClass.setType("1");
                }
                addClassList.add(extendClass);
            }
            jarManage.setClassList(addClassList);
        }
    }

    @RequestMapping(value={"saveJar"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public CommonResult<String> saveJar(@ApiParam(name="jar", value="jar\u5305\u7ba1\u7406\u5bf9\u8c61") @RequestBody BpmExtendJar jar) throws Exception {
        return ((BpmExtendJarManager)this.baseService).saveJar(jar);
    }

    @DeleteMapping(value={"deleteById"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @RequestParam String id) {
        ((BpmExtendJarManager)this.baseService).remove((Serializable)((Object)id));
        return new CommonResult();
    }

    @GetMapping(value={"getJarById"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public BpmExtendJar getJarById(@ApiParam(name="id", value="\u5b9e\u4f53id") @RequestParam String id) throws IOException {
        BpmExtendJar byId = (BpmExtendJar)((Object)((BpmExtendJarManager)this.baseService).getById((Serializable)((Object)id)));
        this.setJarClassList(byId);
        return byId;
    }

    @RequestMapping(value={"publishJar"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03jar\u5305\u5c06\u5176\u4e2d\u7684\u811a\u672c\u7c7b\u6ce8\u518c\u5230\u670d\u52a1\u4e2d", httpMethod="GET", notes="\u53d1\u5e03jar\u5305\u5c06\u5176\u4e2d\u7684\u811a\u672c\u7c7b\u6ce8\u518c\u5230\u670d\u52a1\u4e2d")
    public CommonResult<String> publishJar(@ApiParam(name="jarId", value="jar\u5305Id") @RequestParam String jarId, @ApiParam(name="iscover", value="\u662f\u5426\u8986\u76d6\u540c\u540dclass") @RequestParam Optional<Boolean> iscover) throws Exception {
        return ((BpmExtendJarManager)this.baseService).publishJar(jarId, iscover.orElse(false));
    }
}

