/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller.openController;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.AvoidRepeatableCommit;
import com.hotent.base.annotation.OpenApi;
import com.hotent.base.context.BaseContext;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmIdentityService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.BpmTaskNoticeDone;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.params.AssignParamObject;
import com.hotent.runtime.params.DoNextParamObject;
import com.hotent.runtime.params.ModifyExecutorsParamObject;
import com.hotent.runtime.service.TaskService;
import com.hotent.runtime.vo.DoNextParamObjectVo;
import com.hotent.runtime.vo.ModifyExecutorsParamObjectVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${openApi.prefix}/runtime/task/v1/"})
@Api(tags={"\u6d41\u7a0b\u4efb\u52a1\uff08\u5bf9\u5916\u63a5\u53e3\uff09"})
@ApiGroup(group={"group_bpm"})
@OpenApi(moduleName="bpm-runtime\u6a21\u5757", function="\u6d41\u7a0b\u4efb\u52a1")
public class TaskOpenController {
    @Autowired
    TaskService taskService;
    @Resource
    IFlowManager iFlowService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IProcessManager iProcessService;

    @OpenApi(description="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c\uff08\u5bf9\u5916\u63a5\u53e3\uff09")
    @RequestMapping(value={"getTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c\uff08\u5bf9\u5916\u63a5\u53e3\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c\uff08\u5bf9\u5916\u63a5\u53e3\uff09")
    public CommonResult getTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        PageList<DefaultBpmTask> res = this.taskService.getTodoList(queryFilter);
        return new CommonResult().value(res);
    }

    @RequestMapping(value={"complete"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u4efb\u52a1", httpMethod="POST", notes="\u5904\u7406\u4efb\u52a1")
    @AvoidRepeatableCommit
    @OpenApi(description="\u5904\u7406\u4efb\u52a1")
    public CommonResult<String> complete(@ApiParam(name="doNextParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DoNextParamObjectVo doNextParamObjectVo) throws Exception {
        if (!this.isAuth(doNextParamObjectVo.getTaskId(), doNextParamObjectVo.getAgentLeaderId())) {
            return new CommonResult(false, "\u60a8\u6ca1\u6709\u5904\u7406\u8be5\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        try {
            DoNextParamObject doNextParamObject = new DoNextParamObject();
            BeanUtils.copyProperties((Object)doNextParamObjectVo, (Object)doNextParamObject);
            return this.iFlowService.complete(doNextParamObject).get();
        }
        catch (SQLException e) {
            if (StringUtil.hasEmoji((String)doNextParamObjectVo.getOpinion())) {
                return new CommonResult(false, "\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u8f93\u5165\u8868\u60c5\uff01");
            }
            throw e;
        }
    }

    @RequestMapping(value={"taskDetailBo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5")
    @OpenApi(description="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5")
    public CommonResult taskDetailBo(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=true) @RequestParam String reqParams, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId) throws Exception {
        return new CommonResult().value((Object)this.iFlowService.taskDetail(taskId, reqParams, FormType.PC, leaderId.orElse("").equals("0") ? "" : leaderId.orElse("")).get());
    }

    @RequestMapping(value={"getButtonsBytaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae")
    @OpenApi(description="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae")
    public CommonResult getButtonsBytaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        return new CommonResult().value((Object)this.taskService.getButtonsBytaskId(taskId, leaderId));
    }

    @RequestMapping(value={"canLock"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a\uff0c\u8fd4\u56de\u5f53\u524d\u4efb\u52a1\u7684\u53ef\u64cd\u4f5c\u72b6\u6001\uff1a0:\u4efb\u52a1\u5df2\u7ecf\u5904\u7406,1:\u53ef\u4ee5\u9501\u5b9a,2:\u4e0d\u9700\u8981\u89e3\u9501 ,3:\u53ef\u4ee5\u89e3\u9501\uff0c4,\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a,5:\u8fd9\u79cd\u60c5\u51b5\u4e00\u822c\u662f\u7ba1\u7406\u5458\u64cd\u4f5c\uff0c\u6240\u4ee5\u4e0d\u7528\u51fa\u9501\u5b9a\u6309\u94ae")
    @OpenApi(description="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a")
    public CommonResult canLock(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        CommonResult result = new CommonResult();
        if (task == null) {
            return result.value((Object)0);
        }
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(task.getProcInstId());
        if (isForbindden) {
            return result.value((Object)6);
        }
        int rtn = this.bpmTaskManager.canLockTask(taskId, leaderId.orElse(""));
        return result.value((Object)rtn);
    }

    @RequestMapping(value={"saveDraft"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8349\u7a3f", httpMethod="POST", notes="\u4fdd\u5b58\u8349\u7a3f")
    @AvoidRepeatableCommit
    @OpenApi(description="\u4fdd\u5b58\u8349\u7a3f")
    public CommonResult<String> saveDraft(@ApiParam(name="doNextParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DoNextParamObject doNextParamObject) throws Exception {
        return this.iFlowService.saveDraft(doNextParamObject);
    }

    @RequestMapping(value={"getAfterJumpNodes"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9", httpMethod="POST", notes="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9")
    @OpenApi(description="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9")
    public CommonResult getAfterJumpNodes(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestBody ObjectNode flowManagerVo) throws Exception {
        return new CommonResult().value((Object)this.iFlowService.getAfterJumpNode(flowManagerVo));
    }

    @RequestMapping(value={"delegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", httpMethod="POST", notes="\u4efb\u52a1\u8f6c\u529e")
    @OpenApi(description="\u4efb\u52a1\u8f6c\u529e")
    public CommonResult<String> delegate(@ApiParam(required=true, name="assignParamObject", value="\u4efb\u52a1\u8f6c\u529e\u53c2\u6570") @RequestBody AssignParamObject assignParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId) throws Exception {
        return this.taskService.delegate(assignParamObject, null, leaderId);
    }

    @RequestMapping(value={"retrieveBpmTask"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b", httpMethod="GET", notes="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b\u6d41\u7a0b")
    @OpenApi(description="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b")
    public CommonResult<String> retrieveBpmTask(@ApiParam(required=true, name="taskId", value="\u4efb\u52a1taskId") String taskId) {
        IUser user = ContextUtil.getCurrentUser();
        return this.bpmTaskManager.retrieveBpmTask(user, taskId);
    }

    @RequestMapping(value={"getTodoCount"}, produces={"application/json; charset=utf-8"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u6570\u76ee", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u6570\u76ee")
    @OpenApi(description="\u83b7\u53d6\u5f85\u529e\u6570\u76ee")
    public CommonResult getTodoCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult().value((Object)this.bpmTaskManager.getCountByUserId(this.baseContext.getCurrentUserId()));
    }

    @RequestMapping(value={"getNoticeDoneReadCount"}, produces={"application/json; charset=utf-8"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    @OpenApi(description="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public CommonResult getNoticeDoneReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult().value(this.iFlowService.getNoticeDoneReadCount(this.baseContext.getCurrentUserAccout(), queryFilter));
    }

    @RequestMapping(value={"getNoticeDoneReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    @OpenApi(description="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public CommonResult getNoticeDoneReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        List boys = queryFilter.getQuerys();
        Optional<QueryField> queryFieldOptional = boys.stream().filter(s -> s.getProperty().equals("inst.PROC_DEF_KEY_")).findFirst();
        if (queryFieldOptional.isPresent()) {
            QueryField queryField = queryFieldOptional.get();
            DefaultBpmDefinition po = this.bpmDefinitionManager.getMainByDefKey(queryFieldOptional.get().getValue().toString());
            queryFilter.addFilter("bpm_task_notice_done.PROC_DEF_ID_", (Object)po.getDefId(), QueryOP.EQUAL);
            queryFilter.getQuerys().remove(queryFieldOptional.get());
        }
        PageList<BpmTaskNoticeDone> pageList = this.iFlowService.getNoticeDoneReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return new CommonResult().value(pageList);
    }

    @RequestMapping(value={"getNoticeTodoReadCount"}, produces={"application/json; charset=utf-8"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    @OpenApi(description="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public CommonResult getNoticeTodoReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult().value(this.iFlowService.getNoticeTodoReadCount(this.baseContext.getCurrentUserAccout(), queryFilter));
    }

    @RequestMapping(value={"getNoticeTodoReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    @OpenApi(description="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public CommonResult getNoticeTodoReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<BpmTaskNotice> pageList = this.iFlowService.getNoticeTodoReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return new CommonResult().value(pageList);
    }

    @RequestMapping(value={"batchHandle"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5904\u7406\u4efb\u52a1", httpMethod="POST", notes="\u6279\u91cf\u5904\u7406\u4efb\u52a1")
    @OpenApi(description="\u6279\u91cf\u5904\u7406\u4efb\u52a1")
    public CommonResult<HashMap<String, Object>> batchHandle(@ApiParam(name="requestMap", value="\u8bf7\u6c42\u4f53") @RequestBody Map<String, Object> requestMap) throws Exception {
        return this.taskService.batchHandle(requestMap);
    }

    @RequestMapping(value={"getTasksByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @OpenApi(description="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public CommonResult getTasksByInstId(@ApiParam(name="instId", value="\u5b9e\u4f8bid", required=true) @RequestParam(value="instId") String instId) throws Exception {
        PageList<DefaultBpmTask> tasksByInstId = this.iProcessService.getTasksByInstId(instId);
        return new CommonResult().value(tasksByInstId);
    }

    @RequestMapping(value={"setTaskExecutors"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba", httpMethod="POST", notes="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba")
    @OpenApi(description="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba")
    public CommonResult<String> setTaskExecutors(@ApiParam(required=true, name="modifyExecutorsParamObject", value="\u4fee\u6539\u6267\u884c\u4eba\u5bf9\u8c61") @RequestBody ModifyExecutorsParamObjectVo modifyExecutorsParamObjectVo) throws Exception {
        ModifyExecutorsParamObject modifyExecutorsParamObject = new ModifyExecutorsParamObject();
        BeanUtils.copyProperties((Object)modifyExecutorsParamObjectVo, (Object)modifyExecutorsParamObject);
        return this.iFlowService.setTaskExecutors(modifyExecutorsParamObject);
    }

    private boolean isAuth(String taskId, String leaderId) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser.isAdmin()) {
            return true;
        }
        DefaultBpmTask task = this.bpmTaskManager.getByTaskId(taskId);
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)task)) {
            Boolean hasPermTodo = false;
            List recievers = new ArrayList();
            List queryByBpmTask = this.bpmIdentityService.queryListByBpmTask((BpmTask)task);
            recievers = this.bpmIdentityExtractService.extractUser(queryByBpmTask);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(recievers)) {
                for (IUser iUser : recievers) {
                    if (!currentUser.getUserId().equals(iUser.getUserId()) && (!StringUtil.isNotEmpty((String)leaderId) || !leaderId.equals(iUser.getUserId()))) continue;
                    hasPermTodo = true;
                    break;
                }
            }
            if (!hasPermTodo.booleanValue() && !this.iFlowService.isInRightMap(task.getProcDefKey(), task.getProcInstId())) {
                return false;
            }
        }
        return true;
    }
}

