/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.listener;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.StartNewFlowEvent;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.plugin.core.util.UserAssignRuleParser;
import com.hotent.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.hotent.bpm.plugin.task.startnewflow.context.StartNewFlowPluginContext;
import com.hotent.bpm.plugin.task.startnewflow.def.StartNewFlowPluginDef;
import com.hotent.bpm.plugin.task.startnewflow.entity.StartConfig;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.params.StartFlowParamObject;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class StartNewFlowEventListener
implements ApplicationListener<StartNewFlowEvent> {
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IProcessManager iProcessService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BaseContext baseContext;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    private static final String MAIN_TABLE = "main";
    private static final String SUB_TABLE = "sub";
    private static final String SUN_TABLE = "sun";

    public void onApplicationEvent(StartNewFlowEvent arg0) {
        BpmNodeDef bpmNodeDef = (BpmNodeDef)arg0.getSource();
        StartNewFlowPluginContext pluginContext = (StartNewFlowPluginContext)bpmNodeDef.getPluginContext(StartNewFlowPluginContext.class);
        if (BeanUtils.isEmpty((Object)pluginContext)) {
            return;
        }
        StartNewFlowPluginDef pluginDef = (StartNewFlowPluginDef)pluginContext.getBpmPluginDef();
        List configs = pluginDef.getStartConfigList();
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        HashMap variables = actionCmd.getVariables();
        if (BeanUtils.isEmpty((Object)variables)) {
            variables = new HashMap();
        }
        variables.putAll(BpmContextUtil.getBoFromContext());
        actionCmd.setVariables(variables);
        ExecutorService executorService = Executors.newCachedThreadPool();
        String currentUserId = this.baseContext.getCurrentUserId();
        for (StartConfig conf : configs) {
            executorService.execute(() -> {
                try {
                    IUser userByAccount = this.userServiceImpl.getUserById(currentUserId);
                    SecurityContextHolder.getContext().setAuthentication(null);
                    ContextUtil.setCurrentUser((IUser)userByAccount);
                    this.startByConf(conf, actionCmd);
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage());
                }
            });
        }
    }

    private void startByConf(StartConfig conf, ActionCmd actionCmd) throws Exception {
        if ("".equals(actionCmd.getActionName())) {
            actionCmd.setActionName("agree");
        }
        if (!(conf.getTriggerAction().equals(actionCmd.getActionName()) || OpinionStatus.REJECT.getKey().equals(conf.getTriggerAction()) && OpinionStatus.BACK_TO_START.getKey().equals(actionCmd.getActionName()))) {
            return;
        }
        DefaultBpmDefinition definition = this.bpmDefinitionManager.getMainByDefKey(conf.getDefKey());
        if (BeanUtils.isEmpty((Object)definition)) {
            return;
        }
        ObjectNode oldBoData = null;
        if (StringUtil.isEmpty((String)actionCmd.getBusData())) {
            List dataByInst;
            BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)instanceManager.get((Serializable)((Object)actionCmd.getInstId()));
            if (BeanUtils.isNotEmpty((Object)instance) && BeanUtils.isNotEmpty((Object)(dataByInst = this.boDataService.getDataByInst((BpmProcessInstance)instance)))) {
                oldBoData = BoDataUtil.hanlerData((String)instance.getProcDefId(), (List)dataByInst, (boolean)true);
                BpmContextUtil.setBoToContext((List)dataByInst);
                actionCmd.getVariables().putAll(BpmContextUtil.getBoFromContext());
            }
        } else {
            oldBoData = (ObjectNode)JsonUtil.toJsonNode((String)actionCmd.getBusData());
        }
        List boDatas = this.boDataService.getDataByDefId(definition.getDefId());
        ObjectNode newBoData = null;
        if (BeanUtils.isNotEmpty((Object)boDatas)) {
            newBoData = BoDataUtil.hanlerData((String)definition.getDefId(), (List)boDatas, (boolean)true);
        }
        if ("1".equals(conf.getTriggerType())) {
            this.startWithUsers(oldBoData, newBoData, conf, actionCmd, definition.getId());
        } else {
            this.startWithEntitys(oldBoData, newBoData, conf, definition.getId());
        }
    }

    private void startWithEntitys(ObjectNode oldBoData, ObjectNode newBoData, StartConfig conf, String defId) throws Exception {
        JsonNode conditionJson;
        IUser startUser = null;
        ArrayList<IUser> startUsers = new ArrayList<IUser>();
        if (StringUtil.isNotEmpty((String)conf.getStartAccount())) {
            String[] Accounts;
            for (String account : Accounts = conf.getStartAccount().split(",")) {
                IUser userByAccount = this.userServiceImpl.getUserByAccount(account);
                if (!BeanUtils.isNotEmpty((Object)userByAccount) || userByAccount.getStatus() == 2) continue;
                startUsers.add(userByAccount);
            }
        }
        if (startUsers.size() == 0) {
            startUser = this.userServiceImpl.getUserById(this.baseContext.getCurrentUserId());
            startUsers.add(startUser);
        }
        String[] path = conf.getTriggerEntity().split("\\.");
        ArrayList<String> newBusDatas = new ArrayList<String>();
        String condition = "true";
        if (StringUtil.isNotEmpty((String)conf.getCondition()) && BeanUtils.isNotEmpty((Object)(conditionJson = JsonUtil.toJsonNode((String)conf.getCondition())).get("conditionString")) && StringUtil.isNotEmpty((String)conditionJson.get("conditionString").asText())) {
            condition = conditionJson.get("conditionString").asText();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("curUserId", ContextUtil.getCurrentUserId());
        variables.put("curUserAccount", ContextUtil.getCurrentUser().getAccount());
        variables.put("curUserName", ContextUtil.getCurrentUser().getFullname());
        if (path.length == 2) {
            variables.put(path[1].replace("sub_", ""), (String)HtJsonNodeFactory.build().htObjectNode((ObjectNode)oldBoData.get(path[0])));
            if (this.groovyScriptEngine.executeBoolean(condition, variables)) {
                newBusDatas.add(this.getNewData(oldBoData, newBoData, conf, null, null));
            }
        } else {
            ArrayNode subs = JsonUtil.createArrayNode();
            if (BeanUtils.isNotEmpty((Object)oldBoData.get("subMap"))) {
                String[] subnames = path[1].split("sub_");
                subs = (ArrayNode)oldBoData.get("subMap").get(subnames[1]);
            } else if (oldBoData.hasNonNull(path[0]) && oldBoData.get(path[0]).hasNonNull(path[2]) && oldBoData.get(path[0]).get(path[2]) instanceof ArrayNode) {
                subs = (ArrayNode)oldBoData.get(path[0]).get(path[2]);
            }
            for (JsonNode jsonNode : subs) {
                if (path.length > 3) {
                    if (!jsonNode.hasNonNull(path[3]) || !(jsonNode.get(path[3]) instanceof ArrayNode)) continue;
                    for (JsonNode sonJson : (ArrayNode)jsonNode.get(path[2])) {
                        variables.put(path[3].replace("sub_", ""), (String)HtJsonNodeFactory.build().htObjectNode((ObjectNode)sonJson));
                        if (!StartConfig.DIRECT_TRIGGER.equals(conf.getTriggerTiming()) && !this.groovyScriptEngine.executeBoolean(condition, variables)) continue;
                        newBusDatas.add(this.getNewData(oldBoData, newBoData, conf, (ObjectNode)jsonNode, (ObjectNode)sonJson));
                    }
                    continue;
                }
                variables.put(path[2].replace("sub_", ""), (String)HtJsonNodeFactory.build().htObjectNode((ObjectNode)jsonNode));
                if (!StartConfig.DIRECT_TRIGGER.equals(conf.getTriggerTiming()) && !this.groovyScriptEngine.executeBoolean(condition, variables)) continue;
                newBusDatas.add(this.getNewData(oldBoData, newBoData, conf, (ObjectNode)jsonNode, null));
            }
        }
        String url = "/runtime/instance/v1/start";
        for (String newBusData : newBusDatas) {
            for (IUser starUser : startUsers) {
                StartFlowParamObject paramObject = new StartFlowParamObject();
                paramObject.setData(newBusData);
                paramObject.setDefId(defId);
                System.err.println("\u8868\u5355\u5bf9\u8c61\u542f\u52a8\u65b0\u6d41\u7a0b\uff1a" + defId + "\u53d1\u8d77\u4eba\uff1a" + starUser.getFullname() + "\u8868\u5355\u6570\u636e:" + newBusData);
                paramObject.setAccount(starUser.getAccount());
                try {
                    FluentUtil.postCurAppInterfaceWithHttp((String)url, (String)starUser.getAccount(), (Object)paramObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void startWithUsers(ObjectNode oldBoData, ObjectNode newBoData, StartConfig conf, ActionCmd actionCmd, String defId) throws Exception {
        List<Object> startUsers = new ArrayList<IUser>();
        if (StringUtil.isNotEmpty((String)conf.getUserRule())) {
            ArrayList<UserAssignRule> rules = new ArrayList<UserAssignRule>();
            ObjectNode assignRuleObj = (ObjectNode)JsonUtil.toJsonNode((String)conf.getUserRule());
            if (BeanUtils.isNotEmpty((Object)assignRuleObj.get("calcs"))) {
                UserAssignRule rule = UserAssignRuleParser.getUserAssignRule((ObjectNode)assignRuleObj);
                rules.add(rule);
                Map variables = actionCmd.getVariables();
                variables.putAll(actionCmd.getTransitVars());
                ContextThreadUtil.setActionCmd((ActionCmd)actionCmd);
                startUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(rules, (Map)variables);
            } else {
                startUsers.add(this.userServiceImpl.getUserById(this.baseContext.getCurrentUserId()));
            }
        } else {
            startUsers.add(this.userServiceImpl.getUserById(this.baseContext.getCurrentUserId()));
        }
        if (BeanUtils.isEmpty(startUsers)) {
            return;
        }
        String newBusData = this.getNewData(oldBoData, newBoData, conf);
        String url = "/runtime/instance/v1/start";
        for (IUser iUser : startUsers) {
            StartFlowParamObject paramObject = new StartFlowParamObject();
            paramObject.setData(newBusData);
            paramObject.setDefId(defId);
            System.err.println("\u53d1\u8d77\u4eba\u5bf9\u8c61\u542f\u52a8\u65b0\u6d41\u7a0b\uff1a" + defId + "\u53d1\u8d77\u4eba\uff1a" + iUser.getFullname());
            paramObject.setAccount(iUser.getAccount());
            try {
                FluentUtil.postCurAppInterfaceWithHttp((String)url, (String)iUser.getAccount(), (Object)paramObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getNewData(ObjectNode oldBoData, ObjectNode newBoData, StartConfig conf, ObjectNode subDta, ObjectNode sunData) throws Exception {
        String newBusData = "";
        if (StringUtil.isNotEmpty((String)conf.getFormVarConf()) && oldBoData != null && newBoData != null) {
            ArrayNode formVarConf = (ArrayNode)JsonUtil.toJsonNode((String)conf.getFormVarConf());
            for (JsonNode varConf : formVarConf) {
                String oldVar = JsonUtil.getString((JsonNode)varConf, (String)"oldVar");
                String newVar = JsonUtil.getString((JsonNode)varConf, (String)"newVar");
                if (StringUtil.isEmpty((String)oldVar) || StringUtil.isEmpty((String)newVar)) continue;
                String[] oldVarConf = oldVar.split("\u3010")[1].split("\u3011-")[0].replaceAll("sub_", "").split("\\.");
                String[] newVarConf = newVar.split("\u3010")[1].split("\u3011-")[0].replaceAll("sub_", "").split("\\.");
                if (BeanUtils.isEmpty((Object)oldBoData.get(oldVarConf[0])) || BeanUtils.isEmpty((Object)newBoData.get(newVarConf[0]))) continue;
                JsonNode oldValue = null;
                if (oldVarConf.length == 2) {
                    oldValue = oldBoData.get(oldVarConf[0]).get(oldVarConf[1]);
                    this.getMappingData(newBoData, newVarConf, oldValue);
                    continue;
                }
                if (oldVarConf.length == 3) {
                    oldValue = subDta.get(oldVarConf[oldVarConf.length - 1]);
                    this.getMappingData(newBoData, newVarConf, oldValue);
                    continue;
                }
                if (oldVarConf.length != 4) continue;
                oldValue = sunData.get(oldVarConf[oldVarConf.length - 1]);
                this.getMappingData(newBoData, newVarConf, oldValue);
            }
            newBusData = Base64.getBase64((String)JsonUtil.toJson((Object)newBoData));
        }
        return newBusData;
    }

    private String getNewData(ObjectNode oldBoData, ObjectNode newBoData, StartConfig conf) throws Exception {
        String newBusData = "";
        ObjectNode resultObj = JsonUtil.createObjectNode();
        HashMap<String, Map<String, String>> tableMapping = new HashMap<String, Map<String, String>>();
        if (StringUtil.isNotEmpty((String)conf.getFormVarConf()) && BeanUtils.isNotEmpty((Object)oldBoData) && BeanUtils.isNotEmpty((Object)newBoData)) {
            ArrayNode formVarConfNode = (ArrayNode)JsonUtil.toJsonNode((String)conf.getFormVarConf());
            for (JsonNode varConf : formVarConfNode) {
                String toKey;
                String key;
                String oldVar = JsonUtil.getString((JsonNode)varConf, (String)"oldVar");
                String newVar = JsonUtil.getString((JsonNode)varConf, (String)"newVar");
                if (StringUtil.isEmpty((String)oldVar) || StringUtil.isEmpty((String)newVar)) continue;
                ArrayList<String> oldVarConf = new ArrayList<String>(Arrays.asList(oldVar.split("\u3010")[1].split("\u3011-")[0].replaceAll("sub_", "").split("\\.")));
                ArrayList<String> newVarConf = new ArrayList<String>(Arrays.asList(newVar.split("\u3010")[1].split("\u3011-")[0].replaceAll("sub_", "").split("\\.")));
                if (BeanUtils.isEmpty(oldVarConf) || BeanUtils.isEmpty(newVarConf)) continue;
                int oldLength = oldVarConf.size();
                int newLength = newVarConf.size();
                String string = oldLength == 2 ? MAIN_TABLE : (oldLength == 3 ? SUB_TABLE : (key = oldLength == 4 ? SUN_TABLE : ""));
                String string2 = newLength == 2 ? MAIN_TABLE : (newLength == 3 ? SUB_TABLE : (toKey = newLength == 4 ? SUN_TABLE : ""));
                if (StringUtil.isEmpty((String)key) || StringUtil.isEmpty((String)toKey)) continue;
                JsonNode group = resultObj.get(key);
                if (BeanUtils.isEmpty((Object)group)) {
                    group = JsonUtil.createArrayNode();
                    resultObj.set(key, group);
                }
                this.setField(group, oldLength, newLength, oldVarConf, newVarConf, toKey, tableMapping);
            }
            this.chooseMapping(resultObj, oldBoData, newBoData, tableMapping);
            newBusData = Base64.getBase64((String)JsonUtil.toJson((Object)newBoData));
        }
        return newBusData;
    }

    private void chooseMapping(ObjectNode resultObj, ObjectNode oldBoData, ObjectNode newBoData, Map<String, Map<String, String>> tableMapping) throws Exception {
        if (BeanUtils.isNotEmpty((Object)resultObj.get(MAIN_TABLE))) {
            this.getMappingData(newBoData, (ArrayNode)resultObj.get(MAIN_TABLE), oldBoData, tableMapping, MAIN_TABLE);
        }
        if (BeanUtils.isNotEmpty((Object)resultObj.get(SUB_TABLE))) {
            this.getMappingData(newBoData, (ArrayNode)resultObj.get(SUB_TABLE), oldBoData, tableMapping, SUB_TABLE);
        }
        if (BeanUtils.isNotEmpty((Object)resultObj.get(SUN_TABLE))) {
            this.getMappingData(newBoData, (ArrayNode)resultObj.get(SUN_TABLE), oldBoData, tableMapping, SUN_TABLE);
        }
    }

    private void getMappingData(ObjectNode newData, ArrayNode groupAry, ObjectNode oldBoData, Map<String, Map<String, String>> tableMapping, String formType) throws Exception {
        List list = JsonUtil.arrayToList((ArrayNode)groupAry);
        Map<String, List<ObjectNode>> groupMap = list.stream().collect(Collectors.groupingBy(objectNode -> objectNode.get("toKey").asText()));
        HashMap resultsMap = new HashMap();
        groupMap.keySet().forEach(key -> {
            List groupList = (List)groupMap.get(key);
            ObjectNode mappingNode = (ObjectNode)resultsMap.get(key);
            if (BeanUtils.isEmpty((Object)mappingNode)) {
                mappingNode = JsonUtil.createObjectNode();
                resultsMap.put(key, mappingNode);
            }
            Map<String, List<ObjectNode>> groupToTbName = groupList.stream().collect(Collectors.groupingBy(objectNode -> objectNode.get("toGroup").asText()));
            for (String toTbNameKey : groupToTbName.keySet()) {
                List<ObjectNode> toTbList = groupToTbName.get(toTbNameKey);
                Map<String, List<ObjectNode>> groupFromTbName = toTbList.stream().collect(Collectors.groupingBy(objectNode -> objectNode.get("fromGroup").asText()));
                for (String fromTbNameKey : groupFromTbName.keySet()) {
                    ObjectNode forObjectNode;
                    List<ObjectNode> fromTbList = groupFromTbName.get(fromTbNameKey);
                    String toTbName = fromTbList.get(0).get("toTbName").asText();
                    String fromTbName = fromTbList.get(0).get("fromTbName").asText();
                    ObjectNode toObjectNode = (ObjectNode)mappingNode.get(toTbName);
                    if (BeanUtils.isEmpty((Object)toObjectNode)) {
                        toObjectNode = JsonUtil.createObjectNode();
                        mappingNode.set(toTbName, (JsonNode)toObjectNode);
                    }
                    if (BeanUtils.isEmpty((Object)(forObjectNode = (ObjectNode)toObjectNode.get(fromTbName)))) {
                        forObjectNode = JsonUtil.createObjectNode();
                        toObjectNode.set(fromTbName, (JsonNode)forObjectNode);
                    }
                    ObjectNode mappingResult = JsonUtil.createObjectNode();
                    for (ObjectNode group : fromTbList) {
                        mappingResult.put(group.get("fromColumn").asText(), group.get("toColumn").asText());
                        forObjectNode.put("toMainTbName", group.get("toMainTbName").asText());
                        forObjectNode.put("toSubTbName", group.get("toSubTbName").asText());
                        forObjectNode.put("toSunTbName", group.get("toSunTbName").asText());
                    }
                    forObjectNode.set("mappingResult", (JsonNode)mappingResult);
                }
            }
        });
        groupMap.keySet().forEach(key -> {
            block16: {
                block17: {
                    block15: {
                        if (!MAIN_TABLE.equals(formType)) break block15;
                        Iterator toTbNames = ((ObjectNode)resultsMap.get(key)).fieldNames();
                        while (toTbNames.hasNext()) {
                            String toTbName = (String)toTbNames.next();
                            Iterator fromTbNames = ((ObjectNode)resultsMap.get(key)).get(toTbName).fieldNames();
                            while (fromTbNames.hasNext()) {
                                String fromTbName = (String)fromTbNames.next();
                                try {
                                    this.setMainMappingData((ObjectNode)((ObjectNode)resultsMap.get(key)).get(toTbName).get(fromTbName), newData, (ObjectNode)oldBoData.get((String)((Map)tableMapping.get(fromTbName + toTbName)).get("fromMainTbName")), (String)key);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        break block16;
                    }
                    if (!SUB_TABLE.equals(formType)) break block17;
                    Iterator toTbNames = ((ObjectNode)resultsMap.get(key)).fieldNames();
                    while (toTbNames.hasNext()) {
                        String toTbName = (String)toTbNames.next();
                        Iterator fromTbNames = ((ObjectNode)resultsMap.get(key)).get(toTbName).fieldNames();
                        while (fromTbNames.hasNext()) {
                            String fromTbName = (String)fromTbNames.next();
                            String fromMainTbName = (String)((Map)tableMapping.get(fromTbName + toTbName)).get("fromMainTbName");
                            String fromSubTbName = (String)((Map)tableMapping.get(fromTbName + toTbName)).get("fromSubTbName");
                            ArrayNode subs = this.getSubData(oldBoData, Arrays.asList(fromMainTbName, fromSubTbName));
                            if (!BeanUtils.isNotEmpty((Object)subs)) continue;
                            for (JsonNode sub : subs) {
                                try {
                                    this.setMainMappingData((ObjectNode)((ObjectNode)resultsMap.get(key)).get(toTbName).get(fromTbName), newData, (ObjectNode)sub, (String)key);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    break block16;
                }
                if (!SUN_TABLE.equals(formType)) break block16;
                Iterator toTbNames = ((ObjectNode)resultsMap.get(key)).fieldNames();
                while (toTbNames.hasNext()) {
                    String toTbName = (String)toTbNames.next();
                    Iterator fromTbNames = ((ObjectNode)resultsMap.get(key)).get(toTbName).fieldNames();
                    while (fromTbNames.hasNext()) {
                        String fromTbName = (String)fromTbNames.next();
                        String fromMainTbName = (String)((Map)tableMapping.get(fromTbName + toTbName)).get("fromMainTbName");
                        String fromSubTbName = (String)((Map)tableMapping.get(fromTbName + toTbName)).get("fromSubTbName");
                        String fromSunTbName = (String)((Map)tableMapping.get(fromTbName + toTbName)).get("fromSunTbName");
                        ArrayNode subs = this.getSubData(oldBoData, Arrays.asList(fromMainTbName, fromSubTbName));
                        if (!BeanUtils.isNotEmpty((Object)subs)) continue;
                        for (JsonNode sub : subs) {
                            ObjectNode subNodes = (ObjectNode)sub;
                            ArrayNode suns = this.getSubData(subNodes, Arrays.asList(fromSubTbName, fromSunTbName));
                            if (!BeanUtils.isNotEmpty((Object)suns)) continue;
                            for (JsonNode sun : suns) {
                                try {
                                    this.setMainMappingData((ObjectNode)((ObjectNode)resultsMap.get(key)).get(toTbName).get(fromTbName), newData, (ObjectNode)sun, (String)key);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
            }
        });
    }

    private void setMainMappingData(ObjectNode toObjectNode, ObjectNode newData, ObjectNode oldBoData, String type) throws IOException {
        String fromColumn;
        Iterator fieldNames;
        Iterator initData;
        Object handleData;
        ArrayNode subs;
        ObjectNode newDataObjectNode;
        ObjectNode mappingResult = (ObjectNode)toObjectNode.get("mappingResult");
        String toMainTbName = toObjectNode.get("toMainTbName").asText();
        String toSubTbName = toObjectNode.get("toSubTbName").asText();
        String toSunTbName = toObjectNode.get("toSunTbName").asText();
        if (type.equals(MAIN_TABLE)) {
            newDataObjectNode = (ObjectNode)newData.get(toMainTbName);
            Iterator fieldNames2 = mappingResult.fieldNames();
            while (fieldNames2.hasNext()) {
                String fromColumn2 = (String)fieldNames2.next();
                String toColumn = mappingResult.get(fromColumn2).asText();
                newDataObjectNode.set(toColumn, oldBoData.get(fromColumn2));
            }
        }
        if (type.equals(SUB_TABLE)) {
            subs = this.getSubData(newData, Arrays.asList(toMainTbName, toSubTbName));
            handleData = null;
            if (BeanUtils.isEmpty((Object)subs)) {
                subs = JsonUtil.createArrayNode();
                ((ObjectNode)newData.get(toMainTbName)).set("sub_" + toSubTbName, (JsonNode)subs);
                initData = null;
                initData = (ObjectNode)JsonUtil.toJsonNode((Object)newData.get(toMainTbName).get("initData").get(toSubTbName));
                subs.add((JsonNode)initData);
                handleData = initData;
            } else {
                for (JsonNode sub : subs) {
                    newDataObjectNode = (ObjectNode)sub;
                    boolean mark = true;
                    Iterator fieldNames3 = mappingResult.fieldNames();
                    while (fieldNames3.hasNext()) {
                        String fromColumn3 = (String)fieldNames3.next();
                        String toColumn = mappingResult.get(fromColumn3).asText();
                        if (!newDataObjectNode.has(toColumn) || !StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)newDataObjectNode, (String)toColumn))) continue;
                        mark = false;
                    }
                    if (!mark) continue;
                    handleData = newDataObjectNode;
                    break;
                }
                if (BeanUtils.isEmpty(handleData)) {
                    initData = null;
                    initData = (ObjectNode)JsonUtil.toJsonNode((Object)newData.get(toMainTbName).get("initData").get(toSubTbName));
                    subs.add((JsonNode)initData);
                    handleData = initData;
                }
            }
            fieldNames = mappingResult.fieldNames();
            while (fieldNames.hasNext()) {
                fromColumn = (String)fieldNames.next();
                String toColumn = mappingResult.get(fromColumn).asText();
                handleData.set(toColumn, oldBoData.get(fromColumn));
            }
        }
        if (type.equals(SUN_TABLE)) {
            subs = this.getSubData(newData, Arrays.asList(toMainTbName, toSubTbName));
            handleData = null;
            if (BeanUtils.isEmpty((Object)subs)) {
                if (subs == null) {
                    subs = JsonUtil.createArrayNode();
                }
                initData = (ObjectNode)JsonUtil.toJsonNode((Object)newData.get(toMainTbName).get("initData").get(toSubTbName));
                subs.add((JsonNode)initData);
                ArrayNode suns = JsonUtil.createArrayNode();
                ObjectNode sun = (ObjectNode)JsonUtil.toJsonNode((Object)initData.get("initData").get(toSunTbName));
                suns.add((JsonNode)sun);
                initData.set("sub_" + toSunTbName, (JsonNode)suns);
                handleData = sun;
            } else {
                for (JsonNode sub : subs) {
                    Iterator initData2;
                    ObjectNode subNodes = (ObjectNode)sub;
                    ArrayNode suns = this.getSubData(subNodes, Arrays.asList(toSubTbName, toSunTbName));
                    if (BeanUtils.isEmpty((Object)suns)) {
                        subs = JsonUtil.createArrayNode();
                        ((ObjectNode)newData.get(toMainTbName)).set("sub_" + toSubTbName, (JsonNode)subs);
                        initData2 = (ObjectNode)JsonUtil.toJsonNode((Object)newData.get("initData").get(toSubTbName));
                        subs.add((JsonNode)initData2);
                        handleData = initData2;
                        continue;
                    }
                    for (JsonNode sun : suns) {
                        Iterator fieldNames4 = mappingResult.fieldNames();
                        newDataObjectNode = (ObjectNode)sun;
                        boolean mark = true;
                        while (fieldNames4.hasNext()) {
                            String fromColumn4 = (String)fieldNames4.next();
                            String toColumn = mappingResult.get(fromColumn4).asText();
                            if (!newDataObjectNode.has(toColumn) || !StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)newDataObjectNode, (String)toColumn))) continue;
                            mark = false;
                        }
                        if (!mark) continue;
                        handleData = newDataObjectNode;
                        break;
                    }
                    if (!BeanUtils.isEmpty((Object)handleData)) continue;
                    initData2 = (ObjectNode)JsonUtil.toJsonNode((Object)newData.get(toMainTbName).get("initData").get(toSubTbName).get("initData").get(toSunTbName));
                    suns.add((JsonNode)initData2);
                    handleData = initData2;
                }
            }
            fieldNames = mappingResult.fieldNames();
            while (fieldNames.hasNext()) {
                fromColumn = (String)fieldNames.next();
                String toColumn = mappingResult.get(fromColumn).asText();
                handleData.set(toColumn, oldBoData.get(fromColumn));
            }
        }
    }

    private void getMappingData(ObjectNode newData, String[] newVarConf, JsonNode jsonNode) throws Exception {
        if (newVarConf.length == 2) {
            ObjectNode objectNode = (ObjectNode)newData.get(newVarConf[0]);
            objectNode.set(newVarConf[1], jsonNode);
        } else if (newVarConf.length == 3) {
            ObjectNode objectNode = (ObjectNode)newData.get(newVarConf[0]);
            ArrayNode subs = (ArrayNode)objectNode.get("sub_" + newVarConf[1]);
            if (BeanUtils.isNotEmpty((Object)subs)) {
                for (JsonNode jsonNode1 : subs) {
                    ObjectNode subNode = (ObjectNode)jsonNode1;
                    if (!subNode.has(newVarConf[2]) || !StringUtil.isEmpty((String)JsonUtil.getString((JsonNode)subNode, (String)newVarConf[2]))) continue;
                    subNode.set(newVarConf[2], jsonNode);
                    return;
                }
            }
            subs = JsonUtil.createArrayNode();
            ObjectNode sub = (ObjectNode)objectNode.get("initData").get(newVarConf[1]);
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)sub));
            node.set(newVarConf[2], jsonNode);
            subs.add((JsonNode)node);
            objectNode.set("sub_" + newVarConf[1], (JsonNode)subs);
        } else if (newVarConf.length == 4) {
            ObjectNode objectNode = (ObjectNode)newData.get(newVarConf[0]);
            ArrayNode subs = (ArrayNode)objectNode.get("sub_" + newVarConf[1]);
            if (BeanUtils.isNotEmpty((Object)subs)) {
                ArrayNode sons = (ArrayNode)subs.get(0).get("sub_" + newVarConf[2]);
                if (BeanUtils.isEmpty((Object)sons)) {
                    sons = (ArrayNode)objectNode.get("initData").get(newVarConf[1]).get("sub_" + newVarConf[2]);
                }
                ObjectNode son = (ObjectNode)objectNode.get("initData").get(newVarConf[1]).get("initData").get(newVarConf[2]);
                ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)son));
                node.set(newVarConf[3], jsonNode);
                sons.add((JsonNode)node);
            } else {
                ArrayNode sons = JsonUtil.createArrayNode();
                if (objectNode.get("initData").get(newVarConf[1]).get("sub_" + newVarConf[2]) instanceof ArrayNode) {
                    sons = (ArrayNode)objectNode.get("initData").get(newVarConf[1]).get("sub_" + newVarConf[2]);
                }
                ObjectNode son = (ObjectNode)objectNode.get("initData").get(newVarConf[1]).get("initData").get(newVarConf[2]);
                ObjectNode sub = (ObjectNode)objectNode.get("initData").get(newVarConf[1]);
                ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)son));
                ObjectNode subNode = (ObjectNode)JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)sub));
                node.set(newVarConf[3], jsonNode);
                sons.add((JsonNode)node);
                subNode.set("sub_" + newVarConf[2], (JsonNode)sons);
                subs.add((JsonNode)subNode);
            }
        }
    }

    private ArrayNode getSubData(ObjectNode obData, List<String> path) {
        if (BeanUtils.isNotEmpty((Object)obData.get("subMap"))) {
            String[] subnames = path.get(1).split("sub_");
            return (ArrayNode)obData.get("subMap").get(subnames[1]);
        }
        if (obData.hasNonNull(path.get(0)) && obData.get(path.get(0)).hasNonNull("sub_" + path.get(1)) && obData.get(path.get(0)).get("sub_" + path.get(1)) instanceof ArrayNode) {
            return (ArrayNode)obData.get(path.get(0)).get("sub_" + path.get(1));
        }
        if (obData.hasNonNull("sub_" + path.get(1)) && obData.get("sub_" + path.get(1)) instanceof ArrayNode) {
            return (ArrayNode)obData.get("sub_" + path.get(1));
        }
        return null;
    }

    private void setField(JsonNode group, int oldLength, int newLength, List<String> oldVarConf, List<String> newVarConf, String toKey, Map<String, Map<String, String>> tableMapping) throws Exception {
        ArrayNode groupAry = (ArrayNode)group;
        ObjectNode groupObj = JsonUtil.createObjectNode();
        String fromSubTbName = oldLength > 2 ? oldVarConf.get(1) : "";
        String fromSunTbName = oldLength > 3 ? oldVarConf.get(2) : "";
        String toSubTbName = newLength > 2 ? newVarConf.get(1) : "";
        String toSunTbName = newLength > 3 ? newVarConf.get(2) : "";
        groupObj.put("fromTbName", oldVarConf.get(oldLength - 2));
        groupObj.put("fromMainTbName", oldVarConf.get(0));
        groupObj.put("fromSubTbName", fromSubTbName);
        groupObj.put("fromSunTbName", fromSubTbName);
        groupObj.put("fromColumn", oldVarConf.get(oldLength - 1));
        groupObj.put("toTbName", newVarConf.get(newLength - 2));
        groupObj.put("toMainTbName", newVarConf.get(0));
        groupObj.put("toSubTbName", toSubTbName);
        groupObj.put("toSunTbName", toSunTbName);
        groupObj.put("toColumn", newVarConf.get(newLength - 1));
        groupObj.put("toKey", toKey);
        groupObj.set("oldVarConf", (JsonNode)JsonUtil.listToArrayNode(oldVarConf));
        groupObj.set("newVarConf", (JsonNode)JsonUtil.listToArrayNode(newVarConf));
        groupObj.put("fromGroup", oldVarConf.get(0) + fromSubTbName + fromSunTbName);
        groupObj.put("toGroup", newVarConf.get(0) + toSubTbName + toSunTbName);
        groupAry.add((JsonNode)groupObj);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fromMainTbName", oldVarConf.get(0));
        map.put("fromSubTbName", fromSubTbName);
        map.put("fromSunTbName", fromSunTbName);
        tableMapping.put(oldVarConf.get(oldLength - 2) + newVarConf.get(newLength - 2), map);
    }
}

