/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.runtime.dao.BpmAutoStartConfDao;
import com.hotent.runtime.manager.BpmAutoStartConfManager;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.model.BpmAutoStartConf;
import com.hotent.runtime.params.StartFlowParamObject;
import com.hotent.runtime.params.StartResult;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="boAutoStartConfManager")
public class BpmAutoStartConfManagerImpl
extends BaseManagerImpl<BpmAutoStartConfDao, BpmAutoStartConf>
implements BpmAutoStartConfManager {
    @Resource
    BpmAutoStartConfDao boAutoStartConfDao;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IProcessManager iProcessService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BaseContext baseContext;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public BpmAutoStartConf getByDefKey(String defKey) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("def_key_", (Object)defKey, QueryOP.EQUAL);
        List queryNoPage = this.queryNoPage(queryFilter);
        if (BeanUtils.isNotEmpty((Object)queryNoPage)) {
            return (BpmAutoStartConf)((Object)queryNoPage.get(0));
        }
        return null;
    }

    @Override
    public ObjectNode defAutoStart() throws Exception {
        List all = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            all = super.getAll();
        }
        if (BeanUtils.isNotEmpty((Object)all)) {
            for (BpmAutoStartConf conf : all) {
                List bpmIdentities;
                List extractUser;
                String trigger = conf.getTrigger();
                String startUser = conf.getStartUser();
                if (StringUtil.isEmpty((String)startUser) || StringUtil.isEmpty((String)trigger) || !this.checkTrigger(trigger)) continue;
                this.baseContext.setTempTenantId(conf.getTenantId());
                List list = (List)JsonUtil.toBean((String)startUser, (TypeReference)new TypeReference<List<DefaultBpmIdentity>>(){});
                if (BeanUtils.isEmpty((Object)list) || BeanUtils.isEmpty((Object)(extractUser = this.bpmIdentityExtractService.extractUser(bpmIdentities = list.parallelStream().filter(predicate -> StringUtil.isNotEmpty((String)predicate.getId()) || StringUtil.isNotEmpty((String)predicate.getCode())).collect(Collectors.toList()))))) continue;
                List uniqueUser = extractUser.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IUser>(Comparator.comparing(IUser::getUserId))), ArrayList::new));
                DefaultBpmDefinition mainDef = this.bpmDefinitionManager.getMainByDefKey(conf.getDefKey(), false);
                List boDatas = this.boDataService.getDataByDefId(mainDef.getId());
                ObjectNode jsondata = BoDataUtil.hanlerData((String)mainDef.getId(), (List)boDatas, (boolean)true);
                HashSet<String> startedAccounts = new HashSet<String>();
                for (IUser iUser : uniqueUser) {
                    if (startedAccounts.contains(iUser.getAccount())) continue;
                    this.startByConf(iUser, conf, jsondata, mainDef);
                    startedAccounts.add(iUser.getAccount());
                }
                this.baseContext.clearTempTenantId();
            }
        }
        return (ObjectNode)JsonUtil.toJsonNode((Object)new CommonResult("\u6267\u884c\u6210\u529f"));
    }

    @Override
    public ObjectNode defAutoStartByTriggerName(String triggerName) throws Exception {
        List all = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"trigger_name_", (Object)triggerName);
            all = ((BpmAutoStartConfDao)this.baseMapper).selectList((Wrapper)wrapper);
        }
        if (BeanUtils.isNotEmpty((Object)all)) {
            for (BpmAutoStartConf conf : all) {
                List bpmIdentities;
                List extractUser;
                String trigger = conf.getTrigger();
                String startUser = conf.getStartUser();
                if (StringUtil.isEmpty((String)startUser)) continue;
                this.baseContext.setTempTenantId(conf.getTenantId());
                List list = (List)JsonUtil.toBean((String)startUser, (TypeReference)new TypeReference<List<DefaultBpmIdentity>>(){});
                if (BeanUtils.isEmpty((Object)list) || BeanUtils.isEmpty((Object)(extractUser = this.bpmIdentityExtractService.extractUser(bpmIdentities = list.parallelStream().filter(predicate -> StringUtil.isNotEmpty((String)predicate.getId()) || StringUtil.isNotEmpty((String)predicate.getCode())).collect(Collectors.toList()))))) continue;
                List uniqueUser = extractUser.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IUser>(Comparator.comparing(IUser::getUserId))), ArrayList::new));
                DefaultBpmDefinition mainDef = this.bpmDefinitionManager.getMainByDefKey(conf.getDefKey(), false);
                List boDatas = this.boDataService.getDataByDefId(mainDef.getId());
                ObjectNode jsondata = BoDataUtil.hanlerData((String)mainDef.getId(), (List)boDatas, (boolean)true);
                HashSet<String> startedAccounts = new HashSet<String>();
                for (IUser iUser : uniqueUser) {
                    if (startedAccounts.contains(iUser.getAccount())) continue;
                    this.startByConf(iUser, conf, jsondata, mainDef);
                    startedAccounts.add(iUser.getAccount());
                }
                this.baseContext.clearTempTenantId();
            }
        }
        return (ObjectNode)JsonUtil.toJsonNode((Object)new CommonResult("\u6267\u884c\u6210\u529f"));
    }

    @Override
    public BpmAutoStartConf getByDefId(String defId) {
        BpmDefinitionManager bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
        DefaultBpmDefinition defaultBpmDefinition = bpmDefinitionManager.getById(defId);
        if (BeanUtils.isEmpty((Object)defaultBpmDefinition)) {
            throw new RuntimeException(String.format("\u6839\u636e\u6240\u4f20\u6d41\u7a0b\u5b9a\u4e49ID:%s\u672a\u627e\u5230\u6d41\u5b9a\u4e49", defId));
        }
        BpmAutoStartConf byDefKey = this.getByDefKey(defaultBpmDefinition.getDefKey());
        if (BeanUtils.isEmpty((Object)((Object)byDefKey))) {
            byDefKey = new BpmAutoStartConf();
            byDefKey.setDefKey(defaultBpmDefinition.getDefKey());
        }
        return byDefKey;
    }

    private StartResult startByConf(IUser iUser, BpmAutoStartConf conf, ObjectNode jsondata, DefaultBpmDefinition mainDef) throws Exception {
        this.baseContext.setTempTenantId(conf.getTenantId());
        StartFlowParamObject sObject = new StartFlowParamObject();
        sObject.setAccount(iUser.getAccount());
        sObject.setDefId(mainDef.getDefId());
        sObject.setFlowKey(mainDef.getDefKey());
        sObject.setExpression("\u914d\u7f6e\u81ea\u52a8\u53d1\u8d77");
        String formData = conf.getFormData();
        if (StringUtil.isNotEmpty((String)formData)) {
            ObjectNode dataConf = (ObjectNode)JsonUtil.toJsonNode((String)formData);
            HashMap<String, String> varMap = new HashMap<String, String>();
            varMap.put("startUser", iUser.getUserId());
            varMap.put("flowKey_", mainDef.getDefKey());
            varMap.put("startorName", iUser.getFullname());
            Iterator iterator = jsondata.fields();
            while (iterator.hasNext()) {
                Map.Entry ent = (Map.Entry)iterator.next();
                String entKey = (String)ent.getKey();
                if (!(ent.getValue() instanceof ObjectNode)) continue;
                ObjectNode entity = (ObjectNode)ent.getValue();
                Iterator iterator2 = entity.fields();
                while (iterator2.hasNext()) {
                    Map.Entry filed = (Map.Entry)iterator2.next();
                    String filePath = entKey + "." + (String)filed.getKey();
                    if (!BeanUtils.isNotEmpty((Object)dataConf.get(filePath))) continue;
                    Object executeObject = this.groovyScriptEngine.executeObject(dataConf.get(filePath).asText(), varMap);
                    JsonUtil.putObjectToJson((ObjectNode)entity, (String)((String)filed.getKey()), (Object)executeObject);
                }
            }
        }
        String url = "/runtime/instance/v1/start";
        sObject.setData(Base64.getBase64((String)JsonUtil.toJson((Object)jsondata)));
        FluentUtil.postCurAppInterfaceWithHttp((String)url, (String)iUser.getAccount(), (Object)sObject);
        return null;
    }

    private boolean checkTrigger(String trigger) throws IOException {
        ObjectNode triggerObj = (ObjectNode)JsonUtil.toJsonNode((String)trigger);
        if (!triggerObj.hasNonNull("rdoTimeType")) {
            return false;
        }
        String triggerType = triggerObj.get("rdoTimeType").asText();
        String curDateStr = DateUtil.getCurrentTime((String)"HH:mm");
        String triggerDate = "";
        switch (triggerType) {
            case "1": {
                curDateStr = DateUtil.getCurrentTime((String)"yyyy-MM-dd HH:mm");
                triggerDate = JsonUtil.getString((JsonNode)triggerObj, (String)"sampleDate");
                if (StringUtil.isNotEmpty((String)triggerDate)) {
                    triggerDate = TimeUtil.getDateString((LocalDateTime)TimeUtil.convertString((String)triggerDate), (String)"yyyy-MM-dd HH:mm");
                }
                if (!curDateStr.equals(triggerDate)) break;
                return true;
            }
            case "2": {
                triggerDate = JsonUtil.getString((JsonNode)triggerObj, (String)"txtDay");
                if (!curDateStr.equals(triggerDate)) break;
                return true;
            }
            case "4": {
                triggerDate = JsonUtil.getString((JsonNode)triggerObj, (String)"txtWeek");
                String chkWeek = JsonUtil.getString((JsonNode)triggerObj, (String)"chkWeek");
                if (!curDateStr.equals(triggerDate) || chkWeek.indexOf(String.valueOf(LocalDateTime.now().getDayOfWeek().getValue())) <= -1) break;
                return true;
            }
            case "5": {
                triggerDate = triggerObj.get("txtMon").asText();
                String chkMons = JsonUtil.getString((JsonNode)triggerObj, (String)"chkMons");
                if (!curDateStr.equals(triggerDate) || chkMons.indexOf(String.valueOf(LocalDateTime.now().getDayOfMonth())) <= -1) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public String insertOrUpadae(BpmAutoStartConf boAutoStartConf) throws IOException {
        String msg = "\u6dfb\u52a0\u6d41\u7a0b\u81ea\u52a8\u53d1\u8d77\u914d\u7f6e\u8868\u6210\u529f";
        String triggerName = boAutoStartConf.getTriggerName();
        if (StringUtil.isEmpty((String)triggerName)) {
            triggerName = "startFlow" + UniqueIdUtil.getUId();
            boAutoStartConf.setTriggerName(triggerName);
        }
        if (StringUtil.isEmpty((String)boAutoStartConf.getId())) {
            this.save((Object)boAutoStartConf);
        } else {
            this.update((Model)boAutoStartConf);
            msg = "\u66f4\u65b0\u6d41\u7a0b\u81ea\u52a8\u53d1\u8d77\u914d\u7f6e\u8868\u6210\u529f";
        }
        ObjectNode node = JsonUtil.createObjectNode();
        String description = this.getDescription(boAutoStartConf.getTrigger());
        if (StringUtil.isNotEmpty((String)description)) {
            node.put("description", description);
            node.put("jobName", "\u6d41\u7a0b\u5b9a\u65f6\u542f\u52a8\u4efb\u52a1\u7c7b");
            node.put("triggerName", triggerName);
            this.portalFeignService.saveOrDeleteTrigger(node);
        }
        return msg;
    }

    private String getDescription(String trigger) throws IOException {
        ObjectNode res = JsonUtil.createObjectNode();
        JsonNode triggerNode = JsonUtil.toJsonNode((String)trigger);
        if (!triggerNode.hasNonNull("rdoTimeType")) {
            return "";
        }
        String type = triggerNode.get("rdoTimeType").asText();
        res.put("type", type);
        if ("1".equals(type)) {
            if (!triggerNode.hasNonNull("sampleDate")) {
                return "";
            }
            res.put("timeInterval", triggerNode.get("sampleDate").asText());
        } else if ("2".equals(type)) {
            if (!triggerNode.hasNonNull("txtDay")) {
                return "";
            }
            String[] txtDay = triggerNode.get("txtDay").asText().split(":");
            String cron = String.format("00 %s %s * * ?", txtDay[1], txtDay[0]);
            res.put("type", "6");
            res.put("timeInterval", cron);
        } else if ("4".equals(type)) {
            if (!triggerNode.hasNonNull("chkWeek") || !triggerNode.hasNonNull("txtWeek")) {
                return "";
            }
            String chkWeek = this.transCronWeek(triggerNode.get("chkWeek").asText());
            String timeInterval = chkWeek + "|" + triggerNode.get("txtWeek").asText() + ":00";
            res.put("timeInterval", timeInterval);
        } else if ("5".equals(type)) {
            if (!triggerNode.hasNonNull("chkMons") || !triggerNode.hasNonNull("txtMon")) {
                return "";
            }
            String timeInterval = triggerNode.get("chkMons").asText() + "|" + triggerNode.get("txtMon").asText() + ":00";
            res.put("timeInterval", timeInterval);
        } else {
            return "";
        }
        return res.toString();
    }

    private String transCronWeek(String cronStr) {
        String[] weeks = cronStr.split(",");
        HashSet<String> res = new HashSet<String>();
        String[] stringArray = weeks;
        int n = stringArray.length;
        block18: for (int i = 0; i < n; ++i) {
            String week;
            switch (week = stringArray[i]) {
                case "1": {
                    res.add("MON");
                    continue block18;
                }
                case "2": {
                    res.add("TUE");
                    continue block18;
                }
                case "3": {
                    res.add("WED");
                    continue block18;
                }
                case "4": {
                    res.add("THU");
                    continue block18;
                }
                case "5": {
                    res.add("FRI");
                    continue block18;
                }
                case "6": {
                    res.add("SAT");
                    continue block18;
                }
                case "7": {
                    res.add("SUN");
                    continue block18;
                }
            }
        }
        return StringUtils.join(res, (String)",");
    }
}

