/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.SQLUtil;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.runtime.dao.BpmFlowCollectDao;
import com.hotent.runtime.manager.BpmFlowCollectManager;
import com.hotent.runtime.model.BpmFlowCollect;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmFlowCollectManagerImpl
extends BaseManagerImpl<BpmFlowCollectDao, BpmFlowCollect>
implements BpmFlowCollectManager {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @Override
    public BpmFlowCollect getDetail(String id) {
        BpmFlowCollect bpmFlowCollect = (BpmFlowCollect)this.get((Serializable)((Object)id));
        return bpmFlowCollect;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdate(BpmFlowCollect bpmFlowCollect) {
        this.saveOrUpdate((Object)bpmFlowCollect);
    }

    @Override
    public void bookmark(String defKey) {
        BpmFlowCollect byDefKey = this.getByDefKey(defKey);
        if (BeanUtils.isNotEmpty((Object)((Object)byDefKey))) {
            throw new MessagePassingException("\u8be5\u6d41\u7a0b\u5df2\u5728\u6536\u85cf\u5939\u4e2d");
        }
        BpmFlowCollect bpmFlowCollect = new BpmFlowCollect();
        bpmFlowCollect.setCreator(ContextUtil.getCurrentUserId());
        bpmFlowCollect.setDefKey(defKey);
        bpmFlowCollect.setCreateTime(LocalDateTime.now());
        this.save((Object)bpmFlowCollect);
    }

    @Override
    public void cancel(String defKey) {
        BpmFlowCollect byDefKey = this.getByDefKey(defKey);
        if (BeanUtils.isEmpty((Object)((Object)byDefKey))) {
            return;
        }
        this.removeById((Serializable)((Object)byDefKey.getId()));
    }

    @Override
    public BpmFlowCollect getByDefKey(String defKey) {
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.eq((Object)"DEF_KEY_", (Object)defKey)).eq((Object)"CREATOR_", (Object)ContextUtil.getCurrentUserId());
        return (BpmFlowCollect)((Object)this.getOne((Wrapper)qw));
    }

    @Override
    public PageList<DefaultBpmDefinition> myCollectFlow(QueryFilter<DefaultBpmDefinition> queryFilter) {
        String userId = ContextUtil.getCurrentUserId();
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            SQLUtil.StringToTimestamp(queryFilter);
        }
        IPage<DefaultBpmDefinition> userCollect = ((BpmFlowCollectDao)this.baseMapper).getUserCollect((IPage<BpmFlowCollect>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BpmFlowCollect>)this.convert2Wrapper(queryFilter, this.currentModelClass()), userId);
        return new PageList(userCollect);
    }

    @Override
    public PageList<DefaultBpmDefinition> myCollectFlowByNoAuth(QueryFilter<DefaultBpmDefinition> queryFilter, String userId) {
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            SQLUtil.StringToTimestamp(queryFilter);
        }
        IPage<DefaultBpmDefinition> userCollect = ((BpmFlowCollectDao)this.baseMapper).getUserCollect((IPage<BpmFlowCollect>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BpmFlowCollect>)this.convert2Wrapper(queryFilter, this.currentModelClass()), userId);
        return new PageList(userCollect);
    }

    @Override
    public List<String> getMyCollectDefKeys() {
        return ((BpmFlowCollectDao)this.baseMapper).getUserCollectDefKeys(ContextUtil.getCurrentUserId());
    }

    @Override
    public List<Map<String, Object>> getCollectCountByUserId(QueryFilter queryFilter, String userId) {
        return ((BpmFlowCollectDao)this.baseMapper).getCollectCountByUserId(userId, this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }
}

