/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.JsonUtil;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.runtime.dao.BpmTransRecordDao;
import com.hotent.runtime.manager.BpmTransReceiverManager;
import com.hotent.runtime.manager.BpmTransRecordManager;
import com.hotent.runtime.model.BpmTransRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTransRecordManager")
public class BpmTransRecordManagerImpl
extends BaseManagerImpl<BpmTransRecordDao, BpmTransRecord>
implements BpmTransRecordManager {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTransReceiverManager bpmTransReceiverManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;

    private void toTransBpmTask(BpmTransRecord bpmTransRecord) throws IOException {
        ArrayNode insts = (ArrayNode)JsonUtil.toJsonNode((String)bpmTransRecord.getInsts());
        ArrayList<String> instLists = new ArrayList<String>();
        StringBuffer instIds = new StringBuffer();
        for (JsonNode node : insts) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((Object)node);
            instLists.add(obj.get("instId").asText());
            instIds.append(obj.get("instId").asText() + ",");
        }
        bpmTransRecord.setProcinstIds(instIds.toString());
        bpmTransRecord.setInstIds(instLists);
        HashMap<String, Object> canMap = new HashMap<String, Object>();
        canMap.put("userId", bpmTransRecord.getTransfer());
        canMap.put("executor", bpmTransRecord.getTransfered());
        canMap.put("instIds", bpmTransRecord.getInstIds());
        this.bpmTaskCandidateManager.updateExecutor(canMap);
        this.bpmCheckOpinionManager.updateQualfieds(bpmTransRecord.getInstIds(), bpmTransRecord.getTransfer(), bpmTransRecord.getTransfered(), bpmTransRecord.getTransferName(), bpmTransRecord.getTransferedName());
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ownerMap.put("userId", bpmTransRecord.getTransfer());
        ownerMap.put("ownerId", bpmTransRecord.getTransfered());
        ownerMap.put("ownerName", bpmTransRecord.getTransferedName());
        ownerMap.put("instIds", bpmTransRecord.getInstIds());
        this.bpmTaskManager.updateOwner(ownerMap);
        this.bpmTaskNoticeManager.updateOwner(ownerMap);
        HashMap<String, Object> assigneeMap = new HashMap<String, Object>();
        assigneeMap.put("userId", bpmTransRecord.getTransfer());
        assigneeMap.put("assigneeId", bpmTransRecord.getTransfered());
        assigneeMap.put("assigneeName", bpmTransRecord.getTransferedName());
        assigneeMap.put("instIds", bpmTransRecord.getInstIds());
        this.bpmTaskManager.updateAssignee(assigneeMap);
        this.bpmTaskNoticeManager.updateAssignee(assigneeMap);
        HashMap<String, Object> receiverMap = new HashMap<String, Object>();
        receiverMap.put("receiver", bpmTransRecord.getTransferedName());
        receiverMap.put("receiverId", bpmTransRecord.getTransfered());
        receiverMap.put("receiverIds", bpmTransRecord.getTransfer());
        receiverMap.put("instIds", bpmTransRecord.getInstIds());
        this.bpmTransReceiverManager.updateReceiver(receiverMap);
        super.create((Model)bpmTransRecord);
    }

    @Override
    @Transactional
    public CommonResult<String> turnOver(BpmTransRecord bpmTransRecord) {
        try {
            this.toTransBpmTask(bpmTransRecord);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u79fb\u4ea4\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u79fb\u4ea4\u6210\u529f\uff01");
    }
}

