/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.AsyncThreadClean;
import com.hotent.base.annotation.InterfaceEventPostAsync;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.RequiredException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.service.PropertyService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.string.StringValidator;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.cmd.ProcessInstCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.InterPoseType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeForm;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.BpmTaskOpinion;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.api.service.BpmIdentityService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmOpinionService;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.api.service.DiagramService;
import com.hotent.bpm.engine.def.impl.handler.PropertiesBpmDefXmlHandler;
import com.hotent.bpm.engine.form.BpmFormFactory;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.model.var.DefaultBpmVariableDef;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmCommuReceiverManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmExeStackRelationManager;
import com.hotent.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCommuManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.BpmTaskReminderManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.BpmIdentityResult;
import com.hotent.bpm.persistence.model.BpmInterposeRecored;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProStatus;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.bpm.persistence.util.ServiceUtil;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.BpmIdentityUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.params.BpmCheckOpinionVo;
import com.hotent.runtime.params.BpmImageParamObject;
import com.hotent.runtime.params.BpmNodeDefVo;
import com.hotent.runtime.params.BpmTaskResult;
import com.hotent.runtime.params.DefOtherParam;
import com.hotent.runtime.params.DoEndParamObject;
import com.hotent.runtime.params.DoNextParamObject;
import com.hotent.runtime.params.StartFlowParamObject;
import com.hotent.runtime.params.StartResult;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserGroupService;
import com.hotent.uc.api.service.IUserService;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.javassist.NotFoundException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="IProcessManager")
public class ProcessManagerImpl
implements IProcessManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    BpmInstService processInstanceService;
    @Resource
    BpmTaskService bpmTaskService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmExeStackRelationManager relationManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    PropertiesBpmDefXmlHandler propertiesBpmDefXmlHandler;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    NatTaskService natTaskService;
    @Resource(name="defaultBpmFormService")
    BpmFormService bpmFormService;
    @Resource
    BpmCommuReceiverManager bpmCommuReceiverManager;
    @Resource
    BpmTaskCommuManager bpmTaskCommuManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceMapper;
    @Resource
    IFlowManager flowManager;
    @Resource
    BaseContext baseContext;
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    BpmTaskReminderManager taskReminderManager;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmIdentityService bpmIdentityService;

    @Override
    @GlobalTransactional
    @Transactional
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    @InterfaceEventPostAsync
    public CompletableFuture<StartResult> start(StartFlowParamObject startFlowParamObject) throws Exception {
        boolean isAllowed;
        String defId = startFlowParamObject.getDefId();
        String flowKey = startFlowParamObject.getFlowKey();
        if (StringUtil.isEmpty((String)defId) && StringUtil.isEmpty((String)flowKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u6d41\u7a0b\u5b9a\u4e49ID\u548c\u6d41\u7a0bkey\u5fc5\u987b\u586b\u5199\u4e00\u4e2a!");
        }
        if (ContextUtil.getCurrentUser() != null && !ContextUtil.getCurrentUser().isAdmin() && !(isAllowed = StringUtil.isNotEmpty((String)startFlowParamObject.getDefId()) ? this.bpmDefAuthorizeManager.getStartRightByUserIdAndDefId(ContextUtil.getCurrentUser().getUserId(), defId, startFlowParamObject.getAgentLeaderId(), startFlowParamObject.getProInstId()).booleanValue() : this.bpmDefAuthorizeManager.getStartRightByUserIdAndFlowKey(ContextUtil.getCurrentUser().getUserId(), startFlowParamObject.getFlowKey(), startFlowParamObject.getVersion(), startFlowParamObject.getAgentLeaderId(), startFlowParamObject.getProInstId()).booleanValue())) {
            throw new BaseException("\u60a8\u6ca1\u6709\u542f\u52a8\u8be5\u6d41\u7a0b\u7684\u6743\u9650\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\uff01");
        }
        StartResult result = ((ProcessManagerImpl)AppUtil.getBean(this.getClass())).syncStart(startFlowParamObject);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public StartResult syncStart(StartFlowParamObject startFlowParamObject) throws Exception {
        ThreadMsgUtil.addMapMsg((String)"is_start_process", (String)"true");
        String current = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)current) && StringUtil.isEmpty((String)startFlowParamObject.getAccount())) {
            startFlowParamObject.setAccount(current);
        } else if (StringUtil.isNotEmpty((String)startFlowParamObject.getAccount()) && !startFlowParamObject.getAccount().equals(current)) {
            IUser userByAccount = this.userServiceImpl.getUserByAccount(startFlowParamObject.getAccount());
            SecurityContextHolder.getContext().setAuthentication(null);
            ContextUtil.setCurrentUser((IUser)userByAccount);
        }
        ContextUtil.clearAll();
        DefaultProcessInstCmd processCmd = this.getStartCmd(startFlowParamObject);
        BpmProcessInstance instance = this.processInstanceService.startProcessInst((ProcessInstCmd)processCmd);
        String instId = instance.getId();
        String curBoPkVal = "";
        String executorIsEmpty = "";
        String assignTaskId = "";
        HashMap<String, String> map = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"assign"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"assignTaskId"))) {
            assignTaskId = ThreadMsgUtil.getMapMsg((String)"assignTaskId");
            map.put("assignTaskId", ThreadMsgUtil.getMapMsg((String)"assignTaskId"));
        }
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"assign"))) {
            executorIsEmpty = "assign";
        }
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"curBoPkVal"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        StartResult result = this.getFlowparameter(instId, curBoPkVal, executorIsEmpty, assignTaskId);
        return result;
    }

    public CompletableFuture<StartResult> startSync(StartFlowParamObject startFlowParamObject) throws Exception {
        String current = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)current) && StringUtil.isEmpty((String)startFlowParamObject.getAccount())) {
            startFlowParamObject.setAccount(current);
        }
        ContextUtil.clearAll();
        DefaultProcessInstCmd processCmd = this.getStartCmd(startFlowParamObject);
        BpmProcessInstance instance = this.processInstanceService.startProcessInst((ProcessInstCmd)processCmd);
        String instId = instance.getId();
        String curBoPkVal = "";
        String executorIsEmpty = "";
        String assignTaskId = "";
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"curBoPkVal"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"assign"))) {
            executorIsEmpty = "assign";
        }
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"assignTaskId"))) {
            assignTaskId = ThreadMsgUtil.getMapMsg((String)"assignTaskId");
        }
        StartResult result = this.getFlowparameter(instId, curBoPkVal, executorIsEmpty, assignTaskId);
        return CompletableFuture.completedFuture(result);
    }

    private StartResult getFlowparameter(String instId, String curBoPkVal, String executorIsEmpty, String assignTaskId) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List groupsByUserIdOrAccount = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        List byBpmInstIdUserIdGroupList = this.bpmTaskManager.getByBpmInstIdUserIdGroupList(instId, userId, groupsByUserIdOrAccount);
        DefaultBpmProcessInstance instanceByInstId = this.getInstanceByInstId(instId);
        return new StartResult("\u6d41\u7a0b\u542f\u52a8\u6210\u529f", instId, curBoPkVal, executorIsEmpty, assignTaskId, byBpmInstIdUserIdGroupList, instanceByInstId);
    }

    @Override
    @Transactional
    public StartResult saveDraft(StartFlowParamObject startFlowParamObject) throws Exception {
        ContextUtil.clearAll();
        DefaultProcessInstCmd processCmd = this.getStartCmd(startFlowParamObject);
        processCmd.setApproval(startFlowParamObject.getApproval());
        Map map = this.processInstanceService.saveDraft((ProcessInstCmd)processCmd);
        BpmProcessInstance instance = (BpmProcessInstance)map.get("instance");
        String msg = (String)map.get("msg");
        String instId = instance.getId();
        if (BeanUtils.isEmpty((Object)instance.getSubject())) {
            throw new BaseException("\u6d41\u7a0b\u6807\u9898\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6807\u9898\u8bbe\u7f6e");
        }
        String curBoPkVal = "";
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"curBoPkVal"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        return new StartResult(msg, instId, curBoPkVal);
    }

    private DefaultProcessInstCmd getStartCmd(StartFlowParamObject startFlowParamObject) throws Exception {
        DefaultBpmTask task;
        String nodeUsers;
        DefaultBpmDefinition def;
        DefaultBpmProcessInstance processInstance;
        String defId = startFlowParamObject.getDefId();
        String flowKey = startFlowParamObject.getFlowKey();
        String sysCode = startFlowParamObject.getSysCode();
        String formType = startFlowParamObject.getFormType();
        String formKey = startFlowParamObject.getFormKey();
        String proInstId = startFlowParamObject.getProInstId();
        String busData = "";
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getData())) {
            busData = com.hotent.base.util.Base64.getFromBase64((String)startFlowParamObject.getData());
        }
        String businessKey = startFlowParamObject.getBusinessKey();
        if (StringUtil.isEmpty((String)defId) && StringUtil.isEmpty((String)flowKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u6d41\u7a0b\u5b9a\u4e49ID\u548c\u6d41\u7a0bkey\u5fc5\u987b\u586b\u5199\u4e00\u4e2a!");
        }
        if (StringUtil.isNotEmpty((String)proInstId) && BeanUtils.isNotEmpty((Object)(processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)proInstId)))) && !ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus())) {
            throw new BaseException("\u8be5\u5b9e\u4f8bid\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        DefaultProcessInstCmd processCmd = new DefaultProcessInstCmd();
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getAccount()) && !ContextUtil.getCurrentUser().getAccount().equals(startFlowParamObject.getAccount())) {
            IUser userByAccount = this.userServiceImpl.getUserByAccount(startFlowParamObject.getAccount());
            SecurityContextHolder.getContext().setAuthentication(null);
            ContextUtil.setCurrentUser((IUser)userByAccount);
            processCmd.addTransitVars("startUser", (Object)userByAccount);
            processCmd.addTransitVars("startUserAccount", (Object)userByAccount.getAccount());
            processCmd.addTransitVars("startorName", (Object)userByAccount.getFullname());
        }
        if (StringUtil.isNotEmpty((String)businessKey)) {
            processCmd.setBusinessKey(businessKey);
        }
        if (StringUtil.isNotEmpty((String)formKey)) {
            processCmd.setFormKey(formKey);
        }
        if (BeanUtils.isNotEmpty((Object)startFlowParamObject.getUrgentStateValue()) && startFlowParamObject.getUrgentStateValue().hasNonNull("new")) {
            processCmd.setUrgentState(startFlowParamObject.getUrgentStateValue().get("new").asText());
        }
        if (StringUtil.isNotEmpty((String)defId)) {
            processCmd.setProcDefId(defId);
        }
        if (StringUtil.isEmpty((String)defId) && StringUtil.isNotEmpty((String)flowKey)) {
            BpmDefinition bpmDefinition = null;
            if (BeanUtils.isEmpty((Object)startFlowParamObject.getVersion())) {
                bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefKey(flowKey, false);
                if (BeanUtils.isEmpty((Object)bpmDefinition)) {
                    throw new BaseException("flowKey\u4e3a" + flowKey + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728");
                }
            } else {
                List definitions = this.bpmDefinitionManager.queryByDefKey(flowKey);
                if (BeanUtils.isNotEmpty((Object)definitions)) {
                    for (DefaultBpmDefinition defaultBpmDefinition : definitions) {
                        if (!defaultBpmDefinition.getVersion().equals(startFlowParamObject.getVersion())) continue;
                        bpmDefinition = defaultBpmDefinition;
                        break;
                    }
                    if (BeanUtils.isEmpty((Object)bpmDefinition)) {
                        throw new BaseException(String.format("\u6839\u636eflowKey\u3010%s\u3011\u672a\u67e5\u627e\u5230\u7248\u672c\u4e3a\u3010%s\u3011\u7684\u6d41\u7a0b", flowKey, startFlowParamObject.getVersion()));
                    }
                } else {
                    throw new BaseException("flowKey\u4e3a" + flowKey + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728");
                }
            }
            defId = bpmDefinition.getDefId();
            processCmd.setFlowKey(flowKey);
        }
        if (BeanUtils.isEmpty((Object)(def = this.bpmDefinitionManager.getById(defId)))) {
            throw new BaseException("id\u4e3a" + defId + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        if ("forbidden".equals(def.getStatus()) || "forbidden_instance".equals(def.getStatus())) {
            throw new BaseException("\u6d41\u7a0b\u5b9a\u4e49\u5df2\u88ab\u7981\u6b62\u65e0\u6cd5\u53d1\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        processCmd.setSupportMobile(def.getSupportMobile());
        processCmd.setBusData(busData);
        processCmd.setAgentLeaderId(startFlowParamObject.getAgentLeaderId());
        if (StringUtil.isNotEmpty((String)sysCode)) {
            processCmd.setSysCode(sysCode);
        }
        if (StringUtil.isEmpty((String)formType)) {
            processCmd.setDataMode(this.getFormType(defId));
        } else {
            processCmd.setDataMode(FormCategory.FRAME.value().equals(formType) ? "pk" : "bo");
        }
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        node.put("defId", startFlowParamObject.getDefId());
        node.put("flowKey", startFlowParamObject.getFlowKey());
        List<BpmVariableDef> list = this.flowManager.getWorkflowVar(node.toString());
        if (list != null && list.size() > 0) {
            Map<String, String> existVars = startFlowParamObject.getVars();
            if (BeanUtils.isEmpty(existVars)) {
                existVars = new HashMap<String, String>();
                startFlowParamObject.setVars(existVars);
            }
            for (int i = 0; i < list.size(); ++i) {
                String key = list.get(i).getVarKey();
                if (existVars.containsKey(key)) continue;
                existVars.put(key, list.get(i).getDefaultVal() + "");
            }
            this.setValriablesToCmd(defId, "", existVars, (BaseActionCmd)processCmd);
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getDestination())) {
            processCmd.setDestination(startFlowParamObject.getDestination());
        }
        if (StringUtil.isNotEmpty((String)(nodeUsers = startFlowParamObject.getNodeUsers()))) {
            int isSendNodeUsers = startFlowParamObject.getIsSendNodeUsers();
            Map specUserMap = BpmIdentityUtil.getBpmIdentity((String)nodeUsers);
            if (BeanUtils.isNotEmpty((Object)specUserMap)) {
                processCmd.addVariable("bpm_node_users_", JsonUtil.toJson((Object)specUserMap));
                if (isSendNodeUsers == 1) {
                    processCmd.setBpmIdentities(specUserMap);
                }
            }
        }
        if (StringUtil.isNotEmpty((String)proInstId)) {
            processCmd.setInstId(proInstId);
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getStartOrgId())) {
            processCmd.addTransitVars("start_org_id", (Object)startFlowParamObject.getStartOrgId());
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getTaskId()) && BeanUtils.isNotEmpty((Object)(task = this.bpmTaskManager.getByTaskId(startFlowParamObject.getTaskId())))) {
            processCmd.addTransitVars("bpmTask_", (Object)task);
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getFormKey())) {
            processCmd.setFormKey(startFlowParamObject.getFormKey());
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getUpdateSubTableJson())) {
            ThreadMsgUtil.addMapMsg((String)"updateSubTableJson", (String)startFlowParamObject.getUpdateSubTableJson());
        }
        return processCmd;
    }

    private String getFormType(String defId) {
        String formType = "bo";
        try {
            FormCategory type;
            Form form;
            BpmNodeForm nodeForm = this.bpmFormService.getByDefId(defId);
            if (BeanUtils.isNotEmpty((Object)nodeForm) && BeanUtils.isNotEmpty((Object)(form = nodeForm.getForm())) && FormCategory.FRAME.equals((Object)(type = form.getType()))) {
                formType = "pk";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formType;
    }

    private Map<String, Object> getActVars(String defId, String nodeId, Map<String, String> varMap) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ArrayList bpmVariableList = defExt.getVariableList();
        if (bpmVariableList == null) {
            bpmVariableList = new ArrayList();
        }
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)nodeId)) {
            bpmVariableList.addAll(defExt.getVariableList(nodeId));
        }
        for (BpmVariableDef var : bpmVariableList) {
            String varkey = var.getVarKey();
            String val = varMap.get(varkey);
            if (val == null) continue;
            Object rtnVal = DefaultBpmVariableDef.getValue((String)var.getDataType(), (String)val);
            rtnMap.put(varkey, rtnVal);
        }
        return rtnMap;
    }

    @Override
    @Transactional
    public CommonResult<String> doNext(DoNextParamObject doNextParamObject) throws Exception {
        String destination;
        ContextUtil.clearAll();
        String account = doNextParamObject.getAccount();
        ServiceUtil.setCurrentUser((String)account);
        String taskId = doNextParamObject.getTaskId();
        String actionName = doNextParamObject.getActionName();
        String opinion = doNextParamObject.getOpinion();
        String data = "";
        String base64data = doNextParamObject.getData();
        if (StringUtil.isNotEmpty((String)base64data)) {
            data = com.hotent.base.util.Base64.getFromBase64((String)base64data);
        }
        Boolean directHandlerSign = doNextParamObject.getDirectHandlerSign();
        String backHandMode = doNextParamObject.getBackHandMode();
        String jumpType = doNextParamObject.getJumpType();
        if (this.bpmTaskService.getByTaskId(taskId) == null) {
            throw new RuntimeException("\u6b64\u4efb\u52a1\u5df2\u88ab\u5904\u7406\u6216\u4e0d\u5b58\u5728");
        }
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        if (("free".equals(jumpType) || "select".equals(jumpType) || "reject".equals(actionName)) && StringUtil.isNotEmpty((String)(destination = doNextParamObject.getDestination()))) {
            cmd.setDestination(destination);
        }
        if (directHandlerSign.booleanValue()) {
            cmd.addTransitVars("signDirect", (Object)"1");
        }
        cmd.setTaskId(taskId);
        cmd.setActionName(actionName);
        cmd.setApprovalOpinion(opinion);
        if (StringUtil.isNotEmpty((String)data)) {
            BpmUtil.handOpinion((String)data, (DefaultTaskFinishCmd)cmd);
            cmd.setBusData(data);
            cmd.setDataMode("bo");
        }
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        Map<String, String> vars = doNextParamObject.getVars();
        this.setValriablesToCmd(bpmTask.getProcDefId(), bpmTask.getNodeId(), vars, (BaseActionCmd)cmd);
        cmd.addTransitVars("backHandMode", (Object)backHandMode);
        String nodeUsers = "";
        if (StringUtil.isNotEmpty((String)doNextParamObject.getNodeUsers())) {
            nodeUsers = com.hotent.base.util.Base64.getFromBase64((String)doNextParamObject.getNodeUsers());
        }
        if (StringUtil.isNotEmpty((String)nodeUsers)) {
            Map specUserMap = BpmIdentityUtil.getBpmIdentity((String)nodeUsers);
            cmd.addTransitVars("bpm_node_users_", (Object)specUserMap);
            cmd.setBpmIdentities(specUserMap);
        }
        if (StringUtil.isNotEmpty((String)doNextParamObject.getNotifyType())) {
            cmd.setNotifyType(doNextParamObject.getNotifyType());
        }
        ContextUtil.setCurrentUserByAccount((String)account);
        this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
        return new CommonResult(true, "\u4efb\u52a1\u5904\u7406\u6210\u529f");
    }

    private void setVariables(String defId, String nodeId, String vars, BaseActionCmd cmd) throws Exception {
        Map<String, String> variables = this.convertVars(vars);
        Map<String, Object> varMap = this.getActVars(defId, nodeId, variables);
        if (BeanUtils.isNotEmpty(varMap)) {
            cmd.setVariables(varMap);
        }
    }

    private void setValriablesToCmd(String defId, String nodeId, Map<String, String> variables, BaseActionCmd cmd) throws Exception {
        if (BeanUtils.isEmpty(variables)) {
            return;
        }
        Map<String, Object> varMap = this.getActVars(defId, nodeId, variables);
        if (BeanUtils.isNotEmpty(varMap)) {
            cmd.setVariables(varMap);
        }
    }

    @Override
    public List<BpmNodeDefVo> getEnableRejectNode(String taskId, String rejectType) throws Exception {
        String nodeId;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        String defId = task.getProcDefId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId = task.getNodeId());
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        String backMode = nodeProperties.getBackMode();
        if (StringUtil.isEmpty((String)backMode)) {
            backMode = "normal";
        }
        String procInstId = task.getProcInstId();
        List listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef((String)procInstId, (String)task.getNodeId(), (String)"pre");
        ArrayList<BpmNodeDefVo> bpmExeStacksUserNode = new ArrayList<BpmNodeDefVo>();
        ArrayList<BpmNodeDefVo> bpmExeStacksGoMapUserNode = new ArrayList<BpmNodeDefVo>();
        List relationList = this.relationManager.getListByProcInstId(procInstId);
        for (BpmNodeDef node : listBpmNodeDef) {
            if (!node.getType().equals((Object)NodeType.USERTASK) && !node.getType().equals((Object)NodeType.SIGNTASK) || node.getNodeId().equals(nodeId)) continue;
            BpmNodeDefVo vo = BpmNodeDefVo.parseVo(node);
            bpmExeStacksUserNode.add(vo);
            boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway((String)procInstId, (String)node.getNodeId(), (String)"pre", (List)relationList);
            boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway((String)procInstId, (String)node.getNodeId(), (String)"after", (List)relationList);
            if (!isHavePre || !isHaveAfter) {
                bpmExeStacksGoMapUserNode.add(vo);
                continue;
            }
            List incomeNodes = node.getIncomeNodes();
            if (!BeanUtils.isNotEmpty((Object)incomeNodes)) continue;
            BpmNodeDef nodeDef = (BpmNodeDef)incomeNodes.get(0);
            if (!node.getType().equals((Object)NodeType.USERTASK) || !nodeDef.getType().equals((Object)NodeType.START) && !nodeDef.getType().equals((Object)NodeType.USERTASK)) continue;
            bpmExeStacksGoMapUserNode.add(vo);
        }
        return "direct".equals(rejectType) ? bpmExeStacksUserNode : bpmExeStacksGoMapUserNode;
    }

    private Map<String, String> convertVars(String varsJson) throws Exception {
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)varsJson)) {
            return varMap;
        }
        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)varsJson);
        for (int i = 0; i < array.size(); ++i) {
            String varStr = array.get(i).toString();
            ObjectNode var = (ObjectNode)JsonUtil.toJsonNode((String)varStr);
            String name = var.get("name").asText();
            String value = var.get("val").asText();
            if (!StringUtil.isEmpty((String)name)) continue;
            throw new Exception("\u6d41\u7a0b\u53d8\u91cf\u7684\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return varMap;
    }

    @Override
    public List<BpmTaskOpinion> getHistoryOpinion(String procInstId, String taskId) throws Exception {
        if (StringUtil.isEmpty((String)procInstId) && StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":procInstId\u548ctaskId\u5fc5\u987b\u586b\u5199\u4e00\u4e2a!");
        }
        if ((procInstId == null || procInstId.isEmpty()) && taskId != null) {
            BpmTask bpmTask = this.bpmTaskService.getByTaskId(taskId);
            if (BeanUtils.isEmpty((Object)bpmTask)) {
                throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
            }
            procInstId = this.bpmTaskService.getByTaskId(taskId).getProcInstId();
        }
        List list = this.bpmOpinionService.getTaskOpinions(procInstId);
        return list;
    }

    @Override
    public CommonResult<String> getBusinessKey(String procInstanceId, String taskId) throws NullPointerException {
        DefaultBpmProcessInstance instance;
        if (StringUtil.isEmpty((String)procInstanceId) && StringUtil.isNotEmpty((String)taskId)) {
            procInstanceId = this.bpmTaskService.getByTaskId(taskId).getProcInstId();
        }
        if (BeanUtils.isEmpty((Object)(instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstanceId))))) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u4fe1\u606f\u6ca1\u6709\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\uff01");
        }
        return new CommonResult(true, "\u4e1a\u52a1\u4e3b\u952e--" + instance.getBizKey(), (Object)instance.getBizKey());
    }

    @Override
    public CommonResult<String> getProcInstId(String businessKey) throws NullPointerException {
        DefaultBpmProcessInstance instance = this.bpmProcessInstanceManager.getByBusinessKey(businessKey);
        if (BeanUtils.isEmpty((Object)instance)) {
            throw new NullPointerException("\u6839\u636e\u8f93\u5165\u7684businessKey\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b\u6570\u636e\uff01");
        }
        return new CommonResult(true, "\u6d41\u7a0b\u5b9e\u4f8bid--" + instance.getId(), (Object)instance.getId());
    }

    @Override
    @Transactional
    @InterfaceEventPostAsync
    public CommonResult<String> doEndProcess(DoEndParamObject doEndParamObject) throws Exception {
        String taskId = doEndParamObject.getTaskId();
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        String endReason = doEndParamObject.getEndReason();
        if (StringUtil.isEmpty((String)endReason)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u7ec8\u6b62\u7406\u7531\u5fc5\u586b");
        }
        String files = doEndParamObject.getFiles();
        if (BeanUtils.isEmpty((Object)this.bpmTaskManager.get((Serializable)((Object)taskId)))) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.getById((Serializable)((Object)taskId));
        ArrayList<BpmTask> tasks = new ArrayList<BpmTask>();
        tasks.add((BpmTask)task);
        this.bpmTaskManager.endProcessByTaskId(taskId, "", endReason, files, doEndParamObject.getBusDataObjectNode());
        this.flowManager.doPostAsync(task.getProcInstId(), tasks, EventType.END_PROCESS);
        return new CommonResult(true, "\u5df2\u7ec8\u6b62\u6d41\u7a0b", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> renewProcess(String instId, String reason) throws Exception {
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u5b9e\u4f8bid\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)reason)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u7ec8\u6b62\u7406\u7531\u5fc5\u586b");
        }
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        instance.setStatus(ProcessInstanceStatus.STATUS_RUNNING.getKey());
        instance.setEndTime(LocalDateTime.now());
        instance.setDuration(Long.valueOf(TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)instance.getCreateTime())));
        this.bpmProcessInstanceManager.update((Model)instance);
        List litCheckOpinions = this.bpmCheckOpinionManager.getByInstId(instId);
        if (litCheckOpinions != null) {
            for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : litCheckOpinions) {
                if (!defaultBpmCheckOpinion.getStatus().equals(OpinionStatus.MANUAL_END.getKey())) continue;
                defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setCompleteTime(null);
                defaultBpmCheckOpinion.setAuditor(null);
                defaultBpmCheckOpinion.setAuditorName(null);
                defaultBpmCheckOpinion.setOrgId(null);
                defaultBpmCheckOpinion.setOrgPath(null);
                defaultBpmCheckOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
                defaultBpmCheckOpinion.setDurMs(null);
                defaultBpmCheckOpinion.setOpinion(null);
                this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
                NodeStatus nanualEndStatus = NodeStatus.PENDING;
                this.bpmProStatusManager.createOrUpd(instance.getId(), instance.getBpmnDefId(), defaultBpmCheckOpinion.getTaskKey(), defaultBpmCheckOpinion.getTaskName(), nanualEndStatus);
            }
        }
        BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(instId, reason, InterPoseType.RENEW_END, reason);
        BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
        manager.create((Model)bpmInterposeRecored);
        this.sendMsg(instance, instId, reason);
        return new CommonResult(true, "\u5df2\u6062\u590d\u7ec8\u6b62\u6d41\u7a0b", (Object)"");
    }

    private void sendMsg(DefaultBpmProcessInstance instance, String instId, String reason) throws Exception {
        String topInstId = this.bpmCheckOpinionManager.getTopInstId(instId);
        DefaultBpmProcessInstance processInstance = instId.equals(topInstId) ? instance : (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)topInstId));
        List bpmTaskList = this.bpmTaskService.getTasksInstId(processInstance.getId());
        if (!CollectionUtils.isEmpty((Collection)bpmTaskList)) {
            Optional<BpmTask> optional = bpmTaskList.stream().max(Comparator.comparing(BpmTask::getCreateTime));
            if (topInstId != null && optional.isPresent()) {
                IUser userTask;
                BpmTask bpmTaskLast = optional.get();
                ArrayList<IUser> userList = new ArrayList<IUser>();
                IUser user = BpmUtil.getUser((String)processInstance.getCreateBy());
                if (user != null) {
                    userList.add(user);
                }
                if ((userTask = BpmUtil.getUser((String)bpmTaskLast.getOwnerId())) != null) {
                    userList.add(userTask);
                }
                if (!CollectionUtils.isEmpty(userList)) {
                    String messageType = BpmUtil.getNotifyType((BpmProcessInstance)processInstance, (String)bpmTaskLast.getNodeId());
                    MessageUtil.sendMsg((String)"bpmRenewProcess", (String)messageType, userList, (DefaultBpmProcessInstance)instance, (String)reason);
                }
            }
        }
    }

    @Override
    public List<String> getApprovalItems(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String defKey = bpmProcessInstance.getProcDefKey();
        String typeId = task.getTypeId();
        ArrayList<String> approvalItem = new ArrayList<String>();
        return approvalItem;
    }

    @Override
    public List<BpmIdentityResult> getNodeUsers(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String instanceId = bpmProcessInstance.getId();
        String nodeId = task.getNodeId();
        List opinionList = this.bpmOpinionService.getByInstNodeId(instanceId, nodeId);
        ArrayList<BpmIdentityResult> result = new ArrayList<BpmIdentityResult>();
        for (BpmTaskOpinion b : opinionList) {
            String qualfieds = b.getQualfieds();
            if (b.getCompleteTime() != null) continue;
            result.addAll(this.qualfields2BpmIdentityResult(qualfieds));
        }
        BeanUtils.removeDuplicate(result);
        return result;
    }

    private List<BpmIdentityResult> qualfields2BpmIdentityResult(String qualfieds) throws Exception {
        ArrayList<BpmIdentityResult> result = new ArrayList<BpmIdentityResult>();
        if (StringUtil.isEmpty((String)qualfieds)) {
            return result;
        }
        JsonNode parse = JsonUtil.toJsonNode((String)qualfieds);
        if (BeanUtils.isNotEmpty((Object)parse) && parse.isArray()) {
            ArrayNode ArrayNode2 = (ArrayNode)parse;
            for (JsonNode jsonNode : ArrayNode2) {
                String id;
                if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject()) continue;
                ObjectNode jobject = (ObjectNode)jsonNode;
                JsonNode typeObj = jobject.get("type");
                if (!BeanUtils.isNotEmpty((Object)jobject.get("type")) || !jobject.get("type").isTextual() || !"user".equals(jobject.get("type").asText()) || !BeanUtils.isNotEmpty((Object)(id = jobject.get("id").asText()))) continue;
                IUser user = ServiceUtil.getUserById((String)id);
                result.add(new BpmIdentityResult(user));
            }
        }
        return result;
    }

    @Override
    public List<BpmCheckOpinionVo> getProcessOpinionByActInstId(String actTaskId) throws Exception {
        if (StringUtil.isEmpty((String)actTaskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":actTaskId\u5fc5\u586b\uff01");
        }
        DefaultBpmProcessInstance process = this.bpmProcessInstanceManager.getByBpmnInstId(actTaskId);
        if (BeanUtils.isEmpty((Object)process)) {
            throw new RuntimeException("\u6839\u636esctTaskId\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        }
        List bpmCheckOpinionList = this.bpmCheckOpinionManager.getByInstId(process.getId());
        ArrayList<BpmCheckOpinionVo> checkOpinionVoList = new ArrayList<BpmCheckOpinionVo>();
        for (DefaultBpmCheckOpinion o : bpmCheckOpinionList) {
            o.setQualfieds("");
            JsonNode object = JsonUtil.toJsonNode((Object)o);
            BpmCheckOpinionVo b = (BpmCheckOpinionVo)JsonUtil.toBean((JsonNode)object, BpmCheckOpinionVo.class);
            checkOpinionVoList.add(b);
        }
        return checkOpinionVoList;
    }

    @Override
    public BpmProcessInstance getProcessRunByTaskId(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        return bpmProcessInstance;
    }

    @Override
    public String getStatusByRunidNodeId(String instId, String nodeId) throws Exception {
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1ainstId\u6d41\u7a0b\u5b9e\u4f8bid\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)nodeId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1anodeId\u5bf9\u5e94\u8282\u70b9id\u5fc5\u586b\uff01");
        }
        DefaultBpmProStatus proStatus = this.bpmProStatusManager.getByInstNodeId(instId, nodeId);
        if (BeanUtils.isEmpty((Object)proStatus)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u8be5\u5b9e\u4f8b\u8be5\u8282\u70b9\u7684\u72b6\u6001\uff01");
        }
        String status = "";
        if (NodeStatus.SUBMIT.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SUBMIT.getValue();
        }
        if (NodeStatus.RE_SUBMIT.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.RE_SUBMIT.getValue();
        }
        if (NodeStatus.AGREE.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.AGREE.getValue();
        }
        if (NodeStatus.PENDING.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.PENDING.getValue();
        }
        if (NodeStatus.OPPOSE.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.OPPOSE.getValue();
        }
        if (NodeStatus.BACK.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.BACK.getValue();
        }
        if (NodeStatus.BACK_TO_START.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.BACK_TO_START.getValue();
        }
        if (NodeStatus.COMPLETE.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.COMPLETE.getValue();
        }
        if (NodeStatus.RECOVER.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.RECOVER.getValue();
        }
        if (NodeStatus.RECOVER_TO_START.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.RECOVER_TO_START.getValue();
        }
        if (NodeStatus.SIGN_PASS.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SIGN_PASS.getValue();
        }
        if (NodeStatus.SIGN_NO_PASS.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SIGN_NO_PASS.getValue();
        }
        if (NodeStatus.MANUAL_END.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.MANUAL_END.getValue();
        }
        if (NodeStatus.ABANDON.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.ABANDON.getValue();
        }
        if (NodeStatus.SUSPEND.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SUSPEND.getValue();
        }
        return status;
    }

    @Override
    public BpmTaskResult getTaskByTaskId(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        return new BpmTaskResult(task);
    }

    @Override
    public String getTaskNameByTaskId(String taskId) throws Exception {
        BpmTaskResult taskByTaskId = this.getTaskByTaskId(taskId);
        return taskByTaskId.getTaskName();
    }

    @Override
    public DefaultBpmProcessInstance getInstancetByBusinessKey(String businessKey) throws Exception {
        if (StringUtil.isEmpty((String)businessKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1abusinessKey\u5fc5\u586b");
        }
        DefaultBpmProcessInstance instance = this.bpmProcessInstanceManager.getByBusinessKey(businessKey);
        if (BeanUtils.isEmpty((Object)instance) && BeanUtils.isEmpty((Object)(instance = this.getInstanceFromBusLink(businessKey, null)))) {
            throw new RuntimeException("\u6839\u636e\u3010" + businessKey + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        }
        return instance;
    }

    @Override
    public DefaultBpmProcessInstance getInstancetByBizKeySysCode(String businessKey, String sysCode) throws Exception {
        if (StringUtil.isEmpty((String)businessKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1abusinessKey\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)sysCode)) {
            return this.getInstancetByBusinessKey(businessKey);
        }
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.withParam("biz_key_", (Object)businessKey);
        queryFilter.withParam("sys_code_", (Object)sysCode);
        PageList pageList = this.bpmProcessInstanceManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)pageList) || pageList.getRows().size() == 0) {
            DefaultBpmProcessInstance processInstance = this.getInstanceFromBusLink(businessKey, sysCode);
            if (BeanUtils.isEmpty((Object)processInstance)) {
                throw new RuntimeException("\u6839\u636ebusinessKey\u3010" + businessKey + "\u3011\u3001sysCode\u3010" + sysCode + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e");
            }
            return processInstance;
        }
        if (pageList.getRows().size() > 1) {
            throw new RuntimeException("\u6839\u636ebusinessKey\u3010" + businessKey + "\u3011\u3001sysCode\u3010" + sysCode + "\u3011\u627e\u5230\u4e86\u591a\uff08" + pageList.getTotal() + "\uff09\u6761\u5bf9\u5e94\u7684\u6570\u636e");
        }
        return (DefaultBpmProcessInstance)pageList.getRows().get(0);
    }

    private DefaultBpmProcessInstance getInstanceFromBusLink(String businessKey, String sysCode) {
        DefaultBpmProcessInstance processInstance = null;
        if (StringUtil.isNotEmpty((String)businessKey)) {
            PageList pageList;
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            queryFilter.withParam("businesskey_str_", (Object)businessKey);
            if (StringUtil.isNotEmpty((String)sysCode)) {
                queryFilter.withParam("sys_code_", (Object)sysCode);
            }
            if (BeanUtils.isEmpty((Object)(pageList = this.bpmBusLinkManager.query(queryFilter)).getRows()) && StringValidator.isNumberic((String)businessKey)) {
                QueryFilter queryFilter2 = QueryFilter.build().withDefaultPage();
                queryFilter2.withParam("businesskey_", (Object)businessKey);
                if (StringUtil.isNotEmpty((String)sysCode)) {
                    queryFilter2.withParam("sys_code_", (Object)sysCode);
                }
                pageList = this.bpmBusLinkManager.query(queryFilter2);
            }
            if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
                ArrayList<Object> proInsts = new ArrayList<Object>();
                for (BpmBusLink bpmBusLink : pageList.getRows()) {
                    DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)bpmBusLink.getProcInstId()));
                    if (!BeanUtils.isNotEmpty((Object)instance)) continue;
                    proInsts.add(instance);
                }
                HashSet h = new HashSet(proInsts);
                proInsts.clear();
                proInsts.addAll(h);
                if (proInsts.size() > 1) {
                    throw new RuntimeException("\u6839\u636ebusinessKey\u3010" + businessKey + "\u3011\u3001sysCode\u3010" + sysCode + "\u3011\u627e\u5230\u4e86\u591a\uff08" + proInsts.size() + "\uff09\u6761\u5bf9\u5e94\u7684\u6570\u636e");
                }
                if (BeanUtils.isNotEmpty(proInsts)) {
                    processInstance = (DefaultBpmProcessInstance)proInsts.get(0);
                }
            }
        }
        return processInstance;
    }

    public DefaultBpmProcessInstance getInstanceByInstId(String instId) throws Exception {
        BpmFormService bpmFormService;
        FormModel formModel;
        int showModifyRecord;
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1ainstId\u6d41\u7a0b\u5b9e\u4f8bid\u5fc5\u586b");
        }
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        if (BeanUtils.isEmpty((Object)instance)) {
            throw new RuntimeException("\u6839\u636e\u3010" + instId + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        }
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(instance.getProcDefId());
        if (BeanUtils.isNotEmpty((Object)bpmDefinition) && (showModifyRecord = bpmDefinition.getShowModifyRecord()) == 1) {
            instance.setShowModifyRecord(true);
        }
        if (BeanUtils.isNotEmpty((Object)(formModel = (bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC)).getByDefId(instance.getProcDefId(), "", (BpmProcessInstance)instance, true)))) {
            instance.setBpmFormKey(formModel.getFormKey());
        }
        return instance;
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getInstanceListByXml(String xml) throws Exception {
        IUser user;
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String account = root.attributeValue("account");
        String subject = root.attributeValue("subject");
        String status = root.attributeValue("status");
        String pageSize = root.attributeValue("pageSize");
        String currentPage = root.attributeValue("currentPage");
        if (StringUtil.isNotEmpty((String)account) && BeanUtils.isEmpty((Object)(user = ServiceUtil.getUserByAccount((String)account)))) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        ContextUtil.setCurrentUserByAccount((String)account);
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        PageBean page = new PageBean(Integer.valueOf(1), Integer.valueOf(20));
        if (StringUtil.isNotEmpty((String)pageSize)) {
            page.setPageSize(Integer.valueOf(pageSize).intValue());
        }
        if (StringUtil.isNotEmpty((String)currentPage)) {
            page.setPage(new Integer(currentPage).intValue());
        }
        queryFilter.setPageBean(page);
        if (StringUtil.isNotEmpty((String)status)) {
            queryFilter.withQuery(new QueryField("status_", (Object)status));
        }
        if (StringUtil.isNotEmpty((String)subject)) {
            queryFilter.withQuery(new QueryField("subject_", (Object)subject, QueryOP.LIKE));
        }
        PageList list = (PageList)this.bpmProcessInstanceManager.queryList(queryFilter);
        return list;
    }

    @Override
    public PageList<DefaultBpmTask> getTasksByInstId(String instId) throws Exception {
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1ainstId\u5b9e\u4f8bid\u5fc5\u586b\uff01");
        }
        PageList taskList = new PageList();
        taskList.setRows(this.bpmTaskManager.getByInstId(instId));
        return taskList;
    }

    @Override
    public List<BpmNodeDefVo> getTaskOutNodes(String taskId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String defId = bpmProcessInstance.getProcDefId();
        String nodeId = task.getNodeId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List nodes = taskNodeDef.getOutcomeNodes();
        List<BpmNodeDef> nextNodes = this.handlerSelectOutcomeNodes(nodes);
        ArrayList<BpmNodeDefVo> array = new ArrayList<BpmNodeDefVo>();
        for (BpmNodeDef n : nextNodes) {
            BpmNodeDefVo nodeDefVo = BpmNodeDefVo.parseVo(n);
            array.add(nodeDefVo);
        }
        return array;
    }

    private List<BpmNodeDef> handlerSelectOutcomeNodes(List<BpmNodeDef> outcomeNodes) {
        BpmNodeDef bpmNodeDef;
        NodeType nodeType;
        int size = outcomeNodes.size();
        List<Object> returnList = new ArrayList<BpmNodeDef>();
        if (size == 1 && (NodeType.EXCLUSIVEGATEWAY.equals((Object)(nodeType = (bpmNodeDef = outcomeNodes.get(0)).getType())) || NodeType.INCLUSIVEGATEWAY.equals((Object)nodeType) || NodeType.PARALLELGATEWAY.equals((Object)nodeType))) {
            returnList = bpmNodeDef.getOutcomeNodes();
        }
        if (BeanUtils.isEmpty(returnList)) {
            return outcomeNodes;
        }
        return returnList;
    }

    @Override
    public String getDetailUrl(String taskId) throws Exception {
        ApplicationContext applicationContext = AppUtil.getApplicaitonContext();
        String applicationName = applicationContext.getApplicationName();
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        if (!"bo".equals(bpmProcessInstance.getDataMode())) {
            throw new RuntimeException("\u8be5\u4efb\u52a1\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u5728\u7ebf\u8868\u5355\uff01");
        }
        String url = applicationName + "/flow/instance/instanceFlowForm?id=" + bpmProcessInstance.getId();
        return url;
    }

    @Override
    @Transactional
    public CommonResult<String> setTaskVar(String taskId, Map<String, Object> variables) throws Exception {
        this.natTaskService.setVariables(taskId, variables);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setTaskVarLocal(String taskId, Map<String, Object> variables) throws Exception {
        this.natTaskService.setVariablesLocal(taskId, variables);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> forbiddenInstance(String instId) throws Exception {
        this.processInstanceService.suspendProcessInstance(instId);
        this.taskReminderManager.forbiddenTaskReminder(instId);
        return new CommonResult(true, "\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> unForbiddenInstance(String instId) throws Exception {
        this.processInstanceService.recoverProcessInstance(instId);
        this.taskReminderManager.allowTaskReminder(instId);
        return new CommonResult(true, "\u6d41\u7a0b\u5b9e\u4f8b\u53d6\u6d88\u6302\u8d77\u6210\u529f", (Object)"");
    }

    @Override
    public List<BpmProcessInstance> getBpmProcessByParentIdAndSuperNodeId(String parentInstId, String superNodeId) throws Exception {
        return this.bpmProcessInstanceManager.getBpmProcessByParentIdAndSuperNodeId(parentInstId, superNodeId);
    }

    @Override
    public List<DefaultBpmProcessInstance> getInstancesByParentId(String parentInstId, String status) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.withParam("parent_inst_id_", (Object)parentInstId);
        if (StringUtil.isNotEmpty((String)status)) {
            queryFilter.withParam("status_", (Object)status);
        }
        return this.bpmProcessInstanceManager.queryList(queryFilter);
    }

    @Override
    public List<DefaultBpmProcessInstance> getInstancesByDefId(String defId, String status) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.addFilter("proc_def_id_", (Object)defId, QueryOP.EQUAL);
        if (StringUtil.isNotEmpty((String)status)) {
            queryFilter.addFilter("status_", (Object)status, QueryOP.EQUAL);
        }
        return this.bpmProcessInstanceManager.queryList(queryFilter);
    }

    @Override
    public BpmProcessInstance getTopBpmProcessInstance(String instId) throws Exception {
        return this.bpmProcessInstanceManager.getTopBpmProcessInstance(instId);
    }

    @Override
    public String getBpmImage(BpmImageParamObject bpmImageParamObject) throws Exception {
        BpmProcessInstance instance;
        DiagramService diagramService = (DiagramService)AppUtil.getBean((String)"diagramService");
        BpmInstService instService = (BpmInstService)AppUtil.getBean(BpmInstService.class);
        InputStream is = null;
        if (StringUtil.isNotEmpty((String)bpmImageParamObject.getProcInstId()) && BeanUtils.isNotEmpty((Object)(instance = instService.getProcessInstance(bpmImageParamObject.getProcInstId()))) && ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance.getStatus())) {
            bpmImageParamObject.setDefId(instance.getProcDefId());
        }
        if (StringUtils.isNotEmpty((String)bpmImageParamObject.getDefId())) {
            is = diagramService.getDiagramByBpmnDefId(bpmImageParamObject.getDefId());
        } else if (StringUtils.isNotEmpty((String)bpmImageParamObject.getBpmnInstId())) {
            is = this.getDiagramByInstance(diagramService, bpmImageParamObject.getBpmnInstId());
        } else if (StringUtils.isNotEmpty((String)bpmImageParamObject.getTaskId())) {
            BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean((String)"defaultBpmTaskService");
            BpmTask bpmTask = bpmTaskService.getByTaskId(bpmImageParamObject.getTaskId());
            is = this.getDiagramByInstance(diagramService, bpmTask.getBpmnInstId());
        } else if (StringUtils.isNotEmpty((String)bpmImageParamObject.getProcInstId())) {
            instance = instService.getProcessInstance(bpmImageParamObject.getProcInstId());
            is = this.getDiagramByInstance(diagramService, instance.getBpmnInstId());
        }
        if (is == null) {
            return "";
        }
        byte[] data = null;
        try {
            data = new byte[is.available()];
            is.read(data);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "data:image/png;base64," + new String(Base64.encodeBase64((byte[])data));
    }

    private InputStream getDiagramByInstance(DiagramService diagramService, String bpmnInstId) throws Exception {
        BpmProcessInstance processInstance = this.getProcessInstance(bpmnInstId);
        Map colorMap = this.bpmProStatusManager.getProcessInstanceStatus(processInstance.getId(), processInstance.getIsForbidden());
        if (ProcessInstanceStatus.STATUS_END.getKey().equals(processInstance.getStatus())) {
            List endEvents = this.bpmDefinitionAccessor.getEndEvents(processInstance.getProcDefId());
            Map statusColorMap = (Map)AppUtil.getBean((String)"statusColorMap");
            for (BpmNodeDef bpmNodeDef : endEvents) {
                colorMap.put(bpmNodeDef.getNodeId(), statusColorMap.get("complete"));
            }
        }
        return diagramService.getDiagramByDefId(processInstance.getProcDefId(), colorMap);
    }

    private BpmProcessInstance getProcessInstance(String bpmnInstId) {
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstanceByBpmnInstId(bpmnInstId);
        if (bpmProcessInstance == null) {
            bpmProcessInstance = bpmProcessInstanceManager.getBpmProcessInstanceHistoryByBpmnInstId(bpmnInstId);
        }
        return bpmProcessInstance;
    }

    @Override
    public CommonResult<String> setDefOtherParam(DefOtherParam defOtherParam) throws Exception {
        return null;
    }

    @Override
    @Transactional
    public CommonResult<String> doNextcommu(DoNextParamObject doNextParamObject) throws Exception {
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice notice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)doNextParamObject.getTaskId()));
        if (BeanUtils.isEmpty((Object)notice)) {
            return new CommonResult(false, "\u8be5\u6c9f\u901a\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (OpinionStatus.FEEDBACK.getKey().equals(notice.getStatus())) {
            return new CommonResult(false, "\u8be5\u6c9f\u901a\u5df2\u7ecf\u53cd\u9988");
        }
        String opinion = doNextParamObject.getOpinion();
        this.updOpinionComplete(doNextParamObject.getInstId(), notice.getTaskId(), OpinionStatus.FEEDBACK, ContextUtil.getCurrentUserId(), opinion, doNextParamObject.getFiles(), doNextParamObject.getZfiles());
        notice.setStatus(OpinionStatus.FEEDBACK.getKey());
        notice.setIsRead(Integer.valueOf(1));
        noticeManager.update((Model)notice);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.getById((Serializable)((Object)notice.getProcInstId()));
        if (instance != null && !StringUtils.isEmpty((String)notice.getAssigneeId())) {
            IUser userAssignee = BpmUtil.getUser((String)notice.getOwnerId());
            String notifyType = BpmUtil.getNotifyType((BpmProcessInstance)instance, (String)notice.getNodeId());
            MessageUtil.sendMsg((String)"bpmCommuFeedBack", (String)notifyType, Collections.singletonList(userAssignee), (DefaultBpmProcessInstance)instance, (String)opinion);
        }
        return new CommonResult(true, "\u53cd\u9988\u6210\u529f");
    }

    private void updOpinionComplete(String instId, String opinionId, OpinionStatus opinionStatus, String commuUser, String opinion, String files, String zFiles) {
        IUser user = this.userServiceImpl.getUserById(commuUser);
        DefaultBpmCheckOpinion checkOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)opinionId));
        checkOpinion.setFiles(files);
        checkOpinion.setZfiles(zFiles);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
        checkOpinion.setDurMs(Long.valueOf(durMs));
        checkOpinion.setAuditor(user.getUserId());
        checkOpinion.setAuditorName(user.getFullname());
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setOpinion(opinion);
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    @Override
    public Map<String, Object> getUrgentStateConf(ObjectNode obj) throws Exception {
        BpmNodeDef bpmNodeDef;
        DefaultBpmProcessInstance instance;
        DefaultBpmProcessInstance instance2;
        String defId = obj.hasNonNull("defId") ? obj.get("defId").asText() : "";
        String taskId = obj.hasNonNull("taskId") ? obj.get("taskId").asText() : "";
        String instId = obj.hasNonNull("instId") ? obj.get("instId").asText() : "";
        boolean getConf = obj.hasNonNull("getConf") ? obj.get("getConf").asBoolean() : false;
        String nodeId = "";
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)taskId)) {
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)obj.get("taskId").asText()));
            if (BeanUtils.isNotEmpty((Object)defaultBpmTask)) {
                nodeId = defaultBpmTask.getNodeId();
                instId = defaultBpmTask.getProcInstId();
                defId = defaultBpmTask.getProcDefId();
            }
        } else if (StringUtil.isNotEmpty((String)instId) && BeanUtils.isNotEmpty((Object)(instance2 = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId))))) {
            defId = instance2.getProcDefId();
            result.put("value", instance2.getUrgentState());
            if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance2.getStatus())) {
                result.put("right", "w");
            }
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if ((BeanUtils.isEmpty((Object)defaultBpmDefinition) || defaultBpmDefinition.getShowUrgentState() == 0) && !getConf) {
            return result;
        }
        PropertyService propertyService = (PropertyService)AppUtil.getBean(PropertyService.class);
        String byAlias = propertyService.getProperty("urgentStateConf", "");
        result.put("conf", byAlias);
        if (getConf) {
            return result;
        }
        if (!result.containsKey("value") && BeanUtils.isNotEmpty((Object)(instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId))))) {
            result.put("value", instance.getUrgentState());
            if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance.getStatus())) {
                result.put("right", "w");
            }
        }
        if (StringUtil.isNotEmpty((String)nodeId) && BeanUtils.isNotEmpty((Object)(bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId))) && bpmNodeDef.getNodeProperties().size() > 0 && ((NodeProperties)bpmNodeDef.getNodeProperties().get(0)).isAllowEditUrgentState()) {
            result.put("right", "w");
        }
        if (!result.containsKey("value")) {
            result.put("right", "w");
        }
        return result;
    }

    @Override
    @Transactional
    public CommonResult<String> doNextCopyto(DoNextParamObject doNextParamObject) throws Exception {
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)doNextParamObject.getTaskId()));
        if (BeanUtils.isEmpty((Object)bpmTaskNotice)) {
            throw new NotFoundException(String.format("\u6839\u636e\u4f20\u9605\u4efb\u52a1id\u3010%s\u3011\u672a\u627e\u5230\u4f20\u9605\u4efb\u52a1", doNextParamObject.getTaskId()));
        }
        if (!(TaskType.COMMU.getKey().equals(bpmTaskNotice.getStatus()) || TaskType.COPYTO.getKey().equals(bpmTaskNotice.getStatus()) || OpinionStatus.COPYTO_REPLY.getKey().equals(bpmTaskNotice.getStatus()))) {
            throw new BaseException("\u8be5\u4efb\u52a1\u4e0d\u662f\u4f20\u9605\u4efb\u52a1\uff0c\u4e0d\u80fd\u56de\u590d");
        }
        bpmTaskNotice.setStatus(OpinionStatus.COPYTO_REPLY.getKey());
        bpmTaskNotice.setIsRead(Integer.valueOf(1));
        noticeManager.update((Model)bpmTaskNotice);
        IUser user = this.userServiceImpl.getUserById(ContextUtil.getCurrentUserId());
        ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmProcessInstance def = (DefaultBpmProcessInstance)this.bpmProcessInstanceMapper.get((Serializable)((Object)doNextParamObject.getInstId()));
        String bpmnInstId = def.getBpmnInstId();
        String superInstId = "";
        if (!OpinionStatus.END.getKey().equals(def.getStatus())) {
            superInstId = (String)this.natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        }
        List checkOpinionList = this.bpmCheckOpinionManager.getByInstId(doNextParamObject.getInstId());
        checkOpinionList.forEach(checkOpinion -> {
            if (OpinionStatus.COPYTO.getKey().equals(checkOpinion.getStatus()) && StringUtil.isEmpty((String)checkOpinion.getAuditor())) {
                checkOpinion.setAuditor(user.getUserId());
                checkOpinion.setAuditorName(user.getFullname());
                this.bpmCheckOpinionManager.update((Model)checkOpinion);
            }
        });
        DefaultBpmCheckOpinion checkOpinion2 = new DefaultBpmCheckOpinion();
        checkOpinion2.setId(UniqueIdUtil.getSuid());
        checkOpinion2.setProcDefId(def.getBpmnDefId());
        checkOpinion2.setSupInstId(superInstId);
        checkOpinion2.setProcInstId(doNextParamObject.getInstId());
        checkOpinion2.setTaskId("");
        checkOpinion2.setTaskKey("");
        checkOpinion2.setTaskName("\u4f20\u9605\u4efb\u52a1");
        checkOpinion2.setFiles(doNextParamObject.getFiles());
        checkOpinion2.setZfiles(doNextParamObject.getZfiles());
        checkOpinion2.setStatus(OpinionStatus.COPYTO_REPLY.getKey());
        checkOpinion2.setCreateTime(LocalDateTime.now());
        checkOpinion2.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion2.setQualfiedNames(user.getFullname());
        checkOpinion2.setOpinion(doNextParamObject.getOpinion());
        checkOpinion2.setCompleteTime(LocalDateTime.now());
        long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion2.getCreateTime());
        checkOpinion2.setDurMs(Long.valueOf(durMs));
        checkOpinion2.setAuditor(user.getUserId());
        checkOpinion2.setAuditorName(user.getFullname());
        checkOpinion2.setIsRead(Integer.valueOf(1));
        this.bpmCheckOpinionManager.create((Model)checkOpinion2);
        return new CommonResult(true, "\u56de\u590d\u6210\u529f");
    }

    @Override
    public Map<String, List<DefaultBpmTask>> instanceDetails(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"proc_inst_id_", ids);
        List tasks = this.bpmTaskManager.list((Wrapper)queryWrapper);
        ConcurrentHashMap<String, List<DefaultBpmTask>> map = new ConcurrentHashMap<String, List<DefaultBpmTask>>();
        tasks.parallelStream().forEach(task -> {
            if (StringUtils.isEmpty((String)task.getAssigneeId()) || Objects.equals(task.getAssigneeId(), "0")) {
                try {
                    task = this.bpmIdentityService.setMultiAssignee(task);
                }
                catch (Exception e) {
                    return;
                }
            }
            if (map.containsKey(task.getProcInstId())) {
                ((List)map.get(task.getProcInstId())).add(task);
            } else {
                ArrayList<DefaultBpmTask> list = new ArrayList<DefaultBpmTask>();
                list.add((DefaultBpmTask)task);
                map.put(task.getProcInstId(), list);
            }
        });
        return map;
    }

    @Override
    public DefaultBpmTask getMyRequestTask(String instId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"proc_inst_id_", (Object)instId);
        List tasks = this.bpmTaskManager.list((Wrapper)queryWrapper);
        for (DefaultBpmTask task : tasks) {
            if (ProcessInstanceStatus.STATUS_BACK.toString().equalsIgnoreCase(task.getStatus()) || ProcessInstanceStatus.STATUS_REVOKE_TOSTART.toString().equalsIgnoreCase(task.getStatus()) || ProcessInstanceStatus.STATUS_BACK_TOSTART.toString().equalsIgnoreCase(task.getStatus())) {
                if (!this.existsTodoList(task.getTaskId()).booleanValue()) continue;
                return task;
            }
            try {
                List startNodes = this.bpmDefinitionAccessor.getStartNodes(task.getProcDefId());
                if (CollectionUtils.isEmpty((Collection)startNodes)) continue;
                String nodeId = ((BpmNodeDef)startNodes.get(0)).getNodeId();
                if (!task.getNodeId().equals(nodeId) || !this.existsTodoList(task.getTaskId()).booleanValue()) continue;
                return task;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Boolean existsTodoList(String taskId) {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("bt.id_", (Object)taskId, QueryOP.EQUAL, FieldRelation.AND);
        try {
            long todoTotal = this.flowManager.getTodoList(currentUser.getAccount(), (QueryFilter<DefaultBpmTask>)queryFilter).get().getTotal();
            if (todoTotal > 0L) {
                return true;
            }
            QueryFilter queryFilterLeader = QueryFilter.build();
            queryFilterLeader.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(1), Boolean.valueOf(true)));
            queryFilterLeader.addFilter("task_id_", (Object)taskId, QueryOP.EQUAL, FieldRelation.AND);
            long leaderTotal = this.flowManager.getLeaderTodoList(currentUser.getAccount(), queryFilterLeader).getTotal();
            if (leaderTotal > 0L) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u4efb\u52a1\u662f\u5426\u5728\u5f53\u524d\u7528\u6237\u7684\u5f85\u529e\u5217\u8868\u4e2d\u5f02\u5e38\uff01", (Throwable)e);
        }
        return false;
    }

    @Override
    public CommonResult<String> meetingRoomApply(JsonNode mappingObject, String flowKey) throws Exception {
        String formData = this.getTransData(flowKey, mappingObject);
        StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
        startFlowParamObject.setFlowKey(flowKey);
        startFlowParamObject.setFormType("inner");
        startFlowParamObject.setData(formData);
        StartResult result = this.syncStart(startFlowParamObject);
        if (result.getState().booleanValue()) {
            List tasks = this.bpmTaskManager.getByInstId(result.getInstId());
            if (BeanUtils.isNotEmpty((Object)tasks) && tasks.size() == 1 && ContextUtil.getCurrentUserId().equals(((DefaultBpmTask)tasks.get(0)).getOwnerId())) {
                return new CommonResult(true, "\u542f\u52a8\u6210\u529f\uff01", (Object)(result.getInstId() + ":" + ((DefaultBpmTask)tasks.get(0)).getTaskId()));
            }
            return new CommonResult(true, "\u542f\u52a8\u6210\u529f\uff01", (Object)result.getInstId());
        }
        return new CommonResult(false, result.getMessage());
    }

    private String getTransData(String flowKey, JsonNode mappingObject) throws Exception {
        BpmDefinition def = this.bpmDefinitionService.getBpmDefinitionByDefKey(flowKey, false);
        List boDatas = this.boDataService.getDataByDefId(def.getDefId());
        ObjectNode jsondata = BoDataUtil.hanlerData((String)def.getDefId(), (List)boDatas, (boolean)true);
        String boDefKey = mappingObject.get("boDefKey").asText();
        ObjectNode boDataNode = (ObjectNode)jsondata.get(boDefKey);
        ObjectNode mappingDataNode = (ObjectNode)mappingObject.get("data");
        Iterator fields = mappingDataNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            if (!BeanUtils.isNotEmpty(next.getValue())) continue;
            boDataNode.set(key, (JsonNode)next.getValue());
        }
        jsondata.set(boDefKey, (JsonNode)boDataNode);
        return com.hotent.base.util.Base64.getBase64((String)JsonUtil.toJsonString((Object)jsondata));
    }
}

