/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.runtime.dao.ScriptDao;
import com.hotent.runtime.manager.ScriptManager;
import com.hotent.runtime.model.Script;
import com.hotent.runtime.model.TreeEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="scriptManager")
public class ScriptManagerImpl
extends BaseManagerImpl<ScriptDao, Script>
implements ScriptManager {
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    private ScriptManager scriptManager;

    @Override
    public List<String> getDistinctCategory() {
        return ((ScriptDao)this.baseMapper).getDistinctCategory();
    }

    @Override
    public Integer isNameExists(String name) {
        return ((ScriptDao)this.baseMapper).isNameExists(name);
    }

    @Override
    public CommonResult<List<Map<String, String>>> executeScriptByList(List<String> list) {
        try {
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                String script = list.get(i);
                script = script.replace("\u3010", "").replace("\u3011", "");
                Object obj = this.groovyScriptEngine.executeObject(script, new HashMap());
                String value = "";
                if (BeanUtils.isNotEmpty((Object)obj)) {
                    value = JsonUtil.toJsonNode((Object)obj).toString();
                    if (obj instanceof String) {
                        value = JsonUtil.toJsonNode((Object)obj).textValue();
                    }
                }
                map.put("key", list.get(i));
                if (value instanceof String) {
                    map.put("value", "'" + value + "'");
                } else {
                    map.put("value", value);
                }
                mapList.add(map);
            }
            return new CommonResult(true, "\u6267\u884c\u6210\u529f\uff01", mapList);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
        }
    }

    @Override
    public List<TreeEntity> getScriptTreeData() {
        List<TreeEntity> treeList = this.getTree();
        if (BeanUtils.isEmpty(treeList)) {
            treeList = new ArrayList<TreeEntity>();
        }
        return treeList;
    }

    @Override
    public Script getByScript(String script) {
        List<Script> scripts = ((ScriptDao)this.baseMapper).getByScript(script);
        if (BeanUtils.isNotEmpty(scripts)) {
            return scripts.get(0);
        }
        return new Script();
    }

    private List<TreeEntity> getTree() {
        ArrayList<TreeEntity> listResult = new ArrayList<TreeEntity>();
        List<String> categoryList = this.scriptManager.getDistinctCategory();
        for (String category : categoryList) {
            TreeEntity entity = new TreeEntity(category, category, category, "", "");
            listResult.add(entity);
        }
        List list = this.scriptManager.getAll();
        for (Script script : list) {
            TreeEntity entity = new TreeEntity(script.getName(), script.getScript(), script.getId(), script.getCategory(), "");
            for (TreeEntity pEntity : listResult) {
                if (!pEntity.getId().equals(script.getCategory())) continue;
                ArrayList<TreeEntity> childrens = pEntity.getChildren();
                if (BeanUtils.isEmpty((Object)childrens)) {
                    childrens = new ArrayList<TreeEntity>();
                }
                childrens.add(entity);
                pEntity.setChildren(childrens);
            }
        }
        return listResult;
    }
}

