/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.script;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.context.BaseContext;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.IScript;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.listener.BusDataUtil;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.params.StartFlowParamObject;
import com.hotent.runtime.params.StartResult;
import com.hotent.runtime.utils.SubCalcUtils;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.service.UserServiceImpl;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class ScriptImpl
implements IScript {
    protected static Logger logger = LoggerFactory.getLogger(ScriptImpl.class);
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BoDataService boDataService;
    @Resource
    UCFeignService uCFeignService;
    @Resource
    IProcessManager iProcessService;
    @Resource
    UserServiceImpl userServiceImpl;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;
    private final String FIELD_PREFIX = "F_";
    private final String CurrentGroupIdPrefix = "CurrentGroupId:";

    public Set<String> getCurrentUserIdSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(ContextUtil.getCurrentUser().getUserId());
        return set;
    }

    public IUser getCurrentUser() {
        return ContextUtil.getCurrentUser();
    }

    public String getCurrentUserId() {
        return ContextUtil.getCurrentUser().getUserId();
    }

    public String getCurrentAccount() {
        return ContextUtil.getCurrentUser().getAccount();
    }

    public String getCurrentGroupId() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        ScriptImpl bean = (ScriptImpl)AppUtil.getBean(this.getClass());
        String groupIdFromCache = bean.getCurrentGroupIdFromCache(userId);
        return StringUtil.isEmpty((String)groupIdFromCache) ? ContextUtil.getCurrentGroupId() : groupIdFromCache;
    }

    public String getCurrentGroupName() throws IOException {
        IGroup currentGroup = ContextUtil.getCurrentGroup();
        if (currentGroup == null) {
            return null;
        }
        return currentGroup.getName();
    }

    public String getNextNo(String alias) {
        return this.portalFeignService.getNextIdByAlias(alias);
    }

    public boolean isDefaultTaskFinishCmd(ActionCmd processCmd) {
        return DefaultTaskFinishCmd.class.getName().equals(processCmd.getClass().getName());
    }

    public void validBoDataExist(ObjectNode boData, String fieldName, String messages) {
        JdbcTemplate jdbcTemplate = (JdbcTemplate)AppUtil.getBean((String)"jdbcTemplate");
        ObjectNode boEnt = (ObjectNode)boData.get("boEnt");
        boolean isAdd = true;
        String pk = boEnt.get("pkKey").asText().toLowerCase();
        if (boEnt.findValues("pk") != null && StringUtil.isNotEmpty((String)String.valueOf(boEnt.get(pk).asText()))) {
            isAdd = false;
        }
        String sql = "";
        Object[] aryObj = null;
        JsonNode obj = boData.get(fieldName);
        String val = "";
        if (BeanUtils.isNotEmpty((Object)obj)) {
            val = obj.toString().trim();
        }
        if (isAdd) {
            aryObj = new Object[]{val};
            sql = "select count(*) from " + boEnt.get("tableName").asText() + " where " + "F_" + fieldName + "=?";
        } else {
            aryObj = new Object[]{val, boData.get(boEnt.get("pkKey").asText())};
            sql = "select  count(*) from " + boEnt.get("tableName").asText() + " where " + "F_" + fieldName + "=? and " + boEnt.get("pkKey").asText() + "!=?";
        }
        Integer rtn = (Integer)jdbcTemplate.queryForObject(sql, aryObj, Integer.class);
        if (rtn > 0) {
            if (StringUtil.isNotEmpty((String)messages)) {
                throw new RuntimeException(messages);
            }
            throw new RuntimeException(val + "\u6570\u636e\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5\u8868\u5355\u6570\u636e!");
        }
    }

    public Set<BpmIdentity> getRoles() {
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        List listRole = this.uCFeignService.getAllRole();
        for (ObjectNode role : listRole) {
            DefaultBpmIdentity identity = new DefaultBpmIdentity(role.get("id").asText(), role.get("name").asText(), "group");
            identity.setType("group");
            identity.setExtractType(ExtractType.EXACT_NOEXACT);
            identity.setGroupType(GroupTypeConstant.ROLE.key());
            set.add((BpmIdentity)identity);
        }
        return set;
    }

    public boolean isUserInRole(String account, String roleAlias) {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)roleAlias)) {
            return false;
        }
        List listRole = this.uCFeignService.getRoleListByAccount(account);
        if (BeanUtils.isNotEmpty((Object)listRole)) {
            for (ObjectNode role : listRole) {
                if (!roleAlias.equals(role.get("code").asText())) continue;
                return true;
            }
        }
        return false;
    }

    public ActionCmd getActionCmd() {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        return cmd;
    }

    public String getIUserMainOrgName() {
        ObjectNode org = this.uCFeignService.getMainGroup(ContextUtil.getCurrentUser().getUserId());
        if (BeanUtils.isNotEmpty((Object)org)) {
            return org.get("name").asText();
        }
        return null;
    }

    public String getIUserMainOrgID() {
        ObjectNode org = this.uCFeignService.getMainGroup(ContextUtil.getCurrentUser().getUserId());
        if (BeanUtils.isNotEmpty((Object)org)) {
            return org.get("id").asText();
        }
        return null;
    }

    public Set<String> getIUserPostName() {
        HashSet<String> set = new HashSet<String>();
        List orgRels = this.uCFeignService.getPosListByAccount(ContextUtil.getCurrentUser().getAccount());
        if (BeanUtils.isNotEmpty((Object)orgRels)) {
            for (ObjectNode orgRel : orgRels) {
                set.add(orgRel.get("name").asText());
            }
        }
        return set;
    }

    public Set<String> getIUserPostID() {
        HashSet<String> set = new HashSet<String>();
        List orgRels = this.uCFeignService.getPosListByAccount(ContextUtil.getCurrentUser().getAccount());
        if (BeanUtils.isNotEmpty((Object)orgRels)) {
            for (ObjectNode orgRel : orgRels) {
                set.add(orgRel.get("id").asText());
            }
        }
        return set;
    }

    public Set<String> getIUserRoleName() {
        HashSet<String> set = new HashSet<String>();
        List roles = this.uCFeignService.getRoleListByAccount(ContextUtil.getCurrentUser().getAccount());
        if (BeanUtils.isNotEmpty((Object)roles)) {
            for (ObjectNode role : roles) {
                set.add(role.get("name").asText());
            }
        }
        return set;
    }

    public Set<String> getIUserRoleID() {
        HashSet<String> set = new HashSet<String>();
        List roles = this.uCFeignService.getRoleListByAccount(ContextUtil.getCurrentUser().getUserId());
        if (BeanUtils.isNotEmpty((Object)roles)) {
            for (ObjectNode role : roles) {
                set.add(role.get("id").asText());
            }
        }
        return set;
    }

    public String getCurrentUserName() {
        return ContextUtil.getCurrentUser().getFullname();
    }

    public void getNewsStatusById() throws Exception {
        ActionCmd actionCmd = this.getActionCmd();
        BpmBusLinkManager bpmBusLinkManager = (BpmBusLinkManager)AppUtil.getBean(BpmBusLinkManager.class);
        if (BeanUtils.isNotEmpty((Object)actionCmd)) {
            Map linkMap = bpmBusLinkManager.getMapByInstId(actionCmd.getInstId());
            ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)actionCmd.getBusData());
            Map jsonMap = BoDataUtil.getMap((ObjectNode)jsonObject);
            FormFeignService formFeignService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            for (String key : jsonMap.keySet()) {
                ObjectNode def = formFeignService.getBodefByAlias(key);
                BpmBusLink busLink = (BpmBusLink)linkMap.get(def.get("alias").asText());
                PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
                portalFeignService.publicMsgNews(busLink.getBusinesskeyStr());
            }
        }
    }

    public Boolean isSynchronize(String nodeIds, String actionName) throws Exception {
        Boolean flag = true;
        ActionCmd actionCmd = this.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)actionCmd)) {
            BpmRuntimeFeignService bean = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
            String lastNodeIds = "";
            if (BeanUtils.isNotEmpty((Object)actionCmd.getTransitVars("parentStack"))) {
                BpmExeStack bpmExeStack = (BpmExeStack)actionCmd.getTransitVars("parentStack");
                lastNodeIds = bpmExeStack.getNodeId();
            }
            String lastActionName = actionCmd.getActionName();
            flag = bean.isSynchronize(actionCmd.getInstId(), nodeIds, actionName, lastActionName, lastNodeIds);
        }
        return flag;
    }

    public String getCurrentDate() {
        return TimeUtil.getCurrentDate();
    }

    public String getCurrentDateByStyle(String style) {
        return DateUtil.getCurrentTime((String)style);
    }

    public void updateMainField(String defCode, String field, Object value) throws Exception {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        String instId = cmd.getInstId();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        ObjectNode jsonObject = JsonUtil.createObjectNode();
        if (StringUtil.isNotEmpty((String)defCode) && StringUtil.isNotEmpty((String)field) && BeanUtils.isNotEmpty((Object)instance)) {
            List oldBoDatas = this.boDataService.getDataByInst((BpmProcessInstance)instance);
            if (BeanUtils.isEmpty((Object)oldBoDatas)) {
                throw new RuntimeException(String.format("\u6839\u636e\u5b9e\u4f8bid:%s\u672a\u67e5\u627e\u5230\u8868\u5355\u6570\u636e", instId));
            }
            boolean isUpdate = false;
            block0: for (ObjectNode obj : oldBoDatas) {
                if (!defCode.equals(JsonUtil.getString((JsonNode)obj, (String)"boDefAlias")) || !BeanUtils.isNotEmpty((Object)obj.get("boEnt")) || !BeanUtils.isNotEmpty((Object)obj.get("boEnt").get("attributeList"))) continue;
                ArrayNode attrs = (ArrayNode)obj.get("boEnt").get("attributeList");
                for (JsonNode jsonNode : attrs) {
                    if (!field.equals(jsonNode.get("name").asText())) continue;
                    isUpdate = true;
                    continue block0;
                }
            }
            if (!isUpdate) {
                return;
            }
            jsonObject = BoDataUtil.hanlerData((BpmProcessInstance)instance, (String)"", (List)oldBoDatas);
        } else if (StringUtil.isNotEmpty((String)cmd.getBusData()) && BeanUtils.isNotEmpty((Object)cmd.getTransitVars("processInstance"))) {
            instance = (DefaultBpmProcessInstance)cmd.getTransitVars("processInstance");
            jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)cmd.getBusData());
        } else {
            return;
        }
        Iterator iterator = jsonObject.fields();
        while (iterator.hasNext()) {
            ObjectNode ywdxObj;
            Map.Entry next = (Map.Entry)iterator.next();
            String key = (String)next.getKey();
            if (!key.equals(defCode) || !BeanUtils.isNotEmpty((Object)(ywdxObj = (ObjectNode)next.getValue()))) continue;
            if (value instanceof Integer) {
                ywdxObj.put(field, ((Integer)value).intValue());
                continue;
            }
            ywdxObj.put(field, (String)value);
        }
        BusDataUtil.updateBoData((DefaultBpmProcessInstance)instance, (String)"", (String)JsonUtil.toJson((Object)jsonObject));
        cmd.setBusData(JsonUtil.toJson((Object)jsonObject));
    }

    public void updateMainField(String instId, String defCode, String field, Object value) throws Exception {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        if (StringUtil.isNotEmpty((String)defCode) && StringUtil.isNotEmpty((String)field) && BeanUtils.isNotEmpty((Object)instance)) {
            List oldBoDatas = this.boDataService.getDataByInst((BpmProcessInstance)instance);
            ObjectNode jsonObject = BoDataUtil.hanlerData((BpmProcessInstance)instance, (String)"", (List)oldBoDatas);
            Iterator iterator = jsonObject.fields();
            boolean isUpdate = false;
            block0: while (iterator.hasNext()) {
                ObjectNode ywdxObj;
                Map.Entry next = (Map.Entry)iterator.next();
                String key = (String)next.getKey();
                if (!key.equals(defCode) || !BeanUtils.isNotEmpty((Object)(ywdxObj = (ObjectNode)next.getValue()))) continue;
                Iterator fieldIterator = ywdxObj.fields();
                while (fieldIterator.hasNext()) {
                    String fieldKey = (String)((Map.Entry)fieldIterator.next()).getKey();
                    if (!fieldKey.equals(field)) continue;
                    if (value instanceof Integer) {
                        ywdxObj.put(field, ((Integer)value).intValue());
                    } else {
                        ywdxObj.put(field, (String)value);
                    }
                    isUpdate = true;
                    continue block0;
                }
            }
            if (isUpdate) {
                BusDataUtil.updateBoData((DefaultBpmProcessInstance)instance, (String)"", (String)JsonUtil.toJsonString((Object)jsonObject));
            }
        }
    }

    public void updateSubField(String mainDefCode, String subDefCode, int index, String field, Object value) throws Exception {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (StringUtil.isNotEmpty((String)mainDefCode) && StringUtil.isNotEmpty((String)field)) {
            String busData = cmd.getBusData();
            ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)busData);
            Iterator iterator = jsonObject.fields();
            boolean isUpdate = false;
            while (iterator.hasNext()) {
                ObjectNode ywdxObj;
                Map.Entry next = (Map.Entry)iterator.next();
                String key = (String)next.getKey();
                if (!key.equals(mainDefCode) || !BeanUtils.isNotEmpty((Object)(ywdxObj = (ObjectNode)next.getValue()))) continue;
                Iterator fieldIterator = ywdxObj.fields();
                block1: while (fieldIterator.hasNext()) {
                    ArrayNode subArrayObj;
                    String fieldKey;
                    Map.Entry mainNext = (Map.Entry)fieldIterator.next();
                    if (!((String)mainNext.getKey()).contains("sub_") || !(fieldKey = ((String)mainNext.getKey()).replace("sub_", "")).equals(subDefCode) || !BeanUtils.isNotEmpty((Object)(subArrayObj = (ArrayNode)mainNext.getValue())) || subArrayObj.size() < index + 1) continue;
                    ObjectNode subObj = (ObjectNode)subArrayObj.get(index);
                    Iterator subIterator = subObj.fields();
                    while (subIterator.hasNext()) {
                        Map.Entry subNext = (Map.Entry)subIterator.next();
                        String subFieldKey = (String)subNext.getKey();
                        if (!subFieldKey.equals(field)) continue;
                        if (value instanceof Integer) {
                            subObj.put(field, ((Integer)value).intValue());
                        } else {
                            subObj.put(field, (String)value);
                        }
                        isUpdate = true;
                        continue block1;
                    }
                }
            }
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)cmd.getInstId()));
            if (isUpdate && BeanUtils.isNotEmpty((Object)instance)) {
                BusDataUtil.updateBoData((DefaultBpmProcessInstance)instance, (String)"", (String)JsonUtil.toJson((Object)jsonObject));
                cmd.setBusData(JsonUtil.toJson((Object)jsonObject));
            }
        }
    }

    public Object getSubFiledValue(String defCode, String subTableName, String field) throws IOException {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (StringUtil.isNotEmpty((String)defCode) && StringUtil.isNotEmpty((String)subTableName) && StringUtil.isNotEmpty((String)field)) {
            String busData = cmd.getBusData();
            ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)busData);
            Iterator iterator = jsonObject.fields();
            while (iterator.hasNext()) {
                ObjectNode ywdxObj;
                String key = (String)((Map.Entry)iterator.next()).getKey();
                if (!key.equals(defCode) || !BeanUtils.isNotEmpty((Object)(ywdxObj = (ObjectNode)jsonObject.get(key)))) continue;
                Iterator fieldIterator = ywdxObj.fields();
                while (fieldIterator.hasNext()) {
                    ObjectNode subObj;
                    String subName;
                    String fieldKey = (String)((Map.Entry)fieldIterator.next()).getKey();
                    if (!fieldKey.equals(subName = "sub_" + subTableName) || !BeanUtils.isNotEmpty((Object)(subObj = (ObjectNode)jsonObject.get(subName)))) continue;
                    Iterator subIterator = ywdxObj.fields();
                    while (subIterator.hasNext()) {
                        String subFiledKey = (String)((Map.Entry)fieldIterator.next()).getKey();
                        if (!subFiledKey.equals(field)) continue;
                        return ywdxObj.get(field);
                    }
                }
            }
        }
        return null;
    }

    public String getSubFieldValueByIndex(String defCode, String subTableCode, String subFieldCode, int index) throws Exception {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (StringUtil.isNotEmpty((String)defCode) && StringUtil.isNotEmpty((String)subTableCode)) {
            String busData = cmd.getBusData();
            ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)busData);
            Iterator iterator = jsonObject.fields();
            String subTabName = "sub_" + subTableCode;
            while (iterator.hasNext()) {
                ObjectNode ywdxObj;
                Map.Entry next = (Map.Entry)iterator.next();
                String key = (String)next.getKey();
                if (!key.equals(defCode) || !BeanUtils.isNotEmpty((Object)(ywdxObj = (ObjectNode)next.getValue()))) continue;
                Iterator fieldIterator = ywdxObj.fields();
                while (fieldIterator.hasNext()) {
                    ArrayNode subArrayObj;
                    Map.Entry mainNext = (Map.Entry)fieldIterator.next();
                    if (!((String)mainNext.getKey()).equals(subTabName) || !BeanUtils.isNotEmpty((Object)(subArrayObj = (ArrayNode)mainNext.getValue())) || subArrayObj.size() < index) continue;
                    return JsonUtil.getString((JsonNode)subArrayObj.get(index - 1), (String)subFieldCode, (String)"");
                }
            }
        }
        return "";
    }

    public static boolean littleThen(String st1, String st2) {
        if (BeanUtils.isNotEmpty((Object)st1) && BeanUtils.isNotEmpty((Object)st1)) {
            return st1.compareTo(st2) < 0;
        }
        return false;
    }

    public static boolean LargeThen(String st1, String st2) {
        if (BeanUtils.isNotEmpty((Object)st1) && BeanUtils.isNotEmpty((Object)st1)) {
            return st1.compareTo(st2) > 0;
        }
        return false;
    }

    public static boolean equals(String st1, String st2) {
        if (BeanUtils.isEmpty((Object)st1) && BeanUtils.isEmpty((Object)st2)) {
            return true;
        }
        if (BeanUtils.isNotEmpty((Object)st1) && BeanUtils.isNotEmpty((Object)st1)) {
            return st1.equals(st2);
        }
        return false;
    }

    public static boolean contains(String st1, String st2) {
        if (BeanUtils.isNotEmpty((Object)st1) && BeanUtils.isNotEmpty((Object)st1)) {
            return st1.contains(st2);
        }
        return false;
    }

    public static boolean subContains(ArrayNode arr, String field, String value) throws Exception {
        if (BeanUtils.isEmpty((Object)arr)) {
            return false;
        }
        for (JsonNode node : arr) {
            JsonNode v = node.get(field);
            if (null == v || v.getNodeType().equals((Object)JsonNodeType.NULL) || !v.getNodeType().equals((Object)JsonNodeType.STRING) && !v.getNodeType().equals((Object)JsonNodeType.NUMBER) || !v.asText().contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateLarge(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) > 0L;
    }

    public static boolean isDateLarge(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse((String)endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) > 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLarge(String startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse((String)startTime);
            LocalDateTime date = DateFormatUtil.parse((String)endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) > 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLargeEquals(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) >= 0L;
    }

    public static boolean isDateLargeEquals(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse((String)endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) >= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLargeEquals(String startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse((String)startTime);
            LocalDateTime date = DateFormatUtil.parse((String)endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) >= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittle(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty((Object)startTime) && BeanUtils.isNotEmpty((Object)endTime)) {
            return true;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return false;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) < 0L;
    }

    public static boolean isDateLittle(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return false;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse((String)endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) < 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittle(String startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return false;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse((String)startTime);
            LocalDateTime edate = DateFormatUtil.parse((String)endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - edate.toEpochSecond(ZoneOffset.of("+8")) < 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittleEquals(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty((Object)startTime) && BeanUtils.isNotEmpty((Object)endTime)) {
            return true;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return false;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) <= 0L;
    }

    public static boolean isDateLittleEquals(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return false;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse((String)endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) <= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittleEquals(String startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty((Object)endTime)) {
            return false;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse((String)startTime);
            LocalDateTime edate = DateFormatUtil.parse((String)endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - edate.toEpochSecond(ZoneOffset.of("+8")) <= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateEquals(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty((Object)startTime) && BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        if (BeanUtils.isNotEmpty((Object)startTime) && BeanUtils.isNotEmpty((Object)endTime)) {
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) == 0L;
        }
        return false;
    }

    public static boolean isDateEquals(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime) && BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        if (BeanUtils.isNotEmpty((Object)startTime) && BeanUtils.isNotEmpty((Object)endTime)) {
            try {
                LocalDateTime date = DateFormatUtil.parse((String)endTime);
                return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) < 0L;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isDateEquals(String startTime, String endTime) {
        if (BeanUtils.isEmpty((Object)startTime) && BeanUtils.isEmpty((Object)endTime)) {
            return true;
        }
        if (BeanUtils.isNotEmpty((Object)startTime) && BeanUtils.isNotEmpty((Object)endTime)) {
            try {
                LocalDateTime sdate = DateFormatUtil.parse((String)startTime);
                LocalDateTime date = DateFormatUtil.parse((String)endTime);
                return sdate.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) < 0L;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isDateBelongTo(String time, String boundary) {
        if (BeanUtils.isEmpty((Object)time) || BeanUtils.isEmpty((Object)boundary)) {
            return false;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse((String)time);
            String[] boundaryArr = boundary.split(",");
            if (boundaryArr.length != 2) {
                return false;
            }
            LocalDateTime sdate = DateFormatUtil.parse((String)boundaryArr[0]);
            LocalDateTime edate = DateFormatUtil.parse((String)boundaryArr[1]);
            return date.toEpochSecond(ZoneOffset.of("+8")) >= sdate.toEpochSecond(ZoneOffset.of("+8")) && date.toEpochSecond(ZoneOffset.of("+8")) <= edate.toEpochSecond(ZoneOffset.of("+8"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void testStart(String instid) throws Exception {
        StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
        startFlowParamObject.setFlowKey("csjdlc");
        startFlowParamObject.setAccount("admin");
        ContextThreadUtil.clearTaskMap();
        ContextThreadUtil.cleanCommuVars();
        ContextUtil.clearAll();
        CompletableFuture<StartResult> start = this.iProcessService.start(startFlowParamObject);
        System.out.println(start.get().getState());
    }

    public void startNewWithCurFlowData(String startUsers, String newFlowKey) throws Exception {
        if (StringUtil.isEmpty((String)startUsers)) {
            return;
        }
        List users = this.userServiceImpl.getUserByAccounts(startUsers);
        if (BeanUtils.isEmpty((Object)users)) {
            return;
        }
        ActionCmd actionCmd = this.getActionCmd();
        StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
        startFlowParamObject.setFlowKey(newFlowKey);
        startFlowParamObject.setData(Base64.getBase64((String)actionCmd.getBusData()));
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (IUser iUser : users) {
            executorService.execute(() -> {
                try {
                    ContextUtil.setCurrentUser((IUser)iUser);
                    this.baseContext.setTempTenantId(iUser.getTenantId());
                    startFlowParamObject.setAccount(iUser.getAccount());
                    this.iProcessService.start(startFlowParamObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static boolean isNumberBelongTo(Integer num, String boundary) {
        if (BeanUtils.isEmpty((Object)num) || BeanUtils.isEmpty((Object)boundary)) {
            return false;
        }
        String[] boundaryArr = boundary.split(",");
        if (boundaryArr.length != 2) {
            return false;
        }
        Integer start = Integer.valueOf(boundaryArr[0]);
        Integer end = Integer.valueOf(boundaryArr[1]);
        return start <= num && num <= end;
    }

    public static boolean isStringBelongTo(String target, String boundary) {
        if (BeanUtils.isEmpty((Object)target) || BeanUtils.isEmpty((Object)boundary)) {
            return false;
        }
        String[] boundaryArr = boundary.split(",");
        if (boundaryArr.length <= 0) {
            return false;
        }
        List<String> list = Arrays.asList(boundaryArr);
        return list.contains(target);
    }

    public void updateFormData(String account, String bodefName, String fileName) throws Exception {
        if (StringUtil.isNotEmpty((String)account) && StringUtil.isNotEmpty((String)bodefName) && StringUtil.isNotEmpty((String)fileName)) {
            ObjectNode header = JsonUtil.getMapper().createObjectNode();
            String token = "admin:" + EncryptUtil.encrypt((String)"feignCallEncry");
            header.put("Authorization", "Basic " + Base64.getBase64((String)token));
            String string = FluentUtil.get((String)("http://ip:port/api/user/v1/user/getUser?userNumber&account=" + account), (String)Base64.getBase64((String)JsonUtil.toJson((Object)header)));
            if (BeanUtils.isNotEmpty((Object)string)) {
                ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)string);
                String userName = jsonNode.get("fullname").asText();
                this.updateMainField(bodefName, fileName, userName);
            }
        }
    }

    public void getDataAndCheckBack(BpmDelegateTask delegateTask, String account, String checkValue, String skipNode) throws Exception {
        if (StringUtil.isNotEmpty((String)account) && StringUtil.isNotEmpty((String)checkValue)) {
            ObjectNode jsonNode;
            String userName;
            ObjectNode header = JsonUtil.getMapper().createObjectNode();
            String token = "admin:" + EncryptUtil.encrypt((String)"feignCallEncry");
            header.put("Authorization", "Basic " + Base64.getBase64((String)token));
            String string = FluentUtil.get((String)("http://ip:port/api/user/v1/user/getUser?userNumber&account=" + account), (String)Base64.getBase64((String)JsonUtil.toJson((Object)header)));
            if (BeanUtils.isNotEmpty((Object)string) && (userName = (jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)string)).get("fullname").asText()).equals(checkValue)) {
                ExecutorService executorService = Executors.newCachedThreadPool();
                executorService.execute(() -> {
                    try {
                        IUser userByAccount = this.userServiceImpl.getUserByAccount("admin");
                        Thread.sleep(2000L);
                        ContextUtil.setCurrentUser((IUser)userByAccount);
                        this.baseContext.setTempTenantId(userByAccount.getTenantId());
                        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
                        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
                        cmd.setTaskId(delegateTask.getId());
                        if (StringUtil.isEmpty((String)skipNode)) {
                            cmd.addTransitVars("skip_node", (Object)"UserTask4");
                        } else {
                            cmd.addTransitVars("skip_node", (Object)skipNode);
                        }
                        cmd.setActionName("agree");
                        BpmTaskActionService bpmTaskActionService = (BpmTaskActionService)AppUtil.getBean(BpmTaskActionService.class);
                        bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    public String getCurrentYear() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
        return LocalDateTime.now().format(formatter);
    }

    public String getCurrentMonth() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
        return LocalDateTime.now().format(formatter);
    }

    public String getFillOrgId(String demId) throws Exception {
        JsonNode orgNode;
        String orgId = "";
        CommonResult result = this.uCFeignService.getFillOrg(demId, "");
        if (result.getState().booleanValue() && (orgNode = (JsonNode)result.getValue()).has("id")) {
            orgId = orgNode.get("id").asText();
        }
        if (StringUtil.isEmpty((String)orgId)) {
            throw new RuntimeException("\u83b7\u53d6\u5f53\u524d\u586b\u5236\u5355\u4f4d\u5931\u8d25\uff01");
        }
        return orgId;
    }

    public Map<String, String> getFillOrg(String demId) throws Exception {
        JsonNode orgNode;
        CommonResult result = this.uCFeignService.getFillOrg(demId, "");
        HashMap<String, String> org = null;
        if (result.getState().booleanValue() && (orgNode = (JsonNode)result.getValue()).has("id")) {
            org = new HashMap<String, String>();
            org.put("id", orgNode.get("id").asText());
            org.put("code", orgNode.get("code").asText());
            org.put("name", orgNode.get("name").asText());
        }
        if (BeanUtils.isEmpty(org)) {
            throw new RuntimeException("\u83b7\u53d6\u5f53\u524d\u586b\u5236\u5355\u4f4d\u5931\u8d25\uff01");
        }
        return org;
    }

    public String getMainPostName(String fileName) {
        ObjectNode orgRels = this.getMainPost();
        if (BeanUtils.isNotEmpty((Object)orgRels) && orgRels.has(fileName)) {
            return orgRels.get(fileName).asText();
        }
        return "";
    }

    public String getCurrentMainPostName() {
        return this.getMainPostName("name");
    }

    public String getCurrentMainPostId() {
        return this.getMainPostName("id");
    }

    public String getCurrentMainPostCode() {
        return this.getMainPostName("code");
    }

    private ObjectNode getMainPost() {
        List orgRels = this.uCFeignService.getPosListByAccount(ContextUtil.getCurrentUser().getAccount());
        ObjectNode orgRel = null;
        if (BeanUtils.isNotEmpty((Object)orgRels)) {
            for (ObjectNode post : orgRels) {
                if (1 != post.get("isMaster").asInt()) continue;
                orgRel = post;
                break;
            }
            if (orgRels.size() == 1 && BeanUtils.isEmpty(orgRel)) {
                orgRel = (ObjectNode)orgRels.get(0);
            }
        }
        return orgRel;
    }

    public String getString(Object object) {
        if (BeanUtils.isNotEmpty((Object)object)) {
            if (object instanceof LocalDateTime) {
                return DateFormatUtil.formaDatetTime((LocalDateTime)((LocalDateTime)object));
            }
            return object.toString();
        }
        return "";
    }

    public IUser getUser(String userId) throws IOException {
        return this.userServiceImpl.getUserById(userId);
    }

    public List<Map<String, Object>> querySql(String datasourceAlias, String sql) {
        List maps = (List)this.databaseContext.switchDS(datasourceAlias, () -> this.commonManager.query(sql), e -> {
            throw new BaseException(e.getMessage());
        });
        return maps;
    }

    public void executeSql(String datasourceAlias, String sql) {
        this.databaseContext.switchDS(datasourceAlias, () -> this.commonManager.execute(sql), e -> {
            throw new BaseException(e.getMessage());
        });
    }

    public String executeSql(String sql) {
        if (StringUtil.isEmpty((String)sql)) {
            throw new BaseException("sql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("scriptImpl_execute_:" + sql);
        JdbcTemplate jdbcTemplate = (JdbcTemplate)AppUtil.getBean((String)"jdbcTemplate");
        if (sql.contains("<#id#>")) {
            try {
                JsonNode boData;
                JsonNode node;
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                if (BeanUtils.isNotEmpty((Object)cmd) && StringUtil.isNotEmpty((String)cmd.getInstId()) && (node = JsonUtil.toJsonNode((String)cmd.getBusData())).fields().hasNext() && BeanUtils.isNotEmpty((Object)(boData = (JsonNode)((Map.Entry)node.fields().next()).getValue())) && BeanUtils.isNotEmpty((Object)boData.get("id_"))) {
                    sql = sql.replace("<#id#>", boData.get("id_").asText());
                }
            }
            catch (Exception e) {
                throw new BaseException("\u8868\u5355\u6570\u636e\u83b7\u53d6\u5931\u8d25");
            }
        }
        try {
            if (StringUtil.isEmpty((String)sql)) {
                return "";
            }
            if (this.isProcedure(sql)) {
                this.executeSqlForUpdate(sql, jdbcTemplate);
                return "";
            }
            List list = jdbcTemplate.queryForList(sql = sql.replaceAll("''", "'"), String.class);
            if (list != null && list.size() > 0) {
                return (String)list.get(0);
            }
            return "";
        }
        catch (Exception e) {
            throw new BaseException("\u8bf7\u68c0\u67e5sql\u8bed\u53e5\u662f\u5426\u6b63\u786e");
        }
    }

    private boolean isProcedure(String sql) {
        if (StringUtil.isEmpty((String)(sql = sql.trim().replace("'", "")))) {
            return false;
        }
        return (sql = sql.toUpperCase()).startsWith("CALL") || sql.startsWith("BEGIN");
    }

    private void executeSqlForUpdate(String sql, JdbcTemplate jdbcTemplate) {
        jdbcTemplate.setQueryTimeout(30);
        jdbcTemplate.execute(sql);
    }

    public boolean isCurrentInRole(String roleAlias) {
        return this.isUserInRole(ContextUtil.getCurrentUser().getAccount(), roleAlias);
    }

    public void executeServiceJob(String data) throws Exception {
        if (StringUtil.isNotEmpty((String)data)) {
            ActionCmd cmd = ContextThreadUtil.getActionCmd();
            Map vars = cmd.getVariables();
            String instId = cmd.getInstId();
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            if (BeanUtils.isNotEmpty((Object)instance)) {
                List oldBoDatas = this.boDataService.getDataByInst((BpmProcessInstance)instance);
                if (BeanUtils.isEmpty((Object)oldBoDatas)) {
                    throw new RuntimeException(String.format("\u6839\u636e\u5b9e\u4f8bid:%s\u672a\u67e5\u627e\u5230\u8868\u5355\u6570\u636e", instId));
                }
                BpmDelegateTask delegateTask = null;
                DefaultBpmTask bpmTask = null;
                if (BeanUtils.isNotEmpty((Object)cmd.getTransitVars("bpmTask_")) && BeanUtils.isNotEmpty((Object)(bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_"))) && StringUtil.isNotZeroEmpty((String)bpmTask.getTaskId())) {
                    delegateTask = this.natTaskService.getByTaskId(bpmTask.getTaskId());
                }
                ObjectNode jsonObject = BoDataUtil.hanlerData((BpmProcessInstance)instance, (String)"", (List)oldBoDatas);
                JsonNode jsonNode = JsonUtil.toJsonNode((String)data);
                if (jsonNode.isArray()) {
                    ArrayNode excutorAry = (ArrayNode)jsonNode;
                    for (JsonNode item : excutorAry) {
                        Boolean isSuccess = true;
                        try {
                            String alias = item.get("alias").asText();
                            ArrayNode inputAry = (ArrayNode)item.get("inputs");
                            for (JsonNode input : inputAry) {
                                ObjectNode objectNode = (ObjectNode)input;
                                if (!BeanUtils.isNotEmpty((Object)objectNode.get("value"))) continue;
                                String value = objectNode.get("value").asText();
                                if (value.contains(".")) {
                                    String[] obj = value.split("\\.");
                                    if (obj.length <= 0) continue;
                                    String defCode = obj[0];
                                    String field = obj[1];
                                    Iterator iterator = jsonObject.fields();
                                    while (iterator.hasNext()) {
                                        Map.Entry next = (Map.Entry)iterator.next();
                                        String objKey = (String)next.getKey();
                                        ObjectNode ywdxObj = (ObjectNode)next.getValue();
                                        if (!objKey.equals(defCode) || !BeanUtils.isNotEmpty((Object)ywdxObj) || !BeanUtils.isNotEmpty((Object)ywdxObj.get(field))) continue;
                                        objectNode.set("value", ywdxObj.get(field));
                                    }
                                    continue;
                                }
                                if (!BeanUtils.isNotEmpty(vars.get(value))) continue;
                                objectNode.set("value", JsonUtil.toJsonNode(vars.get(value)));
                            }
                            String paramData = JsonUtil.toJsonString((Object)inputAry);
                            String type = item.get("type").asText();
                            Object result = null;
                            if ("interface".equals(type)) {
                                result = this.portalFeignService.executeIntefaceJob(alias, null, null, paramData);
                            } else if ("service".equals(type)) {
                                result = this.portalFeignService.executeServiceJob(alias, paramData);
                            }
                            if (BeanUtils.isNotEmpty(result)) {
                                JsonNode resultNode = JsonUtil.toJsonNode((Object)result);
                                ArrayNode outputAry = (ArrayNode)item.get("outputs");
                                for (JsonNode output : outputAry) {
                                    String value;
                                    String key = output.get("key").asText();
                                    if (!BeanUtils.isNotEmpty((Object)output.get("value"))) continue;
                                    JsonNode keyData = null;
                                    if (resultNode.isArray()) {
                                        ArrayNode resultAry = (ArrayNode)resultNode;
                                        for (JsonNode execute : resultAry) {
                                            if (!BeanUtils.isNotEmpty((Object)execute.get(key))) continue;
                                            keyData = execute.get(key);
                                            break;
                                        }
                                    } else if (BeanUtils.isNotEmpty((Object)resultNode.get(key))) {
                                        keyData = resultNode.get(key);
                                    }
                                    if ((value = output.get("value").asText()).contains(".")) {
                                        String[] obj = value.split("\\.");
                                        if (obj.length <= 0) continue;
                                        String defCode = obj[0];
                                        String field = obj[1];
                                        Iterator iterator = jsonObject.fields();
                                        while (iterator.hasNext()) {
                                            Map.Entry next = (Map.Entry)iterator.next();
                                            String objKey = (String)next.getKey();
                                            ObjectNode ywdxObj = (ObjectNode)next.getValue();
                                            if (!objKey.equals(defCode) || !BeanUtils.isNotEmpty((Object)ywdxObj) || !BeanUtils.isNotEmpty((Object)ywdxObj.get(field)) || !BeanUtils.isNotEmpty((Object)keyData)) continue;
                                            ywdxObj.set(field, JsonUtil.toJsonNode((Object)keyData));
                                        }
                                        continue;
                                    }
                                    if (!vars.containsKey(value) || !BeanUtils.isNotEmpty((Object)keyData) || !BeanUtils.isNotEmpty((Object)delegateTask)) continue;
                                    delegateTask.setVariable(value, (Object)JsonUtil.toJsonNode((Object)keyData));
                                }
                                BusDataUtil.updateBoData((DefaultBpmProcessInstance)instance, (String)"", (String)JsonUtil.toJson((Object)jsonObject));
                                cmd.setBusData(JsonUtil.toJson((Object)jsonObject));
                                this.buildServiceLog(isSuccess, item, instance, bpmTask, JsonUtil.toJsonString((Object)result));
                                continue;
                            }
                            isSuccess = false;
                            this.buildServiceLog(isSuccess, item, instance, bpmTask, null);
                        }
                        catch (Exception e) {
                            isSuccess = false;
                            String response = ExceptionUtils.getRootCauseMessage((Throwable)e);
                            this.buildServiceLog(isSuccess, item, instance, bpmTask, response);
                        }
                    }
                }
            }
        }
    }

    private void buildServiceLog(Boolean isSuccess, JsonNode item, DefaultBpmProcessInstance instance, DefaultBpmTask bpmTask, String response) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String alias = item.get("alias").asText();
        String type = item.get("type").asText();
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("isSuccess", isSuccess != false ? "1" : "0");
        objectNode.put("alias", alias);
        objectNode.put("type", type);
        objectNode.put("subject", instance.getSubject());
        objectNode.put("procDefId", instance.getProcDefId());
        objectNode.put("procDefKey", instance.getProcDefKey());
        objectNode.put("procInstId", instance.getId());
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(instance.getProcDefId());
        if (BeanUtils.isNotEmpty((Object)bpmDefinition)) {
            objectNode.put("procDefName", bpmDefinition.getName());
        }
        if (BeanUtils.isNotEmpty((Object)bpmTask)) {
            objectNode.put("taskId", bpmTask.getId());
            objectNode.put("nodeId", bpmTask.getNodeId());
        }
        objectNode.put("userId", user.getUserId());
        objectNode.put("userAccount", user.getAccount());
        objectNode.put("userName", user.getFullname());
        objectNode.putPOJO("callTime", (Object)DateUtil.getCurrentDate());
        objectNode.put("response", response);
        this.portalFeignService.saveServiceLog(objectNode);
    }

    @Cacheable(value={"eip:uc:current_user_group_id"}, key="#userId", firstCache=@FirstCache(expireTime=100, timeUnit=TimeUnit.DAYS))
    public String getCurrentGroupIdFromCache(String userId) {
        return null;
    }

    public boolean subFieldContain(JsonNode subArray, String field, String op, Object value, String dataType) {
        return SubCalcUtils.subFieldContain(subArray, field, op, value, dataType);
    }

    public boolean subFieldNotContain(JsonNode subArray, String field, String op, Object value, String dateType) {
        return SubCalcUtils.subFieldNotContain(subArray, field, op, value, dateType);
    }
}

