/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.service;

import com.hotent.base.util.AppUtil;
import com.hotent.runtime.service.RevokeService;
import com.hotent.runtime.service.impl.BeforeSignRevokeService;
import com.hotent.runtime.service.impl.ParallelApproveRevokeService;
import com.hotent.runtime.service.impl.ParallelRevokeService;
import com.hotent.runtime.service.impl.SequentialRevokeService;
import java.util.HashMap;
import java.util.Map;

public class RevokeServiceFactory {
    private static final Map<String, RevokeService> map = new HashMap<String, RevokeService>();

    public static RevokeService getRevokeService(String signType) {
        RevokeService revokeService = map.get(signType);
        if (revokeService == null) {
            switch (signType) {
                case "Parallel": {
                    revokeService = (RevokeService)AppUtil.getBean(ParallelRevokeService.class);
                    break;
                }
                case "ParallelApprove": {
                    revokeService = (RevokeService)AppUtil.getBean(ParallelApproveRevokeService.class);
                    break;
                }
                case "Sequential": {
                    revokeService = (RevokeService)AppUtil.getBean(SequentialRevokeService.class);
                    break;
                }
                case "BeforeSign": {
                    revokeService = (RevokeService)AppUtil.getBean(BeforeSignRevokeService.class);
                }
            }
        }
        return revokeService;
    }
}

