/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.model.form.FormCategory;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.runtime.service.FormValueService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FormValueServiceImpl
implements FormValueService {
    private static final String ROOT_ADDRESS = "rootAddress";
    private static final String SYS_CODE = "sysCode";
    private static final String URL_SUFFIX = "Url";
    private static Pattern regex = Pattern.compile("\\{(\\w+)\\}", 66);

    @Override
    public void setFormValue(FormModel formModel, String action, BpmProcessInstance instance) {
        if (BeanUtils.isEmpty((Object)formModel)) {
            return;
        }
        if (!FormCategory.FRAME.equals((Object)formModel.getType())) {
            return;
        }
        String formKey = formModel.getFormValue();
        Short tokenAuth = formModel.getTokenAuth();
        String url = null;
        url = FluentUtil.isHttpUrl((String)formKey) ? formKey : FormValueServiceImpl.getUrlByFormKey(action, formKey);
        if (null != instance) {
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put("pk", instance.getBizKey());
            vars.put("instId", instance.getId());
            Object nodeId = ContextThreadUtil.getCommuVar((String)"nodeId", null);
            Object nodeName = ContextThreadUtil.getCommuVar((String)"nodeName", null);
            if (BeanUtils.isNotEmpty((Object)nodeId)) {
                vars.put("nodeId", nodeId.toString());
            }
            if (BeanUtils.isNotEmpty((Object)nodeName)) {
                vars.put("nodeName", nodeName.toString());
            }
            url = FormValueServiceImpl.replaceStr(url, vars);
        }
        if (FormModel.TOKEN_AUTH_YES.equals(tokenAuth)) {
            url = FormValueServiceImpl.appendToken(url);
        }
        formModel.setFormValue(url);
    }

    private static String appendToken(String url) {
        url = url.trim();
        int length = url.length();
        int indexOf = url.indexOf("?");
        String token = HttpUtil.getToken();
        if (length < 1 || StringUtil.isEmpty((String)token)) {
            return url;
        }
        url = indexOf > -1 ? (indexOf + 1 == length ? String.format("%stoken=%s", url, token) : (url.charAt(length - 1) == '&' ? String.format("%stoken=%s", url, token) : String.format("%s&token=%s", url, token))) : String.format("%s?token=%s", url, token);
        return url;
    }

    private static String getUrlByFormKey(String action, String formKey) {
        String url = null;
        FormFeignService formRestfulService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        ObjectNode urlFormByKey = formRestfulService.getUrlFormByKey(formKey);
        Assert.notNull((Object)urlFormByKey, (String)String.format("url\u8868\u5355\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", formKey));
        PortalFeignService bean = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        CommonResult commonResult = bean.getBizSystemByCode(JsonUtil.getString((JsonNode)urlFormByKey, (String)SYS_CODE));
        String formValue = "";
        try {
            formValue = JsonUtil.getString((JsonNode)JsonUtil.toJsonNode((Object)commonResult.getValue()), (String)ROOT_ADDRESS, (String)"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (urlFormByKey.hasNonNull(action + URL_SUFFIX)) {
            url = JsonUtil.getString((JsonNode)urlFormByKey, (String)(action + URL_SUFFIX), (String)"");
        } else {
            url = JsonUtil.getString((JsonNode)urlFormByKey, (String)(action + URL_SUFFIX), (String)"");
            if (StringUtil.isEmpty((String)url)) {
                throw new BaseException("url\u8868\u5355\u5f85\u529e\u5730\u5740\u4e3a\u7a7a\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        if (!url.startsWith("/")) {
            url = "/".concat(url);
        }
        return formValue + url;
    }

    private static String replaceStr(String str, Map<String, String> map) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        Matcher regexMatcher = regex.matcher(str);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            String val = map.get(key);
            if (val == null) {
                val = "";
            }
            str = str.replace(toReplace, val);
        }
        return str;
    }
}

