/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.defxml.entity.ext.DecideType;
import com.hotent.bpm.engine.form.BpmFormFactory;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefActManager;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmInstFormManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmDefAct;
import com.hotent.bpm.persistence.model.BpmDefUser;
import com.hotent.bpm.persistence.model.BpmLeaderTask;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.params.AssignParamObject;
import com.hotent.runtime.params.DoNextParamObject;
import com.hotent.runtime.params.TaskDetailVo;
import com.hotent.runtime.service.TaskService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImp
implements TaskService {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BaseContext baseContext;
    @Resource
    IFlowManager iFlowService;
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefActManager bpmDefActManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmInstFormManager bpmInstFormManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public PageList<DefaultBpmTask> getLeaderTodoList(QueryFilter queryFilter) throws Exception {
        this.handleTodoQueryFilter((QueryFilter<DefaultBpmTask>)queryFilter);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getLeaderTodoList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @Override
    public Map<String, BpmLeaderTask> getLeaderTodoCard(QueryFilter queryFilter, Integer size) throws Exception {
        this.handleTodoQueryFilter((QueryFilter<DefaultBpmTask>)queryFilter);
        return this.iFlowService.getLeaderTodoCard(this.baseContext.getCurrentUserAccout(), queryFilter, size);
    }

    @Override
    public PageList<DefaultBpmTask> getTodoList(QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        this.handleTodoQueryFilter(queryFilter);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), queryFilter).get();
        return pageList;
    }

    private void handleTodoQueryFilter(QueryFilter<DefaultBpmTask> queryFilter) {
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            for (QueryField field : queryFilter.getQuerys()) {
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter defFilter = QueryFilter.build();
                    defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                    PageList query = this.bpmDefinitionManager.query(defFilter);
                    ArrayList<String> defKeys = new ArrayList<String>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                    continue;
                }
                fields.add(field);
            }
            queryFilter.setQuerys(fields);
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
    }

    @Override
    public PageList<DefaultBpmTask> listJson(QueryFilter queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            this.setNoAuthFilter(queryFilter);
        }
        queryFilter.addFilter("task.status_", (Object)"COPYTO", QueryOP.NOT_EQUAL, FieldRelation.AND);
        PageList query = this.bpmTaskManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)query) || BeanUtils.isEmpty((Object)query.getRows())) {
            return query;
        }
        HashMap cMap = new HashMap();
        for (DefaultBpmTask task : query.getRows()) {
            if (!StringUtil.isEmpty((String)task.getAssigneeName())) continue;
            cMap.put(task.getTaskId(), new ArrayList());
        }
        Set keySet = cMap.keySet();
        if (BeanUtils.isNotEmpty(keySet)) {
            QueryFilter cQueryFilter = QueryFilter.build();
            cQueryFilter.addFilter("task_id_", (Object)StringUtil.join(keySet, (String)","), QueryOP.IN);
            BpmTaskCandidateManager candidateManager = (BpmTaskCandidateManager)AppUtil.getBean(BpmTaskCandidateManager.class);
            PageList candidateQuery = candidateManager.query(cQueryFilter);
            if (BeanUtils.isEmpty((Object)candidateQuery) || BeanUtils.isEmpty((Object)candidateQuery.getRows())) {
                return query;
            }
            for (DefaultBpmTaskCandidate candidate : candidateQuery.getRows()) {
                ((List)cMap.get(candidate.getTaskId())).add(candidate);
            }
            for (DefaultBpmTask task : query.getRows()) {
                if (!cMap.containsKey(task.getTaskId()) || !BeanUtils.isNotEmpty(cMap.get(task.getTaskId()))) continue;
                List list = (List)cMap.get(task.getTaskId());
                ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
                for (DefaultBpmTaskCandidate candidate : list) {
                    identityList.add(new DefaultBpmIdentity(candidate.getExecutor(), "", candidate.getType()));
                }
                task.setIdentityList(identityList);
            }
        }
        return query;
    }

    @Override
    public ArrayNode getCandidatesListByTaskId(String taskId) throws Exception {
        BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
        List bpmIdentities = bpmTaskService.getTaskCandidates(taskId);
        ArrayNode bpmIdentitiesArray = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isEmpty((Object)bpmIdentities)) {
            return bpmIdentitiesArray;
        }
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        for (BpmIdentity identity : bpmIdentities) {
            ObjectNode identityObj = (ObjectNode)JsonUtil.toJsonNode((Object)((DefaultBpmIdentity)identity));
            bpmIdentitiesArray.add((JsonNode)identityObj);
            if ("user".equals(identity.getType())) continue;
            ArrayList<BpmIdentity> tempList = new ArrayList<BpmIdentity>();
            tempList.add(identity);
            List extractUser = bpmIdentityExtractService.extractUser(tempList);
            if (!BeanUtils.isNotEmpty((Object)extractUser)) continue;
            ArrayList<String> userNames = new ArrayList<String>();
            ArrayList<String> userIds = new ArrayList<String>();
            for (IUser iUser : extractUser) {
                userNames.add(iUser.getFullname());
                userIds.add(iUser.getUserId());
            }
            identityObj.put("userNames", StringUtil.join(userNames, (String)","));
            identityObj.put("userIds", StringUtil.join(userIds, (String)","));
        }
        return bpmIdentitiesArray;
    }

    @Override
    public CommonResult<HashMap<String, Object>> batchHandle(Map<String, Object> requestMap) throws Exception {
        String taskIds = (String)requestMap.get("taskIds");
        String action = (String)requestMap.get("action");
        String opinion = (String)requestMap.get("opinion");
        Map vars = (Map)requestMap.get("vars");
        String[] listIds = taskIds.split(",");
        String account = ContextUtil.getCurrentUser().getAccount();
        ArrayList<DefaultBpmTask> unHandleList = new ArrayList<DefaultBpmTask>();
        ArrayList<DefaultBpmTask> completeList = new ArrayList<DefaultBpmTask>();
        ArrayList unAuthList = new ArrayList();
        ArrayList<DefaultBpmTask> failedList = new ArrayList<DefaultBpmTask>();
        HashMap<String, String> failedMsgMap = new HashMap<String, String>();
        for (String taskId : listIds) {
            BpmNodeDef curNodeProperties = this.iFlowService.getCurNodeProperties(taskId, "", "");
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            BpmProcessInstance processInstance = this.bpmInstService.getProcessInstance(defaultBpmTask.getProcInstId());
            NodeProperties properties = curNodeProperties.getLocalProperties();
            if (BeanUtils.isNotEmpty((Object)curNodeProperties.getNodeProperties())) {
                properties = (NodeProperties)curNodeProperties.getNodeProperties().get(0);
            }
            if (!properties.isBatchHandleRevoke()) {
                unHandleList.add(defaultBpmTask);
                continue;
            }
            String procInstId = defaultBpmTask.getProcInstId();
            String formCategory = this.bpmInstFormManager.getInstFormCategory(defaultBpmTask.getProcInstId(), defaultBpmTask.getNodeId());
            DoNextParamObject doNextParamObject = new DoNextParamObject();
            doNextParamObject.setVars(vars);
            doNextParamObject.setAccount(account);
            doNextParamObject.setTaskId(taskId);
            doNextParamObject.setOpinion(opinion);
            doNextParamObject.setActionName(action);
            doNextParamObject.setAgentLeaderId("0");
            doNextParamObject.setJumpType(properties.getJumpType());
            if (action.equals(DecideType.AGREE.value())) {
                BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC);
                FormModel formModel = bpmFormService.getByDefId(defaultBpmTask.getProcDefId(), defaultBpmTask.getTaskId(), processInstance, true);
                if (BeanUtils.isNotEmpty((Object)formModel)) {
                    doNextParamObject.setFormKey(formModel.getFormKey());
                }
            } else {
                doNextParamObject.setBackHandMode((String)requestMap.get("backHandMode"));
            }
            doNextParamObject.setNodeUsers("[]");
            doNextParamObject.setDestination("");
            doNextParamObject.setFormType(formCategory);
            doNextParamObject.setFiles("");
            doNextParamObject.setZfiles("");
            if (StringUtil.isNotEmpty((String)properties.getOpinionField())) {
                String boData = this.handleSetOpinionText(properties.getOpinionField(), defaultBpmTask, opinion, properties.isAppendOpinion());
                doNextParamObject.setData(Base64.getBase64((String)boData));
            }
            try {
                CommonResult<String> result = this.iFlowService.complete(doNextParamObject).get();
                if (result.getState().booleanValue()) {
                    completeList.add(defaultBpmTask);
                    continue;
                }
                failedList.add(defaultBpmTask);
                failedMsgMap.put(defaultBpmTask.getTaskId(), result.getMessage());
            }
            catch (Exception e) {
                failedList.add(defaultBpmTask);
                failedMsgMap.put(defaultBpmTask.getTaskId(), e.getMessage());
            }
        }
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        result.put("notAuth", unAuthList);
        result.put("complete", completeList);
        result.put("unHandleList", unHandleList);
        result.put("failedList", failedList);
        result.put("failedMsg", failedMsgMap);
        return new CommonResult(true, "\u5904\u7406\u5b8c\u6210", result);
    }

    private String handleSetOpinionText(String opinionField, DefaultBpmTask bpmTask, String opinion, boolean appendOpinion) throws Exception {
        String opinionVal;
        String[] split = opinionField.split("\\.");
        if (split.length != 2) {
            throw new BaseException("\u610f\u89c1\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef");
        }
        BoDataService bean = (BoDataService)AppUtil.getBean(BoDataService.class);
        DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)bpmTask.getProcInstId()));
        List dataByInst = bean.getDataByInst((BpmProcessInstance)inst);
        ObjectNode boData = (ObjectNode)BoDataUtil.hanlerData((List)dataByInst);
        String boDefAlias = split[0];
        String field = split[1];
        ObjectNode mainData = (ObjectNode)boData.get(boDefAlias);
        String userName = ContextUtil.getCurrentUser().getFullname();
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String tail = String.format("\u5ba1\u6838\u4eba\uff1a%s  \u5ba1\u6838\u65e5\u671f\uff1a%s", userName, now);
        if (appendOpinion) {
            opinionVal = String.format("\u5ba1\u6838\u610f\u89c1\uff1a %s %s\n", opinion, tail);
        } else {
            String preVal = "";
            String oldVal = JsonUtil.getString((JsonNode)mainData, (String)field, (String)"");
            if (StringUtil.isNotEmpty((String)oldVal) && !"<p><br/></p>".equals(oldVal.trim())) {
                preVal = oldVal;
            }
            opinionVal = StringUtil.isNotEmpty((String)preVal) && !preVal.contains("\n") ? String.format("\u5ba1\u6838\u610f\u89c1\uff1a %s %s %s\n", preVal, opinion, tail) : String.format("%s\u5ba1\u6838\u610f\u89c1\uff1a %s %s\n", preVal, opinion, tail);
        }
        mainData.put(field, opinionVal);
        return JsonUtil.toJson((Object)boData);
    }

    @Override
    public CommonResult<DefaultBpmTask> nextTask(String defId, String defKey) throws Exception {
        if (StringUtil.isEmpty((String)defKey)) {
            DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)defId));
            if (BeanUtils.isEmpty((Object)defaultBpmDefinition)) {
                throw new BaseException("\u4e0b\u4e00\u4e2a\u4efb\u52a1\u83b7\u53d6\u5931\u8d25\uff1a\u8282\u70b9\u4e3a\u7a7a");
            }
            defKey = defaultBpmDefinition.getDefKey();
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("bt.PROC_DEF_KEY_", (Object)defKey, QueryOP.EQUAL, FieldRelation.AND);
        PageBean bean = new PageBean(Integer.valueOf(1), Integer.valueOf(1));
        queryFilter.setPageBean(bean);
        PageList<DefaultBpmTask> byDefKey = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), (QueryFilter<DefaultBpmTask>)queryFilter).get();
        if (!byDefKey.getRows().isEmpty()) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", byDefKey.getRows().get(0));
        }
        return new CommonResult(true, "\u672a\u83b7\u53d6\u5230\u4efb\u4f55\u5f85\u529e", null);
    }

    @Override
    public CommonResult<String> delegate(AssignParamObject assignParamObject, HttpServletResponse response, Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)assignParamObject.getTaskId());
        BaseActionCmd cmd = new BaseActionCmd();
        cmd.setFormKey(assignParamObject.getFormKey());
        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            if (leaderId.get().equals(assignParamObject.getUserId())) {
                throw new RuntimeException("\u4ee3\u9886\u5bfc\u8f6c\u529e\u65f6\u4e0d\u80fd\u518d\u8f6c\u529e\u7ed9\u9886\u5bfc\uff01");
            }
        }
        return this.iFlowService.delegate(assignParamObject);
    }

    @Override
    public Object nodeOpinion(Optional<String> defId, Optional<String> instId, String nodeId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)nodeId)) {
            String[] split;
            for (String id : split = nodeId.split(",")) {
                Object nodeOpinion = this.iFlowService.nodeOpinion(defId.orElse(""), instId.orElse(""), id);
                if (split.length == 1) {
                    return nodeOpinion;
                }
                map.put(id, nodeOpinion);
            }
        }
        return map;
    }

    @Override
    public TaskDetailVo getButtonsBytaskId(String taskId, Optional<String> leaderId) throws Exception {
        TaskDetailVo buttonsBytaskId = this.iFlowService.getButtonsBytaskId(taskId);
        if (BeanUtils.isNotEmpty(buttonsBytaskId.getButtons())) {
            Iterator<Button> iterator = buttonsBytaskId.getButtons().iterator();
            while (iterator.hasNext()) {
                Button button = iterator.next();
                String btnName = button.getAlias();
                if (!StringUtil.isNotZeroEmpty((String)leaderId.orElse("")) || btnName.equals("agree") || btnName.equals("reject") || btnName.equals("lockUnlock")) continue;
                iterator.remove();
            }
            return buttonsBytaskId;
        }
        return new TaskDetailVo();
    }

    @Override
    public CommonResult<List<String>> filterUnBatchable(String taskIds) {
        if (StringUtil.isEmpty((String)taskIds)) {
            return new CommonResult(true, "", new ArrayList());
        }
        ArrayList<String> filterResult = new ArrayList<String>();
        for (String taskId : taskIds.split(",")) {
            try {
                BpmNodeDef curNodeProperties = this.iFlowService.getCurNodeProperties(taskId, "", "");
                NodeProperties localProperties = curNodeProperties.getLocalProperties();
                if (!localProperties.isBatchHandleRevoke()) continue;
                filterResult.add(taskId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new CommonResult(true, "", filterResult);
    }

    private void setNoAuthFilter(QueryFilter queryFilter) {
        String ids = "";
        List list = this.bpmDefUserManager.getByUserMap("bpmDef", null);
        IGroup ugroup = ContextUtil.getCurrentGroup();
        if (BeanUtils.isNotEmpty((Object)list)) {
            HashMap<String, String> userRightMap = new HashMap<String, String>();
            for (BpmDefUser bpmDefUser : list) {
                String type;
                List bpmDefAct;
                if (StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg())) {
                    bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                    for (BpmDefAct bpm : bpmDefAct) {
                        type = bpm.getType();
                        if ("1".equals(type)) {
                            userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg()) ? StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(bpmDefUser.getAuthOrg().split(",")))) : null);
                        }
                        if (!"2".equals(type)) continue;
                        List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                        for (String defKey : defKeys) {
                            userRightMap.put(defKey, StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg()) ? StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(bpmDefUser.getAuthOrg().split(",")))) : null);
                        }
                    }
                    continue;
                }
                bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                for (BpmDefAct bpm : bpmDefAct) {
                    type = bpm.getType();
                    String orgId = null;
                    if (StringUtil.isNotEmpty((String)bpm.getRightContent())) {
                        try {
                            ObjectNode rightJson = (ObjectNode)JsonUtil.toJsonNode((String)bpm.getRightContent());
                            if (JsonUtil.getBoolean((ObjectNode)rightJson, (String)"i_org", (boolean)false)) {
                                orgId = BeanUtils.isNotEmpty((Object)ugroup) ? ugroup.getGroupId() : "-1";
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    bpm.getRightContent();
                    if ("1".equals(type)) {
                        userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty(orgId) ? "'" + orgId + "'" : null);
                    }
                    if (!"2".equals(type)) continue;
                    List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                    for (String defKey : defKeys) {
                        userRightMap.put(defKey, StringUtil.isNotEmpty((String)orgId) ? "'" + orgId + "'" : null);
                    }
                }
            }
            if (BeanUtils.isNotEmpty(userRightMap)) {
                Map maps = this.ucFeignService.getChildrenIds(userRightMap);
                Map rightMap = StringUtil.getMapStringByMapList((Map)maps);
                userRightMap.putAll(rightMap);
                List instanceIds = this.bpmProcessInstanceManager.getStringListByRightMap(userRightMap);
                if (BeanUtils.isNotEmpty((Object)instanceIds)) {
                    for (String id : instanceIds) {
                        ids = ids + id + ",";
                    }
                }
            }
        }
        queryFilter.addParams("instanceIds", (Object)ids);
    }
}

