/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.math.BigDecimal;

public class SubCalcUtils {
    private static final String OP_EQUALS = "1";
    private static final String OP_NOT_EQUALS = "2";
    private static final String OP_GREAT_THAN = "3";
    private static final String OP_LESS_THAN = "4";
    private static final String OP_GREAT_EQUALS = "7";
    private static final String OP_LESS_EQUALS = "8";
    private static final String OP_CONTAINS = "9";

    public static boolean subFieldContain(JsonNode subArray, String field, String op, Object value, String dataType) {
        if (!(subArray instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)subArray;
        if (arrayNode.isEmpty()) {
            return false;
        }
        for (JsonNode node : arrayNode) {
            ObjectNode row = (ObjectNode)node;
            boolean rowResult = SubCalcUtils.subRowCalc(row, field, op, value, dataType);
            if (!rowResult) continue;
            return true;
        }
        return false;
    }

    public static boolean subFieldNotContain(JsonNode subArray, String field, String op, Object value, String dateType) {
        if (!(subArray instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)subArray;
        if (arrayNode.isEmpty()) {
            return false;
        }
        for (JsonNode node : arrayNode) {
            ObjectNode row = (ObjectNode)node;
            boolean rowResult = SubCalcUtils.subRowCalc(row, field, op, value, dateType);
            if (rowResult) continue;
            return true;
        }
        return false;
    }

    private static boolean subRowCalc(ObjectNode row, String field, String op, Object value, String dateType) {
        switch (dateType) {
            case "string": {
                return SubCalcUtils.subRowStringCalc(row, field, op, null == value ? "" : value.toString());
            }
            case "number": {
                return SubCalcUtils.subRowNumberCalc(row, field, op, null == value ? BigDecimal.ZERO : value);
            }
            case "date": {
                return SubCalcUtils.subRowDateCalc(row, field, op, null == value ? "" : value.toString());
            }
        }
        throw new IllegalArgumentException("unknown date type");
    }

    private static boolean subRowDateCalc(ObjectNode row, String field, String op, String value) {
        String dateValue = JsonUtil.getString((JsonNode)row, (String)field, (String)"");
        if (OP_CONTAINS.equals(op)) {
            return SubCalcUtils.subRowDateRegionCalc(dateValue, value);
        }
        int diff = dateValue.compareTo(value);
        return SubCalcUtils.getSubRowCalcResult(diff, op);
    }

    private static boolean subRowDateRegionCalc(String dateValue, String dateRegion) {
        if (StringUtil.isEmpty((String)dateRegion) || StringUtil.isEmpty((String)dateValue)) {
            return false;
        }
        String[] split = dateRegion.split(",");
        if (2 == split.length) {
            return dateValue.compareTo(split[0]) >= 0 && dateValue.compareTo(split[1]) <= 0;
        }
        throw new IllegalArgumentException("illegal date argument, the date region must contains one comma");
    }

    private static boolean subRowNumberCalc(ObjectNode row, String field, String op, Object value) {
        BigDecimal curValue;
        BigDecimal decimalValue;
        if (value instanceof BigDecimal) {
            decimalValue = (BigDecimal)value;
        } else if (value instanceof Integer) {
            decimalValue = BigDecimal.valueOf(((Integer)value).intValue());
        } else if (value instanceof Long) {
            decimalValue = BigDecimal.valueOf((Long)value);
        } else if (value instanceof Double) {
            decimalValue = BigDecimal.valueOf((Double)value);
        } else {
            if (value instanceof String && OP_CONTAINS.equals(op)) {
                return SubCalcUtils.calcNumberContains(value.toString(), row.get(field));
            }
            throw new IllegalArgumentException("unknown value type");
        }
        JsonNode fieldNode = row.get(field);
        try {
            curValue = fieldNode.decimalValue();
        }
        catch (Exception e) {
            curValue = BigDecimal.ZERO;
        }
        int diff = curValue.compareTo(decimalValue);
        return SubCalcUtils.getSubRowCalcResult(diff, op);
    }

    private static boolean getSubRowCalcResult(int diff, String op) {
        switch (op) {
            case "1": {
                return diff == 0;
            }
            case "2": {
                return diff != 0;
            }
            case "3": {
                return diff > 0;
            }
            case "4": {
                return diff < 0;
            }
            case "7": {
                return diff >= 0;
            }
            case "8": {
                return diff <= 0;
            }
        }
        throw new IllegalArgumentException("unknown operation type");
    }

    private static boolean calcNumberContains(String valueStr, JsonNode node) {
        BigDecimal curValue;
        String[] split = valueStr.split(",");
        try {
            curValue = node.decimalValue();
        }
        catch (Exception e) {
            curValue = BigDecimal.ZERO;
        }
        for (String numberStr : split) {
            BigDecimal decimal = BigDecimal.valueOf(Long.parseLong(numberStr));
            if (curValue.compareTo(decimal) != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean subRowStringCalc(ObjectNode row, String field, String op, String value) {
        String fieldValue = JsonUtil.getString((JsonNode)row, (String)field, (String)"");
        switch (op) {
            case "1": {
                return fieldValue.equals(value);
            }
            case "2": {
                return !fieldValue.equals(value);
            }
            case "9": {
                String[] split;
                for (String s : split = value.split(",")) {
                    if (!fieldValue.equals(s)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("unknown operation type");
    }
}

