/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.draft06;

import com.taobao.api.internal.toplink.embedded.websocket.frame.draft06.FrameBuilderDraft06;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft06.FrameDraft06;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft06.FrameHeaderDraft06;
import java.io.UnsupportedEncodingException;

public class TextFrame
extends FrameDraft06 {
    private String convertedString;

    public TextFrame(FrameHeaderDraft06 header, byte[] bodyData) {
        super(header, bodyData);
    }

    public TextFrame(String str) {
        byte[] body = TextFrame.convertStringToByteArray(str);
        this.setHeader(FrameBuilderDraft06.createFrameHeader(body, false, FrameBuilderDraft06.Opcode.TEXT_FRAME));
        this.setContents(body);
    }

    private static byte[] convertStringToByteArray(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        if (this.convertedString == null) {
            try {
                this.convertedString = new String(this.contents, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.convertedString = "";
            }
        }
        return this.convertedString;
    }
}

