/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.cell.setters;

import cn.hutool.poi.excel.cell.CellSetter;
import cn.hutool.poi.excel.cell.setters.BooleanCellSetter;
import cn.hutool.poi.excel.cell.setters.CalendarCellSetter;
import cn.hutool.poi.excel.cell.setters.CharSequenceCellSetter;
import cn.hutool.poi.excel.cell.setters.DateCellSetter;
import cn.hutool.poi.excel.cell.setters.HyperlinkCellSetter;
import cn.hutool.poi.excel.cell.setters.NullCellSetter;
import cn.hutool.poi.excel.cell.setters.NumberCellSetter;
import cn.hutool.poi.excel.cell.setters.RichTextCellSetter;
import cn.hutool.poi.excel.cell.setters.TemporalAccessorCellSetter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;

public class CellSetterFactory {
    public static CellSetter createCellSetter(Object value2) {
        if (null == value2) {
            return NullCellSetter.INSTANCE;
        }
        if (value2 instanceof CellSetter) {
            return (CellSetter)value2;
        }
        if (value2 instanceof Date) {
            return new DateCellSetter((Date)value2);
        }
        if (value2 instanceof TemporalAccessor) {
            return new TemporalAccessorCellSetter((TemporalAccessor)value2);
        }
        if (value2 instanceof Calendar) {
            return new CalendarCellSetter((Calendar)value2);
        }
        if (value2 instanceof Boolean) {
            return new BooleanCellSetter((Boolean)value2);
        }
        if (value2 instanceof RichTextString) {
            return new RichTextCellSetter((RichTextString)value2);
        }
        if (value2 instanceof Number) {
            return new NumberCellSetter((Number)value2);
        }
        if (value2 instanceof Hyperlink) {
            return new HyperlinkCellSetter((Hyperlink)value2);
        }
        return new CharSequenceCellSetter(value2.toString());
    }
}

