/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

final class FieldWriterListMethod<T>
extends FieldWriterList<T> {
    FieldWriterListMethod(String fieldName, Type itemType, int ordinal, long features, String format, String label, Field field, Method method, Type fieldType, Class fieldClass) {
        super(fieldName, itemType, ordinal, features, format, label, fieldType, fieldClass, field, method);
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        List value2;
        try {
            value2 = (List)this.getFieldValue((Object)object);
        }
        catch (JSONException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        long features = this.features | jsonWriter.getFeatures();
        if (value2 == null) {
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeArrayNull();
                return true;
            }
            return false;
        }
        if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) != 0L && value2.isEmpty()) {
            return false;
        }
        String refPath = jsonWriter.setPath(this, (Object)value2);
        if (refPath != null) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeReference(refPath);
            jsonWriter.popPath(value2);
            return true;
        }
        if (this.itemType == String.class) {
            this.writeListStr(jsonWriter, true, value2);
        } else {
            this.writeList(jsonWriter, value2);
        }
        jsonWriter.popPath(value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        List value2 = (List)this.getFieldValue((Object)object);
        if (value2 == null) {
            jsonWriter.writeNull();
            return;
        }
        this.writeListValue(jsonWriter, value2);
    }
}

