/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.mutable;

import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.util.NumberUtil;

public class MutableFloat
extends Number
implements Comparable<MutableFloat>,
Mutable<Number> {
    private static final long serialVersionUID = 1L;
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float value2) {
        this.value = value2;
    }

    public MutableFloat(Number value2) {
        this(value2.floatValue());
    }

    public MutableFloat(String value2) throws NumberFormatException {
        this.value = Float.parseFloat(value2);
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(float value2) {
        this.value = value2;
    }

    @Override
    public void set(Number value2) {
        this.value = value2.floatValue();
    }

    public MutableFloat increment() {
        this.value += 1.0f;
        return this;
    }

    public MutableFloat decrement() {
        this.value -= 1.0f;
        return this;
    }

    public MutableFloat add(float operand) {
        this.value += operand;
        return this;
    }

    public MutableFloat add(Number operand) {
        this.value += operand.floatValue();
        return this;
    }

    public MutableFloat subtract(float operand) {
        this.value -= operand;
        return this;
    }

    public MutableFloat subtract(Number operand) {
        this.value -= operand.floatValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableFloat) {
            return Float.floatToIntBits(((MutableFloat)obj).value) == Float.floatToIntBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(MutableFloat other) {
        return NumberUtil.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

