/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.ObjByteConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;

final class FieldReaderInt8ValueFunc<T>
extends FieldReader<T> {
    final ObjByteConsumer<T> function;

    public FieldReaderInt8ValueFunc(String fieldName, int ordinal, JSONSchema schema, Method method, ObjByteConsumer<T> function) {
        super(fieldName, Byte.TYPE, Byte.TYPE, ordinal, 0L, null, null, null, schema, method, null);
        this.function = function;
    }

    @Override
    public void accept(T object, byte value2) {
        if (this.schema != null) {
            this.schema.assertValidate(value2);
        }
        this.function.accept(object, value2);
    }

    @Override
    public void accept(T object, Object value2) {
        byte byteValue = TypeUtils.toByteValue(value2);
        if (this.schema != null) {
            this.schema.assertValidate(byteValue);
        }
        this.function.accept(object, byteValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        byte value2 = (byte)jsonReader.readInt32Value();
        if (this.schema != null) {
            this.schema.assertValidate(value2);
        }
        this.function.accept(object, value2);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return (byte)jsonReader.readInt32Value();
    }
}

