/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberSchema
extends JSONSchema {
    final BigDecimal minimum;
    final long minimumLongValue;
    final boolean exclusiveMinimum;
    final BigDecimal maximum;
    final long maximumLongValue;
    final boolean exclusiveMaximum;
    final BigDecimal multipleOf;
    final long multipleOfLongValue;
    final boolean typed;

    NumberSchema(JSONObject input) {
        super(input);
        long longValue;
        this.typed = "number".equals(input.get("type"));
        Object exclusiveMinimum = input.get("exclusiveMinimum");
        BigDecimal minimum = input.getBigDecimal("minimum");
        if (exclusiveMinimum == Boolean.TRUE) {
            this.minimum = minimum;
            this.exclusiveMinimum = true;
        } else if (exclusiveMinimum instanceof Number) {
            this.minimum = input.getBigDecimal("exclusiveMinimum");
            this.exclusiveMinimum = true;
        } else {
            this.minimum = minimum;
            this.exclusiveMinimum = false;
        }
        this.minimumLongValue = this.minimum == null || this.minimum.compareTo(BigDecimal.valueOf(this.minimum.longValue())) != 0 ? Long.MIN_VALUE : this.minimum.longValue();
        BigDecimal maximum = input.getBigDecimal("maximum");
        Object exclusiveMaximum = input.get("exclusiveMaximum");
        if (exclusiveMaximum == Boolean.TRUE) {
            this.maximum = maximum;
            this.exclusiveMaximum = true;
        } else if (exclusiveMaximum instanceof Number) {
            this.maximum = input.getBigDecimal("exclusiveMaximum");
            this.exclusiveMaximum = true;
        } else {
            this.maximum = maximum;
            this.exclusiveMaximum = false;
        }
        this.maximumLongValue = this.maximum == null || this.maximum.compareTo(BigDecimal.valueOf(this.maximum.longValue())) != 0 ? Long.MIN_VALUE : this.maximum.longValue();
        this.multipleOf = input.getBigDecimal("multipleOf");
        this.multipleOfLongValue = this.multipleOf == null ? Long.MIN_VALUE : (this.multipleOf.compareTo(BigDecimal.valueOf(longValue = this.multipleOf.longValue())) == 0 ? longValue : Long.MIN_VALUE);
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Number;
    }

    @Override
    public ValidateResult validate(Object value2) {
        if (value2 == null) {
            return this.typed ? FAIL_INPUT_NULL : SUCCESS;
        }
        if (value2 instanceof Number) {
            BigDecimal decimalValue;
            Number number = (Number)value2;
            if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
                return this.validate(number.longValue());
            }
            if (number instanceof Float || number instanceof Double) {
                return this.validate(number.doubleValue());
            }
            if (number instanceof BigInteger) {
                decimalValue = new BigDecimal((BigInteger)number);
            } else if (number instanceof BigDecimal) {
                decimalValue = (BigDecimal)number;
            } else {
                return new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Number, value2.getClass()});
            }
            if (this.minimum != null && (this.exclusiveMinimum ? this.minimum.compareTo(decimalValue) >= 0 : this.minimum.compareTo(decimalValue) > 0)) {
                return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect > %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value2);
            }
            if (this.maximum != null && (this.exclusiveMaximum ? this.maximum.compareTo(decimalValue) <= 0 : this.maximum.compareTo(decimalValue) < 0)) {
                return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect < %s, but %s" : "maximum not match, expect <= %s, but %s", this.maximum, value2);
            }
            if (this.multipleOf != null && decimalValue.divideAndRemainder(this.multipleOf)[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, decimalValue);
            }
            return SUCCESS;
        }
        return this.typed ? FAIL_TYPE_NOT_MATCH : SUCCESS;
    }

    @Override
    public ValidateResult validate(Integer value2) {
        if (value2 == null) {
            return SUCCESS;
        }
        return this.validate(value2.longValue());
    }

    @Override
    public ValidateResult validate(Float value2) {
        if (value2 == null) {
            return SUCCESS;
        }
        return this.validate(value2.doubleValue());
    }

    @Override
    public ValidateResult validate(Double value2) {
        if (value2 == null) {
            return SUCCESS;
        }
        return this.validate((double)value2);
    }

    @Override
    public ValidateResult validate(Long value2) {
        if (value2 == null) {
            return SUCCESS;
        }
        return this.validate((long)value2);
    }

    @Override
    public ValidateResult validate(long value2) {
        BigDecimal decimalValue = null;
        if (this.minimum != null) {
            if (this.minimumLongValue != Long.MIN_VALUE) {
                if (this.exclusiveMinimum ? value2 <= this.minimumLongValue : value2 < this.minimumLongValue) {
                    return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect > %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value2);
                }
            } else {
                decimalValue = BigDecimal.valueOf(value2);
                if (this.exclusiveMinimum ? this.minimum.compareTo(decimalValue) >= 0 : this.minimum.compareTo(decimalValue) > 0) {
                    return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect > %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value2);
                }
            }
        }
        if (this.maximum != null) {
            if (this.maximumLongValue != Long.MIN_VALUE) {
                if (this.exclusiveMaximum ? value2 >= this.maximumLongValue : value2 > this.maximumLongValue) {
                    return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect < %s, but %s" : "maximum not match, expect <= %s, but %s", this.maximum, value2);
                }
            } else {
                if (decimalValue == null) {
                    decimalValue = BigDecimal.valueOf(value2);
                }
                if (this.exclusiveMaximum ? this.maximum.compareTo(decimalValue) <= 0 : this.maximum.compareTo(decimalValue) < 0) {
                    return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect < %s, but %s" : "maximum not match, expect <= %s, but %s", this.maximum, value2);
                }
            }
        }
        if (this.multipleOf != null) {
            if (this.multipleOfLongValue != Long.MIN_VALUE && value2 % this.multipleOfLongValue != 0L) {
                return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, decimalValue);
            }
            if (decimalValue == null) {
                decimalValue = BigDecimal.valueOf(value2);
            }
            if (decimalValue.divideAndRemainder(this.multipleOf)[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, value2);
            }
        }
        return SUCCESS;
    }

    @Override
    public ValidateResult validate(double value2) {
        if (this.minimum != null) {
            if (this.minimumLongValue != Long.MIN_VALUE) {
                if (this.exclusiveMinimum ? value2 <= (double)this.minimumLongValue : value2 < (double)this.minimumLongValue) {
                    return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect > %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value2);
                }
            } else {
                double minimumDoubleValue = this.minimum.doubleValue();
                if (this.exclusiveMinimum ? value2 <= minimumDoubleValue : value2 < minimumDoubleValue) {
                    return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect > %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value2);
                }
            }
        }
        if (this.maximum != null) {
            if (this.maximumLongValue != Long.MIN_VALUE) {
                if (this.exclusiveMaximum ? value2 >= (double)this.maximumLongValue : value2 > (double)this.maximumLongValue) {
                    return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect < %s, but %s" : "maximum not match, expect <= %s, but %s", this.maximum, value2);
                }
            } else {
                double maximumDoubleValue = this.maximum.doubleValue();
                if (this.exclusiveMaximum ? value2 >= maximumDoubleValue : value2 > maximumDoubleValue) {
                    return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect < %s, but %s" : "maximum not match, expect <= %s, but %s", this.maximum, value2);
                }
            }
        }
        if (this.multipleOf != null) {
            if (this.multipleOfLongValue != Long.MIN_VALUE && value2 % (double)this.multipleOfLongValue != 0.0) {
                return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, value2);
            }
            BigDecimal decimalValue = BigDecimal.valueOf(value2);
            if (decimalValue.divideAndRemainder(this.multipleOf)[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, decimalValue);
            }
        }
        return SUCCESS;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject object = JSONObject.of("type", "number");
        if (this.minimumLongValue != Long.MIN_VALUE) {
            object.put(this.exclusiveMinimum ? "exclusiveMinimum" : "minimum", this.minimumLongValue);
        } else if (this.minimum != null) {
            object.put(this.exclusiveMinimum ? "exclusiveMinimum" : "minimum", this.minimum);
        }
        if (this.maximumLongValue != Long.MIN_VALUE) {
            object.put(this.exclusiveMaximum ? "exclusiveMaximum" : "maximum", this.minimumLongValue);
        } else if (this.maximum != null) {
            object.put(this.exclusiveMaximum ? "exclusiveMaximum" : "maximum", this.maximum);
        }
        if (this.multipleOfLongValue != Long.MIN_VALUE) {
            object.put("multipleOf", this.multipleOfLongValue);
        } else if (this.multipleOf != null) {
            object.put("multipleOf", this.multipleOf);
        }
        return object;
    }
}

