/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;

final class FieldReaderInt8Field<T>
extends FieldReaderObjectField<T> {
    FieldReaderInt8Field(String fieldName, Class fieldType, int ordinal, long features, String format, Byte defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Integer fieldInt = jsonReader.readInt32();
        if (this.schema != null) {
            this.schema.assertValidate(fieldInt);
        }
        try {
            this.field.set(object, fieldInt == null ? null : Byte.valueOf(fieldInt.byteValue()));
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, short value2) {
        this.accept(object, (Object)((byte)value2));
    }

    @Override
    public void accept(T object, float value2) {
        this.accept(object, (Object)((byte)value2));
    }

    @Override
    public void accept(T object, double value2) {
        this.accept(object, (Object)((byte)value2));
    }

    @Override
    public void accept(T object, int value2) {
        this.accept(object, (Object)((byte)value2));
    }

    @Override
    public void accept(T object, long value2) {
        this.accept(object, (Object)((byte)value2));
    }

    @Override
    public void accept(T object, Object value2) {
        Byte byteValue = TypeUtils.toByte(value2);
        if (this.schema != null) {
            this.schema.assertValidate(byteValue);
        }
        try {
            this.field.set(object, byteValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return (byte)jsonReader.readInt32Value();
    }
}

