/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.tree.Node;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final TreeNodeConfig treeNodeConfig;
    private Tree<T> parent;

    public Tree() {
        this((TreeNodeConfig)null);
    }

    public Tree(TreeNodeConfig treeNodeConfig) {
        this.treeNodeConfig = ObjectUtil.defaultIfNull(treeNodeConfig, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public TreeNodeConfig getConfig() {
        return this.treeNodeConfig;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Tree<T> getNode(T id) {
        return TreeUtil.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this, includeCurrentNode);
    }

    public Tree<T> setParent(Tree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    @Override
    public T getId() {
        return (T)this.get(this.treeNodeConfig.getIdKey());
    }

    @Override
    public Tree<T> setId(T id) {
        this.put(this.treeNodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.treeNodeConfig.getParentIdKey());
    }

    @Override
    public Tree<T> setParentId(T parentId) {
        this.put(this.treeNodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.treeNodeConfig.getNameKey());
    }

    @Override
    public Tree<T> setName(CharSequence name) {
        this.put(this.treeNodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.treeNodeConfig.getWeightKey());
    }

    @Override
    public Tree<T> setWeight(Comparable<?> weight) {
        this.put(this.treeNodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<Tree<T>> getChildren() {
        return (List)this.get(this.treeNodeConfig.getChildrenKey());
    }

    public boolean hasChild() {
        return CollUtil.isNotEmpty(this.getChildren());
    }

    public void walk(Consumer<Tree<T>> consumer) {
        consumer.accept(this);
        List<Tree<Tree>> children = this.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            children.forEach((? super T tree) -> tree.walk(consumer));
        }
    }

    public Tree<T> filterNew(Filter<Tree<T>> filter) {
        return this.cloneTree().filter(filter);
    }

    public Tree<T> filter(Filter<Tree<T>> filter) {
        if (filter.accept(this)) {
            return this;
        }
        List<Tree<T>> children = this.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            ArrayList<Tree<T>> filteredChildren = new ArrayList<Tree<T>>(children.size());
            for (Tree<Tree<Tree>> tree : children) {
                Tree<T> filteredChild = tree.filter(filter);
                if (null == filteredChild) continue;
                filteredChildren.add(filteredChild);
            }
            if (CollUtil.isNotEmpty(filteredChildren)) {
                return this.setChildren(filteredChildren);
            }
            this.setChildren(null);
        }
        return null;
    }

    public Tree<T> setChildren(List<Tree<T>> children) {
        if (null == children) {
            this.remove(this.treeNodeConfig.getChildrenKey());
        }
        this.put(this.treeNodeConfig.getChildrenKey(), children);
        return this;
    }

    @SafeVarargs
    public final Tree<T> addChildren(Tree<T> ... children) {
        if (ArrayUtil.isNotEmpty(children)) {
            List<Tree<T>> childrenList = this.getChildren();
            if (null == childrenList) {
                childrenList = new ArrayList<Tree<T>>();
                this.setChildren(childrenList);
            }
            for (Tree<T> child : children) {
                child.setParent(this);
                childrenList.add(child);
            }
        }
        return this;
    }

    public void putExtra(String key, Object value2) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value2);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        Tree.printTree(this, new PrintWriter(stringWriter), 0);
        return stringWriter.toString();
    }

    public Tree<T> cloneTree() {
        Tree result = ObjectUtil.clone(this);
        result.setChildren(this.cloneChildren());
        return result;
    }

    private List<Tree<T>> cloneChildren() {
        List<Tree<Tree>> children = this.getChildren();
        if (null == children) {
            return null;
        }
        ArrayList newChildren = new ArrayList(children.size());
        children.forEach((? super T t) -> newChildren.add(t.cloneTree()));
        return newChildren;
    }

    private static void printTree(Tree<?> tree, PrintWriter writer, int intent) {
        writer.println(StrUtil.format("{}{}[{}]", StrUtil.repeat(' ', intent), tree.getName(), tree.getId()));
        writer.flush();
        List<Tree<?>> children = tree.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            for (Tree<?> child : children) {
                Tree.printTree(child, writer, intent + 2);
            }
        }
    }
}

