/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds;

import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceWrapper
implements DataSource,
Closeable,
Cloneable {
    private final DataSource ds;
    private final String driver;

    public static DataSourceWrapper wrap(DataSource ds, String driver) {
        return new DataSourceWrapper(ds, driver);
    }

    public DataSourceWrapper(DataSource ds, String driver) {
        this.ds = ds;
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public DataSource getRaw() {
        return this.ds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.ds.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ds.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.ds.getConnection(username, password);
    }

    @Override
    public void close() {
        if (this.ds instanceof AutoCloseable) {
            IoUtil.close((AutoCloseable)((Object)this.ds));
        }
    }
}

