/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handshake;

import com.taobao.api.internal.toplink.embedded.websocket.BufferManager;
import com.taobao.api.internal.toplink.embedded.websocket.HttpHeader;
import com.taobao.api.internal.toplink.embedded.websocket.exception.ErrorCode;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.handshake.HttpResponseHeaderParser;
import com.taobao.api.internal.toplink.embedded.websocket.util.StringUtil;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.EnumSet;

public abstract class Handshake {
    private int responseStatus;
    private HttpResponseHeaderParser httpResponseHeaderParser;
    private volatile State state = State.INIT;
    protected BufferManager bufferManager = new BufferManager();

    protected State transitionTo(State to) {
        if (this.state.canTransitionTo(to)) {
            State old = this.state;
            this.state = to;
            return old;
        }
        throw new IllegalStateException("Couldn't transtion from " + (Object)((Object)this.state) + " to " + (Object)((Object)to));
    }

    protected State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean handshakeResponse(ByteBuffer downloadBuffer) throws WebSocketException {
        boolean bl;
        ByteBuffer buffer;
        block9: {
            boolean bl2;
            block8: {
                buffer = null;
                try {
                    int position;
                    if (this.state == State.INIT || this.state == State.DONE) {
                        this.transitionTo(State.METHOD);
                        this.responseStatus = -1;
                        this.httpResponseHeaderParser = new HttpResponseHeaderParser();
                        this.bufferManager.init();
                        buffer = downloadBuffer;
                    } else {
                        buffer = this.bufferManager.getBuffer(downloadBuffer);
                    }
                    if (this.state == State.METHOD || this.state == State.HEADER) {
                        position = buffer.position();
                        if (!this.parseHandshakeResponseHeader(buffer)) {
                            buffer.position(position);
                            this.bufferManager.storeFragmentBuffer(buffer);
                            boolean bl3 = false;
                            Object var6_6 = null;
                            if (buffer == null) return bl3;
                            if (buffer == downloadBuffer) return bl3;
                            downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
                            return bl3;
                        }
                        this.transitionTo(State.BODY);
                    }
                    if (this.state == State.BODY) {
                        position = buffer.position();
                        if (!this.parseHandshakeResponseBody(buffer)) {
                            buffer.position(position);
                            this.bufferManager.storeFragmentBuffer(buffer);
                            bl2 = false;
                            break block8;
                        }
                    }
                    bl = this.done();
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (buffer == null) throw throwable;
                    if (buffer == downloadBuffer) throw throwable;
                    downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
                    throw throwable;
                }
            }
            Object var6_7 = null;
            if (buffer == null) return bl2;
            if (buffer == downloadBuffer) return bl2;
            downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
            return bl2;
        }
        Object var6_8 = null;
        if (buffer == null) return bl;
        if (buffer == downloadBuffer) return bl;
        downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
        return bl;
    }

    protected boolean done() {
        this.transitionTo(State.DONE);
        return true;
    }

    public boolean isDone() {
        return this.state == State.DONE;
    }

    protected boolean parseHandshakeResponseBody(ByteBuffer buffer) throws WebSocketException {
        return true;
    }

    protected boolean parseHandshakeResponseHeader(ByteBuffer buffer) throws WebSocketException {
        if (this.state == State.METHOD) {
            String line = StringUtil.readLine(buffer);
            if (line == null) {
                return false;
            }
            if (!line.startsWith("HTTP/1.1")) {
                throw new WebSocketException(ErrorCode.E3101, line);
            }
            this.responseStatus = Integer.valueOf(line.substring(9, 12));
            if (this.responseStatus != 101) {
                throw new WebSocketException(ErrorCode.E3102, line);
            }
            this.transitionTo(State.HEADER);
        }
        if (this.state == State.HEADER) {
            this.httpResponseHeaderParser.parse(buffer);
            return this.httpResponseHeaderParser.isCompleted();
        }
        return true;
    }

    public abstract ByteBuffer createHandshakeRequest() throws WebSocketException;

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public HttpHeader getResponseHeader() {
        return this.httpResponseHeaderParser.getResponseHeader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INIT,
        METHOD,
        HEADER,
        BODY,
        DONE;

        private static EnumMap<State, EnumSet<State>> stateMap;

        boolean canTransitionTo(State state) {
            EnumSet<State> set = stateMap.get((Object)this);
            if (set == null) {
                return false;
            }
            return set.contains((Object)state);
        }

        static {
            stateMap = new EnumMap(State.class);
            stateMap.put(INIT, EnumSet.of(METHOD));
            stateMap.put(METHOD, EnumSet.of(HEADER));
            stateMap.put(HEADER, EnumSet.of(BODY, DONE));
            stateMap.put(BODY, EnumSet.of(DONE));
            stateMap.put(DONE, EnumSet.of(METHOD));
        }
    }
}

