/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;

final class FieldWriterDoubleValField<T>
extends FieldWriter<T> {
    FieldWriterDoubleValField(String name, int ordinal, String format, String label, Field field) {
        super(name, ordinal, 0L, format, label, Double.TYPE, Double.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(Object object) {
        return this.getFieldValueDouble(object);
    }

    public double getFieldValueDouble(Object object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            double value2 = this.fieldOffset != -1L ? JDKUtils.UNSAFE.getDouble(object, this.fieldOffset) : this.field.getDouble(object);
            return value2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        double value2 = this.getFieldValueDouble(object);
        this.writeDouble(jsonWriter, value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        double value2 = this.getFieldValueDouble(object);
        if (this.decimalFormat != null) {
            jsonWriter.writeDouble(value2, this.decimalFormat);
        } else {
            jsonWriter.writeDouble(value2);
        }
    }
}

