/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.convert.BasicType;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.convert.NumberWordFormatter;
import cn.hutool.core.convert.impl.CollectionConverter;
import cn.hutool.core.convert.impl.EnumConverter;
import cn.hutool.core.convert.impl.MapConverter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.text.UnicodeUtil;
import cn.hutool.core.util.ByteUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Convert {
    public static String toStr(Object value2, String defaultValue) {
        return Convert.convertQuietly(String.class, value2, defaultValue);
    }

    public static String toStr(Object value2) {
        return Convert.toStr(value2, null);
    }

    public static String[] toStrArray(Object value2) {
        return Convert.convert(String[].class, value2);
    }

    public static Character toChar(Object value2, Character defaultValue) {
        return Convert.convertQuietly(Character.class, value2, defaultValue);
    }

    public static Character toChar(Object value2) {
        return Convert.toChar(value2, null);
    }

    public static Character[] toCharArray(Object value2) {
        return Convert.convert(Character[].class, value2);
    }

    public static Byte toByte(Object value2, Byte defaultValue) {
        return Convert.convertQuietly(Byte.class, value2, defaultValue);
    }

    public static Byte toByte(Object value2) {
        return Convert.toByte(value2, null);
    }

    public static Byte[] toByteArray(Object value2) {
        return Convert.convert(Byte[].class, value2);
    }

    public static byte[] toPrimitiveByteArray(Object value2) {
        return Convert.convert(byte[].class, value2);
    }

    public static Short toShort(Object value2, Short defaultValue) {
        return Convert.convertQuietly(Short.class, value2, defaultValue);
    }

    public static Short toShort(Object value2) {
        return Convert.toShort(value2, null);
    }

    public static Short[] toShortArray(Object value2) {
        return Convert.convert(Short[].class, value2);
    }

    public static Number toNumber(Object value2, Number defaultValue) {
        return Convert.convertQuietly(Number.class, value2, defaultValue);
    }

    public static Number toNumber(Object value2) {
        return Convert.toNumber(value2, null);
    }

    public static Number[] toNumberArray(Object value2) {
        return Convert.convert(Number[].class, value2);
    }

    public static Integer toInt(Object value2, Integer defaultValue) {
        return Convert.convertQuietly(Integer.class, value2, defaultValue);
    }

    public static Integer toInt(Object value2) {
        return Convert.toInt(value2, null);
    }

    public static Integer[] toIntArray(Object value2) {
        return Convert.convert(Integer[].class, value2);
    }

    public static Long toLong(Object value2, Long defaultValue) {
        return Convert.convertQuietly(Long.class, value2, defaultValue);
    }

    public static Long toLong(Object value2) {
        return Convert.toLong(value2, null);
    }

    public static Long[] toLongArray(Object value2) {
        return Convert.convert(Long[].class, value2);
    }

    public static Double toDouble(Object value2, Double defaultValue) {
        return Convert.convertQuietly(Double.class, value2, defaultValue);
    }

    public static Double toDouble(Object value2) {
        return Convert.toDouble(value2, null);
    }

    public static Double[] toDoubleArray(Object value2) {
        return Convert.convert(Double[].class, value2);
    }

    public static Float toFloat(Object value2, Float defaultValue) {
        return Convert.convertQuietly(Float.class, value2, defaultValue);
    }

    public static Float toFloat(Object value2) {
        return Convert.toFloat(value2, null);
    }

    public static Float[] toFloatArray(Object value2) {
        return Convert.convert(Float[].class, value2);
    }

    public static Boolean toBool(Object value2, Boolean defaultValue) {
        return Convert.convertQuietly(Boolean.class, value2, defaultValue);
    }

    public static Boolean toBool(Object value2) {
        return Convert.toBool(value2, null);
    }

    public static Boolean[] toBooleanArray(Object value2) {
        return Convert.convert(Boolean[].class, value2);
    }

    public static BigInteger toBigInteger(Object value2, BigInteger defaultValue) {
        return Convert.convertQuietly(BigInteger.class, value2, defaultValue);
    }

    public static BigInteger toBigInteger(Object value2) {
        return Convert.toBigInteger(value2, null);
    }

    public static BigDecimal toBigDecimal(Object value2, BigDecimal defaultValue) {
        return Convert.convertQuietly(BigDecimal.class, value2, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value2) {
        return Convert.toBigDecimal(value2, null);
    }

    public static Date toDate(Object value2, Date defaultValue) {
        return Convert.convertQuietly(Date.class, value2, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Object value2, LocalDateTime defaultValue) {
        return Convert.convertQuietly(LocalDateTime.class, value2, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Object value2) {
        return Convert.toLocalDateTime(value2, null);
    }

    public static Date toInstant(Object value2, Date defaultValue) {
        return Convert.convertQuietly(Instant.class, value2, defaultValue);
    }

    public static Date toDate(Object value2) {
        return Convert.toDate(value2, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value2, E defaultValue) {
        return new EnumConverter(clazz).convertQuietly(value2, defaultValue);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value2) {
        return Convert.toEnum(clazz, value2, null);
    }

    public static Collection<?> toCollection(Class<?> collectionType, Class<?> elementType, Object value2) {
        return new CollectionConverter(collectionType, elementType).convert(value2, null);
    }

    public static List<?> toList(Object value2) {
        return Convert.convert(List.class, value2);
    }

    public static <T> List<T> toList(Class<T> elementType, Object value2) {
        return (List)Convert.toCollection(ArrayList.class, elementType, value2);
    }

    public static <T> Set<T> toSet(Class<T> elementType, Object value2) {
        return (Set)Convert.toCollection(HashSet.class, elementType, value2);
    }

    public static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, Object value2) {
        return new MapConverter((Type)((Object)HashMap.class), keyType, valueType).convert(value2, null);
    }

    public static <T> T convertByClassName(String className, Object value2) throws ConvertException {
        return Convert.convert(ClassUtil.loadClass(className), value2);
    }

    public static <T> T convert(Class<T> type, Object value2) throws ConvertException {
        return Convert.convert(type, value2);
    }

    public static <T> T convert(TypeReference<T> reference, Object value2) throws ConvertException {
        return Convert.convert(reference.getType(), value2, null);
    }

    public static <T> T convert(Type type, Object value2) throws ConvertException {
        return Convert.convert(type, value2, null);
    }

    public static <T> T convert(Class<T> type, Object value2, T defaultValue) throws ConvertException {
        return Convert.convert(type, value2, defaultValue);
    }

    public static <T> T convert(Type type, Object value2, T defaultValue) throws ConvertException {
        return Convert.convertWithCheck(type, value2, defaultValue, false);
    }

    public static <T> T convertQuietly(Type type, Object value2) {
        return Convert.convertQuietly(type, value2, null);
    }

    public static <T> T convertQuietly(Type type, Object value2, T defaultValue) {
        return Convert.convertWithCheck(type, value2, defaultValue, true);
    }

    public static <T> T convertWithCheck(Type type, Object value2, T defaultValue, boolean quietly) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        try {
            return registry.convert(type, value2, defaultValue);
        }
        catch (Exception e) {
            if (quietly) {
                return defaultValue;
            }
            throw e;
        }
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        if (StrUtil.isBlank(text)) {
            return text;
        }
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000' || c[i] == '\u00a0' || c[i] == '\u2007' || c[i] == '\u202f') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String toHex(String str, Charset charset) {
        return HexUtil.encodeHexStr(str, charset);
    }

    public static String toHex(byte[] bytes) {
        return HexUtil.encodeHexStr(bytes);
    }

    public static byte[] hexToBytes(String src) {
        return HexUtil.decodeHex(src.toCharArray());
    }

    public static String hexToStr(String hexStr, Charset charset) {
        return HexUtil.decodeHexStr(hexStr, charset);
    }

    public static String strToUnicode(String strText) {
        return UnicodeUtil.toUnicode(strText);
    }

    public static String unicodeToStr(String unicode) {
        return UnicodeUtil.toString(unicode);
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StrUtil.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        return CharsetUtil.convert(str, sourceCharset, destCharset);
    }

    public static long convertTime(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        Assert.notNull(sourceUnit, "sourceUnit is null !", new Object[0]);
        Assert.notNull(destUnit, "destUnit is null !", new Object[0]);
        return destUnit.convert(sourceDuration, sourceUnit);
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }

    public static String numberToWord(Number number) {
        return NumberWordFormatter.format(number);
    }

    public static String numberToSimple(Number number) {
        return NumberWordFormatter.formatSimple(number.longValue());
    }

    public static String numberToChinese(double number, boolean isUseTraditional) {
        return NumberChineseFormatter.format(number, isUseTraditional);
    }

    public static int chineseToNumber(String number) {
        return NumberChineseFormatter.chineseToNumber(number);
    }

    public static String digitToChinese(Number n) {
        if (null == n) {
            return "\u96f6";
        }
        return NumberChineseFormatter.format(n.doubleValue(), true, true);
    }

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return ByteUtil.bytesToShort(bytes);
    }

    public static byte[] shortToBytes(short shortValue) {
        return ByteUtil.shortToBytes(shortValue);
    }

    public static int bytesToInt(byte[] bytes) {
        return ByteUtil.bytesToInt(bytes);
    }

    public static byte[] intToBytes(int intValue) {
        return ByteUtil.intToBytes(intValue);
    }

    public static byte[] longToBytes(long longValue) {
        return ByteUtil.longToBytes(longValue);
    }

    public static long bytesToLong(byte[] bytes) {
        return ByteUtil.bytesToLong(bytes);
    }
}

