/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.parser.ValueParser;

public class SimpleValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public SimpleValueParser(int min, int max) {
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    @Override
    public int parse(String value2) throws CronException {
        int i;
        if ("L".equalsIgnoreCase(value2)) {
            return this.max;
        }
        try {
            i = Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new CronException(e, "Invalid integer value: '{}'", value2);
        }
        if (i < this.min || i > this.max) {
            throw new CronException("Value {} out of range: [{} , {}]", i, this.min, this.max);
        }
        return i;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

