/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.impl.ToDouble;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;

final class JSONPathFunction
extends JSONPathSegment
implements JSONPathSegment.EvalSegment {
    static final JSONPathFunction FUNC_TYPE = new JSONPathFunction(JSONPathFunction::type);
    static final JSONPathFunction FUNC_DOUBLE = new JSONPathFunction(new ToDouble(null));
    static final JSONPathFunction FUNC_FLOOR = new JSONPathFunction(JSONPathFunction::floor);
    static final JSONPathFunction FUNC_CEIL = new JSONPathFunction(JSONPathFunction::ceil);
    static final JSONPathFunction FUNC_ABS = new JSONPathFunction(JSONPathFunction::abs);
    static final JSONPathFunction FUNC_NEGATIVE = new JSONPathFunction(JSONPathFunction::negative);
    static final JSONPathFunction FUNC_EXISTS = new JSONPathFunction(JSONPathFunction::exists);
    static final JSONPathFunction FUNC_LOWER = new JSONPathFunction(JSONPathFunction::lower);
    static final JSONPathFunction FUNC_UPPER = new JSONPathFunction(JSONPathFunction::upper);
    static final JSONPathFunction FUNC_TRIM = new JSONPathFunction(JSONPathFunction::trim);
    static final JSONPathFunction FUNC_FIRST = new JSONPathFunction(JSONPathFunction::first);
    static final JSONPathFunction FUNC_LAST = new JSONPathFunction(JSONPathFunction::last);
    final Function function;

    public JSONPathFunction(Function function) {
        this.function = function;
    }

    static Object floor(Object value2) {
        if (value2 instanceof Double) {
            return Math.floor((Double)value2);
        }
        if (value2 instanceof Float) {
            return Math.floor(((Float)value2).floatValue());
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).setScale(0, RoundingMode.FLOOR);
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Object item = list.get(i);
                if (item instanceof Double) {
                    list.set(i, Math.floor((Double)item));
                    continue;
                }
                if (item instanceof Float) {
                    list.set(i, Math.floor(((Float)item).floatValue()));
                    continue;
                }
                if (!(item instanceof BigDecimal)) continue;
                list.set(i, ((BigDecimal)item).setScale(0, RoundingMode.FLOOR));
            }
        }
        return value2;
    }

    static Object ceil(Object value2) {
        if (value2 instanceof Double) {
            return Math.ceil((Double)value2);
        }
        if (value2 instanceof Float) {
            return Math.ceil(((Float)value2).floatValue());
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).setScale(0, RoundingMode.CEILING);
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Object item = list.get(i);
                if (item instanceof Double) {
                    list.set(i, Math.ceil((Double)item));
                    continue;
                }
                if (item instanceof Float) {
                    list.set(i, Math.ceil(((Float)item).floatValue()));
                    continue;
                }
                if (!(item instanceof BigDecimal)) continue;
                list.set(i, ((BigDecimal)item).setScale(0, RoundingMode.CEILING));
            }
        }
        return value2;
    }

    static Object exists(Object value2) {
        return value2 != null;
    }

    static Object negative(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Integer) {
            int intValue = (Integer)value2;
            if (intValue == Integer.MIN_VALUE) {
                return -((long)intValue);
            }
            return -intValue;
        }
        if (value2 instanceof Long) {
            long longValue = (Long)value2;
            if (longValue == Long.MIN_VALUE) {
                return BigInteger.valueOf(longValue).negate();
            }
            return -longValue;
        }
        if (value2 instanceof Byte) {
            byte byteValue = (Byte)value2;
            if (byteValue == -128) {
                return (int)(-((short)byteValue));
            }
            return -byteValue;
        }
        if (value2 instanceof Short) {
            short shortValue = (Short)value2;
            if (shortValue == Short.MIN_VALUE) {
                return (int)(-shortValue);
            }
            return -shortValue;
        }
        if (value2 instanceof Double) {
            return -((Double)value2).doubleValue();
        }
        if (value2 instanceof Float) {
            return Float.valueOf(-((Float)value2).floatValue());
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).negate();
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).negate();
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            JSONArray values = new JSONArray(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                Object negativeItem = JSONPathFunction.negative(item);
                values.add(negativeItem);
            }
            return values;
        }
        return value2;
    }

    static Object first(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof JSONPath.Sequence) {
            value2 = ((JSONPath.Sequence)value2).values;
        }
        if (value2 instanceof List) {
            if (((List)value2).isEmpty()) {
                return null;
            }
            return ((List)value2).get(0);
        }
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (collection.isEmpty()) {
                return null;
            }
            return collection.iterator().next();
        }
        if (value2.getClass().isArray()) {
            int len = Array.getLength(value2);
            if (len == 0) {
                return null;
            }
            return Array.get(value2, 0);
        }
        return value2;
    }

    static Object last(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof JSONPath.Sequence) {
            value2 = ((JSONPath.Sequence)value2).values;
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            int size = list.size();
            if (size == 0) {
                return null;
            }
            return list.get(size - 1);
        }
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (collection.isEmpty()) {
                return null;
            }
            Object last = null;
            for (Object o : collection) {
                last = o;
            }
            return last;
        }
        if (value2.getClass().isArray()) {
            int len = Array.getLength(value2);
            if (len == 0) {
                return null;
            }
            return Array.get(value2, len - 1);
        }
        return value2;
    }

    static Object abs(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Integer) {
            int intValue = (Integer)value2;
            if (intValue < 0) {
                return -intValue;
            }
            return value2;
        }
        if (value2 instanceof Long) {
            long longValue = (Long)value2;
            if (longValue < 0L) {
                return -longValue;
            }
            return value2;
        }
        if (value2 instanceof Byte) {
            byte byteValue = (Byte)value2;
            if (byteValue < 0) {
                return -byteValue;
            }
            return value2;
        }
        if (value2 instanceof Short) {
            short shortValue = (Short)value2;
            if (shortValue < 0) {
                return -shortValue;
            }
            return value2;
        }
        if (value2 instanceof Double) {
            double doubleValue = (Double)value2;
            if (doubleValue < 0.0) {
                return -doubleValue;
            }
            return value2;
        }
        if (value2 instanceof Float) {
            float floatValue = ((Float)value2).floatValue();
            if (floatValue < 0.0f) {
                return Float.valueOf(-floatValue);
            }
            return value2;
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).abs();
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).abs();
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            JSONArray values = new JSONArray(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                values.add(JSONPathFunction.abs(item));
            }
            return values;
        }
        throw new JSONException("abs not support " + value2);
    }

    static String type(Object value2) {
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof Collection) {
            return "array";
        }
        if (value2 instanceof Number) {
            return "number";
        }
        if (value2 instanceof Boolean) {
            return "boolean";
        }
        if (value2 instanceof String || value2 instanceof UUID || value2 instanceof Enum) {
            return "string";
        }
        return "object";
    }

    static Object lower(Object value2) {
        if (value2 == null) {
            return null;
        }
        String str = value2 instanceof String ? (String)value2 : value2.toString();
        return str.toLowerCase();
    }

    static Object upper(Object value2) {
        if (value2 == null) {
            return null;
        }
        String str = value2 instanceof String ? (String)value2 : value2.toString();
        return str.toUpperCase();
    }

    static Object trim(Object value2) {
        if (value2 == null) {
            return null;
        }
        String str = value2 instanceof String ? (String)value2 : value2.toString();
        return str.trim();
    }

    @Override
    public void accept(JSONReader jsonReader, JSONPath.Context context) {
        if (context.parent == null) {
            context.root = jsonReader.readAny();
            context.eval = true;
        }
        this.eval(context);
    }

    @Override
    public void eval(JSONPath.Context context) {
        Object value2 = context.parent == null ? context.root : context.parent.value;
        context.value = this.function.apply(value2);
    }

    static final class IndexString
    extends Index {
        final String value;

        public IndexString(String value2) {
            this.value = value2;
        }

        @Override
        protected boolean eq(Object item) {
            if (item == null) {
                return false;
            }
            return this.value.equals(item.toString());
        }
    }

    static final class IndexDecimal
    extends Index {
        final BigDecimal value;

        public IndexDecimal(BigDecimal value2) {
            this.value = value2;
        }

        @Override
        protected boolean eq(Object item) {
            String str;
            if (item == null) {
                return false;
            }
            if (item instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)item;
                decimal = decimal.stripTrailingZeros();
                return this.value.equals(decimal);
            }
            if (item instanceof Float || item instanceof Double) {
                double doubleValue = ((Number)item).doubleValue();
                BigDecimal decimal = new BigDecimal(doubleValue).stripTrailingZeros();
                return this.value.equals(decimal);
            }
            if (item instanceof String && TypeUtils.isNumber(str = (String)item)) {
                BigDecimal decimal = new BigDecimal(str).stripTrailingZeros();
                return this.value.equals(decimal);
            }
            return false;
        }
    }

    static final class IndexInt
    extends Index {
        final long value;
        transient BigDecimal decimalValue;

        public IndexInt(long value2) {
            this.value = value2;
        }

        @Override
        protected boolean eq(Object item) {
            if (item instanceof Integer || item instanceof Long || item instanceof Byte || item instanceof Short) {
                return ((Number)item).longValue() == this.value;
            }
            if (item instanceof Float || item instanceof Double) {
                return ((Number)item).doubleValue() == (double)this.value;
            }
            if (item instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)item;
                decimal = decimal.stripTrailingZeros();
                if (this.decimalValue == null) {
                    this.decimalValue = BigDecimal.valueOf(this.value);
                }
                return this.decimalValue.equals(decimal);
            }
            return false;
        }
    }

    static abstract class Index
    implements Function {
        Index() {
        }

        protected abstract boolean eq(Object var1);

        public final Object apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof List) {
                List list = (List)o;
                for (int i = 0; i < list.size(); ++i) {
                    if (!this.eq(list.get(i))) continue;
                    return i;
                }
                return -1;
            }
            if (o.getClass().isArray()) {
                int len = Array.getLength(o);
                for (int i = 0; i < len; ++i) {
                    Object item = Array.get(o, i);
                    if (!this.eq(item)) continue;
                    return i;
                }
                return -1;
            }
            if (this.eq(o)) {
                return 0;
            }
            return null;
        }
    }

    static final class BiFunctionAdapter
    implements BiFunction {
        private final Function function;

        BiFunctionAdapter(Function function) {
            this.function = function;
        }

        public Object apply(Object o1, Object o2) {
            return this.function.apply(o2);
        }
    }

    static final class SizeFunction
    implements Function {
        static final SizeFunction INSTANCE = new SizeFunction();

        SizeFunction() {
        }

        public Object apply(Object value2) {
            if (value2 == null) {
                return -1;
            }
            if (value2 instanceof Collection) {
                return ((Collection)value2).size();
            }
            if (value2.getClass().isArray()) {
                return Array.getLength(value2);
            }
            if (value2 instanceof Map) {
                return ((Map)value2).size();
            }
            if (value2 instanceof JSONPath.Sequence) {
                return ((JSONPath.Sequence)value2).values.size();
            }
            return 1;
        }
    }

    static final class TypeFunction
    implements Function {
        static final TypeFunction INSTANCE = new TypeFunction();

        TypeFunction() {
        }

        public Object apply(Object object) {
            return JSONPathFunction.type(object);
        }
    }
}

