/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriterInt16;
import java.lang.reflect.Field;

final class FieldWriterInt16ValField<T>
extends FieldWriterInt16<T> {
    FieldWriterInt16ValField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, Short.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        return this.getFieldValueShort(object);
    }

    public short getFieldValueShort(T object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            short value2 = this.fieldOffset != -1L ? JDKUtils.UNSAFE.getShort(object, this.fieldOffset) : this.field.getShort(object);
            return value2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        short value2 = this.getFieldValueShort(object);
        this.writeInt16(jsonWriter, value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        short value2 = this.getFieldValueShort(object);
        jsonWriter.writeInt32(value2);
    }
}

