/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.CreditCodeUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    public static final Pattern GENERAL = PatternPool.GENERAL;
    public static final Pattern NUMBERS = PatternPool.NUMBERS;
    public static final Pattern GROUP_VAR = PatternPool.GROUP_VAR;
    public static final Pattern IPV4 = PatternPool.IPV4;
    public static final Pattern IPV6 = PatternPool.IPV6;
    public static final Pattern MONEY = PatternPool.MONEY;
    public static final Pattern EMAIL = PatternPool.EMAIL;
    public static final Pattern MOBILE = PatternPool.MOBILE;
    public static final Pattern CITIZEN_ID = PatternPool.CITIZEN_ID;
    public static final Pattern ZIP_CODE = PatternPool.ZIP_CODE;
    public static final Pattern BIRTHDAY = PatternPool.BIRTHDAY;
    public static final Pattern URL = PatternPool.URL;
    public static final Pattern URL_HTTP = PatternPool.URL_HTTP;
    public static final Pattern GENERAL_WITH_CHINESE = PatternPool.GENERAL_WITH_CHINESE;
    public static final Pattern UUID = PatternPool.UUID;
    public static final Pattern UUID_SIMPLE = PatternPool.UUID_SIMPLE;
    public static final Pattern PLATE_NUMBER = PatternPool.PLATE_NUMBER;
    public static final Pattern CAR_VIN = PatternPool.CAR_VIN;
    public static final Pattern CAR_DRIVING_LICENCE = PatternPool.CAR_DRIVING_LICENCE;

    public static boolean isTrue(boolean value2) {
        return value2;
    }

    public static boolean isFalse(boolean value2) {
        return false == value2;
    }

    public static boolean validateTrue(boolean value2, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isFalse(value2)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return true;
    }

    public static boolean validateFalse(boolean value2, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isTrue(value2)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return false;
    }

    public static boolean isNull(Object value2) {
        return null == value2;
    }

    public static boolean isNotNull(Object value2) {
        return null != value2;
    }

    public static <T> T validateNull(T value2, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNotNull(value2)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return null;
    }

    public static <T> T validateNotNull(T value2, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNull(value2)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return value2;
    }

    public static boolean isEmpty(Object value2) {
        return null == value2 || value2 instanceof String && StrUtil.isEmpty((String)value2);
    }

    public static boolean isNotEmpty(Object value2) {
        return false == Validator.isEmpty(value2);
    }

    public static <T> T validateEmpty(T value2, String errorMsg) throws ValidateException {
        if (Validator.isNotEmpty(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static <T> T validateNotEmpty(T value2, String errorMsg) throws ValidateException {
        if (Validator.isEmpty(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean equal(Object t1, Object t2) {
        return ObjectUtil.equal(t1, t2);
    }

    public static Object validateEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (!Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
        return t1;
    }

    public static void validateNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(t1, t2, errorMsg);
    }

    public static void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(t1, t2, errorMsg);
    }

    public static <T extends CharSequence> T validateMatchRegex(String regex, T value2, String errorMsg) throws ValidateException {
        if (!Validator.isMatchRegex(regex, value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isMatchRegex(Pattern pattern, CharSequence value2) {
        return ReUtil.isMatch(pattern, value2);
    }

    public static boolean isMatchRegex(String regex, CharSequence value2) {
        return ReUtil.isMatch(regex, value2);
    }

    public static boolean isGeneral(CharSequence value2) {
        return Validator.isMatchRegex(GENERAL, value2);
    }

    public static <T extends CharSequence> T validateGeneral(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isGeneral(CharSequence value2, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        String reg = "^\\w{" + min + "," + max + "}$";
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isMatchRegex(reg, value2);
    }

    public static <T extends CharSequence> T validateGeneral(T value2, int min, int max, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value2, min, max)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isGeneral(CharSequence value2, int min) {
        return Validator.isGeneral(value2, min, 0);
    }

    public static <T extends CharSequence> T validateGeneral(T value2, int min, String errorMsg) throws ValidateException {
        return Validator.validateGeneral(value2, min, 0, errorMsg);
    }

    public static boolean isLetter(CharSequence value2) {
        return StrUtil.isAllCharMatch(value2, Character::isLetter);
    }

    public static <T extends CharSequence> T validateLetter(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isLetter(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isUpperCase(CharSequence value2) {
        return StrUtil.isAllCharMatch(value2, Character::isUpperCase);
    }

    public static <T extends CharSequence> T validateUpperCase(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isUpperCase(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isLowerCase(CharSequence value2) {
        return StrUtil.isAllCharMatch(value2, Character::isLowerCase);
    }

    public static <T extends CharSequence> T validateLowerCase(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isLowerCase(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isNumber(CharSequence value2) {
        return NumberUtil.isNumber(value2);
    }

    public static boolean hasNumber(CharSequence value2) {
        return ReUtil.contains(PatternPool.NUMBERS, value2);
    }

    public static String validateNumber(String value2, String errorMsg) throws ValidateException {
        if (!Validator.isNumber(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isWord(CharSequence value2) {
        return Validator.isMatchRegex(PatternPool.WORD, value2);
    }

    public static <T extends CharSequence> T validateWord(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isWord(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isMoney(CharSequence value2) {
        return Validator.isMatchRegex(MONEY, value2);
    }

    public static <T extends CharSequence> T validateMoney(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isMoney(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isZipCode(CharSequence value2) {
        return Validator.isMatchRegex(ZIP_CODE, value2);
    }

    public static <T extends CharSequence> T validateZipCode(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isZipCode(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isEmail(CharSequence value2) {
        return Validator.isMatchRegex(EMAIL, value2);
    }

    public static <T extends CharSequence> T validateEmail(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isEmail(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isMobile(CharSequence value2) {
        return Validator.isMatchRegex(MOBILE, value2);
    }

    public static <T extends CharSequence> T validateMobile(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isMobile(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isCitizenId(CharSequence value2) {
        return IdcardUtil.isValidCard(String.valueOf(value2));
    }

    public static <T extends CharSequence> T validateCitizenIdNumber(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isCitizenId(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateUtil.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && DateUtil.isLeapYear(year);
        }
        return true;
    }

    public static boolean isBirthday(CharSequence value2) {
        Matcher matcher = BIRTHDAY.matcher(value2);
        if (matcher.find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }

    public static <T extends CharSequence> T validateBirthday(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isBirthday(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isIpv4(CharSequence value2) {
        return Validator.isMatchRegex(IPV4, value2);
    }

    public static <T extends CharSequence> T validateIpv4(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isIpv4(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isIpv6(CharSequence value2) {
        return Validator.isMatchRegex(IPV6, value2);
    }

    public static <T extends CharSequence> T validateIpv6(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isIpv6(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isMac(CharSequence value2) {
        return Validator.isMatchRegex(PatternPool.MAC_ADDRESS, value2);
    }

    public static <T extends CharSequence> T validateMac(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isMac(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isPlateNumber(CharSequence value2) {
        return Validator.isMatchRegex(PLATE_NUMBER, value2);
    }

    public static <T extends CharSequence> T validatePlateNumber(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isPlateNumber(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isUrl(CharSequence value2) {
        if (StrUtil.isBlank(value2)) {
            return false;
        }
        try {
            new URL(StrUtil.str(value2));
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static <T extends CharSequence> T validateUrl(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isUrl(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isChinese(CharSequence value2) {
        return Validator.isMatchRegex(PatternPool.CHINESES, value2);
    }

    public static boolean hasChinese(CharSequence value2) {
        return ReUtil.contains("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+", value2);
    }

    public static <T extends CharSequence> T validateChinese(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isChinese(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isGeneralWithChinese(CharSequence value2) {
        return Validator.isMatchRegex(GENERAL_WITH_CHINESE, value2);
    }

    public static <T extends CharSequence> T validateGeneralWithChinese(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isGeneralWithChinese(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isUUID(CharSequence value2) {
        return Validator.isMatchRegex(UUID, value2) || Validator.isMatchRegex(UUID_SIMPLE, value2);
    }

    public static <T extends CharSequence> T validateUUID(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isUUID(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isHex(CharSequence value2) {
        return Validator.isMatchRegex(PatternPool.HEX, value2);
    }

    public static <T extends CharSequence> T validateHex(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isHex(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isBetween(Number value2, Number min, Number max) {
        Assert.notNull(value2);
        Assert.notNull(min);
        Assert.notNull(max);
        double doubleValue = value2.doubleValue();
        return doubleValue >= min.doubleValue() && doubleValue <= max.doubleValue();
    }

    public static void validateBetween(Number value2, Number min, Number max, String errorMsg) throws ValidateException {
        if (!Validator.isBetween(value2, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isCreditCode(CharSequence creditCode) {
        return CreditCodeUtil.isCreditCode(creditCode);
    }

    public static boolean isCarVin(CharSequence value2) {
        return Validator.isMatchRegex(CAR_VIN, value2);
    }

    public static <T extends CharSequence> T validateCarVin(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isCarVin(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }

    public static boolean isCarDrivingLicence(CharSequence value2) {
        return Validator.isMatchRegex(CAR_DRIVING_LICENCE, value2);
    }

    public static <T extends CharSequence> T validateCarDrivingLicence(T value2, String errorMsg) throws ValidateException {
        if (!Validator.isCarDrivingLicence(value2)) {
            throw new ValidateException(errorMsg);
        }
        return value2;
    }
}

