/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;

public class JSONArray
extends JSON
implements List<Object>,
Serializable,
Cloneable {
    static ObjectReader<JSONArray> arrayReader;
    static ObjectReader<JSONObject> objectReader;
    private List list = new com.alibaba.fastjson2.JSONArray();
    protected transient Object relatedArray;
    protected transient Type componentType;

    public JSONArray() {
    }

    public JSONArray(List list) {
        this.list = list;
    }

    public JSONArray(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public Byte getByte(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).byteValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Byte");
    }

    public Short getShort(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Short) {
            return (Short)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).shortValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Short");
    }

    public Float getFloat(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Float) {
            return (Float)value2;
        }
        if (value2 instanceof Number) {
            return Float.valueOf(((Number)value2).floatValue());
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Float");
    }

    public Double getDouble(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Double");
    }

    public int getIntValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to int value");
    }

    public BigDecimal getBigDecimal(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            if (value2 instanceof BigDecimal) {
                return (BigDecimal)value2;
            }
            if (value2 instanceof BigInteger) {
                return new BigDecimal((BigInteger)value2);
            }
            if (value2 instanceof Float) {
                float floatValue = ((Float)value2).floatValue();
                return TypeUtils.toBigDecimal(floatValue);
            }
            if (value2 instanceof Double) {
                double doubleValue = (Double)value2;
                return TypeUtils.toBigDecimal(doubleValue);
            }
            long longValue = ((Number)value2).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            return TypeUtils.toBigDecimal(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to BigDecimal");
    }

    public long getLongValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0L;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to long value");
    }

    public Integer getInteger(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Integer");
    }

    public Long getLong(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Long");
    }

    public boolean getBooleanValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue() == 1;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to boolean value");
    }

    public Boolean getBoolean(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue() == 1;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Boolean");
    }

    public JSONObject getJSONObject(int index) {
        Object value2 = this.get(index);
        if (value2 instanceof JSONObject) {
            return (JSONObject)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (objectReader == null) {
                objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
            }
            return objectReader.readObject(reader, null, null, 0L);
        }
        if (value2 instanceof Map) {
            return new JSONObject((Map)value2);
        }
        if (value2 == null) {
            return null;
        }
        Class<?> valueClass = value2.getClass();
        ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(valueClass);
        if (objectWriter instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter writerAdapter = (ObjectWriterAdapter)objectWriter;
            return new JSONObject(writerAdapter.toJSONObject(value2));
        }
        return null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object item) {
        return this.list.add(item);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public JSONArray fluentClear() {
        this.list.clear();
        return this;
    }

    public JSONArray fluentRemove(int index) {
        this.list.remove(index);
        return this;
    }

    public JSONArray fluentRemove(Object o) {
        this.list.remove(o);
        return this;
    }

    public JSONArray fluentSet(int index, Object element) {
        this.set(index, element);
        return this;
    }

    public JSONArray fluentRemoveAll(Collection<?> c) {
        this.list.removeAll(c);
        return this;
    }

    public JSONArray fluentAddAll(Collection<?> c) {
        this.list.addAll(c);
        return this;
    }

    public short getShortValue(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).shortValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to short value");
    }

    public float getFloatValue(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return 0.0f;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).floatValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to float value");
    }

    public double getDoubleValue(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return 0.0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to double value");
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    public byte getByteValue(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).byteValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to byte value");
    }

    public BigInteger getBigInteger(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            if (value2 instanceof BigInteger) {
                return (BigInteger)value2;
            }
            if (value2 instanceof BigDecimal) {
                return ((BigDecimal)value2).toBigInteger();
            }
            long longValue = ((Number)value2).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to BigInteger");
    }

    public Date getSqlDate(int index) {
        Object object = this.get(index);
        return TypeUtils.cast(object, Date.class);
    }

    public Timestamp getTimestamp(int index) {
        Object object = this.get(index);
        return TypeUtils.cast(object, Timestamp.class);
    }

    public java.util.Date getDate(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof java.util.Date) {
            return (java.util.Date)value2;
        }
        if (value2 instanceof Number) {
            long millis = ((Number)value2).longValue();
            if (millis == 0L) {
                return null;
            }
            return new java.util.Date(millis);
        }
        return TypeUtils.toDate(value2);
    }

    @Override
    public Object set(int index, Object element) {
        if (index == -1) {
            this.list.add(element);
            return null;
        }
        if (this.list.size() <= index) {
            for (int i = this.list.size(); i < index; ++i) {
                this.list.add(null);
            }
            this.list.add(element);
            return null;
        }
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    @Override
    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public String getString(int index) {
        Object value2 = this.list.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        return com.alibaba.fastjson2.JSON.toJSONString(value2);
    }

    public JSONArray getJSONArray(int index) {
        Object value2 = this.get(index);
        if (value2 instanceof JSONArray) {
            return (JSONArray)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            if (arrayReader == null) {
                arrayReader = reader.getObjectReader((Type)((Object)JSONArray.class));
            }
            return arrayReader.readObject(reader, null, null, 0L);
        }
        if (value2 instanceof List) {
            return new JSONArray((List)value2);
        }
        return null;
    }

    public <T> T getObject(int index, Type type) {
        Object obj = this.list.get(index);
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type);
        }
        String json = JSON.toJSONString(obj);
        return JSON.parseObject(json, type, new Feature[0]);
    }

    public <T> T getObject(int index, Class<T> clazz) {
        Object obj = this.list.get(index);
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (T)obj;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(obj.getClass(), clazz);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        String json = JSON.toJSONString(obj);
        ObjectReader objectReader = provider.getObjectReader(clazz);
        JSONReader jsonReader = JSONReader.of(json);
        String defaultDateFormat = JSON.DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            jsonReader.getContext().setDateFormat(defaultDateFormat);
        }
        return objectReader.readObject(jsonReader, null, null, 0L);
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz);
        for (Object item : this) {
            if (!(item instanceof Map)) {
                if (item == null || item.getClass() == clazz) {
                    list.add(item);
                    continue;
                }
                Function typeConvert = provider.getTypeConvert(item.getClass(), clazz);
                if (typeConvert != null) {
                    Object converted = typeConvert.apply(item);
                    list.add(converted);
                    continue;
                }
                throw new com.alibaba.fastjson2.JSONException((item == null ? "null" : item.getClass()) + " cannot be converted to " + clazz);
            }
            Object classItem = objectReader.createInstance((Map)item, JSONReader.Feature.SupportSmartMatch.mask);
            list.add(classItem);
        }
        return list;
    }

    public JSONArray fluentAdd(Object e) {
        this.list.add(e);
        return this;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz);
        return objectReader.createInstance(this);
    }

    public String toString() {
        return JSONArray.toJSONString(this);
    }

    public JSONArray clone() {
        return new JSONArray(new ArrayList(this.list));
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JSONArray) {
            return this.list.equals(((JSONArray)obj).list);
        }
        return this.list.equals(obj);
    }

    @Override
    public <T> T toJavaObject(Type type) {
        return com.alibaba.fastjson.util.TypeUtils.cast((Object)this, type, ParserConfig.getGlobalInstance());
    }

    @Deprecated
    public Type getComponentType() {
        return this.componentType;
    }

    @Deprecated
    public void setComponentType(Type componentType) {
        this.componentType = componentType;
    }

    @Deprecated
    public Object getRelatedArray() {
        return this.relatedArray;
    }

    @Deprecated
    public void setRelatedArray(Object relatedArray) {
        this.relatedArray = relatedArray;
    }
}

