/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.impl;

import com.gexin.rp.sdk.base.CommonEnum;
import com.gexin.rp.sdk.base.uitls.LangUtil;
import com.gexin.rp.sdk.base.uitls.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TagsTarget {
    public static final String SPLIT_TAG_CHAR = ",";
    public static final String SPLIT_TAG_AND_OPT_CHAR = " ";
    private String clientId;
    private Set<String> tagSet;
    private Integer opType;

    public TagsTarget() {
        this.opType = CommonEnum.OpTypeEnum.OP_TYPE_AND.type;
    }

    public Map<String, String> toMap() {
        if (StringUtils.isBlank(this.clientId)) {
            throw new RuntimeException("clientId can not be empty.");
        }
        if (this.tagSet == null || this.tagSet.isEmpty()) {
            throw new RuntimeException("tagSet can not be empty.");
        }
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tagSet) {
            if (StringUtils.isBlank(tag)) {
                throw new RuntimeException("value in tagSet cannot be empty.");
            }
            sb.append(tag).append(SPLIT_TAG_CHAR);
        }
        if (sb.length() == 0) {
            throw new RuntimeException("value in tagSet cannot be empty.");
        }
        String value = sb.substring(0, sb.length() - 1) + SPLIT_TAG_AND_OPT_CHAR + this.opType;
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(this.clientId, value);
        return map;
    }

    public static TagsTarget build(String tagsAndOpType, String cid) {
        String[] tagArr;
        TagsTarget tagsTarget = new TagsTarget();
        tagsTarget.setClientId(cid);
        int index = tagsAndOpType.lastIndexOf(SPLIT_TAG_AND_OPT_CHAR);
        if (index < 0) {
            tagsTarget.addTag(tagsAndOpType);
            return tagsTarget;
        }
        String opTypeStr = tagsAndOpType.substring(index + 1);
        tagsTarget.setOpType(LangUtil.parseInt(opTypeStr, CommonEnum.OpTypeEnum.OP_TYPE_AND.type));
        String tags = tagsAndOpType.substring(0, index);
        for (String tag : tagArr = tags.split(SPLIT_TAG_CHAR)) {
            tagsTarget.addTag(tag);
        }
        return tagsTarget;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Set<String> getTagSet() {
        return this.tagSet;
    }

    public void setTagSet(Set<String> tagSet) {
        this.tagSet = tagSet;
    }

    public Integer getOpType() {
        return this.opType;
    }

    public void setOpType(Integer opType) {
        this.opType = opType;
    }

    public TagsTarget addTag(String tag) {
        if (StringUtils.isBlank(tag)) {
            return this;
        }
        if (this.tagSet == null) {
            this.tagSet = new HashSet<String>(8);
        }
        this.tagSet.add(tag);
        return this;
    }
}

