/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.impl.NumberConverter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.function.Function;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object value2) {
        return PrimitiveConverter.convert(value2, this.targetType, this::convertToStr);
    }

    @Override
    protected String convertToStr(Object value2) {
        return StrUtil.trim(super.convertToStr(value2));
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }

    protected static Object convert(Object value2, Class<?> primitiveClass, Function<Object, String> toStringFunc) {
        if (Byte.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value2, Byte.class, toStringFunc), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value2, Short.class, toStringFunc), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value2, Integer.class, toStringFunc), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value2, Long.class, toStringFunc), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value2, Float.class, toStringFunc), 0);
        }
        if (Double.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value2, Double.class, toStringFunc), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return Convert.convert(Character.class, value2);
        }
        if (Boolean.TYPE == primitiveClass) {
            return Convert.convert(Boolean.class, value2);
        }
        throw new ConvertException("Unsupported target type: {}", primitiveClass);
    }
}

