/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson2.JSONReader;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;

public class DefaultJSONParser
implements Closeable {
    private final JSONReader reader;
    private final ParserConfig config;
    private final JSONScanner lexer;
    private Object input;

    public DefaultJSONParser(String text) {
        this(JSONReader.of(text), ParserConfig.global);
        this.input = text;
    }

    public DefaultJSONParser(Object input, JSONLexer lexer, ParserConfig config) {
        this.lexer = (JSONScanner)lexer;
        this.reader = lexer.getReader();
        this.config = config;
        this.input = input;
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public DefaultJSONParser(String text, ParserConfig config) {
        this(JSONReader.of(text), config);
    }

    public DefaultJSONParser(JSONReader reader, ParserConfig config) {
        this.reader = reader;
        this.config = config;
        this.lexer = new JSONScanner(this.reader);
    }

    public JSONLexer getLexer() {
        return this.lexer;
    }

    public JSONReader getRawReader() {
        return this.reader;
    }

    public Object parse() {
        return this.reader.readAny();
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        return this.reader.readArray(clazz);
    }

    public void parseArray(Type type, Collection array) {
        this.reader.readArray(array, type);
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.reader.readArray(array, clazz);
    }

    public Object[] parseArray(Type[] types) {
        return this.reader.readArray(types);
    }

    public final void parseArray(Collection array) {
        this.reader.readArray(array, (Type)((Object)Object.class));
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.reader.read(clazz);
    }

    public <T> T parseObject(Type type) {
        return this.reader.read(type);
    }

    public void parseObject(Object object) {
        this.reader.readObject(object, new JSONReader.Feature[0]);
    }

    @Deprecated
    public Object parse(Object fieldName) {
        return this.reader.readAny();
    }

    @Deprecated
    public void handleResovleTask(Object value2) {
        this.reader.handleResolveTasks(value2);
    }

    public void handleResolveTasks(Object value2) {
        this.reader.handleResolveTasks(value2);
    }

    public final void accept(int token) {
        char expect;
        switch (token) {
            case 25: {
                expect = '.';
                break;
            }
            case 12: {
                expect = '{';
                break;
            }
            case 13: {
                expect = '}';
                break;
            }
            case 14: {
                expect = '[';
                break;
            }
            case 15: {
                expect = ']';
                break;
            }
            case 10: {
                expect = '(';
                break;
            }
            case 11: {
                expect = ')';
                break;
            }
            case 16: {
                if (this.reader.hasComma() || this.reader.nextIfComma()) {
                    return;
                }
                throw new JSONException("syntax error, expect ',', actual " + this.reader.current());
            }
            case 17: {
                expect = ':';
                break;
            }
            case 6: {
                if (!this.reader.nextIfMatchIdent('t', 'r', 'u', 'e')) {
                    throw new JSONException("syntax error, expect true, actual " + this.reader.current());
                }
                return;
            }
            case 7: {
                if (!this.reader.nextIfMatchIdent('f', 'a', 'l', 's', 'e')) {
                    throw new JSONException("syntax error, expect false, actual " + this.reader.current());
                }
                return;
            }
            case 8: {
                if (!this.reader.nextIfNull()) {
                    throw new JSONException("syntax error, expect false, actual " + this.reader.current());
                }
                return;
            }
            case 4: {
                char ch = this.reader.current();
                if (ch == '\"' || ch == '\'') {
                    this.reader.readString();
                    return;
                }
                throw new JSONException("syntax error, expect string, actual " + ch);
            }
            case 21: {
                if (!this.reader.nextIfSet()) {
                    throw new JSONException("syntax error, expect set, actual " + this.reader.current());
                }
                return;
            }
            case 2: 
            case 3: {
                boolean isInt;
                char ch = this.reader.current();
                if (ch != '-' && ch != '+' && (ch < '0' || ch > '9')) {
                    throw new JSONException("syntax error, expect int, actual " + this.reader.current());
                }
                Number number = this.reader.readNumber();
                boolean bl = isInt = number instanceof Integer || number instanceof Long || number instanceof BigInteger;
                if (isInt ? token == 2 : token == 3) {
                    return;
                }
                throw new JSONException("syntax error, expect int, actual " + this.reader.current());
            }
            default: {
                throw new JSONException("not support accept token " + JSONToken.name(token));
            }
        }
        if (!this.reader.nextIfMatch(expect)) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + this.reader.current());
        }
    }

    public JSONObject parseObject() {
        if (this.reader.nextIfNull()) {
            return null;
        }
        JSONObject object = new JSONObject(this.lexer.isOrderedField());
        this.reader.read(object, 0L);
        return object;
    }

    public void config(Feature feature, boolean state) {
        this.lexer.config(feature, state);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    public boolean isEnabled(Feature feature) {
        return this.lexer.isEnabled(feature);
    }
}

