/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame;

import com.taobao.api.internal.toplink.embedded.websocket.BufferManager;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameHeader;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.EnumSet;

public abstract class FrameParser {
    private volatile State state = State.DONE;
    private FrameHeader header;
    private BufferManager bufferManager = new BufferManager();

    protected State transitionTo(State to) {
        if (this.state.canTransitionTo(to)) {
            State old = this.state;
            this.state = to;
            return old;
        }
        throw new IllegalStateException("Couldn't transtion from " + (Object)((Object)this.state) + " to " + (Object)((Object)to));
    }

    protected State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Frame parse(ByteBuffer downloadBuffer) throws WebSocketException {
        Frame frame;
        ByteBuffer buffer;
        block11: {
            Frame frame2;
            block10: {
                Frame position2;
                block9: {
                    buffer = null;
                    try {
                        if (State.DONE.equals((Object)this.state)) {
                            this.transitionTo(State.HEADER);
                            buffer = downloadBuffer;
                        } else {
                            buffer = this.bufferManager.getBuffer(downloadBuffer);
                        }
                        if (State.HEADER.equals((Object)this.state)) {
                            int position2 = buffer.position();
                            this.header = this.createFrameHeader(buffer);
                            if (this.header == null) {
                                buffer.position(position2);
                                this.bufferManager.storeFragmentBuffer(buffer);
                                Frame frame3 = null;
                                Object var7_9 = null;
                                if (buffer == null) return frame3;
                                if (buffer == downloadBuffer) return frame3;
                                downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
                                return frame3;
                            }
                            if (this.header.getContentsLength() - 1L > Integer.MAX_VALUE) {
                                throw new IllegalArgumentException("large data is not support yet");
                            }
                            this.transitionTo(State.FRAME);
                        }
                        if (State.FRAME.equals((Object)this.state)) {
                            if (this.header.getContentsLength() > (long)buffer.remaining()) {
                                this.bufferManager.storeFragmentBuffer(buffer);
                                position2 = null;
                                break block9;
                            }
                            byte[] bodyBuf = new byte[(int)this.header.getContentsLength()];
                            buffer.get(bodyBuf, 0, bodyBuf.length);
                            Frame frame4 = this.createFrame(this.header, bodyBuf);
                            this.transitionTo(State.DONE);
                            this.bufferManager.init();
                            this.header = null;
                            frame2 = frame4;
                            break block10;
                        }
                        frame = null;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        if (buffer == null) throw throwable;
                        if (buffer == downloadBuffer) throw throwable;
                        downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
                        throw throwable;
                    }
                }
                Object var7_10 = null;
                if (buffer == null) return position2;
                if (buffer == downloadBuffer) return position2;
                downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
                return position2;
            }
            Object var7_11 = null;
            if (buffer == null) return frame2;
            if (buffer == downloadBuffer) return frame2;
            downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
            return frame2;
        }
        Object var7_12 = null;
        if (buffer == null) return frame;
        if (buffer == downloadBuffer) return frame;
        downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
        return frame;
    }

    protected abstract FrameHeader createFrameHeader(ByteBuffer var1);

    protected abstract Frame createFrame(FrameHeader var1, byte[] var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        HEADER,
        FRAME,
        DONE;

        private static EnumMap<State, EnumSet<State>> stateMap;

        boolean canTransitionTo(State state) {
            EnumSet<State> set = stateMap.get((Object)this);
            if (set == null) {
                return false;
            }
            return set.contains((Object)state);
        }

        static {
            stateMap = new EnumMap(State.class);
            stateMap.put(HEADER, EnumSet.of(FRAME));
            stateMap.put(FRAME, EnumSet.of(DONE));
            stateMap.put(DONE, EnumSet.of(HEADER));
        }
    }
}

