/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.domain;

import com.gexin.rp.sdk.base.domain.DomainListBO;
import com.gexin.rp.sdk.base.domain.IDomainCheck;
import com.gexin.rp.sdk.base.uitls.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainCheck<T> {
    private IDomainCheck<T> check;
    private final int checkSize;

    public DomainCheck(IDomainCheck<T> check) {
        this(check, 20);
    }

    public DomainCheck(IDomainCheck<T> check, int checkSize) {
        this.check = check;
        this.checkSize = checkSize;
    }

    public List<T> sort(List<DomainListBO<T>> list) {
        Map<T, Integer> domainTOGapMap = this.initGap(list);
        List<T> domainList = this.getALlDomain(list);
        Map<T, Integer> map = this.doCheck(domainList, domainTOGapMap);
        return this.doSort(map);
    }

    private List<T> getALlDomain(List<DomainListBO<T>> list) {
        ArrayList<T> domainList = new ArrayList<T>();
        for (DomainListBO<T> domainListBO : list) {
            if (!Utils.isNotEmpty(domainListBO.getDomainList())) continue;
            domainList.addAll(domainListBO.getDomainList());
        }
        return domainList;
    }

    private Map<T, Integer> doCheck(List<T> domainList, Map<T, Integer> domainToGapMap) {
        HashMap<Object, Integer> detectMap = new HashMap<Object, Integer>(domainList.size(), 1.0f);
        for (int i = 0; i < this.checkSize; ++i) {
            for (Object domain : domainList) {
                if (detectMap.get(domain) == null) {
                    detectMap.put(domain, 0);
                }
                boolean rst = false;
                try {
                    rst = this.check.check(domain);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!rst) continue;
                detectMap.put(domain, (Integer)detectMap.get(domain) + 1);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        boolean allBad = true;
        for (Object key : detectMap.keySet()) {
            if ((Integer)detectMap.get(key) != 0) {
                allBad = false;
            }
            int score = (Integer)detectMap.get(key) * 100 / this.checkSize + domainToGapMap.get(key);
            detectMap.put(key, score);
        }
        if (allBad) {
            return Collections.emptyMap();
        }
        return detectMap;
    }

    private List<T> doSort(Map<T, Integer> detectMap) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (detectMap == null || detectMap.size() == 0) {
            return null;
        }
        Object domain = null;
        Integer max = 0;
        while (detectMap.size() != 0) {
            for (Map.Entry<T, Integer> entry : detectMap.entrySet()) {
                if (entry.getValue() < max) continue;
                max = entry.getValue();
                domain = entry.getKey();
            }
            max = 0;
            result.add(domain);
            detectMap.remove(domain);
        }
        return result;
    }

    private Map<T, Integer> initGap(List<DomainListBO<T>> list) {
        HashMap<T, Integer> map = new HashMap<T, Integer>(list.size(), 1.0f);
        int gap = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i != list.size() - 1) {
                gap += list.get(i).getPriorityGap().intValue();
            }
            for (T t : list.get(i).getDomainList()) {
                map.put(t, gap);
            }
        }
        return map;
    }
}

