/*
 * Decompiled with CFR 0.152.
 */
package com.integration.oauth2.sdk;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.integration.oauth2.sdk.OAuth2Exception;
import com.integration.oauth2.sdk.response.AccessTokenResponse;
import com.integration.oauth2.sdk.response.RefreshTokenResponse;
import com.integration.oauth2.util.RSAUtil;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OAuth2Client {
    private String baseUrl;
    private String clientId;
    private String clientSecret;
    private String publicKey;
    private int timeout;
    private static volatile OAuth2Client instance;
    private int connectionTimeout = (int)TimeUnit.SECONDS.toMillis(30L);

    private OAuth2Client(String baseUrl, String clientId, String clientSecret, String publicKey) {
        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.publicKey = publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OAuth2Client getInstance(String baseUrl, String clientId, String clientSecret, String publicKey) {
        if (instance == null) {
            Class<OAuth2Client> clazz = OAuth2Client.class;
            synchronized (OAuth2Client.class) {
                if (instance == null) {
                    instance = new OAuth2Client(baseUrl, clientId, clientSecret, publicKey);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            instance.updateConfiguration(baseUrl, clientId, clientSecret, publicKey);
        }
        return instance;
    }

    private synchronized void updateConfiguration(String baseUrl, String clientId, String clientSecret, String publicKey) {
        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.publicKey = publicKey;
    }

    public void setTimeout(int timeout) {
        this.connectionTimeout = (int)TimeUnit.SECONDS.toMillis(timeout);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public AccessTokenResponse getAccessToken(String code, String redirectUri) throws OAuth2Exception {
        try {
            String encryptedClientSecret = RSAUtil.publicEncrypt(this.clientSecret, RSAUtil.getPublicKey(this.publicKey));
            encryptedClientSecret = URLEncoder.encode(encryptedClientSecret);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("grant_type", "authorization_code");
            params.put("code", code);
            params.put("client_id", this.clientId);
            params.put("client_secret", encryptedClientSecret);
            params.put("redirect_uri", redirectUri);
            String jsonResponse = this.get(this.baseUrl + "auth/oauth2/token", params);
            ObjectMapper objectMapper = new ObjectMapper();
            AccessTokenResponse accessTokenResponse = objectMapper.readValue(jsonResponse, AccessTokenResponse.class);
            return accessTokenResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAuth2Exception("\u83b7\u53d6access_token\u5931\u8d25", e);
        }
    }

    public String getOpenApiToken(String account) throws OAuth2Exception {
        try {
            String encryptedClientSecret = RSAUtil.publicEncrypt(this.clientSecret, RSAUtil.getPublicKey(this.publicKey));
            encryptedClientSecret = URLEncoder.encode(encryptedClientSecret);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sysCode", this.clientId);
            params.put("secretKey", encryptedClientSecret);
            String jsonResponse = this.get(this.baseUrl + "uc/apiManager/getToken", params);
            JSONObject object = JSONObject.parseObject(jsonResponse);
            return object.get("value").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAuth2Exception("\u83b7\u53d6openApi_token\u5931\u8d25", e);
        }
    }

    public RefreshTokenResponse getOpenApiRefreshToken(String token) throws OAuth2Exception {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String jsonResponse = this.get(this.baseUrl + "/auth/refresh", params, token);
            ObjectMapper objectMapper = new ObjectMapper();
            RefreshTokenResponse accessTokenResponse = objectMapper.readValue(jsonResponse, RefreshTokenResponse.class);
            return accessTokenResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAuth2Exception("\u83b7\u53d6openApi_token\u5931\u8d25", e);
        }
    }

    public RefreshTokenResponse refreshToken(String refresh_token) throws OAuth2Exception {
        try {
            String encryptedClientSecret = RSAUtil.publicEncrypt(this.clientSecret, RSAUtil.getPublicKey(this.publicKey));
            encryptedClientSecret = URLEncoder.encode(encryptedClientSecret);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("grant_type", "refresh_token");
            params.put("refresh_token", refresh_token);
            params.put("client_id", this.clientId);
            params.put("client_secret", encryptedClientSecret);
            String jsonResponse = this.get(this.baseUrl + "auth/oauth2/refresh", params);
            ObjectMapper objectMapper = new ObjectMapper();
            RefreshTokenResponse accessTokenResponse = objectMapper.readValue(jsonResponse, RefreshTokenResponse.class);
            return accessTokenResponse;
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u5237\u65b0access_token\u5931\u8d25", e);
        }
    }

    public String getUserInfo(String token) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("token", token);
            return this.postForm(this.baseUrl + "/uc/api/user/v1/getInfo", form);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u83b7\u53d6\u7528\u6237\u57fa\u7840\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    public String getUserDetail(String accessToken, String account) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("name", account);
            return this.postForm(this.baseUrl + "/uc/api/user/v1/getDetail", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    public String getOrgsAll(String accessToken, String updateTime) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("updateTime", updateTime);
            return this.get(this.baseUrl + "/uc/openApi/server/org/v1/getOrgsAll", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868\u6570\u636e\u5931\u8d25", e);
        }
    }

    public String getUsersAll(String accessToken, String pageNum, String pageSize) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("pageNum", pageNum);
            form.put("pageSize", pageSize);
            return this.get(this.baseUrl + "/uc/openApi/server/user/v1/getUsersAll", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u83b7\u53d6\u7528\u6237\u5217\u8868\u6570\u636e\u5931\u8d25", e);
        }
    }

    public String updateUserPwd(String accessToken, String id, String password) throws OAuth2Exception {
        try {
            String encryptedClientSecret = RSAUtil.publicEncrypt(password, RSAUtil.getPublicKey(this.publicKey));
            encryptedClientSecret = URLEncoder.encode(encryptedClientSecret);
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("id", id);
            form.put("password", encryptedClientSecret);
            return this.post(this.baseUrl + "/uc/openApi/server/user/v1/updateUserPwd", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u66f4\u65b0\u7528\u6237\u5bc6\u7801\u5931\u8d25", e);
        }
    }

    public String changePwd(String accessToken, String account, String oldPwd, String newPwd) throws OAuth2Exception {
        try {
            String encryptedClientSecret1 = RSAUtil.publicEncrypt(oldPwd, RSAUtil.getPublicKey(this.publicKey));
            encryptedClientSecret1 = URLEncoder.encode(encryptedClientSecret1);
            String encryptedClientSecret2 = RSAUtil.publicEncrypt(newPwd, RSAUtil.getPublicKey(this.publicKey));
            encryptedClientSecret2 = URLEncoder.encode(encryptedClientSecret2);
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("account", account);
            form.put("oldPwd", encryptedClientSecret1);
            form.put("newPwd", encryptedClientSecret2);
            return this.post(this.baseUrl + "/uc/openApi/server/user/v1/changePwd", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25", e);
        }
    }

    public String deleteUser(String accessToken, String account) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("account", account);
            return this.delete(this.baseUrl + "/uc/openApi/server/user/v1/deleteUser", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u5220\u9664\u7528\u6237\u5931\u8d25", e);
        }
    }

    public String restUserPwd(String accessToken, String account, String password) throws OAuth2Exception {
        try {
            String encryptedClientSecret = RSAUtil.publicEncrypt(password, RSAUtil.getPublicKey(this.publicKey));
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("account", account);
            form.put("passWord", encryptedClientSecret);
            return this.post(this.baseUrl + "/uc/openApi/server/user/v1/restUserPwd", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25", e);
        }
    }

    public String userRegister(String accessToken, String fullName, String account, String mobile, String password) throws OAuth2Exception {
        try {
            String encryptedClientSecret = RSAUtil.publicEncrypt(password, RSAUtil.getPublicKey(this.publicKey));
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("fullName", fullName);
            form.put("account", account);
            form.put("mobile", mobile);
            form.put("passWord", encryptedClientSecret);
            return this.post(this.baseUrl + "/uc/openApi/server/user/v1/userRegister", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u65b0\u589e\u7528\u6237\u5931\u8d25", e);
        }
    }

    public String updateUser(String accessToken, String fullName, String account, String mobile, String status) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("fullName", fullName);
            form.put("account", account);
            form.put("mobile", mobile);
            form.put("status", status);
            return this.post(this.baseUrl + "/uc/openApi/server/user/v1/updateUser", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u7f16\u8f91\u7528\u6237\u5931\u8d25", e);
        }
    }

    public String getRolesAll(String accessToken, String pageNum, String pageSize) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("pageNum", pageNum);
            form.put("pageSize", pageSize);
            return this.get(this.baseUrl + "/uc/openApi/server/role/v1/getRolesAll", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u83b7\u53d6\u89d2\u8272\u5217\u8868\u6570\u636e\u5931\u8d25", e);
        }
    }

    public String sendMsg(String accessToken, String subject, String description, String content, String receiverId) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("subject", subject);
            form.put("description", description);
            form.put("content", content);
            form.put("receiverId", receiverId);
            return this.post(this.baseUrl + "/portal/openApi/message/v1/send", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25", e);
        }
    }

    public String sendMsg(String accessToken, String subject, String description, String content, String receiverId, String messageNewType) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("subject", subject);
            form.put("description", description);
            form.put("content", content);
            form.put("receiverId", receiverId);
            form.put("messageNewType", messageNewType);
            return this.post(this.baseUrl + "/portal/openApi/message/v1/send", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25", e);
        }
    }

    public String getMsgStatus(String accessToken, String message_id) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("message_id", message_id);
            return this.post(this.baseUrl + "/portal/openApi/message/v1/getStatus", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u83b7\u53d6\u6d88\u606f\u72b6\u6001\u5931\u8d25", e);
        }
    }

    public String deleteMsg(String accessToken, String message_id) throws OAuth2Exception {
        try {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("message_id", message_id);
            return this.post(this.baseUrl + "/portal/openApi/message/v1/delete", form, accessToken);
        }
        catch (Exception e) {
            throw new OAuth2Exception("\u5220\u9664\u6d88\u606f\u5931\u8d25", e);
        }
    }

    private String get(String url, Map<String, Object> form, String accessToken) {
        HttpRequest request = HttpRequest.get(url).form(form).timeout(this.connectionTimeout);
        if (accessToken != null && !accessToken.isEmpty()) {
            request.header("Authorization", "Bearer " + accessToken);
        }
        return request.execute().body();
    }

    private String get(String url, Map<String, Object> params) {
        return HttpRequest.get(url).form(params).timeout(this.connectionTimeout).execute().body();
    }

    private String postForm(String url, Map<String, Object> form) {
        return this.postForm(url, form, null);
    }

    private String postForm(String url, Map<String, Object> form, String accessToken) {
        HttpRequest request = HttpRequest.post(url).form(form).timeout(this.connectionTimeout);
        if (accessToken != null && !accessToken.isEmpty()) {
            request.header("Authorization", "Bearer " + accessToken);
        }
        return request.execute().body();
    }

    private String post(String url, Map<String, Object> form, String accessToken) {
        String jsonBody = JSONObject.toJSONString(form, new JSONWriter.Feature[0]);
        HttpRequest request = ((HttpRequest)HttpRequest.post(url).header("Content-Type", "application/json")).body(jsonBody).timeout(this.connectionTimeout);
        if (accessToken != null && !accessToken.isEmpty()) {
            request.header("Authorization", "Bearer " + accessToken);
        }
        return request.execute().body();
    }

    private String delete(String url, Map<String, Object> form, String accessToken) {
        String jsonBody = JSONObject.toJSONString(form, new JSONWriter.Feature[0]);
        HttpRequest request = ((HttpRequest)HttpRequest.delete(url).header("Content-Type", "application/json")).body(jsonBody).timeout(this.connectionTimeout);
        if (accessToken != null && !accessToken.isEmpty()) {
            request.header("Authorization", "Bearer " + accessToken);
        }
        return request.execute().body();
    }
}

